# Changelog

Versions follow [Semantic Versioning](https://semver.org) (`<major>.<minor>.<patch>`).

## [Unreleased]

### Added

- Trial outcome counter chart in session "Overview" panel.
- Favicon for web interface.
- Version details in session file.
- Signal detection theory classification per trial.
- Added response identifier to Response object.
- Stimulus info now returns common name and identifier.

### Changed

- History table now sorts sessions in descending order based on date.
- Default to non-empty response object for no_response trials.
- First stimulus in Go/NoGo is now always the target. This fixes weird bug where sometimes distractor and target stimuli would be flipped on the first trial.
- More informative stimulus information in the trial - give the actual stimulus shown rather than what was used in the task.

## [0.4.1] - 2023-02-02

### Added

- This changelog.
- Community code of conduct.
- Contributing guidelines.
- History panel now shows table of past sessions and allows downloading session JSON files.
- Provisional support for different filetypes in download API.

### Changed

- Use logging library instead of prints.

### Fixed

- CLI entry point.

## [0.4.0] - 2023-01-19

### Added

- Support for python 3.9.

### Changed

- Package project with hatch instead of setuptools.
- Upgrade numpy dependency to >= 1.22 (addresses security concerns in 1.21).
- Restructured documentation, now uses autogenerated summaries for classes and methods.

### Fixed

- CI and automated testing now work again.

### Removed

- Dropped support for Python 3.7 due to important security upgrades in numpy not available in this version.
- Remove `importlib` calls to support later versions of python where this has been deprecated.- No longer using `requirements.txt`, use hatch and tox for development.

## [0.3.5] - 2022-07-21

### Added

- Variable contrast moving gratings as stimuli.

### Changed

- Recommend `pipx` as the default installation option.

## [0.3.4] - 2022-03-28

### Added

- Readme includes install, upgrade and contribution instructions.
- Stimulus details added to session file.
- Variable contrast gratings as stimuli.

### Changed

- Application launcher in `__init__.py` will only launch if ran as a script.
- Explicit contrast casting to float.

## [0.3.3] - 2022-03-22

### Changed

- Use pygame version 2.0.1.


## [0.3.2] - 2022-03-22

### Changed

- Various build system improvements.

## [0.3.1] - 2022-03-22

### Added

- Use setuptools to package and version app.
- Add `make_release.sh` to build and upload to PYPI.

### Changed

- Use python 3.7 for RPiOS Buster compatibility.

## [0.3.0] - 2022-03-21

### Added

- Protocols support multiple Trial classes.
- `Devices` module to support external USB microcontroller integration.
- Plugin system for stimuli, protocols and devices.
- Show hostname on web panel.
- Support lever-push apparatus as response device.

### Changed

- Use pygame 2.0's dedicated `touch events` API.
- Use full names in interfaces instead of abbreviations (e.g. stim -> stimulus).
- Trial outcomes marked as "correct" or "incorrect" instead of using SDT terms for better generalisability.
- Stimuli and protocols refactored into their own modules.

### Fixed

- Addressed circular imports in `visiomode.protocols` and `visiomode.models`.
- Issue where precues were sometimes counted as "no response".
- Append `.json` to session file.

## [0.2.1] - 2021-03-13

### Added

- Migrated to pygame version 2.0.
- Session start/finish times to webpanel session log.
- Webpanel session progress bar.
- Webpanel session log shows timestamp alongside trial outcome.

### Changed

- Webpanel session log resets when new session starts.

## [0.2.0] - 2021-03-10

### Added

- Web panel log displays real-time session updates.
- Screen resolution can be set in config file instead of being hardcoded.
- Added Go/NoGo paradigm.

### Changed

- API restructured to split stimulus and task logic.
- Session listener refactored out of protocol interface to the main loop.
- Use same protocol identifiers on backend and frontend.
- Use python queues to share data between backend and frontend. Replaces Redis/socketIO.

## Fixed

- Timestamp session at request time instead of application launch.
- Removing Redis fixes application timing issues (was too slow).

### Removed

- Redis/socketIO as the means of communication between backend and frontend.

## [0.1.0] - 2021-02-09

### Added

- Bare-bones web interface to set up task.
- CLI-based task monitoring.
- Grating and isoluminant gray stimuli.
- Single-target and 2AFC paradigms.
- Initial JSON file format for storing session data.
- Redis-based syncing between behaviour & web interface components.
- SocketIO reads Redis updates for web interface.

[unreleased]: https://github.com/DuguidLab/visiomode/compare/v0.4.1...HEAD
[0.4.1]: https://github.com/DuguidLab/visiomode/compare/v0.4.0...v0.4.1
[0.4.0]: https://github.com/DuguidLab/visiomode/compare/v0.3.5...v0.4.0
[0.3.5]: https://github.com/DuguidLab/visiomode/compare/v0.3.4...v0.3.5
[0.3.4]: https://github.com/DuguidLab/visiomode/compare/v0.3.3...v0.3.4
[0.3.3]: https://github.com/DuguidLab/visiomode/compare/v0.3.2...v0.3.3
[0.3.2]: https://github.com/DuguidLab/visiomode/compare/v0.3.1...v0.3.2
[0.3.1]: https://github.com/DuguidLab/visiomode/compare/v0.3.0...v0.3.1
[0.3.0]: https://github.com/DuguidLab/visiomode/compare/v0.2.1...v0.3.0
[0.2.1]: https://github.com/DuguidLab/visiomode/compare/v0.2.0...v0.2.1
[0.2.0]: https://github.com/DuguidLab/visiomode/compare/v0.1.0...v0.2.0
[0.1.0]: https://github.com/DuguidLab/visiomode/releases/tag/v0.1.0
