#
# Copyright (c) Lightly AG and affiliates.
# All rights reserved.
#
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.
#
from __future__ import annotations

from typing import Any, TypedDict

from torch.nn import Module
from torch.optim.lr_scheduler import LRScheduler
from torch.optim.optimizer import Optimizer
from torch.utils.data import DataLoader

from lightly_train.types import TaskBatch


class TrainTaskState(TypedDict):
    train_model: Module
    optimizer: Optimizer
    scheduler: LRScheduler
    train_dataloader: DataLoader[TaskBatch]
    step: int
    # Model class path and initialization arguments for serialization.
    # Used to reconstruct the model after training.
    model_class_path: str
    model_init_args: dict[str, Any]


class CheckpointDict(TypedDict):
    train_model_state_dict: dict[str, Any]
    # Model class path and initialization arguments for serialization.
    # Used to reconstruct the model after training.
    model_class_path: str
    model_init_args: dict[str, Any]


# Checkpoint as saved in out/checkpoints/last.ckpt
class TrainCheckpoint(CheckpointDict):
    optimizer_state_dict: dict[str, Any]
    scheduler_state_dict: dict[str, Any]
    train_dataloader: DataLoader[TaskBatch]
    step: int


# Checkpoint as saved in out/exported/last.pt
class ExportedCheckpoint(CheckpointDict):
    pass
