"""
All wgpu structs.
"""

# THIS CODE IS AUTOGENERATED - DO NOT EDIT

_use_sphinx_repr = False


class Struct:
    def __init__(self, name, **kwargs):
        self._name = name
        for key, val in kwargs.items():
            setattr(self, key, val)

    def __iter__(self):
        return iter([key for key in dir(self) if not key.startswith("_")])

    def __repr__(self):
        options = ", ".join(f"'{x}'" for x in self)
        if _use_sphinx_repr:  # no-cover
            return options
        return f"<{self.__class__.__name__} {self._name}: {options}>"


# There are 50 structs

RequestAdapterOptions = Struct(
    "RequestAdapterOptions",
    power_preference="enums.PowerPreference",
)  #:

DeviceDescriptor = Struct(
    "DeviceDescriptor",
    label="str",
    non_guaranteed_features="List[enums.FeatureName]",
    non_guaranteed_limits="Dict[str, int]",
)  #:

BufferDescriptor = Struct(
    "BufferDescriptor",
    label="str",
    size="int",
    usage="flags.BufferUsage",
    mapped_at_creation="bool",
)  #:

TextureDescriptor = Struct(
    "TextureDescriptor",
    label="str",
    size="structs.Extent3D",
    mip_level_count="int",
    sample_count="int",
    dimension="enums.TextureDimension",
    format="enums.TextureFormat",
    usage="flags.TextureUsage",
)  #:

TextureViewDescriptor = Struct(
    "TextureViewDescriptor",
    label="str",
    format="enums.TextureFormat",
    dimension="enums.TextureViewDimension",
    aspect="enums.TextureAspect",
    base_mip_level="int",
    mip_level_count="int",
    base_array_layer="int",
    array_layer_count="int",
)  #:

SamplerDescriptor = Struct(
    "SamplerDescriptor",
    label="str",
    address_mode_u="enums.AddressMode",
    address_mode_v="enums.AddressMode",
    address_mode_w="enums.AddressMode",
    mag_filter="enums.FilterMode",
    min_filter="enums.FilterMode",
    mipmap_filter="enums.FilterMode",
    lod_min_clamp="float",
    lod_max_clamp="float",
    compare="enums.CompareFunction",
    max_anisotropy="int",
)  #:

BindGroupLayoutDescriptor = Struct(
    "BindGroupLayoutDescriptor",
    label="str",
    entries="List[structs.BindGroupLayoutEntry]",
)  #:

BindGroupLayoutEntry = Struct(
    "BindGroupLayoutEntry",
    binding="int",
    visibility="flags.ShaderStage",
    buffer="structs.BufferBindingLayout",
    sampler="structs.SamplerBindingLayout",
    texture="structs.TextureBindingLayout",
    storage_texture="structs.StorageTextureBindingLayout",
)  #:

BufferBindingLayout = Struct(
    "BufferBindingLayout",
    type="enums.BufferBindingType",
    has_dynamic_offset="bool",
    min_binding_size="int",
)  #:

SamplerBindingLayout = Struct(
    "SamplerBindingLayout",
    type="enums.SamplerBindingType",
)  #:

TextureBindingLayout = Struct(
    "TextureBindingLayout",
    sample_type="enums.TextureSampleType",
    view_dimension="enums.TextureViewDimension",
    multisampled="bool",
)  #:

StorageTextureBindingLayout = Struct(
    "StorageTextureBindingLayout",
    access="enums.StorageTextureAccess",
    format="enums.TextureFormat",
    view_dimension="enums.TextureViewDimension",
)  #:

BindGroupDescriptor = Struct(
    "BindGroupDescriptor",
    label="str",
    layout="GPUBindGroupLayout",
    entries="List[structs.BindGroupEntry]",
)  #:

BindGroupEntry = Struct(
    "BindGroupEntry",
    binding="int",
    resource="Union[GPUSampler, GPUTextureView, structs.BufferBinding]",
)  #:

BufferBinding = Struct(
    "BufferBinding",
    buffer="GPUBuffer",
    offset="int",
    size="int",
)  #:

PipelineLayoutDescriptor = Struct(
    "PipelineLayoutDescriptor",
    label="str",
    bind_group_layouts="List[GPUBindGroupLayout]",
)  #:

ShaderModuleDescriptor = Struct(
    "ShaderModuleDescriptor",
    label="str",
    code="str",
    source_map="dict",
)  #:

ProgrammableStage = Struct(
    "ProgrammableStage",
    module="GPUShaderModule",
    entry_point="str",
)  #:

ComputePipelineDescriptor = Struct(
    "ComputePipelineDescriptor",
    label="str",
    layout="GPUPipelineLayout",
    compute="structs.ProgrammableStage",
)  #:

RenderPipelineDescriptor = Struct(
    "RenderPipelineDescriptor",
    label="str",
    layout="GPUPipelineLayout",
    vertex="structs.VertexState",
    primitive="structs.PrimitiveState",
    depth_stencil="structs.DepthStencilState",
    multisample="structs.MultisampleState",
    fragment="structs.FragmentState",
)  #:

PrimitiveState = Struct(
    "PrimitiveState",
    topology="enums.PrimitiveTopology",
    strip_index_format="enums.IndexFormat",
    front_face="enums.FrontFace",
    cull_mode="enums.CullMode",
    clamp_depth="bool",
)  #:

MultisampleState = Struct(
    "MultisampleState",
    count="int",
    mask="int",
    alpha_to_coverage_enabled="bool",
)  #:

FragmentState = Struct(
    "FragmentState",
    module="GPUShaderModule",
    entry_point="str",
    targets="List[structs.ColorTargetState]",
)  #:

ColorTargetState = Struct(
    "ColorTargetState",
    format="enums.TextureFormat",
    blend="structs.BlendState",
    write_mask="flags.ColorWrite",
)  #:

BlendState = Struct(
    "BlendState",
    color="structs.BlendComponent",
    alpha="structs.BlendComponent",
)  #:

BlendComponent = Struct(
    "BlendComponent",
    src_factor="enums.BlendFactor",
    dst_factor="enums.BlendFactor",
    operation="enums.BlendOperation",
)  #:

DepthStencilState = Struct(
    "DepthStencilState",
    format="enums.TextureFormat",
    depth_write_enabled="bool",
    depth_compare="enums.CompareFunction",
    stencil_front="structs.StencilFaceState",
    stencil_back="structs.StencilFaceState",
    stencil_read_mask="int",
    stencil_write_mask="int",
    depth_bias="int",
    depth_bias_slope_scale="float",
    depth_bias_clamp="float",
)  #:

StencilFaceState = Struct(
    "StencilFaceState",
    compare="enums.CompareFunction",
    fail_op="enums.StencilOperation",
    depth_fail_op="enums.StencilOperation",
    pass_op="enums.StencilOperation",
)  #:

VertexState = Struct(
    "VertexState",
    module="GPUShaderModule",
    entry_point="str",
    buffers="List[structs.VertexBufferLayout]",
)  #:

VertexBufferLayout = Struct(
    "VertexBufferLayout",
    array_stride="int",
    step_mode="enums.InputStepMode",
    attributes="List[structs.VertexAttribute]",
)  #:

VertexAttribute = Struct(
    "VertexAttribute",
    format="enums.VertexFormat",
    offset="int",
    shader_location="int",
)  #:

CommandBufferDescriptor = Struct(
    "CommandBufferDescriptor",
    label="str",
)  #:

CommandEncoderDescriptor = Struct(
    "CommandEncoderDescriptor",
    label="str",
    measure_execution_time="bool",
)  #:

ImageDataLayout = Struct(
    "ImageDataLayout",
    offset="int",
    bytes_per_row="int",
    rows_per_image="int",
)  #:

ImageCopyBuffer = Struct(
    "ImageCopyBuffer",
    offset="int",
    bytes_per_row="int",
    rows_per_image="int",
    buffer="GPUBuffer",
)  #:

ImageCopyTexture = Struct(
    "ImageCopyTexture",
    texture="GPUTexture",
    mip_level="int",
    origin="Union[List[int], structs.Origin3D]",
    aspect="enums.TextureAspect",
)  #:

ImageCopyImageBitmap = Struct(
    "ImageCopyImageBitmap",
    image_bitmap="memoryview",
    origin="Union[List[int], structs.Origin2D]",
)  #:

ComputePassDescriptor = Struct(
    "ComputePassDescriptor",
    label="str",
)  #:

RenderPassDescriptor = Struct(
    "RenderPassDescriptor",
    label="str",
    color_attachments="List[structs.RenderPassColorAttachment]",
    depth_stencil_attachment="structs.RenderPassDepthStencilAttachment",
    occlusion_query_set="GPUQuerySet",
)  #:

RenderPassColorAttachment = Struct(
    "RenderPassColorAttachment",
    view="GPUTextureView",
    resolve_target="GPUTextureView",
    load_value="Union[enums.LoadOp, Union[List[float], structs.Color]]",
    store_op="enums.StoreOp",
)  #:

RenderPassDepthStencilAttachment = Struct(
    "RenderPassDepthStencilAttachment",
    view="GPUTextureView",
    depth_load_value="Union[enums.LoadOp, float]",
    depth_store_op="enums.StoreOp",
    depth_read_only="bool",
    stencil_load_value="Union[enums.LoadOp, int]",
    stencil_store_op="enums.StoreOp",
    stencil_read_only="bool",
)  #:

RenderBundleDescriptor = Struct(
    "RenderBundleDescriptor",
    label="str",
)  #:

RenderBundleEncoderDescriptor = Struct(
    "RenderBundleEncoderDescriptor",
    label="str",
    color_formats="List[enums.TextureFormat]",
    depth_stencil_format="enums.TextureFormat",
    sample_count="int",
)  #:

QuerySetDescriptor = Struct(
    "QuerySetDescriptor",
    label="str",
    type="enums.QueryType",
    count="int",
    pipeline_statistics="List[enums.PipelineStatisticName]",
)  #:

SwapChainDescriptor = Struct(
    "SwapChainDescriptor",
    label="str",
    device="GPUDevice",
    format="enums.TextureFormat",
    usage="flags.TextureUsage",
)  #:

UncapturedErrorEventInit = Struct(
    "UncapturedErrorEventInit",
    error="Union[GPUOutOfMemoryError, GPUValidationError]",
)  #:

Color = Struct(
    "Color",
    r="float",
    g="float",
    b="float",
    a="float",
)  #:

Origin2D = Struct(
    "Origin2D",
    x="int",
    y="int",
)  #:

Origin3D = Struct(
    "Origin3D",
    x="int",
    y="int",
    z="int",
)  #:

Extent3D = Struct(
    "Extent3D",
    width="int",
    height="int",
    depth_or_array_layers="int",
)  #:
