"""
All wgpu enums. Also available in the root wgpu namespace.
"""

# THIS CODE IS AUTOGENERATED - DO NOT EDIT

_use_sphinx_repr = False


class Enum:
    def __init__(self, name, **kwargs):
        self._name = name
        for key, val in kwargs.items():
            setattr(self, key, val)

    def __iter__(self):
        return iter(
            [getattr(self, key) for key in dir(self) if not key.startswith("_")]
        )

    def __repr__(self):
        options = ", ".join(f"'{x}'" for x in self)
        if _use_sphinx_repr:  # no-cover
            return options
        return f"<{self.__class__.__name__} {self._name}: {options}>"


# There are 29 enums

PowerPreference = Enum(
    "PowerPreference",
    low_power="low-power",
    high_performance="high-performance",
)  #:

FeatureName = Enum(
    "FeatureName",
    depth_clamping="depth-clamping",
    depth24unorm_stencil8="depth24unorm-stencil8",
    depth32float_stencil8="depth32float-stencil8",
    pipeline_statistics_query="pipeline-statistics-query",
    texture_compression_bc="texture-compression-bc",
    timestamp_query="timestamp-query",
)  #:

TextureDimension = Enum(
    "TextureDimension",
    d1="1d",
    d2="2d",
    d3="3d",
)  #:

TextureViewDimension = Enum(
    "TextureViewDimension",
    d1="1d",
    d2="2d",
    d2_array="2d-array",
    cube="cube",
    cube_array="cube-array",
    d3="3d",
)  #:

TextureAspect = Enum(
    "TextureAspect",
    all="all",
    stencil_only="stencil-only",
    depth_only="depth-only",
)  #:

TextureFormat = Enum(
    "TextureFormat",
    r8unorm="r8unorm",
    r8snorm="r8snorm",
    r8uint="r8uint",
    r8sint="r8sint",
    r16uint="r16uint",
    r16sint="r16sint",
    r16float="r16float",
    rg8unorm="rg8unorm",
    rg8snorm="rg8snorm",
    rg8uint="rg8uint",
    rg8sint="rg8sint",
    r32uint="r32uint",
    r32sint="r32sint",
    r32float="r32float",
    rg16uint="rg16uint",
    rg16sint="rg16sint",
    rg16float="rg16float",
    rgba8unorm="rgba8unorm",
    rgba8unorm_srgb="rgba8unorm-srgb",
    rgba8snorm="rgba8snorm",
    rgba8uint="rgba8uint",
    rgba8sint="rgba8sint",
    bgra8unorm="bgra8unorm",
    bgra8unorm_srgb="bgra8unorm-srgb",
    rgb9e5ufloat="rgb9e5ufloat",
    rgb10a2unorm="rgb10a2unorm",
    rg11b10ufloat="rg11b10ufloat",
    rg32uint="rg32uint",
    rg32sint="rg32sint",
    rg32float="rg32float",
    rgba16uint="rgba16uint",
    rgba16sint="rgba16sint",
    rgba16float="rgba16float",
    rgba32uint="rgba32uint",
    rgba32sint="rgba32sint",
    rgba32float="rgba32float",
    stencil8="stencil8",
    depth16unorm="depth16unorm",
    depth24plus="depth24plus",
    depth24plus_stencil8="depth24plus-stencil8",
    depth32float="depth32float",
    bc1_rgba_unorm="bc1-rgba-unorm",
    bc1_rgba_unorm_srgb="bc1-rgba-unorm-srgb",
    bc2_rgba_unorm="bc2-rgba-unorm",
    bc2_rgba_unorm_srgb="bc2-rgba-unorm-srgb",
    bc3_rgba_unorm="bc3-rgba-unorm",
    bc3_rgba_unorm_srgb="bc3-rgba-unorm-srgb",
    bc4_r_unorm="bc4-r-unorm",
    bc4_r_snorm="bc4-r-snorm",
    bc5_rg_unorm="bc5-rg-unorm",
    bc5_rg_snorm="bc5-rg-snorm",
    bc6h_rgb_ufloat="bc6h-rgb-ufloat",
    bc6h_rgb_float="bc6h-rgb-float",
    bc7_rgba_unorm="bc7-rgba-unorm",
    bc7_rgba_unorm_srgb="bc7-rgba-unorm-srgb",
    depth24unorm_stencil8="depth24unorm-stencil8",
    depth32float_stencil8="depth32float-stencil8",
)  #:

AddressMode = Enum(
    "AddressMode",
    clamp_to_edge="clamp-to-edge",
    repeat="repeat",
    mirror_repeat="mirror-repeat",
)  #:

FilterMode = Enum(
    "FilterMode",
    nearest="nearest",
    linear="linear",
)  #:

CompareFunction = Enum(
    "CompareFunction",
    never="never",
    less="less",
    equal="equal",
    less_equal="less-equal",
    greater="greater",
    not_equal="not-equal",
    greater_equal="greater-equal",
    always="always",
)  #:

BufferBindingType = Enum(
    "BufferBindingType",
    uniform="uniform",
    storage="storage",
    read_only_storage="read-only-storage",
)  #:

SamplerBindingType = Enum(
    "SamplerBindingType",
    filtering="filtering",
    non_filtering="non-filtering",
    comparison="comparison",
)  #:

TextureSampleType = Enum(
    "TextureSampleType",
    float="float",
    unfilterable_float="unfilterable-float",
    depth="depth",
    sint="sint",
    uint="uint",
)  #:

StorageTextureAccess = Enum(
    "StorageTextureAccess",
    read_only="read-only",
    write_only="write-only",
)  #:

CompilationMessageType = Enum(
    "CompilationMessageType",
    error="error",
    warning="warning",
    info="info",
)  #:

PrimitiveTopology = Enum(
    "PrimitiveTopology",
    point_list="point-list",
    line_list="line-list",
    line_strip="line-strip",
    triangle_list="triangle-list",
    triangle_strip="triangle-strip",
)  #:

FrontFace = Enum(
    "FrontFace",
    ccw="ccw",
    cw="cw",
)  #:

CullMode = Enum(
    "CullMode",
    none="none",
    front="front",
    back="back",
)  #:

BlendFactor = Enum(
    "BlendFactor",
    zero="zero",
    one="one",
    src_component="src-component",
    one_minus_src_component="one-minus-src-component",
    src_alpha="src-alpha",
    one_minus_src_alpha="one-minus-src-alpha",
    dst_component="dst-component",
    one_minus_dst_component="one-minus-dst-component",
    dst_alpha="dst-alpha",
    one_minus_dst_alpha="one-minus-dst-alpha",
    src_alpha_saturated="src-alpha-saturated",
    blendcolor_component="blendcolor-component",
    one_minus_blendcolor_component="one-minus-blendcolor-component",
)  #:

BlendOperation = Enum(
    "BlendOperation",
    add="add",
    subtract="subtract",
    reverse_subtract="reverse-subtract",
    min="min",
    max="max",
)  #:

StencilOperation = Enum(
    "StencilOperation",
    keep="keep",
    zero="zero",
    replace="replace",
    invert="invert",
    increment_clamp="increment-clamp",
    decrement_clamp="decrement-clamp",
    increment_wrap="increment-wrap",
    decrement_wrap="decrement-wrap",
)  #:

IndexFormat = Enum(
    "IndexFormat",
    uint16="uint16",
    uint32="uint32",
)  #:

VertexFormat = Enum(
    "VertexFormat",
    uint8x2="uint8x2",
    uint8x4="uint8x4",
    sint8x2="sint8x2",
    sint8x4="sint8x4",
    unorm8x2="unorm8x2",
    unorm8x4="unorm8x4",
    snorm8x2="snorm8x2",
    snorm8x4="snorm8x4",
    uint16x2="uint16x2",
    uint16x4="uint16x4",
    sint16x2="sint16x2",
    sint16x4="sint16x4",
    unorm16x2="unorm16x2",
    unorm16x4="unorm16x4",
    snorm16x2="snorm16x2",
    snorm16x4="snorm16x4",
    float16x2="float16x2",
    float16x4="float16x4",
    float32="float32",
    float32x2="float32x2",
    float32x3="float32x3",
    float32x4="float32x4",
    uint32="uint32",
    uint32x2="uint32x2",
    uint32x3="uint32x3",
    uint32x4="uint32x4",
    sint32="sint32",
    sint32x2="sint32x2",
    sint32x3="sint32x3",
    sint32x4="sint32x4",
)  #:

InputStepMode = Enum(
    "InputStepMode",
    vertex="vertex",
    instance="instance",
)  #:

LoadOp = Enum(
    "LoadOp",
    load="load",
)  #:

StoreOp = Enum(
    "StoreOp",
    store="store",
    clear="clear",
)  #:

QueryType = Enum(
    "QueryType",
    occlusion="occlusion",
    pipeline_statistics="pipeline-statistics",
    timestamp="timestamp",
)  #:

PipelineStatisticName = Enum(
    "PipelineStatisticName",
    vertex_shader_invocations="vertex-shader-invocations",
    clipper_invocations="clipper-invocations",
    clipper_primitives_out="clipper-primitives-out",
    fragment_shader_invocations="fragment-shader-invocations",
    compute_shader_invocations="compute-shader-invocations",
)  #:

DeviceLostReason = Enum(
    "DeviceLostReason",
    destroyed="destroyed",
)  #:

ErrorFilter = Enum(
    "ErrorFilter",
    out_of_memory="out-of-memory",
    validation="validation",
)  #:
