# Dispersion

The **dispersion** Python package provides a way of loading and evaluating files
containing the dispersion of the refractive index of materials.

[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)
[![DOI](https://zenodo.org/badge/238195637.svg)](https://zenodo.org/badge/latestdoi/238195637)

Read the full documentation at https://dispersion.readthedocs.io/en/latest/index.html

## Background

In optics, the phenomenon that the refractive index depends upon the
frequency is called the phenomenon of dispersion, because it is the basis
of the fact that light is "dispersed" by a prism into a spectrum.

Feynman Lectures in physics

## Getting Started

Python is required to install and use the **dispersion** package. It
is recommended to use a package manager such as pip to install the package.
::

  > pip install dispersion

now we need to tell the package where you are going to store the material data
files. To do this we run the script that comes with the package
::

  > dispersion_setup

This script will ask you to type in the path to a folder where the database
file structure will be installed. Secondly, you will be asked to
name the database. Finally you will be asked if you would like to install
the available modules.

Now that the database has been setup, we can start using the package. For
examples and further documentation, see the related pages.
