# Generated by Django 4.1.5 on 2023-01-14 21:14

from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name='League',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                ('name', models.CharField(max_length=255)),
                (
                    'uuid',
                    models.UUIDField(
                        blank=True,
                        default=uuid.uuid4,
                        editable=False,
                        null=True,
                    ),
                ),
                (
                    'logo',
                    models.ImageField(
                        blank=True, null=True, upload_to='sports/league-logos/'
                    ),
                ),
                (
                    'abbreviation_str',
                    models.CharField(blank=True, max_length=10, null=True),
                ),
                ('thesportsdb_id', models.IntegerField(blank=True, null=True)),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Team',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                ('name', models.CharField(max_length=255)),
                (
                    'uuid',
                    models.UUIDField(
                        blank=True,
                        default=uuid.uuid4,
                        editable=False,
                        null=True,
                    ),
                ),
                ('thesportsdb_id', models.IntegerField(blank=True, null=True)),
                (
                    'league',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to='sports.league',
                    ),
                ),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SportEvent',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                (
                    'uuid',
                    models.UUIDField(
                        blank=True,
                        default=uuid.uuid4,
                        editable=False,
                        null=True,
                    ),
                ),
                (
                    'title',
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    'run_time',
                    models.CharField(blank=True, max_length=8, null=True),
                ),
                (
                    'run_time_ticks',
                    models.PositiveBigIntegerField(blank=True, null=True),
                ),
                (
                    'event_type',
                    models.CharField(
                        choices=[
                            ('UK', 'Unknown'),
                            ('GA', 'Game'),
                            ('MA', 'Match'),
                            ('ME', 'Meet'),
                        ],
                        default='UK',
                        max_length=2,
                    ),
                ),
                ('start_utc', models.DateTimeField(blank=True, null=True)),
                (
                    'season',
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    'away_team',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='away_event_set',
                        to='sports.team',
                    ),
                ),
                (
                    'home_team',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='home_event_set',
                        to='sports.team',
                    ),
                ),
                (
                    'league',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to='sports.league',
                    ),
                ),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
