"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpUserPoolAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const core_1 = require("@aws-cdk/core");
/**
 * Authorize Http Api routes on whether the requester is registered as part of
 * an AWS Cognito user pool.
 */
class HttpUserPoolAuthorizer {
    /**
     * Initialize a Cognito user pool authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The user pool to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, pool, props = {}) {
        this.id = id;
        this.pool = pool;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpUserPoolAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(options) {
        var _b, _c, _d, _e;
        if (!this.authorizer) {
            const region = (_b = this.props.userPoolRegion) !== null && _b !== void 0 ? _b : core_1.Stack.of(options.scope).region;
            const clients = (_c = this.props.userPoolClients) !== null && _c !== void 0 ? _c : [this.pool.addClient('UserPoolAuthorizerClient')];
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_d = this.props.identitySource) !== null && _d !== void 0 ? _d : ['$request.header.Authorization'],
                type: aws_apigatewayv2_1.HttpAuthorizerType.JWT,
                authorizerName: (_e = this.props.authorizerName) !== null && _e !== void 0 ? _e : this.id,
                jwtAudience: clients.map((c) => c.userPoolClientId),
                jwtIssuer: `https://cognito-idp.${region}.amazonaws.com/${this.pool.userPoolId}`,
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'JWT',
        };
    }
}
exports.HttpUserPoolAuthorizer = HttpUserPoolAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpUserPoolAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpUserPoolAuthorizer", version: "1.155.0" };
//# sourceMappingURL=data:application/json;base64,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