"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaAuthorizer = exports.HttpLambdaResponseType = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_1 = require("@aws-cdk/aws-apigatewayv2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
/**
 * Specifies the type responses the lambda returns
 */
var HttpLambdaResponseType;
(function (HttpLambdaResponseType) {
    /** Returns simple boolean response */
    HttpLambdaResponseType[HttpLambdaResponseType["SIMPLE"] = 0] = "SIMPLE";
    /** Returns an IAM Policy */
    HttpLambdaResponseType[HttpLambdaResponseType["IAM"] = 1] = "IAM";
})(HttpLambdaResponseType = exports.HttpLambdaResponseType || (exports.HttpLambdaResponseType = {}));
/**
 * Authorize Http Api routes via a lambda function
 */
class HttpLambdaAuthorizer {
    /**
     * Initialize a lambda authorizer to be bound with HTTP route.
     * @param id The id of the underlying construct
     * @param pool The lambda function handler to use for authorization
     * @param props Properties to configure the authorizer
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_HttpLambdaAuthorizerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
    bind(options) {
        var _b, _c, _d, _e;
        if (this.httpApi && (this.httpApi.apiId !== options.route.httpApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            const responseTypes = (_b = this.props.responseTypes) !== null && _b !== void 0 ? _b : [HttpLambdaResponseType.IAM];
            const enableSimpleResponses = responseTypes.includes(HttpLambdaResponseType.SIMPLE) || undefined;
            this.httpApi = options.route.httpApi;
            this.authorizer = new aws_apigatewayv2_1.HttpAuthorizer(options.scope, this.id, {
                httpApi: options.route.httpApi,
                identitySource: (_c = this.props.identitySource) !== null && _c !== void 0 ? _c : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_1.HttpAuthorizerType.LAMBDA,
                authorizerName: (_d = this.props.authorizerName) !== null && _d !== void 0 ? _d : this.id,
                enableSimpleResponses,
                payloadFormatVersion: enableSimpleResponses ? aws_apigatewayv2_1.AuthorizerPayloadVersion.VERSION_2_0 : aws_apigatewayv2_1.AuthorizerPayloadVersion.VERSION_1_0,
                authorizerUri: lambdaAuthorizerArn(this.handler),
                resultsCacheTtl: (_e = this.props.resultsCacheTtl) !== null && _e !== void 0 ? _e : core_1.Duration.minutes(5),
            });
            this.handler.addPermission(`${core_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: core_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.httpApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.HttpLambdaAuthorizer = HttpLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers.HttpLambdaAuthorizer", version: "1.155.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${core_1.Stack.of(handler).partition}:apigateway:${core_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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