# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.5.0.20211029.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class Secure3DAuthenticationRequest(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'authentication_type': 'str',
        'term_url': 'str',
        'method_notification_url': 'str',
        'challenge_indicator': 'str',
        'message_category': 'str',
        'challenge_window_size': 'str',
        'browser_java_script_enabled': 'bool',
        'secure3_d_device_channel': 'str',
        'secure3_d_three_ri_indicator': 'str',
        'authentication_indicator': 'str',
        'recurring_expiry': 'str',
        'recurring_frequency': 'int'
    }

    attribute_map = {
        'authentication_type': 'authenticationType',
        'term_url': 'termURL',
        'method_notification_url': 'methodNotificationURL',
        'challenge_indicator': 'challengeIndicator',
        'message_category': 'messageCategory',
        'challenge_window_size': 'challengeWindowSize',
        'browser_java_script_enabled': 'browserJavaScriptEnabled',
        'secure3_d_device_channel': 'secure3DDeviceChannel',
        'secure3_d_three_ri_indicator': 'secure3DThreeRIIndicator',
        'authentication_indicator': 'authenticationIndicator',
        'recurring_expiry': 'recurringExpiry',
        'recurring_frequency': 'recurringFrequency'
    }

    def __init__(self, authentication_type=None, term_url=None, method_notification_url=None, challenge_indicator='01', message_category=None, challenge_window_size=None, browser_java_script_enabled=None, secure3_d_device_channel=None, secure3_d_three_ri_indicator=None, authentication_indicator='01', recurring_expiry=None, recurring_frequency=None):  # noqa: E501
        """Secure3DAuthenticationRequest - a model defined in OpenAPI"""  # noqa: E501

        self._authentication_type = None
        self._term_url = None
        self._method_notification_url = None
        self._challenge_indicator = None
        self._message_category = None
        self._challenge_window_size = None
        self._browser_java_script_enabled = None
        self._secure3_d_device_channel = None
        self._secure3_d_three_ri_indicator = None
        self._authentication_indicator = None
        self._recurring_expiry = None
        self._recurring_frequency = None
        self.discriminator = None

        self.authentication_type = authentication_type
        self.term_url = term_url
        self.method_notification_url = method_notification_url
        if challenge_indicator is not None:
            self.challenge_indicator = challenge_indicator
        if message_category is not None:
            self.message_category = message_category
        if challenge_window_size is not None:
            self.challenge_window_size = challenge_window_size
        self.browser_java_script_enabled = browser_java_script_enabled
        self.secure3_d_device_channel = secure3_d_device_channel
        self.secure3_d_three_ri_indicator = secure3_d_three_ri_indicator
        if authentication_indicator is not None:
            self.authentication_indicator = authentication_indicator
        self.recurring_expiry = recurring_expiry
        self.recurring_frequency = recurring_frequency

    @property
    def authentication_type(self):
        """Gets the authentication_type of this Secure3DAuthenticationRequest.  # noqa: E501

        Indicates what kind of authentication scheme the merchant wants to use on the card.  # noqa: E501

        :return: The authentication_type of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._authentication_type

    @authentication_type.setter
    def authentication_type(self, authentication_type):
        """Sets the authentication_type of this Secure3DAuthenticationRequest.

        Indicates what kind of authentication scheme the merchant wants to use on the card.  # noqa: E501

        :param authentication_type: The authentication_type of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        if authentication_type is None:
            raise ValueError("Invalid value for `authentication_type`, must not be `None`")  # noqa: E501

        self._authentication_type = authentication_type

    @property
    def term_url(self):
        """Gets the term_url of this Secure3DAuthenticationRequest.  # noqa: E501

        The result of the authentication will be sent to this URL. If not provided, a term URL will be dynamically generated. Note this must be a valid URL (special characters should be URL-encoded).  # noqa: E501

        :return: The term_url of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._term_url

    @term_url.setter
    def term_url(self, term_url):
        """Sets the term_url of this Secure3DAuthenticationRequest.

        The result of the authentication will be sent to this URL. If not provided, a term URL will be dynamically generated. Note this must be a valid URL (special characters should be URL-encoded).  # noqa: E501

        :param term_url: The term_url of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        if term_url is None:
            raise ValueError("Invalid value for `term_url`, must not be `None`")  # noqa: E501

        self._term_url = term_url

    @property
    def method_notification_url(self):
        """Gets the method_notification_url of this Secure3DAuthenticationRequest.  # noqa: E501

        The 3DS method iframe and transaction ID will be sent here. Note this must be a valid URL (special characters should be URL-encoded).  # noqa: E501

        :return: The method_notification_url of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._method_notification_url

    @method_notification_url.setter
    def method_notification_url(self, method_notification_url):
        """Sets the method_notification_url of this Secure3DAuthenticationRequest.

        The 3DS method iframe and transaction ID will be sent here. Note this must be a valid URL (special characters should be URL-encoded).  # noqa: E501

        :param method_notification_url: The method_notification_url of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        if method_notification_url is None:
            raise ValueError("Invalid value for `method_notification_url`, must not be `None`")  # noqa: E501

        self._method_notification_url = method_notification_url

    @property
    def challenge_indicator(self):
        """Gets the challenge_indicator of this Secure3DAuthenticationRequest.  # noqa: E501

        Indicates whether or not a challenge should be performed. 01 = No preference (You have no preference whether a challenge should be performed. This is the default value) 02 = No challenge requested (You prefer that no challenge should be performed) 03 = Challenge requested: 3DS Requestor Preference (You prefer that a challenge should be performed) 04 = Challenge requested: Mandate (There are local or regional mandates that mean that a challenge must be performed) The following are applicable only for 3DS 2.2 protocol. 05 = No challenge requested (transactional risk analysis is already performed) 06 = No challenge requested (Data share only) 07 = No challenge requested (strong consumer authentication is already performed) 08 = No challenge requested (utilise whitelist exemption if no challenge required) 09 = Challenge requested (whitelist prompt requested if challenge required)   # noqa: E501

        :return: The challenge_indicator of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._challenge_indicator

    @challenge_indicator.setter
    def challenge_indicator(self, challenge_indicator):
        """Sets the challenge_indicator of this Secure3DAuthenticationRequest.

        Indicates whether or not a challenge should be performed. 01 = No preference (You have no preference whether a challenge should be performed. This is the default value) 02 = No challenge requested (You prefer that no challenge should be performed) 03 = Challenge requested: 3DS Requestor Preference (You prefer that a challenge should be performed) 04 = Challenge requested: Mandate (There are local or regional mandates that mean that a challenge must be performed) The following are applicable only for 3DS 2.2 protocol. 05 = No challenge requested (transactional risk analysis is already performed) 06 = No challenge requested (Data share only) 07 = No challenge requested (strong consumer authentication is already performed) 08 = No challenge requested (utilise whitelist exemption if no challenge required) 09 = Challenge requested (whitelist prompt requested if challenge required)   # noqa: E501

        :param challenge_indicator: The challenge_indicator of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["01", "02", "03", "04", "05", "06", "07", "08", "09"]  # noqa: E501
        if challenge_indicator not in allowed_values:
            raise ValueError(
                "Invalid value for `challenge_indicator` ({0}), must be one of {1}"  # noqa: E501
                .format(challenge_indicator, allowed_values)
            )

        self._challenge_indicator = challenge_indicator

    @property
    def message_category(self):
        """Gets the message_category of this Secure3DAuthenticationRequest.  # noqa: E501

        Indicates the message category of 3d secure authentication version 2.X. 01 = Payment Authentication 02 = Non-Payment Authentication 80 = Mastercard Data Only   # noqa: E501

        :return: The message_category of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._message_category

    @message_category.setter
    def message_category(self, message_category):
        """Sets the message_category of this Secure3DAuthenticationRequest.

        Indicates the message category of 3d secure authentication version 2.X. 01 = Payment Authentication 02 = Non-Payment Authentication 80 = Mastercard Data Only   # noqa: E501

        :param message_category: The message_category of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["01", "02", "80"]  # noqa: E501
        if message_category not in allowed_values:
            raise ValueError(
                "Invalid value for `message_category` ({0}), must be one of {1}"  # noqa: E501
                .format(message_category, allowed_values)
            )

        self._message_category = message_category

    @property
    def challenge_window_size(self):
        """Gets the challenge_window_size of this Secure3DAuthenticationRequest.  # noqa: E501

        Defines the size of the challenge window displayed to customers during authentication. 01 = 250 x 400 02 = 390 x 400 03 = 500 x 600 04 = 600 x 400 05 = Full screen   # noqa: E501

        :return: The challenge_window_size of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._challenge_window_size

    @challenge_window_size.setter
    def challenge_window_size(self, challenge_window_size):
        """Sets the challenge_window_size of this Secure3DAuthenticationRequest.

        Defines the size of the challenge window displayed to customers during authentication. 01 = 250 x 400 02 = 390 x 400 03 = 500 x 600 04 = 600 x 400 05 = Full screen   # noqa: E501

        :param challenge_window_size: The challenge_window_size of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["01", "02", "03", "04", "05"]  # noqa: E501
        if challenge_window_size not in allowed_values:
            raise ValueError(
                "Invalid value for `challenge_window_size` ({0}), must be one of {1}"  # noqa: E501
                .format(challenge_window_size, allowed_values)
            )

        self._challenge_window_size = challenge_window_size

    @property
    def browser_java_script_enabled(self):
        """Gets the browser_java_script_enabled of this Secure3DAuthenticationRequest.  # noqa: E501

        Indicates if the browser issuing the request is capable of performing JavaScript.  # noqa: E501

        :return: The browser_java_script_enabled of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: bool
        """
        return self._browser_java_script_enabled

    @browser_java_script_enabled.setter
    def browser_java_script_enabled(self, browser_java_script_enabled):
        """Sets the browser_java_script_enabled of this Secure3DAuthenticationRequest.

        Indicates if the browser issuing the request is capable of performing JavaScript.  # noqa: E501

        :param browser_java_script_enabled: The browser_java_script_enabled of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: bool
        """

        self._browser_java_script_enabled = browser_java_script_enabled

    @property
    def secure3_d_device_channel(self):
        """Gets the secure3_d_device_channel of this Secure3DAuthenticationRequest.  # noqa: E501

        02 = BRW 03 = 3RI   # noqa: E501

        :return: The secure3_d_device_channel of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._secure3_d_device_channel

    @secure3_d_device_channel.setter
    def secure3_d_device_channel(self, secure3_d_device_channel):
        """Sets the secure3_d_device_channel of this Secure3DAuthenticationRequest.

        02 = BRW 03 = 3RI   # noqa: E501

        :param secure3_d_device_channel: The secure3_d_device_channel of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None,"02", "03"]  # noqa: E501
        if secure3_d_device_channel not in allowed_values:
            raise ValueError(
                "Invalid value for `secure3_d_device_channel` ({0}), must be one of {1}"  # noqa: E501
                .format(secure3_d_device_channel, allowed_values)
            )

        self._secure3_d_device_channel = secure3_d_device_channel

    @property
    def secure3_d_three_ri_indicator(self):
        """Gets the secure3_d_three_ri_indicator of this Secure3DAuthenticationRequest.  # noqa: E501

        01 = Recurring transaction 02 = Instalment transaction 03 = Add card 04 = Maintain card information 05 = Account verification 06 = Split/delayed shipment 07 = Top-up 08 = Mail Order 09 = Telephone Order 10 = Whitelist status check 11 = Other payment   # noqa: E501

        :return: The secure3_d_three_ri_indicator of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._secure3_d_three_ri_indicator

    @secure3_d_three_ri_indicator.setter
    def secure3_d_three_ri_indicator(self, secure3_d_three_ri_indicator):
        """Sets the secure3_d_three_ri_indicator of this Secure3DAuthenticationRequest.

        01 = Recurring transaction 02 = Instalment transaction 03 = Add card 04 = Maintain card information 05 = Account verification 06 = Split/delayed shipment 07 = Top-up 08 = Mail Order 09 = Telephone Order 10 = Whitelist status check 11 = Other payment   # noqa: E501

        :param secure3_d_three_ri_indicator: The secure3_d_three_ri_indicator of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        allowed_values = [None,"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11"]  # noqa: E501
        if secure3_d_three_ri_indicator not in allowed_values:
            raise ValueError(
                "Invalid value for `secure3_d_three_ri_indicator` ({0}), must be one of {1}"  # noqa: E501
                .format(secure3_d_three_ri_indicator, allowed_values)
            )

        self._secure3_d_three_ri_indicator = secure3_d_three_ri_indicator

    @property
    def authentication_indicator(self):
        """Gets the authentication_indicator of this Secure3DAuthenticationRequest.  # noqa: E501

        Provides additional information to the ACS to determine the best approach for handling an authentication request. 01 = Payment transaction 02 = Recurring transaction 03 = Installment transaction 04 = Add card 05 = Maintain card 06 = Card holder verification as part of EMV token ID and Value   # noqa: E501

        :return: The authentication_indicator of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._authentication_indicator

    @authentication_indicator.setter
    def authentication_indicator(self, authentication_indicator):
        """Sets the authentication_indicator of this Secure3DAuthenticationRequest.

        Provides additional information to the ACS to determine the best approach for handling an authentication request. 01 = Payment transaction 02 = Recurring transaction 03 = Installment transaction 04 = Add card 05 = Maintain card 06 = Card holder verification as part of EMV token ID and Value   # noqa: E501

        :param authentication_indicator: The authentication_indicator of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        allowed_values = ["01", "02", "03", "04", "05", "06"]  # noqa: E501
        if authentication_indicator not in allowed_values:
            raise ValueError(
                "Invalid value for `authentication_indicator` ({0}), must be one of {1}"  # noqa: E501
                .format(authentication_indicator, allowed_values)
            )

        self._authentication_indicator = authentication_indicator

    @property
    def recurring_expiry(self):
        """Gets the recurring_expiry of this Secure3DAuthenticationRequest.  # noqa: E501

        Date after which no further authorisations shall be performed.  # noqa: E501

        :return: The recurring_expiry of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: str
        """
        return self._recurring_expiry

    @recurring_expiry.setter
    def recurring_expiry(self, recurring_expiry):
        """Sets the recurring_expiry of this Secure3DAuthenticationRequest.

        Date after which no further authorisations shall be performed.  # noqa: E501

        :param recurring_expiry: The recurring_expiry of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: str
        """
        if recurring_expiry is not None and not re.search(r'^([0-9]{4})(1[0-2]|0[1-9])(3[01]|0[1-9]|[12][0-9])$', recurring_expiry):  # noqa: E501
            raise ValueError(r"Invalid value for `recurring_expiry`, must be a follow pattern or equal to `/^([0-9]{4})(1[0-2]|0[1-9])(3[01]|0[1-9]|[12][0-9])$/`")  # noqa: E501

        self._recurring_expiry = recurring_expiry

    @property
    def recurring_frequency(self):
        """Gets the recurring_frequency of this Secure3DAuthenticationRequest.  # noqa: E501

        Indicates the minimum number of days between authorisations.  # noqa: E501

        :return: The recurring_frequency of this Secure3DAuthenticationRequest.  # noqa: E501
        :rtype: int
        """
        return self._recurring_frequency

    @recurring_frequency.setter
    def recurring_frequency(self, recurring_frequency):
        """Sets the recurring_frequency of this Secure3DAuthenticationRequest.

        Indicates the minimum number of days between authorisations.  # noqa: E501

        :param recurring_frequency: The recurring_frequency of this Secure3DAuthenticationRequest.  # noqa: E501
        :type: int
        """
        if recurring_frequency is not None and recurring_frequency > 9999:  # noqa: E501
            raise ValueError("Invalid value for `recurring_frequency`, must be a value less than or equal to `9999`")  # noqa: E501
        if recurring_frequency is not None and recurring_frequency < 1:  # noqa: E501
            raise ValueError("Invalid value for `recurring_frequency`, must be a value greater than or equal to `1`")  # noqa: E501

        self._recurring_frequency = recurring_frequency

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Secure3DAuthenticationRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
