# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.5.0.20211029.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class RedirectAttributes(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'challenge_indicator': 'str',
        'authenticate_transaction': 'bool',
        'three_ds_emv_co_message_category': 'str',
        'browser_java_script_enabled': 'bool',
        'override3ds_country_exclusion': 'bool',
        'three_ds_transaction_type': 'str',
        'skip_tra': 'bool',
        'full_bypass': 'bool',
        'mobile_mode': 'bool',
        'payment_mode': 'str',
        'language': 'str'
    }

    attribute_map = {
        'challenge_indicator': 'challengeIndicator',
        'authenticate_transaction': 'authenticateTransaction',
        'three_ds_emv_co_message_category': 'threeDSEmvCoMessageCategory',
        'browser_java_script_enabled': 'browserJavaScriptEnabled',
        'override3ds_country_exclusion': 'override3dsCountryExclusion',
        'three_ds_transaction_type': 'threeDSTransactionType',
        'skip_tra': 'skipTRA',
        'full_bypass': 'fullBypass',
        'mobile_mode': 'mobileMode',
        'payment_mode': 'paymentMode',
        'language': 'language'
    }

    def __init__(self, challenge_indicator='01', authenticate_transaction=None, three_ds_emv_co_message_category=None, browser_java_script_enabled=False, override3ds_country_exclusion=False, three_ds_transaction_type=None, skip_tra=False, full_bypass=False, mobile_mode=False, payment_mode=None, language=None):  # noqa: E501
        """RedirectAttributes - a model defined in OpenAPI"""  # noqa: E501

        self._challenge_indicator = None
        self._authenticate_transaction = None
        self._three_ds_emv_co_message_category = None
        self._browser_java_script_enabled = None
        self._override3ds_country_exclusion = None
        self._three_ds_transaction_type = None
        self._skip_tra = None
        self._full_bypass = None
        self._mobile_mode = None
        self._payment_mode = None
        self._language = None
        self.discriminator = None

        if challenge_indicator is not None:
            self.challenge_indicator = challenge_indicator
        if authenticate_transaction is not None:
            self.authenticate_transaction = authenticate_transaction
        if three_ds_emv_co_message_category is not None:
            self.three_ds_emv_co_message_category = three_ds_emv_co_message_category
        if browser_java_script_enabled is not None:
            self.browser_java_script_enabled = browser_java_script_enabled
        if override3ds_country_exclusion is not None:
            self.override3ds_country_exclusion = override3ds_country_exclusion
        if three_ds_transaction_type is not None:
            self.three_ds_transaction_type = three_ds_transaction_type
        if skip_tra is not None:
            self.skip_tra = skip_tra
        if full_bypass is not None:
            self.full_bypass = full_bypass
        if mobile_mode is not None:
            self.mobile_mode = mobile_mode
        if payment_mode is not None:
            self.payment_mode = payment_mode
        if language is not None:
            self.language = language

    @property
    def challenge_indicator(self):
        """Gets the challenge_indicator of this RedirectAttributes.  # noqa: E501

        Indicates whether or not a challenge should be performed. 01 = No preference (You have no preference whether a challenge should be performed. This is the default value) 02 = No challenge requested (You prefer that no challenge should be performed) 03 = Challenge requested: 3DS Requestor Preference (You prefer that a challenge should be performed) 04 = Challenge requested: Mandate (There are local or regional mandates that mean that a challenge must be performed)   # noqa: E501

        :return: The challenge_indicator of this RedirectAttributes.  # noqa: E501
        :rtype: str
        """
        return self._challenge_indicator

    @challenge_indicator.setter
    def challenge_indicator(self, challenge_indicator):
        """Sets the challenge_indicator of this RedirectAttributes.

        Indicates whether or not a challenge should be performed. 01 = No preference (You have no preference whether a challenge should be performed. This is the default value) 02 = No challenge requested (You prefer that no challenge should be performed) 03 = Challenge requested: 3DS Requestor Preference (You prefer that a challenge should be performed) 04 = Challenge requested: Mandate (There are local or regional mandates that mean that a challenge must be performed)   # noqa: E501

        :param challenge_indicator: The challenge_indicator of this RedirectAttributes.  # noqa: E501
        :type: str
        """
        allowed_values = ["01", "02", "03", "04"]  # noqa: E501
        if challenge_indicator not in allowed_values:
            raise ValueError(
                "Invalid value for `challenge_indicator` ({0}), must be one of {1}"  # noqa: E501
                .format(challenge_indicator, allowed_values)
            )

        self._challenge_indicator = challenge_indicator

    @property
    def authenticate_transaction(self):
        """Gets the authenticate_transaction of this RedirectAttributes.  # noqa: E501

        If 3D secure should be applied.  # noqa: E501

        :return: The authenticate_transaction of this RedirectAttributes.  # noqa: E501
        :rtype: bool
        """
        return self._authenticate_transaction

    @authenticate_transaction.setter
    def authenticate_transaction(self, authenticate_transaction):
        """Sets the authenticate_transaction of this RedirectAttributes.

        If 3D secure should be applied.  # noqa: E501

        :param authenticate_transaction: The authenticate_transaction of this RedirectAttributes.  # noqa: E501
        :type: bool
        """

        self._authenticate_transaction = authenticate_transaction

    @property
    def three_ds_emv_co_message_category(self):
        """Gets the three_ds_emv_co_message_category of this RedirectAttributes.  # noqa: E501

        EmvCo Messag Category  # noqa: E501

        :return: The three_ds_emv_co_message_category of this RedirectAttributes.  # noqa: E501
        :rtype: str
        """
        return self._three_ds_emv_co_message_category

    @three_ds_emv_co_message_category.setter
    def three_ds_emv_co_message_category(self, three_ds_emv_co_message_category):
        """Sets the three_ds_emv_co_message_category of this RedirectAttributes.

        EmvCo Messag Category  # noqa: E501

        :param three_ds_emv_co_message_category: The three_ds_emv_co_message_category of this RedirectAttributes.  # noqa: E501
        :type: str
        """
        allowed_values = ["01", "02", "80"]  # noqa: E501
        if three_ds_emv_co_message_category not in allowed_values:
            raise ValueError(
                "Invalid value for `three_ds_emv_co_message_category` ({0}), must be one of {1}"  # noqa: E501
                .format(three_ds_emv_co_message_category, allowed_values)
            )

        self._three_ds_emv_co_message_category = three_ds_emv_co_message_category

    @property
    def browser_java_script_enabled(self):
        """Gets the browser_java_script_enabled of this RedirectAttributes.  # noqa: E501

        Browser Java Script Enabled flag  # noqa: E501

        :return: The browser_java_script_enabled of this RedirectAttributes.  # noqa: E501
        :rtype: bool
        """
        return self._browser_java_script_enabled

    @browser_java_script_enabled.setter
    def browser_java_script_enabled(self, browser_java_script_enabled):
        """Sets the browser_java_script_enabled of this RedirectAttributes.

        Browser Java Script Enabled flag  # noqa: E501

        :param browser_java_script_enabled: The browser_java_script_enabled of this RedirectAttributes.  # noqa: E501
        :type: bool
        """

        self._browser_java_script_enabled = browser_java_script_enabled

    @property
    def override3ds_country_exclusion(self):
        """Gets the override3ds_country_exclusion of this RedirectAttributes.  # noqa: E501

        Override 3ds Country Exclusion flag  # noqa: E501

        :return: The override3ds_country_exclusion of this RedirectAttributes.  # noqa: E501
        :rtype: bool
        """
        return self._override3ds_country_exclusion

    @override3ds_country_exclusion.setter
    def override3ds_country_exclusion(self, override3ds_country_exclusion):
        """Sets the override3ds_country_exclusion of this RedirectAttributes.

        Override 3ds Country Exclusion flag  # noqa: E501

        :param override3ds_country_exclusion: The override3ds_country_exclusion of this RedirectAttributes.  # noqa: E501
        :type: bool
        """

        self._override3ds_country_exclusion = override3ds_country_exclusion

    @property
    def three_ds_transaction_type(self):
        """Gets the three_ds_transaction_type of this RedirectAttributes.  # noqa: E501

        Secure 3D Transaction Type  # noqa: E501

        :return: The three_ds_transaction_type of this RedirectAttributes.  # noqa: E501
        :rtype: str
        """
        return self._three_ds_transaction_type

    @three_ds_transaction_type.setter
    def three_ds_transaction_type(self, three_ds_transaction_type):
        """Sets the three_ds_transaction_type of this RedirectAttributes.

        Secure 3D Transaction Type  # noqa: E501

        :param three_ds_transaction_type: The three_ds_transaction_type of this RedirectAttributes.  # noqa: E501
        :type: str
        """
        allowed_values = ["01", "03", "10", "11", "28"]  # noqa: E501
        if three_ds_transaction_type not in allowed_values:
            raise ValueError(
                "Invalid value for `three_ds_transaction_type` ({0}), must be one of {1}"  # noqa: E501
                .format(three_ds_transaction_type, allowed_values)
            )

        self._three_ds_transaction_type = three_ds_transaction_type

    @property
    def skip_tra(self):
        """Gets the skip_tra of this RedirectAttributes.  # noqa: E501

        skip TRA exemption for the transaction  # noqa: E501

        :return: The skip_tra of this RedirectAttributes.  # noqa: E501
        :rtype: bool
        """
        return self._skip_tra

    @skip_tra.setter
    def skip_tra(self, skip_tra):
        """Sets the skip_tra of this RedirectAttributes.

        skip TRA exemption for the transaction  # noqa: E501

        :param skip_tra: The skip_tra of this RedirectAttributes.  # noqa: E501
        :type: bool
        """

        self._skip_tra = skip_tra

    @property
    def full_bypass(self):
        """Gets the full_bypass of this RedirectAttributes.  # noqa: E501

        Full by pass flag  # noqa: E501

        :return: The full_bypass of this RedirectAttributes.  # noqa: E501
        :rtype: bool
        """
        return self._full_bypass

    @full_bypass.setter
    def full_bypass(self, full_bypass):
        """Sets the full_bypass of this RedirectAttributes.

        Full by pass flag  # noqa: E501

        :param full_bypass: The full_bypass of this RedirectAttributes.  # noqa: E501
        :type: bool
        """

        self._full_bypass = full_bypass

    @property
    def mobile_mode(self):
        """Gets the mobile_mode of this RedirectAttributes.  # noqa: E501

        Mobile mode flag  # noqa: E501

        :return: The mobile_mode of this RedirectAttributes.  # noqa: E501
        :rtype: bool
        """
        return self._mobile_mode

    @mobile_mode.setter
    def mobile_mode(self, mobile_mode):
        """Sets the mobile_mode of this RedirectAttributes.

        Mobile mode flag  # noqa: E501

        :param mobile_mode: The mobile_mode of this RedirectAttributes.  # noqa: E501
        :type: bool
        """

        self._mobile_mode = mobile_mode

    @property
    def payment_mode(self):
        """Gets the payment_mode of this RedirectAttributes.  # noqa: E501

        Payment Mode  # noqa: E501

        :return: The payment_mode of this RedirectAttributes.  # noqa: E501
        :rtype: str
        """
        return self._payment_mode

    @payment_mode.setter
    def payment_mode(self, payment_mode):
        """Sets the payment_mode of this RedirectAttributes.

        Payment Mode  # noqa: E501

        :param payment_mode: The payment_mode of this RedirectAttributes.  # noqa: E501
        :type: str
        """
        allowed_values = ["FULLPAY", "PAYONLY", "PAYPLUS"]  # noqa: E501
        if payment_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `payment_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(payment_mode, allowed_values)
            )

        self._payment_mode = payment_mode

    @property
    def language(self):
        """Gets the language of this RedirectAttributes.  # noqa: E501

        Language used by client.  # noqa: E501

        :return: The language of this RedirectAttributes.  # noqa: E501
        :rtype: str
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this RedirectAttributes.

        Language used by client.  # noqa: E501

        :param language: The language of this RedirectAttributes.  # noqa: E501
        :type: str
        """
        if language is not None and not re.search(r'^(?!\s*$).+', language):  # noqa: E501
            raise ValueError(r"Invalid value for `language`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._language = language

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RedirectAttributes):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
