# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.5.0.20211029.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class EncryptedGooglePayData(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'encrypted_message': 'str',
        'ephemeral_public_key': 'str',
        'tag': 'str'
    }

    attribute_map = {
        'encrypted_message': 'encryptedMessage',
        'ephemeral_public_key': 'ephemeralPublicKey',
        'tag': 'tag'
    }

    def __init__(self, encrypted_message=None, ephemeral_public_key=None, tag=None):  # noqa: E501
        """EncryptedGooglePayData - a model defined in OpenAPI"""  # noqa: E501

        self._encrypted_message = None
        self._ephemeral_public_key = None
        self._tag = None
        self.discriminator = None

        self.encrypted_message = encrypted_message
        self.ephemeral_public_key = ephemeral_public_key
        self.tag = tag

    @property
    def encrypted_message(self):
        """Gets the encrypted_message of this EncryptedGooglePayData.  # noqa: E501

        The encrypted message containing the actual payment information as well as additional security fields.  # noqa: E501

        :return: The encrypted_message of this EncryptedGooglePayData.  # noqa: E501
        :rtype: str
        """
        return self._encrypted_message

    @encrypted_message.setter
    def encrypted_message(self, encrypted_message):
        """Sets the encrypted_message of this EncryptedGooglePayData.

        The encrypted message containing the actual payment information as well as additional security fields.  # noqa: E501

        :param encrypted_message: The encrypted_message of this EncryptedGooglePayData.  # noqa: E501
        :type: str
        """
        if encrypted_message is None:
            raise ValueError("Invalid value for `encrypted_message`, must not be `None`")  # noqa: E501
        if encrypted_message is not None and not re.search(r'^(?!\s*$).+', encrypted_message):  # noqa: E501
            raise ValueError(r"Invalid value for `encrypted_message`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._encrypted_message = encrypted_message

    @property
    def ephemeral_public_key(self):
        """Gets the ephemeral_public_key of this EncryptedGooglePayData.  # noqa: E501

        The ephemeral public key associated with the private key to encrypt the message in uncompressed point format.  # noqa: E501

        :return: The ephemeral_public_key of this EncryptedGooglePayData.  # noqa: E501
        :rtype: str
        """
        return self._ephemeral_public_key

    @ephemeral_public_key.setter
    def ephemeral_public_key(self, ephemeral_public_key):
        """Sets the ephemeral_public_key of this EncryptedGooglePayData.

        The ephemeral public key associated with the private key to encrypt the message in uncompressed point format.  # noqa: E501

        :param ephemeral_public_key: The ephemeral_public_key of this EncryptedGooglePayData.  # noqa: E501
        :type: str
        """
        if ephemeral_public_key is None:
            raise ValueError("Invalid value for `ephemeral_public_key`, must not be `None`")  # noqa: E501
        if ephemeral_public_key is not None and not re.search(r'^(?!\s*$).+', ephemeral_public_key):  # noqa: E501
            raise ValueError(r"Invalid value for `ephemeral_public_key`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._ephemeral_public_key = ephemeral_public_key

    @property
    def tag(self):
        """Gets the tag of this EncryptedGooglePayData.  # noqa: E501

        MAC of the encryptedMessage.  # noqa: E501

        :return: The tag of this EncryptedGooglePayData.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this EncryptedGooglePayData.

        MAC of the encryptedMessage.  # noqa: E501

        :param tag: The tag of this EncryptedGooglePayData.  # noqa: E501
        :type: str
        """
        if tag is None:
            raise ValueError("Invalid value for `tag`, must not be `None`")  # noqa: E501
        if tag is not None and not re.search(r'^(?!\s*$).+', tag):  # noqa: E501
            raise ValueError(r"Invalid value for `tag`, must be a follow pattern or equal to `/^(?!\s*$).+/`")  # noqa: E501

        self._tag = tag

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EncryptedGooglePayData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
