# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.5.0.20211029.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class BasketItem(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'description': 'str',
        'sub_total': 'float',
        'value_added_tax': 'float',
        'local_tax': 'float',
        'delivery_amount': 'float',
        'charge_total': 'float',
        'currency': 'str',
        'quantity': 'int',
        'category': 'str',
        'detailed_category': 'str',
        'options': 'list[Option]'
    }

    attribute_map = {
        'id': 'id',
        'description': 'description',
        'sub_total': 'subTotal',
        'value_added_tax': 'valueAddedTax',
        'local_tax': 'localTax',
        'delivery_amount': 'deliveryAmount',
        'charge_total': 'chargeTotal',
        'currency': 'currency',
        'quantity': 'quantity',
        'category': 'category',
        'detailed_category': 'detailedCategory',
        'options': 'options'
    }

    def __init__(self, id=None, description=None, sub_total=None, value_added_tax=None, local_tax=None, delivery_amount=None, charge_total=None, currency=None, quantity=None, category=None, detailed_category=None, options=None):  # noqa: E501
        """BasketItem - a model defined in OpenAPI"""  # noqa: E501

        self._id = None
        self._description = None
        self._sub_total = None
        self._value_added_tax = None
        self._local_tax = None
        self._delivery_amount = None
        self._charge_total = None
        self._currency = None
        self._quantity = None
        self._category = None
        self._detailed_category = None
        self._options = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if description is not None:
            self.description = description
        if sub_total is not None:
            self.sub_total = sub_total
        if value_added_tax is not None:
            self.value_added_tax = value_added_tax
        if local_tax is not None:
            self.local_tax = local_tax
        if delivery_amount is not None:
            self.delivery_amount = delivery_amount
        if charge_total is not None:
            self.charge_total = charge_total
        if currency is not None:
            self.currency = currency
        if quantity is not None:
            self.quantity = quantity
        if category is not None:
            self.category = category
        if detailed_category is not None:
            self.detailed_category = detailed_category
        if options is not None:
            self.options = options

    @property
    def id(self):
        """Gets the id of this BasketItem.  # noqa: E501

        A unique ID associated with the product.  # noqa: E501

        :return: The id of this BasketItem.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this BasketItem.

        A unique ID associated with the product.  # noqa: E501

        :param id: The id of this BasketItem.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def description(self):
        """Gets the description of this BasketItem.  # noqa: E501

        A name or short description of the product.  # noqa: E501

        :return: The description of this BasketItem.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this BasketItem.

        A name or short description of the product.  # noqa: E501

        :param description: The description of this BasketItem.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def sub_total(self):
        """Gets the sub_total of this BasketItem.  # noqa: E501

        Subtotal amount.  # noqa: E501

        :return: The sub_total of this BasketItem.  # noqa: E501
        :rtype: float
        """
        return self._sub_total

    @sub_total.setter
    def sub_total(self, sub_total):
        """Sets the sub_total of this BasketItem.

        Subtotal amount.  # noqa: E501

        :param sub_total: The sub_total of this BasketItem.  # noqa: E501
        :type: float
        """

        self._sub_total = sub_total

    @property
    def value_added_tax(self):
        """Gets the value_added_tax of this BasketItem.  # noqa: E501

        Value added tax amount.  # noqa: E501

        :return: The value_added_tax of this BasketItem.  # noqa: E501
        :rtype: float
        """
        return self._value_added_tax

    @value_added_tax.setter
    def value_added_tax(self, value_added_tax):
        """Sets the value_added_tax of this BasketItem.

        Value added tax amount.  # noqa: E501

        :param value_added_tax: The value_added_tax of this BasketItem.  # noqa: E501
        :type: float
        """

        self._value_added_tax = value_added_tax

    @property
    def local_tax(self):
        """Gets the local_tax of this BasketItem.  # noqa: E501

        Local tax amount.  # noqa: E501

        :return: The local_tax of this BasketItem.  # noqa: E501
        :rtype: float
        """
        return self._local_tax

    @local_tax.setter
    def local_tax(self, local_tax):
        """Sets the local_tax of this BasketItem.

        Local tax amount.  # noqa: E501

        :param local_tax: The local_tax of this BasketItem.  # noqa: E501
        :type: float
        """

        self._local_tax = local_tax

    @property
    def delivery_amount(self):
        """Gets the delivery_amount of this BasketItem.  # noqa: E501

        Delivery amount.  # noqa: E501

        :return: The delivery_amount of this BasketItem.  # noqa: E501
        :rtype: float
        """
        return self._delivery_amount

    @delivery_amount.setter
    def delivery_amount(self, delivery_amount):
        """Sets the delivery_amount of this BasketItem.

        Delivery amount.  # noqa: E501

        :param delivery_amount: The delivery_amount of this BasketItem.  # noqa: E501
        :type: float
        """

        self._delivery_amount = delivery_amount

    @property
    def charge_total(self):
        """Gets the charge_total of this BasketItem.  # noqa: E501

        Charge Total amount.  # noqa: E501

        :return: The charge_total of this BasketItem.  # noqa: E501
        :rtype: float
        """
        return self._charge_total

    @charge_total.setter
    def charge_total(self, charge_total):
        """Sets the charge_total of this BasketItem.

        Charge Total amount.  # noqa: E501

        :param charge_total: The charge_total of this BasketItem.  # noqa: E501
        :type: float
        """

        self._charge_total = charge_total

    @property
    def currency(self):
        """Gets the currency of this BasketItem.  # noqa: E501

        The currency of the original transaction.  # noqa: E501

        :return: The currency of this BasketItem.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this BasketItem.

        The currency of the original transaction.  # noqa: E501

        :param currency: The currency of this BasketItem.  # noqa: E501
        :type: str
        """
        if currency is not None and not re.search(r'([A-Z]{3})|([0-9]{3})', currency):  # noqa: E501
            raise ValueError(r"Invalid value for `currency`, must be a follow pattern or equal to `/([A-Z]{3})|([0-9]{3})/`")  # noqa: E501

        self._currency = currency

    @property
    def quantity(self):
        """Gets the quantity of this BasketItem.  # noqa: E501

        The unit in which the product is sold (e.g. litre, kilogram, etc). Leave empty if the product is sold as a complete unit.  # noqa: E501

        :return: The quantity of this BasketItem.  # noqa: E501
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity):
        """Sets the quantity of this BasketItem.

        The unit in which the product is sold (e.g. litre, kilogram, etc). Leave empty if the product is sold as a complete unit.  # noqa: E501

        :param quantity: The quantity of this BasketItem.  # noqa: E501
        :type: int
        """

        self._quantity = quantity

    @property
    def category(self):
        """Gets the category of this BasketItem.  # noqa: E501

        Category of the product.  # noqa: E501

        :return: The category of this BasketItem.  # noqa: E501
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this BasketItem.

        Category of the product.  # noqa: E501

        :param category: The category of this BasketItem.  # noqa: E501
        :type: str
        """

        self._category = category

    @property
    def detailed_category(self):
        """Gets the detailed_category of this BasketItem.  # noqa: E501

        Detailed Category of the product.  # noqa: E501

        :return: The detailed_category of this BasketItem.  # noqa: E501
        :rtype: str
        """
        return self._detailed_category

    @detailed_category.setter
    def detailed_category(self, detailed_category):
        """Sets the detailed_category of this BasketItem.

        Detailed Category of the product.  # noqa: E501

        :param detailed_category: The detailed_category of this BasketItem.  # noqa: E501
        :type: str
        """

        self._detailed_category = detailed_category

    @property
    def options(self):
        """Gets the options of this BasketItem.  # noqa: E501

        Option details  # noqa: E501

        :return: The options of this BasketItem.  # noqa: E501
        :rtype: list[Option]
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this BasketItem.

        Option details  # noqa: E501

        :param options: The options of this BasketItem.  # noqa: E501
        :type: list[Option]
        """

        self._options = options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, BasketItem):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
