# coding: utf-8

"""
    Payment Gateway API Specification.

    The documentation here is designed to provide all of the technical guidance required to consume and integrate with our APIs for payment processing. To learn more about our APIs please visit https://docs.firstdata.com/org/gateway.  # noqa: E501

    The version of the OpenAPI document: 21.5.0.20211029.001
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six


class AdditionalTransactionDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'comments': 'str',
        'invoice_number': 'str',
        'purchase_order_number': 'str',
        'disbursement_trans_type': 'str',
        'wallet_provider': 'str',
        'receipts': 'list[Receipt]',
        'additional_response_data': 'AdditionalResponseData'
    }

    attribute_map = {
        'comments': 'comments',
        'invoice_number': 'invoiceNumber',
        'purchase_order_number': 'purchaseOrderNumber',
        'disbursement_trans_type': 'disbursementTransType',
        'wallet_provider': 'walletProvider',
        'receipts': 'receipts',
        'additional_response_data': 'additionalResponseData'
    }

    def __init__(self, comments=None, invoice_number=None, purchase_order_number=None, disbursement_trans_type=None, wallet_provider=None, receipts=None, additional_response_data=None):  # noqa: E501
        """AdditionalTransactionDetails - a model defined in OpenAPI"""  # noqa: E501

        self._comments = None
        self._invoice_number = None
        self._purchase_order_number = None
        self._disbursement_trans_type = None
        self._wallet_provider = None
        self._receipts = None
        self._additional_response_data = None
        self.discriminator = None

        if comments is not None:
            self.comments = comments
        if invoice_number is not None:
            self.invoice_number = invoice_number
        if purchase_order_number is not None:
            self.purchase_order_number = purchase_order_number
        if disbursement_trans_type is not None:
            self.disbursement_trans_type = disbursement_trans_type
        if wallet_provider is not None:
            self.wallet_provider = wallet_provider
        if receipts is not None:
            self.receipts = receipts
        if additional_response_data is not None:
            self.additional_response_data = additional_response_data

    @property
    def comments(self):
        """Gets the comments of this AdditionalTransactionDetails.  # noqa: E501

        Comment for the payment.  # noqa: E501

        :return: The comments of this AdditionalTransactionDetails.  # noqa: E501
        :rtype: str
        """
        return self._comments

    @comments.setter
    def comments(self, comments):
        """Sets the comments of this AdditionalTransactionDetails.

        Comment for the payment.  # noqa: E501

        :param comments: The comments of this AdditionalTransactionDetails.  # noqa: E501
        :type: str
        """
        if comments is not None and len(comments) > 1024:
            raise ValueError("Invalid value for `comments`, length must be less than or equal to `1024`")  # noqa: E501

        self._comments = comments

    @property
    def invoice_number(self):
        """Gets the invoice_number of this AdditionalTransactionDetails.  # noqa: E501

        Invoice number.  # noqa: E501

        :return: The invoice_number of this AdditionalTransactionDetails.  # noqa: E501
        :rtype: str
        """
        return self._invoice_number

    @invoice_number.setter
    def invoice_number(self, invoice_number):
        """Sets the invoice_number of this AdditionalTransactionDetails.

        Invoice number.  # noqa: E501

        :param invoice_number: The invoice_number of this AdditionalTransactionDetails.  # noqa: E501
        :type: str
        """
        if invoice_number is not None and len(invoice_number) > 48:
            raise ValueError("Invalid value for `invoice_number`, length must be less than or equal to `48`")  # noqa: E501

        self._invoice_number = invoice_number

    @property
    def purchase_order_number(self):
        """Gets the purchase_order_number of this AdditionalTransactionDetails.  # noqa: E501

        Purchase order number.  # noqa: E501

        :return: The purchase_order_number of this AdditionalTransactionDetails.  # noqa: E501
        :rtype: str
        """
        return self._purchase_order_number

    @purchase_order_number.setter
    def purchase_order_number(self, purchase_order_number):
        """Sets the purchase_order_number of this AdditionalTransactionDetails.

        Purchase order number.  # noqa: E501

        :param purchase_order_number: The purchase_order_number of this AdditionalTransactionDetails.  # noqa: E501
        :type: str
        """
        if purchase_order_number is not None and len(purchase_order_number) > 128:
            raise ValueError("Invalid value for `purchase_order_number`, length must be less than or equal to `128`")  # noqa: E501

        self._purchase_order_number = purchase_order_number

    @property
    def disbursement_trans_type(self):
        """Gets the disbursement_trans_type of this AdditionalTransactionDetails.  # noqa: E501

        The type of debit disbursement transaction.  # noqa: E501

        :return: The disbursement_trans_type of this AdditionalTransactionDetails.  # noqa: E501
        :rtype: str
        """
        return self._disbursement_trans_type

    @disbursement_trans_type.setter
    def disbursement_trans_type(self, disbursement_trans_type):
        """Sets the disbursement_trans_type of this AdditionalTransactionDetails.

        The type of debit disbursement transaction.  # noqa: E501

        :param disbursement_trans_type: The disbursement_trans_type of this AdditionalTransactionDetails.  # noqa: E501
        :type: str
        """
        allowed_values = ["FUNDING", "DISBURSEMENT"]  # noqa: E501
        if disbursement_trans_type not in allowed_values:
            raise ValueError(
                "Invalid value for `disbursement_trans_type` ({0}), must be one of {1}"  # noqa: E501
                .format(disbursement_trans_type, allowed_values)
            )

        self._disbursement_trans_type = disbursement_trans_type

    @property
    def wallet_provider(self):
        """Gets the wallet_provider of this AdditionalTransactionDetails.  # noqa: E501

        The wallet provider type.  # noqa: E501

        :return: The wallet_provider of this AdditionalTransactionDetails.  # noqa: E501
        :rtype: str
        """
        return self._wallet_provider

    @wallet_provider.setter
    def wallet_provider(self, wallet_provider):
        """Sets the wallet_provider of this AdditionalTransactionDetails.

        The wallet provider type.  # noqa: E501

        :param wallet_provider: The wallet_provider of this AdditionalTransactionDetails.  # noqa: E501
        :type: str
        """
        allowed_values = ["GOOGLE_PAY", "APPLE_PAY", "SAMSUNG_PAY", "MASTERPASS"]  # noqa: E501
        if wallet_provider not in allowed_values:
            raise ValueError(
                "Invalid value for `wallet_provider` ({0}), must be one of {1}"  # noqa: E501
                .format(wallet_provider, allowed_values)
            )

        self._wallet_provider = wallet_provider

    @property
    def receipts(self):
        """Gets the receipts of this AdditionalTransactionDetails.  # noqa: E501

        Provides receipt response data, if it has been requested.  # noqa: E501

        :return: The receipts of this AdditionalTransactionDetails.  # noqa: E501
        :rtype: list[Receipt]
        """
        return self._receipts

    @receipts.setter
    def receipts(self, receipts):
        """Sets the receipts of this AdditionalTransactionDetails.

        Provides receipt response data, if it has been requested.  # noqa: E501

        :param receipts: The receipts of this AdditionalTransactionDetails.  # noqa: E501
        :type: list[Receipt]
        """

        self._receipts = receipts

    @property
    def additional_response_data(self):
        """Gets the additional_response_data of this AdditionalTransactionDetails.  # noqa: E501


        :return: The additional_response_data of this AdditionalTransactionDetails.  # noqa: E501
        :rtype: AdditionalResponseData
        """
        return self._additional_response_data

    @additional_response_data.setter
    def additional_response_data(self, additional_response_data):
        """Sets the additional_response_data of this AdditionalTransactionDetails.


        :param additional_response_data: The additional_response_data of this AdditionalTransactionDetails.  # noqa: E501
        :type: AdditionalResponseData
        """

        self._additional_response_data = additional_response_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AdditionalTransactionDetails):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
