"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const apigateway = require("@aws-cdk/aws-apigateway");
const lambda = require("@aws-cdk/aws-lambda");
const s3 = require("@aws-cdk/aws-s3");
const core = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new core.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new core.Stack(app, 'integration-stack', { env });
        let alias = stack.node.tryGetContext('alias');
        if (alias === undefined) {
            alias = 'xxx';
        }
        index_1.StackResourceRenamer.rename(stack, {
            rename: (origName, _) => {
                return origName + '-' + alias;
            },
        });
        //for integration test
        this.stack = [stack];
        //resources in stack
        const bucket = new s3.Bucket(stack, 'WidgetStore', {
            bucketName: 'widget-store-bucket',
        });
        const handler = new lambda.Function(stack, 'WidgetHandler', {
            runtime: lambda.Runtime.NODEJS_10_X,
            handler: 'index.handler',
            functionName: 'handler_func',
            code: lambda.Code.fromInline(`
                exports.handler = async (event)=> {
                    console.log('event: ',event,' env: ',process.env);
                }
            `),
            environment: {
                BUCKET: bucket.bucketName,
            },
        });
        bucket.grantReadWrite(handler);
        const api = new apigateway.RestApi(stack, 'widgets-api', {
            restApiName: 'Widget Service',
            description: 'serves widgets',
        });
        const getBind = new apigateway.LambdaIntegration(handler, {
            requestTemplates: { 'application/json': '{"statusCode": "200"}' },
        });
        api.root.addMethod('GET', getBind, {
            operationName: 'get-widget',
        });
        new core.CfnOutput(stack, 'Dns', {
            exportName: 'ApiDns',
            value: api.url,
        });
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHNEQUFzRDtBQUN0RCw4Q0FBOEM7QUFDOUMsc0NBQXNDO0FBQ3RDLHNDQUFzQztBQUN0QyxtQ0FBK0M7QUFFL0MsTUFBYSxZQUFZO0lBRXZCO1FBQ0UsTUFBTSxHQUFHLEdBQUcsSUFBSSxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUM7UUFFM0IsTUFBTSxHQUFHLEdBQUc7WUFDVixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxrQkFBa0I7WUFDdEMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxHQUFHLENBQUMsbUJBQW1CO1NBQ3pDLENBQUM7UUFFRixNQUFNLEtBQUssR0FBRyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxFQUFFLG1CQUFtQixFQUFFLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQztRQUVoRSxJQUFJLEtBQUssR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUM5QyxJQUFJLEtBQUssS0FBRyxTQUFTLEVBQUU7WUFDckIsS0FBSyxHQUFDLEtBQUssQ0FBQztTQUNiO1FBQ0QsNEJBQW9CLENBQUMsTUFBTSxDQUFDLEtBQUssRUFBRTtZQUNqQyxNQUFNLEVBQUUsQ0FBQyxRQUFRLEVBQUUsQ0FBQyxFQUFDLEVBQUU7Z0JBQ3JCLE9BQU8sUUFBUSxHQUFDLEdBQUcsR0FBQyxLQUFLLENBQUM7WUFDNUIsQ0FBQztTQUNGLENBQUMsQ0FBQztRQUVILHNCQUFzQjtRQUN0QixJQUFJLENBQUMsS0FBSyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFckIsb0JBQW9CO1FBQ3BCLE1BQU0sTUFBTSxHQUFHLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO1lBQ2pELFVBQVUsRUFBRSxxQkFBcUI7U0FDbEMsQ0FBQyxDQUFDO1FBRUgsTUFBTSxPQUFPLEdBQUcsSUFBSSxNQUFNLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxlQUFlLEVBQUU7WUFDMUQsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVztZQUNuQyxPQUFPLEVBQUUsZUFBZTtZQUN4QixZQUFZLEVBQUUsY0FBYztZQUM1QixJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUM7Ozs7YUFJdEIsQ0FBQztZQUNSLFdBQVcsRUFBRTtnQkFDWCxNQUFNLEVBQUUsTUFBTSxDQUFDLFVBQVU7YUFDMUI7U0FDRixDQUFDLENBQUM7UUFFSCxNQUFNLENBQUMsY0FBYyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRS9CLE1BQU0sR0FBRyxHQUFHLElBQUksVUFBVSxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFO1lBQ3ZELFdBQVcsRUFBRSxnQkFBZ0I7WUFDN0IsV0FBVyxFQUFFLGdCQUFnQjtTQUM5QixDQUFDLENBQUM7UUFFSCxNQUFNLE9BQU8sR0FBRyxJQUFJLFVBQVUsQ0FBQyxpQkFBaUIsQ0FBQyxPQUFPLEVBQUU7WUFDeEQsZ0JBQWdCLEVBQUUsRUFBRSxrQkFBa0IsRUFBRSx1QkFBdUIsRUFBRTtTQUNsRSxDQUFDLENBQUM7UUFFSCxHQUFHLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsT0FBTyxFQUFFO1lBQ2pDLGFBQWEsRUFBRSxZQUFZO1NBQzVCLENBQUMsQ0FBQztRQUVILElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLEVBQUUsS0FBSyxFQUFFO1lBQy9CLFVBQVUsRUFBRSxRQUFRO1lBQ3BCLEtBQUssRUFBRSxHQUFHLENBQUMsR0FBRztTQUNmLENBQUMsQ0FBQztJQUNMLENBQUM7Q0FDRjtBQWhFRCxvQ0FnRUM7QUFFRCxJQUFJLFlBQVksRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgYXBpZ2F0ZXdheSBmcm9tICdAYXdzLWNkay9hd3MtYXBpZ2F0ZXdheSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0ICogYXMgY29yZSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFN0YWNrUmVzb3VyY2VSZW5hbWVyIH0gZnJvbSAnLi9pbmRleCc7XG5cbmV4cG9ydCBjbGFzcyBJbnRlZ1Rlc3Rpbmcge1xuICByZWFkb25seSBzdGFjazogY29yZS5TdGFja1tdXG4gIGNvbnN0cnVjdG9yKCkge1xuICAgIGNvbnN0IGFwcCA9IG5ldyBjb3JlLkFwcCgpO1xuXG4gICAgY29uc3QgZW52ID0ge1xuICAgICAgcmVnaW9uOiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9SRUdJT04sXG4gICAgICBhY2NvdW50OiBwcm9jZXNzLmVudi5DREtfREVGQVVMVF9BQ0NPVU5ULFxuICAgIH07XG5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjb3JlLlN0YWNrKGFwcCwgJ2ludGVncmF0aW9uLXN0YWNrJywgeyBlbnYgfSk7XG5cbiAgICBsZXQgYWxpYXMgPSBzdGFjay5ub2RlLnRyeUdldENvbnRleHQoJ2FsaWFzJyk7XG4gICAgaWYgKGFsaWFzPT09dW5kZWZpbmVkKSB7XG4gICAgICBhbGlhcz0neHh4JztcbiAgICB9XG4gICAgU3RhY2tSZXNvdXJjZVJlbmFtZXIucmVuYW1lKHN0YWNrLCB7XG4gICAgICByZW5hbWU6IChvcmlnTmFtZSwgXyk9PntcbiAgICAgICAgcmV0dXJuIG9yaWdOYW1lKyctJythbGlhcztcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICAvL2ZvciBpbnRlZ3JhdGlvbiB0ZXN0XG4gICAgdGhpcy5zdGFjayA9IFtzdGFja107XG5cbiAgICAvL3Jlc291cmNlcyBpbiBzdGFja1xuICAgIGNvbnN0IGJ1Y2tldCA9IG5ldyBzMy5CdWNrZXQoc3RhY2ssICdXaWRnZXRTdG9yZScsIHtcbiAgICAgIGJ1Y2tldE5hbWU6ICd3aWRnZXQtc3RvcmUtYnVja2V0JyxcbiAgICB9KTtcblxuICAgIGNvbnN0IGhhbmRsZXIgPSBuZXcgbGFtYmRhLkZ1bmN0aW9uKHN0YWNrLCAnV2lkZ2V0SGFuZGxlcicsIHtcbiAgICAgIHJ1bnRpbWU6IGxhbWJkYS5SdW50aW1lLk5PREVKU18xMF9YLFxuICAgICAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICAgICAgZnVuY3Rpb25OYW1lOiAnaGFuZGxlcl9mdW5jJyxcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21JbmxpbmUoYFxuICAgICAgICAgICAgICAgIGV4cG9ydHMuaGFuZGxlciA9IGFzeW5jIChldmVudCk9PiB7XG4gICAgICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKCdldmVudDogJyxldmVudCwnIGVudjogJyxwcm9jZXNzLmVudik7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgYCksXG4gICAgICBlbnZpcm9ubWVudDoge1xuICAgICAgICBCVUNLRVQ6IGJ1Y2tldC5idWNrZXROYW1lLFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGJ1Y2tldC5ncmFudFJlYWRXcml0ZShoYW5kbGVyKTtcblxuICAgIGNvbnN0IGFwaSA9IG5ldyBhcGlnYXRld2F5LlJlc3RBcGkoc3RhY2ssICd3aWRnZXRzLWFwaScsIHtcbiAgICAgIHJlc3RBcGlOYW1lOiAnV2lkZ2V0IFNlcnZpY2UnLFxuICAgICAgZGVzY3JpcHRpb246ICdzZXJ2ZXMgd2lkZ2V0cycsXG4gICAgfSk7XG5cbiAgICBjb25zdCBnZXRCaW5kID0gbmV3IGFwaWdhdGV3YXkuTGFtYmRhSW50ZWdyYXRpb24oaGFuZGxlciwge1xuICAgICAgcmVxdWVzdFRlbXBsYXRlczogeyAnYXBwbGljYXRpb24vanNvbic6ICd7XCJzdGF0dXNDb2RlXCI6IFwiMjAwXCJ9JyB9LFxuICAgIH0pO1xuXG4gICAgYXBpLnJvb3QuYWRkTWV0aG9kKCdHRVQnLCBnZXRCaW5kLCB7XG4gICAgICBvcGVyYXRpb25OYW1lOiAnZ2V0LXdpZGdldCcsXG4gICAgfSk7XG5cbiAgICBuZXcgY29yZS5DZm5PdXRwdXQoc3RhY2ssICdEbnMnLCB7XG4gICAgICBleHBvcnROYW1lOiAnQXBpRG5zJyxcbiAgICAgIHZhbHVlOiBhcGkudXJsLFxuICAgIH0pO1xuICB9XG59XG5cbm5ldyBJbnRlZ1Rlc3RpbmcoKTtcbiJdfQ==