/*
 * The internal definitions
 *
 * Copyright (C) 2013-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBCREG_INTERNAL_DEFINITIONS_H )
#define _LIBCREG_INTERNAL_DEFINITIONS_H

#include <common.h>
#include <byte_stream.h>

#define LIBCREG_ENDIAN_BIG				_BYTE_STREAM_ENDIAN_BIG
#define LIBCREG_ENDIAN_LITTLE				_BYTE_STREAM_ENDIAN_LITTLE

/* Define HAVE_LOCAL_LIBCREG for local use of libcreg
 */
#if !defined( HAVE_LOCAL_LIBCREG )
#include <libcreg/definitions.h>

/* The definitions in <libcreg/definitions.h> are copied here
 * for local use of libcreg
 */
#else
#define LIBCREG_VERSION					20221022

/* The libcreg version string
 */
#define LIBCREG_VERSION_STRING				"20221022"

/* The libcreg file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBCREG_ACCESS_FLAGS
{
	LIBCREG_ACCESS_FLAG_READ			= 0x01,
/* Reserved: not supported yet */
	LIBCREG_ACCESS_FLAG_WRITE			= 0x02
};

/* The libcreg file access macros
 */
#define LIBCREG_OPEN_READ				( LIBCREG_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBCREG_OPEN_WRITE				( LIBCREG_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBCREG_OPEN_READ_WRITE				( LIBCREG_ACCESS_FLAG_READ | LIBCREG_ACCESS_FLAG_WRITE )

/* The key and value name separator
 */
#define LIBCREG_SEPARATOR				'\\'

/* The value types
 */
enum LIBCREG_VALUE_TYPES
{
	LIBCREG_VALUE_TYPE_UNDEFINED			= 0,
	LIBCREG_VALUE_TYPE_STRING			= 1,
	LIBCREG_VALUE_TYPE_EXPANDABLE_STRING		= 2,
	LIBCREG_VALUE_TYPE_BINARY_DATA			= 3,
	LIBCREG_VALUE_TYPE_INTEGER_32BIT_LITTLE_ENDIAN	= 4,
	LIBCREG_VALUE_TYPE_INTEGER_32BIT_BIG_ENDIAN	= 5,
	LIBCREG_VALUE_TYPE_SYMBOLIC_LINK		= 6,
	LIBCREG_VALUE_TYPE_MULTI_VALUE_STRING		= 7,
	LIBCREG_VALUE_TYPE_RESOURCE_LIST		= 8,
	LIBCREG_VALUE_TYPE_FULL_RESOURCE_DESCRIPTOR	= 9,
	LIBCREG_VALUE_TYPE_RESOURCE_REQUIREMENTS_LIST	= 10,
	LIBCREG_VALUE_TYPE_INTEGER_64BIT_LITTLE_ENDIAN	= 11
};

#endif /* !defined( HAVE_LOCAL_LIBCREG ) */

/* The IO handle flags
 */
enum LIBCREG_IO_HANDLE_FLAGS
{
	/* The file is corrupted
	 */
	LIBCREG_IO_HANDLE_FLAG_IS_CORRUPTED		= 0x01
};

/* The item flags
 */
enum LIBCREG_ITEM_FLAGS
{
	/* The item is corrupted
	 */
	LIBCREG_ITEM_FLAG_IS_CORRUPTED			= 0x01
};

/* The key name entry flags
 */
enum LIBCREG_KEY_NAME_ENTRY_FLAGS
{
	/* The key name entry is corrupted
	 */
	LIBCREG_KEY_NAME_ENTRY_FLAG_IS_CORRUPTED	= 0x01
};

/* The value entry flags
 */
enum LIBCREG_VALUE_ENTRY_FLAGS
{
	/* The value entry is corrupted
	 */
	LIBCREG_VALUE_ENTRY_FLAG_IS_CORRUPTED		= 0x01
};

#define LIBCREG_ROOT_KEY_OFFSET				0x20

#define LIBCREG_MAXIMUM_CACHE_ENTRIES_DATA_BLOCKS	64 * 1024
#define LIBCREG_MAXIMUM_CACHE_ENTRIES_KEYS		256 * 1024
#define LIBCREG_MAXIMUM_CACHE_ENTRIES_VALUES		128

#define LIBCREG_MAXIMUM_SUB_KEY_RECURSION_DEPTH		1024 * 1024

#endif /* !defined( _LIBCREG_INTERNAL_DEFINITIONS_H ) */

