"""
A collection of monsters from D&D 5e's SRD

This file was autogenerated by https://github.com/stravajiaxen/5e-srd-to-py
"""

from dungeonsheets.monsters.monsters import Monster
from dungeonsheets.stats import Ability


class SaberToothedTiger(Monster):
    """
    **Keen Smell**: The tiger has advantage on Wisdom (Perception) checks that rely on smell.

    **Pounce**: If the tiger moves at least 20 ft. straight toward a creature and then hits it with a claw attack on the same turn, that target must succeed on a DC 14 Strength saving throw or be knocked prone. If the target is prone, the tiger can make one bite attack against it as a bonus action.

    **Bite**: Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 10 (1d10 + 5) piercing damage.

    **Claw**: Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 12 (2d6 + 5) slashing damage.
    """

    name = "Saber-Toothed Tiger"
    description = "Large beast, unaligned"
    challenge_rating = 2
    armor_class = 12
    skills = "Perception +3, Stealth +6"
    senses = "Passive Perception 13"
    languages = ""
    strength = Ability(18)
    dexterity = Ability(14)
    constitution = Ability(15)
    intelligence = Ability(3)
    wisdom = Ability(12)
    charisma = Ability(8)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 52
    hit_dice = "7d10"


class Sahuagin(Monster):
    """
    **Blood Frenzy**: The sahuagin has advantage on melee attack rolls against any creature that doesn't have all its hit points.

    **Limited Amphibiousness**: The sahuagin can breathe air and water, but it needs to be submerged at least once every 4 hours to avoid suffocating.

    **Shark Telepathy**: The sahuagin can magically command any shark within 120 feet of it, using a limited telepathy.

    **Multiattack**: The sahuagin makes two melee attacks: one with its bite and one with its claws or spear.

    **Bite**: Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 3 (1d4 + 1) piercing damage.

    **Claws**: Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 3 (1d4 + 1) slashing damage.

    **Spear**: Melee or Ranged Weapon Attack: +3 to hit, reach 5 ft. or range 20/60 ft., one target. Hit: 4 (1d6 + 1) piercing damage, or 5 (1d8 + 1) piercing damage if used with two hands to make a melee attack.
    """

    name = "Sahuagin"
    description = "Medium humanoid, lawful evil"
    challenge_rating = 0.5
    armor_class = 12
    skills = "Perception +5"
    senses = "Darkvision 120 ft., Passive Perception 15"
    languages = "Sahuagin"
    strength = Ability(13)
    dexterity = Ability(11)
    constitution = Ability(12)
    intelligence = Ability(12)
    wisdom = Ability(13)
    charisma = Ability(9)
    speed = 30
    swim_speed = 40
    fly_speed = 0
    climb_speed = 0
    hp_max = 22
    hit_dice = "4d8"


class Salamander(Monster):
    """
    **Heated Body**: A creature that touches the salamander or hits it with a melee attack while within 5 ft. of it takes 7 (2d6) fire damage.

    **Heated Weapons**: Any metal melee weapon the salamander wields deals an extra 3 (1d6) fire damage on a hit (included in the attack).

    **Multiattack**: The salamander makes two attacks: one with its spear and one with its tail.

    **Spear**: Melee or Ranged Weapon Attack: +7 to hit, reach 5 ft. or range 20 ft./60 ft., one target. Hit: 11 (2d6 + 4) piercing damage, or 13 (2d8 + 4) piercing damage if used with two hands to make a melee attack, plus 3 (1d6) fire damage.

    **Tail**: Melee Weapon Attack: +7 to hit, reach 10 ft., one target. Hit: 11 (2d6 + 4) bludgeoning damage plus 7 (2d6) fire damage, and the target is grappled (escape DC 14). Until this grapple ends, the target is restrained, the salamander can automatically hit the target with its tail, and the salamander can't make tail attacks against other targets.
    """

    name = "Salamander"
    description = "Large elemental, neutral evil"
    challenge_rating = 5
    armor_class = 15
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 10"
    languages = "Ignan"
    strength = Ability(18)
    dexterity = Ability(14)
    constitution = Ability(15)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(12)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 90
    hit_dice = "12d10"


class Satyr(Monster):
    """
    **Magic Resistance**: The satyr has advantage on saving throws against spells and other magical effects.

    **Ram**: Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 6 (2d4 + 1) bludgeoning damage.

    **Shortsword**: Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 6 (1 d6 + 3) piercing damage.

    **Shortbow**: Ranged Weapon Attack: +5 to hit, range 80/320 ft., one target. Hit: 6 (1d6 + 3) piercing damage.

    **Variant: Panpipes**: Gentle Lullaby. The creature falls asleep and is unconscious for 1 minute. The effect ends if the creature takes damage or if someone takes an action to shake the creature awake.
    """

    name = "Satyr"
    description = "Medium fey, chaotic neutral"
    challenge_rating = 0.5
    armor_class = 14
    skills = "Perception +2, Performance +6, Stealth +5"
    senses = "Passive Perception 12"
    languages = "Common, Elvish, Sylvan"
    strength = Ability(12)
    dexterity = Ability(16)
    constitution = Ability(11)
    intelligence = Ability(12)
    wisdom = Ability(10)
    charisma = Ability(14)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 31
    hit_dice = "7d8"


class Scorpion(Monster):
    """
    **Sting**: Melee Weapon Attack: +2 to hit, reach 5 ft., one creature. Hit: 1 piercing damage, and the target must make a DC 9 Constitution saving throw, taking 4 (1d8) poison damage on a failed save, or half as much damage on a successful one.
    """

    name = "Scorpion"
    description = "Tiny beast, unaligned"
    challenge_rating = 0
    armor_class = 11
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 9"
    languages = ""
    strength = Ability(2)
    dexterity = Ability(11)
    constitution = Ability(8)
    intelligence = Ability(1)
    wisdom = Ability(8)
    charisma = Ability(2)
    speed = 10
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 1
    hit_dice = "1d4"


class Scout(Monster):
    """
    **Keen Hearing and Sight**: The scout has advantage on Wisdom (Perception) checks that rely on hearing or sight.

    **Multiattack**: The scout makes two melee attacks or two ranged attacks.

    **Shortsword**: Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 + 2) piercing damage.

    **Longbow**: Ranged Weapon Attack: +4 to hit, ranged 150/600 ft., one target. Hit: 6 (1d8 + 2) piercing damage.
    """

    name = "Scout"
    description = "Medium humanoid, any alignment"
    challenge_rating = 0.5
    armor_class = 13
    skills = "Nature +4, Perception +5, Stealth +6, Survival +5"
    senses = "Passive Perception 15"
    languages = "any one language (usually Common)"
    strength = Ability(11)
    dexterity = Ability(14)
    constitution = Ability(12)
    intelligence = Ability(11)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 16
    hit_dice = "3d8"


class SeaHag(Monster):
    """
    **Amphibious**: The hag can breathe air and water.

    **Horrific Appearance**: Any humanoid that starts its turn within 30 feet of the hag and can see the hag's true form must make a DC 11 Wisdom saving throw. On a failed save, the creature is frightened for 1 minute. A creature can repeat the saving throw at the end of each of its turns, with disadvantage if the hag is within line of sight, ending the effect on itself on a success. If a creature's saving throw is successful or the effect ends for it, the creature is immune to the hag's Horrific Appearance for the next 24 hours.
    Unless the target is surprised or the revelation of the hag's true form is sudden, the target can avert its eyes and avoid making the initial saving throw. Until the start of its next turn, a creature that averts its eyes has disadvantage on attack rolls against the hag.

    **Claws**: Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 10 (2d6 + 3) slashing damage.

    **Death Glare**: The hag targets one frightened creature she can see within 30 ft. of her. If the target can see the hag, it must succeed on a DC 11 Wisdom saving throw against this magic or drop to 0 hit points.

    **Illusory Appearance**: The hag covers herself and anything she is wearing or carrying with a magical illusion that makes her look like an ugly creature of her general size and humanoid shape. The effect ends if the hag takes a bonus action to end it or if she dies.
    The changes wrought by this effect fail to hold up to physical inspection. For example, the hag could appear to have no claws, but someone touching her hand might feel the claws. Otherwise, a creature must take an action to visually inspect the illusion and succeed on a DC 16 Intelligence (Investigation) check to discern that the hag is disguised.
    """

    name = "Sea Hag"
    description = "Medium fey, chaotic evil"
    challenge_rating = 2
    armor_class = 14
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 11"
    languages = "Aquan, Common, Giant"
    strength = Ability(16)
    dexterity = Ability(13)
    constitution = Ability(16)
    intelligence = Ability(12)
    wisdom = Ability(12)
    charisma = Ability(13)
    speed = 30
    swim_speed = 40
    fly_speed = 0
    climb_speed = 0
    hp_max = 52
    hit_dice = "7d8"


class SeaHorse(Monster):
    """
    **Water Breathing**: The sea horse can breathe only underwater.
    """

    name = "Sea Horse"
    description = "Tiny beast, unaligned"
    challenge_rating = 0
    armor_class = 11
    skills = ""
    senses = "Passive Perception 10"
    languages = ""
    strength = Ability(1)
    dexterity = Ability(12)
    constitution = Ability(8)
    intelligence = Ability(1)
    wisdom = Ability(10)
    charisma = Ability(2)
    speed = 0
    swim_speed = 20
    fly_speed = 0
    climb_speed = 0
    hp_max = 1
    hit_dice = "1d4"


class Shadow(Monster):
    """
    **Amorphous**: The shadow can move through a space as narrow as 1 inch wide without squeezing.

    **Shadow Stealth**: While in dim light or darkness, the shadow can take the Hide action as a bonus action. Its stealth bonus is also improved to +6.

    **Sunlight Weakness**: While in sunlight, the shadow has disadvantage on attack rolls, ability checks, and saving throws.

    **Strength Drain**: Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 9 (2d6 + 2) necrotic damage, and the target's Strength score is reduced by 1d4. The target dies if this reduces its Strength to 0. Otherwise, the reduction lasts until the target finishes a short or long rest.
    If a non-evil humanoid dies from this attack, a new shadow rises from the corpse 1d4 hours later.
    """

    name = "Shadow"
    description = "Medium undead, chaotic evil"
    challenge_rating = 0.5
    armor_class = 12
    skills = "Stealth +4"
    senses = "Darkvision 60 ft., Passive Perception 10"
    languages = ""
    strength = Ability(6)
    dexterity = Ability(14)
    constitution = Ability(13)
    intelligence = Ability(6)
    wisdom = Ability(10)
    charisma = Ability(8)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 16
    hit_dice = "3d8"


class ShadowDemon(Monster):
    """Incorporeal Movement.
      The demon can move through other creatures and objects as if
      they were difficult terrain. It takes 5 (1d10) force damage if
      it ends its turn inside an object.
    Light Sensitivity.
      While in bright light, the demon has disadvantage on attack
      rolls, as well as on Wisdom (Perception) checks that rely on
      sight.
    Shadow Stealth.
      While in dim light or darkness, the demon can take the Hide
      action as a bonus action.
    Claws.
      *Melee Weapon Attack:* +5 to hit, reach 5ft., one
      creature. *Hit:* 10 (2d6+3) psychic damage or, if the demon
      had advantage on the attack roll, 17 (4d6+3) psychic damage.
    """

    name = "Shadow Demon"
    description = "Medium fiend (demon), chaotic evil"
    challenge_rating = 4
    armor_class = 13
    skills = "Stealth +7"
    saving_throws = "Dex +5, Cha +4"
    damage_vulnerabilities = "radiant"
    damage_resistances = (
        "acid, fire, necrotic, thunder; bludgeoning, piercing, and slashing from"
        " nonmagical attacks"
    )
    damage_immunities = "cold, lightning, poison"
    condition_immunities = (
        "exhaustion, grappled, paralyzed, petrified, poisoned, prone, restrained"
    )
    senses = "Darkvision 120 ft., Passive Perception 11"
    languages = "Abyssal, telepathy 120 ft."
    strength = Ability(1)
    dexterity = Ability(17)
    constitution = Ability(12)
    intelligence = Ability(14)
    wisdom = Ability(13)
    charisma = Ability(14)
    speed = 30
    fly_speed = 30
    hp_max = 66
    hit_dice = "12d8 + 12"


class ShamblingMound(Monster):
    """
    **Lightning Absorption**: Whenever the shambling mound is subjected to lightning damage, it takes no damage and regains a number of hit points equal to the lightning damage dealt.

    **Multiattack**: The shambling mound makes two slam attacks. If both attacks hit a Medium or smaller target, the target is grappled (escape DC 14), and the shambling mound uses its Engulf on it.

    **Slam**: Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 13 (2d8 + 4) bludgeoning damage.

    **Engulf**: The shambling mound engulfs a Medium or smaller creature grappled by it. The engulfed target is blinded, restrained, and unable to breathe, and it must succeed on a DC 14 Constitution saving throw at the start of each of the mound's turns or take 13 (2d8 + 4) bludgeoning damage. If the mound moves, the engulfed target moves with it. The mound can have only one creature engulfed at a time.
    """

    name = "Shambling Mound"
    description = "Large plant, unaligned"
    challenge_rating = 5
    armor_class = 15
    skills = "Stealth +2"
    senses = "Blindsight 60 ft. (blind beyond this radius), Passive Perception 10"
    languages = ""
    strength = Ability(18)
    dexterity = Ability(8)
    constitution = Ability(16)
    intelligence = Ability(5)
    wisdom = Ability(10)
    charisma = Ability(5)
    speed = 20
    swim_speed = 20
    fly_speed = 0
    climb_speed = 0
    hp_max = 136
    hit_dice = "16d10"


class ShieldGuardian(Monster):
    """
    **Bound**: The shield guardian is magically bound to an amulet. As long as the guardian and its amulet are on the same plane of existence, the amulet's wearer can telepathically call the guardian to travel to it, and the guardian knows the distance and direction to the amulet. If the guardian is within 60 feet of the amulet's wearer, half of any damage the wearer takes (rounded up) is transferred to the guardian.

    **Regeneration**: The shield guardian regains 10 hit points at the start of its turn if it has at least 1 hit. point.

    **Spell Storing**: A spellcaster who wears the shield guardian's amulet can cause the guardian to store one spell of 4th level or lower. To do so, the wearer must cast the spell on the guardian. The spell has no effect but is stored within the guardian. When commanded to do so by the wearer or when a situation arises that was predefined by the spellcaster, the guardian casts the stored spell with any parameters set by the original caster, requiring no components. When the spell is cast or a new spell is stored, any previously stored spell is lost.

    **Multiattack**: The guardian makes two fist attacks.

    **Fist**: Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 11 (2d6 + 4) bludgeoning damage.
    """

    name = "Shield Guardian"
    description = "Large construct, unaligned"
    challenge_rating = 7
    armor_class = 17
    skills = ""
    senses = "Blindsight 10 ft., Darkvision 60 ft., Passive Perception 10"
    languages = "understands commands given in any language but can't speak"
    strength = Ability(18)
    dexterity = Ability(8)
    constitution = Ability(18)
    intelligence = Ability(7)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 142
    hit_dice = "15d10"


class Shrieker(Monster):
    """
    **False Appearance**: While the shrieker remains motionless, it is indistinguishable from an ordinary fungus.

    **Shriek**: When bright light or a creature is within 30 feet of the shrieker, it emits a shriek audible within 300 feet of it. The shrieker continues to shriek until the disturbance moves out of range and for 1d4 of the shrieker's turns afterward
    """

    name = "Shrieker"
    description = "Medium plant, unaligned"
    challenge_rating = 0
    armor_class = 5
    skills = ""
    senses = "Blindsight 30 ft. (blind beyond this radius), Passive Perception 6"
    languages = ""
    strength = Ability(1)
    dexterity = Ability(1)
    constitution = Ability(10)
    intelligence = Ability(1)
    wisdom = Ability(3)
    charisma = Ability(1)
    speed = 0
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 13
    hit_dice = "3d8"


class SilverDragonWyrmling(Monster):
    """
    **Bite**: Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 9 (1d10 + 4) piercing damage.

    **Breath Weapons**: The dragon uses one of the following breath weapons.
    Cold Breath. The dragon exhales an icy blast in a 15-foot cone. Each creature in that area must make a DC 13 Constitution saving throw, taking 18 (4d8) cold damage on a failed save, or half as much damage on a successful one.
    Paralyzing Breath. The dragon exhales paralyzing gas in a 15-foot cone. Each creature in that area must succeed on a DC 13 Constitution saving throw or be paralyzed for 1 minute. A creature can repeat the saving throw at the end of each of its turns, ending the effect on itself on a success.
    """

    name = "Silver Dragon Wyrmling"
    description = "Medium dragon, lawful good"
    challenge_rating = 2
    armor_class = 17
    skills = "Perception +4, Stealth +2"
    senses = "Blindsight 10 ft., Darkvision 60 ft., Passive Perception 14"
    languages = "Draconic"
    strength = Ability(19)
    dexterity = Ability(10)
    constitution = Ability(17)
    intelligence = Ability(12)
    wisdom = Ability(11)
    charisma = Ability(15)
    speed = 30
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    hp_max = 45
    hit_dice = "6d8"


class Skeleton(Monster):
    """
    **Shortsword**: Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 + 2) piercing damage.

    **Shortbow**: Ranged Weapon Attack: +4 to hit, range 80/320 ft., one target. Hit: 5 (1d6 + 2) piercing damage.
    """

    name = "Skeleton"
    description = "Medium undead, lawful evil"
    challenge_rating = 0.25
    armor_class = 13
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 9"
    languages = "understands all languages it spoke in life but can't speak"
    strength = Ability(10)
    dexterity = Ability(14)
    constitution = Ability(15)
    intelligence = Ability(6)
    wisdom = Ability(8)
    charisma = Ability(5)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 13
    hit_dice = "2d8"


class Solar(Monster):
    """
    **Angelic Weapons**: The solar's weapon attacks are magical. When the solar hits with any weapon, the weapon deals an extra 6d8 radiant damage (included in the attack).

    **Divine Awareness**: The solar knows if it hears a lie.

    **Innate Spellcasting**: The solar's spell casting ability is Charisma (spell save DC 25). It can innately cast the following spells, requiring no material components:
    At will: detect evil and good, invisibility (self only)
    3/day each: blade barrier, dispel evil and good, resurrection
    1/day each: commune, control weather

    **Magic Resistance**: The solar has advantage on saving throws against spells and other magical effects.

    **Multiattack**: The solar makes two greatsword attacks.

    **Greatsword**: Melee Weapon Attack: +15 to hit, reach 5 ft., one target. Hit: 22 (4d6 + 8) slashing damage plus 27 (6d8) radiant damage.

    **Slaying Longbow**: Ranged Weapon Attack: +13 to hit, range 150/600 ft., one target. Hit: 15 (2d8 + 6) piercing damage plus 27 (6d8) radiant damage. If the target is a creature that has 190 hit points or fewer, it must succeed on a DC 15 Constitution saving throw or die.

    **Flying Sword**: The solar releases its greatsword to hover magically in an unoccupied space within 5 ft. of it. If the solar can see the sword, the solar can mentally command it as a bonus action to fly up to 50 ft. and either make one attack against a target or return to the solar's hands. If the hovering sword is targeted by any effect, the solar is considered to be holding it. The hovering sword falls if the solar dies.

    **Healing Touch**: The solar touches another creature. The target magically regains 40 (8d8 + 4) hit points and is freed from any curse, disease, poison, blindness, or deafness.
    """

    name = "Solar"
    description = "Large celestial, lawful good"
    challenge_rating = 21
    armor_class = 21
    skills = "Perception +14"
    senses = "Truesight 120 ft., Passive Perception 24"
    languages = "all, telepathy 120 ft."
    strength = Ability(26)
    dexterity = Ability(22)
    constitution = Ability(26)
    intelligence = Ability(25)
    wisdom = Ability(25)
    charisma = Ability(30)
    speed = 50
    swim_speed = 0
    fly_speed = 150
    climb_speed = 0
    hp_max = 243
    hit_dice = "18d10"


class Specter(Monster):
    """
    **Incorporeal Movement**: The specter can move through other creatures and objects as if they were difficult terrain. It takes 5 (1d10) force damage if it ends its turn inside an object.

    **Sunlight Sensitivity**: While in sunlight, the specter has disadvantage on attack rolls, as well as on Wisdom (Perception) checks that rely on sight.

    **Life Drain**: Melee Spell Attack: +4 to hit, reach 5 ft., one creature. Hit: 10 (3d6) necrotic damage. The target must succeed on a DC 10 Constitution saving throw or its hit point maximum is reduced by an amount equal to the damage taken. This reduction lasts until the creature finishes a long rest. The target dies if this effect reduces its hit point maximum to 0.
    """

    name = "Specter"
    description = "Medium undead, chaotic evil"
    challenge_rating = 1
    armor_class = 12
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 10"
    languages = "understands all languages it knew in life but can't speak"
    strength = Ability(1)
    dexterity = Ability(14)
    constitution = Ability(11)
    intelligence = Ability(10)
    wisdom = Ability(10)
    charisma = Ability(11)
    speed = 0
    swim_speed = 0
    fly_speed = 50
    climb_speed = 0
    hp_max = 22
    hit_dice = "5d8"


class Spider(Monster):
    """
    **Spider Climb**: The spider can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

    **Web Sense**: While in contact with a web, the spider knows the exact location of any other creature in contact with the same web.

    **Web Walker**: The spider ignores movement restrictions caused by webbing.

    **Bite**: Melee Weapon Attack: +4 to hit, reach 5 ft., one creature. Hit: 1 piercing damage, and the target must succeed on a DC 9 Constitution saving throw or take 2 (1d4) poison damage.
    """

    name = "Spider"
    description = "Tiny beast, unaligned"
    challenge_rating = 0
    armor_class = 12
    skills = "Stealth +4"
    senses = "Darkvision 30 ft., Passive Perception 12"
    languages = ""
    strength = Ability(2)
    dexterity = Ability(14)
    constitution = Ability(8)
    intelligence = Ability(1)
    wisdom = Ability(10)
    charisma = Ability(2)
    speed = 20
    swim_speed = 0
    fly_speed = 0
    climb_speed = 20
    hp_max = 1
    hit_dice = "1d4"


class SpiritNaga(Monster):
    """
    **Rejuvenation**: If it dies, the naga returns to life in 1d6 days and regains all its hit points. Only a wish spell can prevent this trait from functioning.

    **Spellcasting**: The naga is a 10th-level spellcaster. Its spellcasting ability is Intelligence (spell save DC 14, +6 to hit with spell attacks), and it needs only verbal components to cast its spells. It has the following wizard spells prepared:

    - Cantrips (at will): mage hand, minor illusion, ray of frost
    - 1st level (4 slots): charm person, detect magic, sleep
    - 2nd level (3 slots): detect thoughts, hold person
    - 3rd level (3 slots): lightning bolt, water breathing
    - 4th level (3 slots): blight, dimension door
    - 5th level (2 slots): dominate person

    **Bite**: Melee Weapon Attack: +7 to hit, reach 10 ft., one creature. Hit: 7 (1d6 + 4) piercing damage, and the target must make a DC 13 Constitution saving throw, taking 31 (7d8) poison damage on a failed save, or half as much damage on a successful one.
    """

    name = "Spirit Naga"
    description = "Large monstrosity, chaotic evil"
    challenge_rating = 8
    armor_class = 15
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 12"
    languages = "Abyssal, Common"
    strength = Ability(18)
    dexterity = Ability(17)
    constitution = Ability(14)
    intelligence = Ability(16)
    wisdom = Ability(15)
    charisma = Ability(16)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 75
    hit_dice = "10d10"


class Sprite(Monster):
    """
    **Longsword**: Melee Weapon Attack: +2 to hit, reach 5 ft., one target. Hit: 1 slashing damage.

    **Shortbow**: Ranged Weapon Attack: +6 to hit, range 40/160 ft., one target. Hit: 1 piercing damage, and the target must succeed on a DC 10 Constitution saving throw or become poisoned for 1 minute. If its saving throw result is 5 or lower, the poisoned target falls unconscious for the same duration, or until it takes damage or another creature takes an action to shake it awake.

    **Heart Sight**: The sprite touches a creature and magically knows the creature's current emotional state. If the target fails a DC 10 Charisma saving throw, the sprite also knows the creature's alignment. Celestials, fiends, and undead automatically fail the saving throw.

    **Invisibility**: The sprite magically turns invisible until it attacks or casts a spell, or until its concentration ends (as if concentrating on a spell). Any equipment the sprite wears or carries is invisible with it.
    """

    name = "Sprite"
    description = "Tiny fey, neutral good"
    challenge_rating = 0.25
    armor_class = 15
    skills = "Perception +3, Stealth +8"
    senses = "Passive Perception 13"
    languages = "Common, Elvish, Sylvan"
    strength = Ability(3)
    dexterity = Ability(18)
    constitution = Ability(10)
    intelligence = Ability(14)
    wisdom = Ability(13)
    charisma = Ability(11)
    speed = 10
    swim_speed = 0
    fly_speed = 40
    climb_speed = 0
    hp_max = 2
    hit_dice = "1d4"


class Spy(Monster):
    """
    **Cunning Action**: On each of its turns, the spy can use a bonus action to take the Dash, Disengage, or Hide action.

    **Sneak Attack (1/Turn)**: The spy deals an extra 7 (2d6) damage when it hits a target with a weapon attack and has advantage on the attack roll, or when the target is within 5 ft. of an ally of the spy that isn't incapacitated and the spy doesn't have disadvantage on the attack roll.

    **Multiattack**: The spy makes two melee attacks.

    **Shortsword**: Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 5 (1d6 + 2) piercing damage.

    **Hand Crossbow**: Ranged Weapon Attack: +4 to hit, range 30/120 ft., one target. Hit: 5 (1d6 + 2) piercing damage.
    """

    name = "Spy"
    description = "Medium humanoid, any alignment"
    challenge_rating = 1
    armor_class = 12
    skills = (
        "Deception +5, Insight +4, Investigation +5, Perception +6, Persuasion +5,"
        " Stealth +4"
    )
    senses = "Passive Perception 16"
    languages = "any two languages"
    strength = Ability(10)
    dexterity = Ability(15)
    constitution = Ability(10)
    intelligence = Ability(12)
    wisdom = Ability(14)
    charisma = Ability(16)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 27
    hit_dice = "6d8"


class SteamMephit(Monster):
    """
    **Death Burst**: When the mephit dies, it explodes in a cloud of steam. Each creature within 5 ft. of the mephit must succeed on a DC 10 Dexterity saving throw or take 4 (1d8) fire damage.

    **Innate Spellcasting**: The mephit can innately cast blur, requiring no material components. Its innate spellcasting ability is Charisma.

    **Claws**: Melee Weapon Attack: +2 to hit, reach 5 ft., one creature. Hit: 2 (1d4) slashing damage plus 2 (1d4) fire damage.

    **Steam Breath (Recharge 6)**: The mephit exhales a 15-foot cone of scalding steam. Each creature in that area must succeed on a DC 10 Dexterity saving throw, taking 4 (1d8) fire damage on a failed save, or half as much damage on a successful one.

    **Variant: Summon Mephits**: The mephit has a 25 percent chance of summoning 1d4 mephits of its kind. A summoned mephit appears in an unoccupied space within 60 feet of its summoner, acts as an ally of its summoner, and can't summon other mephits. It remains for 1 minute, until it or its summoner dies, or until its summoner dismisses it as an action.
    """

    name = "Steam Mephit"
    description = "Small elemental, neutral evil"
    challenge_rating = 0.25
    armor_class = 10
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 10"
    languages = "Aquan, Ignan"
    strength = Ability(5)
    dexterity = Ability(11)
    constitution = Ability(10)
    intelligence = Ability(11)
    wisdom = Ability(10)
    charisma = Ability(12)
    speed = 30
    swim_speed = 0
    fly_speed = 30
    climb_speed = 0
    hp_max = 21
    hit_dice = "6d6"


class Stirge(Monster):
    """
    **Blood Drain**: Melee Weapon Attack: +5 to hit, reach 5 ft., one creature. Hit: 5 (1d4 + 3) piercing damage, and the stirge attaches to the target. While attached, the stirge doesn't attack. Instead, at the start of each of the stirge's turns, the target loses 5 (1d4 + 3) hit points due to blood loss.
    The stirge can detach itself by spending 5 feet of its movement. It does so after it drains 10 hit points of blood from the target or the target dies. A creature, including the target, can use its action to detach the stirge.
    """

    name = "Stirge"
    description = "Tiny beast, unaligned"
    challenge_rating = 0.125
    armor_class = 14
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 9"
    languages = ""
    strength = Ability(4)
    dexterity = Ability(16)
    constitution = Ability(11)
    intelligence = Ability(2)
    wisdom = Ability(8)
    charisma = Ability(6)
    speed = 10
    swim_speed = 0
    fly_speed = 40
    climb_speed = 0
    hp_max = 2
    hit_dice = "1d4"


class StoneGiant(Monster):
    """
    **Stone Camouflage**: The giant has advantage on Dexterity (Stealth) checks made to hide in rocky terrain.

    **Multiattack**: The giant makes two greatclub attacks.

    **Greatclub**: Melee Weapon Attack: +9 to hit, reach 15 ft., one target. Hit: 19 (3d8 + 6) bludgeoning damage.

    **Rock**: Ranged Weapon Attack: +9 to hit, range 60/240 ft., one target. Hit: 28 (4d10 + 6) bludgeoning damage. If the target is a creature, it must succeed on a DC 17 Strength saving throw or be knocked prone.
    """

    name = "Stone Giant"
    description = "Huge giant, neutral"
    challenge_rating = 7
    armor_class = 17
    skills = "Athletics +12, Perception +4"
    senses = "Darkvision 60 ft., Passive Perception 14"
    languages = "Giant"
    strength = Ability(23)
    dexterity = Ability(15)
    constitution = Ability(20)
    intelligence = Ability(10)
    wisdom = Ability(12)
    charisma = Ability(9)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 126
    hit_dice = "11d12"


class StoneGolem(Monster):
    """
    **Immutable Form**: The golem is immune to any spell or effect that would alter its form.

    **Magic Resistance**: The golem has advantage on saving throws against spells and other magical effects.

    **Magic Weapons**: The golem's weapon attacks are magical.

    **Multiattack**: The golem makes two slam attacks.

    **Slam**: Melee Weapon Attack: +10 to hit, reach 5 ft., one target. Hit: 19 (3d8 + 6) bludgeoning damage.

    **Slow**: The golem targets one or more creatures it can see within 10 ft. of it. Each target must make a DC 17 Wisdom saving throw against this magic. On a failed save, a target can't use reactions, its speed is halved, and it can't make more than one attack on its turn. In addition, the target can take either an action or a bonus action on its turn, not both. These effects last for 1 minute. A target can repeat the saving throw at the end of each of its turns, ending the effect on itself on a success.
    """

    name = "Stone Golem"
    description = "Large construct, unaligned"
    challenge_rating = 10
    armor_class = 17
    skills = ""
    senses = "Darkvision 120 ft., Passive Perception 10"
    languages = "understands the languages of its creator but can't speak"
    strength = Ability(22)
    dexterity = Ability(9)
    constitution = Ability(20)
    intelligence = Ability(3)
    wisdom = Ability(11)
    charisma = Ability(1)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 178
    hit_dice = "17d10"


class Stonemelder(Monster):
    """Death Burst.
      When the stonemelder dies, it turns to stone and explodes in a
      burst of rock shards, becoming a smoking pile of rubble. Each
      creature within 10 feet of the exploding stonemelder must make a
      DC 14 Dexterity saving throw, taking 11 (2d10) bludgeoning
      damage on a failed save, or half as much damage on a successful
      one.
    Spellcasting.
      The stonemelder is a 7th-level spellcaster. Its spellcasting
      ability is Charisma (spell save DC 13, +5 to hit with spell
      attacks. It knows the following sorcerer spells (an asterisked
      spell is from *Princes of the Apocalypse* appendix B):
    Cantrips (at will):
      acid splash, blade ward, light mending, mold earth*
    1st level (4 slots):
      expeditious retreat, false life, shield
    2nd level (3 slots):
      Maximilian's earthen grasp,* shatter
    3rd level (3 slots):
      erupting earth,* meld into stone
    4th level (1 slots):
      stoneskin
    Black Earth Rod.
      *Melee Weapon Attack:* +5 to hit, reach 5 ft., one
      target. *Hit:* 5 (1d6 + 2) bludgeoning damage. The stonemelder
      can also expend a spell slot to deal extra damage, dealing 2d8
      bludgeoning damage for a 1st level slot, plus an additional 1d8
      for each level of the slot above 1st.

    Stonemelders are spellcasters who gain their power from Ogrémoch,
    using elemental earth magic to sheathe their bodies in carapaces
    of rock. They are elite champions of the cult and answer only to
    the cult leaders. Not even the Black Earth priests tell
    stonemelders what to do.

    Each stonemelder carries a weapon known as a Black Earth rod. Such
    a rod is like an ordinary mace, but in the hands of a stonemelder,
    it serves as a conduit for Ogrémoch's wrath.

    """

    name = "Stonemelder"
    description = "Medium humanoid (human), neutral evil"
    challenge_rating = 4
    armor_class = 17
    skills = "Intimidation +5, Perception +2"
    senses = "termorsense 30 ft., passive Perception 12"
    languages = "Common, Terran"
    strength = Ability(15)
    dexterity = Ability(10)
    constitution = Ability(16)
    intelligence = Ability(12)
    wisdom = Ability(11)
    charisma = Ability(17)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 75
    hit_dice = "10d8 + 30"


class StormGiant(Monster):
    """
    **Amphibious**: The giant can breathe air and water.

    **Innate Spellcasting**: The giant's innate spellcasting ability is Charisma (spell save DC 17). It can innately cast the following spells, requiring no material components:

    At will: detect magic, feather fall, levitate, light
    3/day each: control weather, water breathing

    **Multiattack**: The giant makes two greatsword attacks.

    **Greatsword**: Melee Weapon Attack: +14 to hit, reach 10 ft., one target. Hit: 30 (6d6 + 9) slashing damage.

    **Rock**: Ranged Weapon Attack: +14 to hit, range 60/240 ft., one target. Hit: 35 (4d12 + 9) bludgeoning damage.

    **Lightning Strike**: The giant hurls a magical lightning bolt at a point it can see within 500 feet of it. Each creature within 10 feet of that point must make a DC 17 Dexterity saving throw, taking 54 (12d8) lightning damage on a failed save, or half as much damage on a successful one.
    """

    name = "Storm Giant"
    description = "Huge giant, chaotic good"
    challenge_rating = 13
    armor_class = 16
    skills = "Arcana +8, Athletics +14, History +8, Perception +9"
    senses = "Passive Perception 19"
    languages = "Common, Giant"
    strength = Ability(29)
    dexterity = Ability(14)
    constitution = Ability(20)
    intelligence = Ability(16)
    wisdom = Ability(18)
    charisma = Ability(18)
    speed = 50
    swim_speed = 50
    fly_speed = 0
    climb_speed = 0
    hp_max = 230
    hit_dice = "20d12"


class SuccubusIncubus(Monster):
    """
    **Telepathic Bond**: The fiend ignores the range restriction on its telepathy when communicating with a creature it has charmed. The two don't even need to be on the same plane of existence.

    **Shapechanger**: The fiend can use its action to polymorph into a Small or Medium humanoid, or back into its true form. Without wings, the fiend loses its flying speed. Other than its size and speed, its statistics are the same in each form. Any equipment it is wearing or carrying isn't transformed. It reverts to its true form if it dies.

    **Claw (Fiend Form Only)**: Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 6 (1d6 + 3) slashing damage.

    **Charm**: One humanoid the fiend can see within 30 feet of it must succeed on a DC 15 Wisdom saving throw or be magically charmed for 1 day. The charmed target obeys the fiend's verbal or telepathic commands. If the target suffers any harm or receives a suicidal command, it can repeat the saving throw, ending the effect on a success. If the target successfully saves against the effect, or if the effect on it ends, the target is immune to this fiend's Charm for the next 24 hours.
    The fiend can have only one target charmed at a time. If it charms another, the effect on the previous target ends.

    **Draining Kiss**: The fiend kisses a creature charmed by it or a willing creature. The target must make a DC 15 Constitution saving throw against this magic, taking 32 (5d10 + 5) psychic damage on a failed save, or half as much damage on a successful one. The target's hit point maximum is reduced by an amount equal to the damage taken. This reduction lasts until the target finishes a long rest. The target dies if this effect reduces its hit point maximum to 0.

    **Etherealness**: The fiend magically enters the Ethereal Plane from the Material Plane, or vice versa.
    """

    name = "Succubus/Incubus"
    description = "Medium fiend, neutral evil"
    challenge_rating = 4
    armor_class = 15
    skills = "Deception +9, Insight +5, Perception +5, Persuasion +9, Stealth +7"
    senses = "Darkvision 60 ft., Passive Perception 15"
    languages = "Abyssal, Common, Infernal, telepathy 60 ft."
    strength = Ability(8)
    dexterity = Ability(17)
    constitution = Ability(13)
    intelligence = Ability(15)
    wisdom = Ability(12)
    charisma = Ability(20)
    speed = 30
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    hp_max = 66
    hit_dice = "12d8"


class SwarmOfBats(Monster):
    """
    **Echolocation**: The swarm can't use its blindsight while deafened.

    **Keen Hearing**: The swarm has advantage on Wisdom (Perception) checks that rely on hearing.

    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny bat. The swarm can't regain hit points or gain temporary hit points.

    **Bites**: Melee Weapon Attack: +4 to hit, reach 0 ft., one creature in the swarm's space. Hit: 5 (2d4) piercing damage, or 2 (1d4) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Bats"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.25
    armor_class = 12
    skills = ""
    senses = "Blindsight 60 ft., Passive Perception 11"
    languages = ""
    strength = Ability(5)
    dexterity = Ability(15)
    constitution = Ability(10)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(4)
    speed = 0
    swim_speed = 0
    fly_speed = 30
    climb_speed = 0
    hp_max = 22
    hit_dice = "5d8"


class SwarmOfBeetles(Monster):
    """
    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny insect. The swarm can't regain hit points or gain temporary hit points.

    **Bites**: Melee Weapon Attack: +3 to hit, reach 0 ft., one target in the swarm's space. Hit: 10 (4d4) piercing damage, or 5 (2d4) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Beetles"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.5
    armor_class = 12
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 8"
    languages = ""
    strength = Ability(3)
    dexterity = Ability(13)
    constitution = Ability(10)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(1)
    speed = 20
    swim_speed = 0
    fly_speed = 0
    climb_speed = 20
    hp_max = 22
    hit_dice = "5d8"


class SwarmOfCentipedes(Monster):
    """
    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny insect. The swarm can't regain hit points or gain temporary hit points.

    **Bites**: Melee Weapon Attack: +3 to hit, reach 0 ft., one target in the swarm's space. Hit: 10 (4d4) piercing damage, or 5 (2d4) piercing damage if the swarm has half of its hit points or fewer.
    A creature reduced to 0 hit points by a swarm of centipedes is stable but poisoned for 1 hour, even after regaining hit points, and paralyzed while poisoned in this way.
    """

    name = "Swarm of Centipedes"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.5
    armor_class = 12
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 8"
    languages = ""
    strength = Ability(3)
    dexterity = Ability(13)
    constitution = Ability(10)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(1)
    speed = 20
    swim_speed = 0
    fly_speed = 0
    climb_speed = 20
    hp_max = 22
    hit_dice = "5d8"


class SwarmOfInsects(Monster):
    """
    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny insect. The swarm can't regain hit points or gain temporary hit points.

    **Bites**: Melee Weapon Attack: +3 to hit, reach 0 ft., one target in the swarm's space. Hit: 10 (4d4) piercing damage, or 5 (2d4) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Insects"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.5
    armor_class = 12
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 8"
    languages = ""
    strength = Ability(3)
    dexterity = Ability(13)
    constitution = Ability(10)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(1)
    speed = 20
    swim_speed = 0
    fly_speed = 0
    climb_speed = 20
    hp_max = 22
    hit_dice = "5d8"


class SwarmOfPoisonousSnakes(Monster):
    """
    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny snake. The swarm can't regain hit points or gain temporary hit points.

    **Bites**: Melee Weapon Attack: +6 to hit, reach 0 ft., one creature in the swarm's space. Hit: 7 (2d6) piercing damage, or 3 (1d6) piercing damage if the swarm has half of its hit points or fewer. The target must make a DC 10 Constitution saving throw, taking 14 (4d6) poison damage on a failed save, or half as much damage on a successful one.
    """

    name = "Swarm of Poisonous Snakes"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 2
    armor_class = 14
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 10"
    languages = ""
    strength = Ability(8)
    dexterity = Ability(18)
    constitution = Ability(11)
    intelligence = Ability(1)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 30
    swim_speed = 30
    fly_speed = 0
    climb_speed = 0
    hp_max = 36
    hit_dice = "8d8"


class SwarmOfQuippers(Monster):
    """
    **Blood Frenzy**: The swarm has advantage on melee attack rolls against any creature that doesn't have all its hit points.

    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny quipper. The swarm can't regain hit points or gain temporary hit points.

    **Water Breathing**: The swarm can breathe only underwater.

    **Bites**: Melee Weapon Attack: +5 to hit, reach 0 ft., one creature in the swarm's space. Hit: 14 (4d6) piercing damage, or 7 (2d6) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Quippers"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 1
    armor_class = 13
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 8"
    languages = ""
    strength = Ability(13)
    dexterity = Ability(16)
    constitution = Ability(9)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(2)
    speed = 0
    swim_speed = 40
    fly_speed = 0
    climb_speed = 0
    hp_max = 28
    hit_dice = "8d8"


class SwarmOfRats(Monster):
    """
    **Keen Smell**: The swarm has advantage on Wisdom (Perception) checks that rely on smell.

    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny rat. The swarm can't regain hit points or gain temporary hit points.

    **Bites**: Melee Weapon Attack: +2 to hit, reach 0 ft., one target in the swarm's space. Hit: 7 (2d6) piercing damage, or 3 (1d6) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Rats"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.25
    armor_class = 10
    skills = ""
    senses = "Darkvision 30 ft., Passive Perception 10"
    languages = ""
    strength = Ability(9)
    dexterity = Ability(11)
    constitution = Ability(9)
    intelligence = Ability(2)
    wisdom = Ability(10)
    charisma = Ability(3)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 24
    hit_dice = "7d8"


class SwarmOfRavens(Monster):
    """
    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny raven. The swarm can't regain hit points or gain temporary hit points.

    **Beaks**: Melee Weapon Attack: +4 to hit, reach 5 ft., one target in the swarm's space. Hit: 7 (2d6) piercing damage, or 3 (1d6) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Ravens"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.25
    armor_class = 12
    skills = ""
    senses = "Passive Perception 15"
    languages = ""
    strength = Ability(6)
    dexterity = Ability(14)
    constitution = Ability(8)
    intelligence = Ability(3)
    wisdom = Ability(12)
    charisma = Ability(6)
    speed = 10
    swim_speed = 0
    fly_speed = 50
    climb_speed = 0
    hp_max = 24
    hit_dice = "7d8"


class SwarmOfSpiders(Monster):
    """
    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny insect. The swarm can't regain hit points or gain temporary hit points.

    **Spider Climb**: The swarm can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

    **Web Sense**: While in contact with a web, the swarm knows the exact location of any other creature in contact with the same web.

    **Web Walker**: The swarm ignores movement restrictions caused by webbing.

    **Bites**: Melee Weapon Attack: +3 to hit, reach 0 ft., one target in the swarm's space. Hit: 10 (4d4) piercing damage, or 5 (2d4) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Spiders"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.5
    armor_class = 12
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 8"
    languages = ""
    strength = Ability(3)
    dexterity = Ability(13)
    constitution = Ability(10)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(1)
    speed = 20
    swim_speed = 0
    fly_speed = 0
    climb_speed = 20
    hp_max = 22
    hit_dice = "5d8"


class SwarmOfWasps(Monster):
    """
    **Swarm**: The swarm can occupy another creature's space and vice versa, and the swarm can move through any opening large enough for a Tiny insect. The swarm can't regain hit points or gain temporary hit points.

    **Bites**: Melee Weapon Attack: +3 to hit, reach 0 ft., one target in the swarm's space. Hit: 10 (4d4) piercing damage, or 5 (2d4) piercing damage if the swarm has half of its hit points or fewer.
    """

    name = "Swarm of Wasps"
    description = "Medium swarm of Tiny beasts, unaligned"
    challenge_rating = 0.5
    armor_class = 12
    skills = ""
    senses = "Blindsight 10 ft., Passive Perception 8"
    languages = ""
    strength = Ability(3)
    dexterity = Ability(13)
    constitution = Ability(10)
    intelligence = Ability(1)
    wisdom = Ability(7)
    charisma = Ability(1)
    speed = 5
    swim_speed = 0
    fly_speed = 30
    climb_speed = 0
    hp_max = 22
    hit_dice = "5d8"
