"""
A collection of monsters from D&D 5e's SRD

This file was autogenerated by https://github.com/stravajiaxen/5e-srd-to-py
"""

from dungeonsheets.monsters.monsters import Monster
from dungeonsheets.stats import Ability


class OchreJelly(Monster):
    """
    **Amorphous**: The jelly can move through a space as narrow as 1 inch wide without squeezing.

    **Spider Climb**: The jelly can climb difficult surfaces, including upside down on ceilings, without needing to make an ability check.

    **Pseudopod**: Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 9 (2d6 + 2) bludgeoning damage plus 3 (1d6) acid damage.
    """

    name = "Ochre Jelly"
    description = "Large ooze, unaligned"
    challenge_rating = 2
    armor_class = 8
    skills = ""
    senses = "Blindsight 60 ft. (blind beyond this radius), Passive Perception 8"
    languages = ""
    strength = Ability(15)
    dexterity = Ability(6)
    constitution = Ability(14)
    intelligence = Ability(2)
    wisdom = Ability(6)
    charisma = Ability(1)
    speed = 10
    swim_speed = 0
    fly_speed = 0
    climb_speed = 10
    hp_max = 45
    hit_dice = "6d10"


class Octopus(Monster):
    """
    **Hold Breath**: While out of water, the octopus can hold its breath for 30 minutes.

    **Underwater Camouflage**: The octopus has advantage on Dexterity (Stealth) checks made while underwater.

    **Water Breathing**: The octopus can breathe only underwater.

    **Tentacles**: Melee Weapon Attack: +4 to hit, reach 5 ft., one target. Hit: 1 bludgeoning damage, and the target is grappled (escape DC 10). Until this grapple ends, the octopus can't use its tentacles on another target.

    **Ink Cloud**: A 5-foot-radius cloud of ink extends all around the octopus if it is underwater. The area is heavily obscured for 1 minute, although a significant current can disperse the ink. After releasing the ink, the octopus can use the Dash action as a bonus action.
    """

    name = "Octopus"
    description = "Small beast, unaligned"
    challenge_rating = 0
    armor_class = 12
    skills = "Perception +2, Stealth +4"
    senses = "Darkvision 30 ft., Passive Perception 12"
    languages = ""
    strength = Ability(4)
    dexterity = Ability(15)
    constitution = Ability(11)
    intelligence = Ability(3)
    wisdom = Ability(10)
    charisma = Ability(4)
    speed = 5
    swim_speed = 30
    fly_speed = 0
    climb_speed = 0
    hp_max = 3
    hit_dice = "1d6"


class Ogre(Monster):
    """
    **Greatclub**: Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 13 (2d8 + 4) bludgeoning damage.

    **Javelin**: Melee or Ranged Weapon Attack: +6 to hit, reach 5 ft. or range 30/120 ft., one target. Hit: 11 (2d6 + 4) piercing damage.
    """

    name = "Ogre"
    description = "Large giant, chaotic evil"
    challenge_rating = 2
    armor_class = 11
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 8"
    languages = "Common, Giant"
    strength = Ability(19)
    dexterity = Ability(8)
    constitution = Ability(16)
    intelligence = Ability(5)
    wisdom = Ability(7)
    charisma = Ability(7)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 59
    hit_dice = "7d10"


class OgreZombie(Monster):
    """
    **Undead Fortitude**: If damage reduces the zombie to 0 hit points, it must make a Constitution saving throw with a DC of 5+the damage taken, unless the damage is radiant or from a critical hit. On a success, the zombie drops to 1 hit point instead.

    **Morningstar**: Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 13 (2d8 + 4) bludgeoning damage.
    """

    name = "Ogre Zombie"
    description = "Large undead, neutral evil"
    challenge_rating = 2
    armor_class = 8
    skills = ""
    senses = "Darkvision 60 ft., Passive Perception 8"
    languages = "understands Common and Giant but can't speak"
    strength = Ability(19)
    dexterity = Ability(6)
    constitution = Ability(18)
    intelligence = Ability(3)
    wisdom = Ability(6)
    charisma = Ability(5)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 85
    hit_dice = "9d10"


class Oni(Monster):
    """
    **Innate Spellcasting**: The oni's innate spellcasting ability is Charisma (spell save DC 13). The oni can innately cast the following spells, requiring no material components:

    At will: darkness, invisibility
    1/day each: charm person, cone of cold, gaseous form, sleep

    **Magic Weapons**: The oni's weapon attacks are magical.

    **Regeneration**: The oni regains 10 hit points at the start of its turn if it has at least 1 hit point.

    **Multiattack**: The oni makes two attacks, either with its claws or its glaive.

    **Claw (Oni Form Only)**: Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 8 (1d8 + 4) slashing damage.

    **Glaive**: Melee Weapon Attack: +7 to hit, reach 10 ft., one target. Hit: 15 (2d10 + 4) slashing damage, or 9 (1d10 + 4) slashing damage in Small or Medium form.

    **Change Shape**: The oni magically polymorphs into a Small or Medium humanoid, into a Large giant, or back into its true form. Other than its size, its statistics are the same in each form. The only equipment that is transformed is its glaive, which shrinks so that it can be wielded in humanoid form. If the oni dies, it reverts to its true form, and its glaive reverts to its normal size.
    """

    name = "Oni"
    description = "Large giant, lawful evil"
    challenge_rating = 7
    armor_class = 16
    skills = "Arcana +5, Deception +8, Perception +4"
    senses = "Darkvision 60 ft., Passive Perception 14"
    languages = "Common, Giant"
    strength = Ability(19)
    dexterity = Ability(11)
    constitution = Ability(16)
    intelligence = Ability(14)
    wisdom = Ability(12)
    charisma = Ability(15)
    speed = 30
    swim_speed = 0
    fly_speed = 30
    climb_speed = 0
    hp_max = 110
    hit_dice = "13d10"


class Orc(Monster):
    """
    **Aggressive**: As a bonus action, the orc can move up to its speed toward a hostile creature that it can see.

    **Greataxe**: Melee Weapon Attack: +5 to hit, reach 5 ft., one target. Hit: 9 (1d12 + 3) slashing damage.

    **Javelin**: Melee or Ranged Weapon Attack: +5 to hit, reach 5 ft. or range 30/120 ft., one target. Hit: 6 (1d6 + 3) piercing damage.
    """

    name = "Orc"
    description = "Medium humanoid, chaotic evil"
    challenge_rating = 0.5
    armor_class = 13
    skills = "Intimidation +2"
    senses = "Darkvision 60 ft., Passive Perception 10"
    languages = "Common, Orc"
    strength = Ability(16)
    dexterity = Ability(12)
    constitution = Ability(16)
    intelligence = Ability(7)
    wisdom = Ability(11)
    charisma = Ability(10)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 15
    hit_dice = "2d8"


class Otyugh(Monster):
    """
    **Limited Telepathy**: The otyugh can magically transmit simple messages and images to any creature within 120 ft. of it that can understand a language. This form of telepathy doesn't allow the receiving creature to telepathically respond.

    **Multiattack**: The otyugh makes three attacks: one with its bite and two with its tentacles.

    **Bite**: Melee Weapon Attack: +6 to hit, reach 5 ft., one target. Hit: 12 (2d8 + 3) piercing damage. If the target is a creature, it must succeed on a DC 15 Constitution saving throw against disease or become poisoned until the disease is cured. Every 24 hours that elapse, the target must repeat the saving throw, reducing its hit point maximum by 5 (1d10) on a failure. The disease is cured on a success. The target dies if the disease reduces its hit point maximum to 0. This reduction to the target's hit point maximum lasts until the disease is cured.

    **Tentacle**: Melee Weapon Attack: +6 to hit, reach 10 ft., one target. Hit: 7 (1d8 + 3) bludgeoning damage plus 4 (1d8) piercing damage. If the target is Medium or smaller, it is grappled (escape DC 13) and restrained until the grapple ends. The otyugh has two tentacles, each of which can grapple one target.

    **Tentacle Slam**: The otyugh slams creatures grappled by it into each other or a solid surface. Each creature must succeed on a DC 14 Constitution saving throw or take 10 (2d6 + 3) bludgeoning damage and be stunned until the end of the otyugh's next turn. On a successful save, the target takes half the bludgeoning damage and isn't stunned.
    """

    name = "Otyugh"
    description = "Large aberration, neutral"
    challenge_rating = 5
    armor_class = 14
    skills = ""
    senses = "Darkvision 120 ft., Passive Perception 11"
    languages = "Otyugh"
    strength = Ability(16)
    dexterity = Ability(11)
    constitution = Ability(19)
    intelligence = Ability(6)
    wisdom = Ability(13)
    charisma = Ability(6)
    speed = 30
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 114
    hit_dice = "12d10"


class Owl(Monster):
    """
    **Flyby**: The owl doesn't provoke opportunity attacks when it flies out of an enemy's reach.

    **Keen Hearing and Sight**: The owl has advantage on Wisdom (Perception) checks that rely on hearing or sight.

    **Talons**: Melee Weapon Attack: +3 to hit, reach 5 ft., one target. Hit: 1 slashing damage.
    """

    name = "Owl"
    description = "Tiny beast, unaligned"
    challenge_rating = 0
    armor_class = 11
    skills = "Perception +3, Stealth +3"
    senses = "Darkvision 120 ft., Passive Perception 13"
    languages = ""
    strength = Ability(3)
    dexterity = Ability(13)
    constitution = Ability(8)
    intelligence = Ability(2)
    wisdom = Ability(12)
    charisma = Ability(7)
    speed = 5
    swim_speed = 0
    fly_speed = 60
    climb_speed = 0
    hp_max = 1
    hit_dice = "1d4"


class Owlbear(Monster):
    """
    **Keen Sight and Smell**: The owlbear has advantage on Wisdom (Perception) checks that rely on sight or smell.

    **Multiattack**: The owlbear makes two attacks: one with its beak and one with its claws.

    **Beak**: Melee Weapon Attack: +7 to hit, reach 5 ft., one creature. Hit: 10 (1d10 + 5) piercing damage.

    **Claws**: Melee Weapon Attack: +7 to hit, reach 5 ft., one target. Hit: 14 (2d8 + 5) slashing damage.
    """

    name = "Owlbear"
    description = "Large monstrosity, unaligned"
    challenge_rating = 3
    armor_class = 13
    skills = "Perception +3"
    senses = "Darkvision 60 ft., Passive Perception 13"
    languages = ""
    strength = Ability(20)
    dexterity = Ability(12)
    constitution = Ability(17)
    intelligence = Ability(3)
    wisdom = Ability(12)
    charisma = Ability(7)
    speed = 40
    swim_speed = 0
    fly_speed = 0
    climb_speed = 0
    hp_max = 59
    hit_dice = "7d10"
