# LD-Cool-P Figshare API Tool

| Categories | Status |
| ---        | ---    |
| General    | ![GitHub top language](https://img.shields.io/github/languages/top/UAL-ODIS/ldcoolp-figshare) [![GitHub release (latest by date)](https://img.shields.io/github/v/release/UAL-ODIS/ldcoolp-figshare)](https://github.com/UAL-ODIS/ldcoolp-figshare/releases) [![GitHub](https://img.shields.io/github/license/UAL-ODIS/ldcoolp-figshare?color=blue)](LICENSE) |
| CI/CD      | Under construction | 
| PyPI       | ![PyPI - Python Version](https://img.shields.io/pypi/pyversions/ldcoolp-figshare) ![PyPI](https://img.shields.io/pypi/v/ldcoolp-figshare) ![PyPI - Downloads](https://img.shields.io/pypi/dm/voxcharta-my-voting-record?color=blue) | 
| Docs       | [![docs](https://img.shields.io/github/workflow/status/UAL-ODIS/ldcoolp-figshare/Sphinx%20Docs%20Check?label=sphinx%20docs)](https://github.com/UAL-ODIS/ldcoolp-figshare/actions?query=workflow%3A%22Sphinx+Docs+Check%22) [![Read the Docs](https://img.shields.io/readthedocs/ldcoolp-figshare?label=RTDs)](https://readthedocs.org/projects/ldcoolp-figshare/builds) |

Our complete Sphinx documentation is available
[here](https://ldcoolp-figshare.readthedocs.io) at ReadTheDocs.io.

`ldcoolp-figshare` is a command-line API used in
[`LD-Cool-P`](https://github.com/UAL-ODIS/LD_Cool_P) to interact with the
[Figshare API](https://api.figshare.com). It is used by
[ReDATA](https://arizona.figshare.com) data curators for the curation of
submitted research data products. This codebase is generalized such that
other curators with a
[Figshare for Institution](https://knowledge.figshare.com/institutions)
instance can use.

---

- [Getting Started](https://ldcoolp-figshare.readthedocs.io/en/latest/getting_started.html)
    - [Requirements](https://ldcoolp-figshare.readthedocs.io/en/latest/getting_started.html#requirements)
- [Use Examples](https://ldcoolp-figshare.readthedocs.io/en/latest/use_examples.html)
    - [Get a list of accounts](https://ldcoolp-figshare.readthedocs.io/en/latest/use_examples.html#get-a-list-of-accounts)
    - [Obtain curation records](https://ldcoolp-figshare.readthedocs.io/en/latest/use_examples.html#obtain-curation-records)
    - [DOI status and reservation](https://ldcoolp-figshare.readthedocs.io/en/latest/use_examples.html#doi-status-and-reservation)
    - [Retrieve list of institution groups](https://ldcoolp-figshare.readthedocs.io/en/latest/use_examples.html#retrieve-list-of-institution-groups)
    - [Retrieve list of articles for a user](https://ldcoolp-figshare.readthedocs.io/en/latest/use_examples.html#retrieve-list-of-articles-for-a-user)
- [Continuous Integration](https://ldcoolp-figshare.readthedocs.io/en/latest/ci.html)
- [Versioning](https://ldcoolp-figshare.readthedocs.io/en/latest/versioning.html)
- [Authors](https://ldcoolp-figshare.readthedocs.io/en/latest/authors.html)
- [License](https://ldcoolp-figshare.readthedocs.io/en/latest/license.html)
- [API Documentation](https://ldcoolp-figshare.readthedocs.io/en/latest/modules.html)
