# -*- coding: utf-8 -*-
#  Copyright (C) 2020 Rocky Bernstein
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

import os.path as osp

from trepan.processor.command.set import SetCommand as Trepan3kSetCommand

class SetCommand(Trepan3kSetCommand):
    """**set** *set subcommand*

Modifies parts of the debugger environment.

You can give unique prefix of the name of a subcommand to get
information about just that subcommand.

Type `set` for a list of *set* subcommands and what they do.
Type `help set *` for just the list of *set* subcommands.
"""

    category      = 'data'
    min_args      = 0
    max_args      = None
    name          = osp.basename(__file__).split('.')[0]
    need_stack    = False
    short_help    = 'Modify parts of the debugger environment'

    def __init__(self, proc, name="set"):
        """Initialize show subcommands. Note: instance variable name
        has to be setcmds ('set' + 'cmds') for subcommand completion
        to work."""

        super().__init__(proc, name)
        new_cmdlist = []
        for subname in self.cmds.cmdlist:
            if subname in ("dbg_trepan", "events"):
                del self.cmds.subcmds[subname]
            else:
                new_cmdlist.append(subname)
        self.cmds.cmdlist = new_cmdlist
        self._load_debugger_subcommands(name, "trepanxpy")

if __name__ == '__main__':
    from trepan.processor.command import mock
    d, cp = mock.dbg_setup()
    command = SetCommand(cp, 'set')
    command.run(['set'])
    pass
