# Generated by Django 2.2.7 on 2019-11-25 14:28

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='MapBaseLayer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50, unique=True)),
                ('order', models.PositiveSmallIntegerField(default=0)),
                ('slug', models.SlugField(editable=False, unique=True)),
                ('base_layer_type', models.CharField(choices=[('mapbox', 'MapBox'), ('raster', 'Raster'), ('vector', 'Vector')], db_index=True, max_length=25)),
                ('map_box_url', models.CharField(blank=True, max_length=255)),
                ('sprite', models.CharField(blank=True, max_length=255)),
                ('glyphs', models.CharField(blank=True, max_length=255)),
                ('min_zoom', models.PositiveSmallIntegerField(default=0)),
                ('max_zoom', models.PositiveSmallIntegerField(default=22)),
            ],
            options={
                'verbose_name': 'Map base layers',
                'verbose_name_plural': 'Map base layers',
                'ordering': ('order', 'name'),
            },
        ),
        migrations.CreateModel(
            name='BaseLayerTile',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(max_length=255)),
                ('base_layer', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='tiles', to='mapbox_baselayer.MapBaseLayer')),
            ],
        ),
    ]
