# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aiosignald']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'aiosignald',
    'version': '0.3.0a4',
    'description': 'Python bindings for signald',
    'long_description': 'Signald python bindings\n=======================\n\n\n[![pypi](https://badge.fury.io/py/aiosignald.svg)](https://pypi.org/project/aiosignald/)\n[![Documentation Status](https://readthedocs.org/projects/aiosignald/badge/?version=latest)](https://aiosignald.readthedocs.io/en/latest/)\n[![builds.sr.ht status](https://builds.sr.ht/~nicoco/aiosignald/commits/master/.build.yml.svg)](https://builds.sr.ht/~nicoco/aiosignald/commits/master/.build.yml?)\n\nInteract with the signal messaging network in python with sweet, sweet autocompletion.\n\nMost of the code is generated by the `generate.py` script that\nuses the schema available at <https://signald.org/protocol.json>.\n\nNo 3rd party dep, just the python standard lib.\n\nInstall\n-------\n\n`pip install aiosignald`\n\nHave signald running. See [their\ndocs](https://signald.org/articles/install/) about it.\n\nIssue tracker: https://todo.sr.ht/~nicoco/aiosignald\n\nPart of the [slidge project](https://sr.ht/~nicoco/slidge) (but can be used independently)\n\nUsage\n-----\n\n### Example: registration\n\n```py\nimport asyncio\n\nfrom aiosignald import SignaldAPI\nimport aiosignald.generated as api\n\nclass SignalClient(SignaldAPI):\n    async def handle_IncomingMessage(self, msg: api.IncomingMessagev1, _payload):\n        # hook to the incoming event by naming you function handle_EventName\n        # most stuff comes through an IncomingMessage anyway\n        print("Received: ", msg)\n\nasync def main():\n    loop = asyncio.get_running_loop()\n    _, signald = await loop.create_unix_connection(\n        SignaldAPI, path=SIGNALD_SOCKET_PATH)\n    await signald.register(account="+XXXXXX")\n    # Some async code to get the SMS code\n    code = await user_input("Enter your sms code?")\n    await signald.verify(account="+XXXXXX", code=code)\n    # linking to an existing account is also possible\n    # uri = await signald.generate_linking_uri()\n    await signald.on_con_lost\n\n# See https://signald.org/articles/protocol/ for more info about this\nSIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"\n\nasyncio.run(main())\n```\n\nDocs are available on [readthedocs](https://aiosignald.readthedocs.org).\n',
    'author': 'Nicolas Cedilnik',
    'author_email': 'nicoco@nicoco.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://git.sr.ht/~nicoco/aiosignald',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4',
}


setup(**setup_kwargs)
