# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/survey_scenario/modules/calage_sur_marges.ipynb.

# %% auto 0
__all__ = ["LexCalibration"]

# %% ../notebooks/survey_scenario/modules/calage_sur_marges.ipynb 4
import numpy
import pandas as pd
from openfisca_core.model_api import Enum
from openfisca_survey_manager.calibration import Calibration

# from openfisca_survey_manager.calmar import
from .calmar_tools import calmar, check_calmar
from .helpers_survey_scenario import dico_var, individus_to_entity
from .inflation_calibration_values import get_total_population


# %% ../notebooks/survey_scenario/modules/calage_sur_marges.ipynb 7
class LexCalibration(Calibration):
    """An object to calibrate survey data of a SurveySimulation"""

    initial_total_population = None
    initial_weight_name = None
    parameters = {
        "use_proportions": True,
        "initial_weight": None,
        "method": None,  # 'linear', 'raking ratio', 'logit'
        "up": None,
        "lo": None,
    }
    period = None
    survey_scenario = None
    total_population = None
    weight_name = None
    entity = None

    # Ok
    def __init__(self, survey_scenario, period):
        # Non parametrable
        self.entity = "foyer_fiscal"
        self.period = period
        self._set_survey_scenario(survey_scenario)

    # def reset(self):
    #    """Reset the calibration to its initial state"""
    #    simulation = self.scenario.simulation
    #    holder = simulation.get_holder(self.weight_name)
    #    holder.array = numpy.array(self.initial_weight, dtype = holder.variable.dtype)

    # OK
    def _set_survey_scenario(self, survey_scenario):
        """Sets the survey scenario

        Args:
          survey_scenario: the survey scenario
        """
        self.scenario = survey_scenario
        # TODO BenJ deal with baseline if reform is present
        if survey_scenario.simulation is None:
            survey_scenario.simulation = survey_scenario.new_simulation()
        period = self.period
        self.weight_name = self.scenario.weight_variable_by_entity["foyer_fiscal"]
        self.initial_weight_name = self.weight_name + "_ini"
        self.initial_weight = survey_scenario.calculate_variable(
            variable=self.weight_name, period=period
        )
        self.initial_total_population = sum(self.initial_weight)
        self.weight = survey_scenario.calculate_variable(
            variable=self.weight_name, period=period
        )

    # OK
    def calibrate(self, target_margin_by_variable, calmar_parameters):
        """Applies the calibrations by updating weights and margins"""
        # Adding our new margins
        self.set_target_margins(target_margin_by_variable)
        margins_by_variable = self.margins_by_variable
        self.parameters = calmar_parameters
        parameters = self.get_parameters()

        # On ne prend que les 'target' de chaque variable
        if margins_by_variable is not None:
            simple_margins_by_variable = {
                variable: margins_by_type["target"]
                for variable, margins_by_type in margins_by_variable.items()
            }
        else:
            simple_margins_by_variable = dict()

        # On utilise le total de foyers fiscaux de POTE pour recaler la population
        self.total_population = get_total_population(self.period)
        simple_margins_by_variable["total_population"] = self.total_population
        updated_margins = self._update_weights(
            simple_margins_by_variable, parameters=parameters
        )

        # self.set_calibrated_weights()
        self.propagate_weights(self.scenario.simulation)
        self._update_margins()

        # On garde les poids initiaux pour avoir une trace de la calibration
        print(
            "La calibration est finie ! On est passés d'un poids total de ",
            self.initial_weight.sum(),
            " à ",
            self.weight.sum(),
            " avec de nouvelles marges à :",
            updated_margins,
        )

        #

    # def set_parameters(self, parameter, value):
    #    """Sets a parameter value
    #
    #    Args:
    #      parameter: the parameter to be set
    #      value: the value used to set the parameter
    #    """
    #    if parameter == 'lo':
    #        self.parameters['lo'] = 1 / value
    #    else:
    #        self.parameters[parameter] = value
    #

    # def get_parameters(self) -> dict:
    #    """Gets the parameters

    #    Returns:
    #        dict: Parameters
    #    """

    #    p = {}
    #    p['method'] = self.parameters.get('method', 'linear')
    #    if self.parameters.get('invlo') is not None:
    #        p['lo'] = 1 / self.parameters.get('invlo')
    #    p['up'] = self.parameters.get('up')
    #    if p['method'] == 'logit':
    #        assert self.parameters.get('invlo') is not None and self.parameters.get('up') is not None
    #        p['lo'] = 1 / self.parameters.get('invlo')
    #        p['up'] = self.parameters.get('up')
    #    p['use_proportions'] = self.parameters.get('use_proportions', True)
    #    p['initial_weight'] = self.weight_name + ""
    #    return p

    # OK
    def set_target_margins(self, target_margin_by_variable: dict):
        """[summary]

        Args:
            target_margin_by_variable (dict): Targets margins
        """
        for variable, target in target_margin_by_variable.items():
            self.set_target_margin(variable, target)
        self._update_margins()

    # Ok
    def set_target_margin(self, variable, target):
        # Enregistre la marge selon qu'elle soit un nombre ou une variable catégorique
        """Sets variable target margin

        Args:
          variable: Target variable
          target: Target value
        """
        assert variable in self.scenario.tax_benefit_system.variables
        variable_instance = self.scenario.tax_benefit_system.variables[variable]
        target_by_category = None
        categorical_variable = (
            (variable_instance.value_type in [bool, Enum])
            or (variable_instance.unit == "years")
            or (variable_instance.unit == "months")
        )
        if categorical_variable:
            value = self.scenario.calculate_variable(
                variable=variable, period=self.period
            )
            categories = numpy.sort(numpy.unique(value))
            target_by_category = dict(zip(categories, target))

        if not self.margins_by_variable:
            self.margins_by_variable = dict()
        if variable not in self.margins_by_variable:
            self.margins_by_variable[variable] = dict()
        self.margins_by_variable[variable]["target"] = target_by_category or target

    # OK
    # On a bien toutes les marges que l'on set dans `set_target_margins()`, quelles que soient leurs entités
    def _update_margins(self):
        """Updates margins
        Output example: self.margins_by_variable {'rfr': {'target': 713523524000,
                                                'actual': 1347014100000.0,
                                                'initial': 1347014100000.0},
                                            'salaire_de_base': {'target': 950523524000,
                                                              'actual': 0.0,
                                                                  'initial': 0.0},
                                            'retraite_brute': {'target': 1500523524000,
                                            'actual': 637107200000.0,
                                            'initial': 637107200000.0}}
        """
        for variable in self.margins_by_variable:
            assert variable in self.scenario.tax_benefit_system.variables
            column = self.scenario.tax_benefit_system.variables[variable]
            value = self.scenario.calculate_variable(variable, period=self.period)
            # Cas d'une variable catégorique
            margin_items = [
                ("actual", self.weight),
                ("initial", self.initial_weight),
            ]
            if column.value_type in [bool, Enum]:
                margin_items.append(("category", value))
                margins_data_frame = pd.DataFrame.from_items(margin_items)
                margins_data_frame = margins_data_frame.groupby(
                    "category", sort=True
                ).sum()
                margin_by_type = margins_data_frame.to_dict()

            # Là on calcule les marges initiales: il faut aller chercher le poids qui va bien
            # TODO : verifier que les poids de toutes les entités sont bien updatés dans la base_ind post calib
            else:
                var_entity = column.entity.key
                if var_entity == "menage":
                    print(
                        "Attention, les calculs sont faux pour la variable ",
                        variable,
                        " car on ne travaille pas sur les ménages",
                    )
                weight_entity = dico_var[var_entity]["weight"]
                base_ind = self.scenario.create_data_frame_by_entity(
                    variables=self.scenario.used_as_input_variables
                    + [variable, weight_entity],
                    period=self.period,
                    merge=True,
                )

                assert base_ind[variable] is not None
                assert base_ind[weight_entity] is not None

                # Si on a déjà fait le calcul des totaux initiaux
                if "initial" in self.margins_by_variable[variable].keys():
                    init = self.margins_by_variable[variable]["initial"]
                # Sinon, s'il faut calculer les valeurs initiales
                else:
                    init = (base_ind[self.weight_name] * base_ind[variable]).sum()

                margin_by_type = dict(
                    actual=(base_ind[self.weight_name] * base_ind[variable]).sum(),
                    initial=init,
                )
            self.margins_by_variable[variable].update(margin_by_type)

    # Ok
    def _update_weights(self, margins, parameters=None):
        """Runs calmar, stores new weights and returns adjusted margins
        Args:
          margins: margins
          parameters:  Parameters (Default value = {})
        Returns:
            dict: Updated margins
        """
        if parameters is None:
            parameters = dict()
        data = self._build_calmar_data()
        assert self.initial_weight_name is not None
        parameters["initial_weight"] = self.initial_weight_name

        # CALIBRATION SUR MARGES
        val_pondfin, lambdasol, updated_margins = calmar(data, margins, **parameters)
        assert (
            val_pondfin.sum() != 0
        ), "Il n'y a eu aucune modification des poids lors de la calibration"
        # Check
        check_calmar(
            data,
            margins,
            initial_weight="wprm_init",
            pondfin_out=val_pondfin,
            lambdasol=lambdasol,
            margins_new_dict=updated_margins,
        )

        # Poids updatés
        self.weight = val_pondfin
        # Analyse
        print("Apres calibration, on varié les poids d'un total de ", val_pondfin.sum())
        print(
            "La variation est diverse:",
            len(numpy.unique(val_pondfin)),
            "nouveaux poids pour ",
            len(val_pondfin),
            "foyers dans la base",
        )
        return updated_margins

    # OK
    def _build_calmar_data(self) -> pd.DataFrame:
        """Builds the data dictionnary used as calmar input argument

        Returns:
            pd.DataFrame: Data used by calmar
        """

        # Select only filtered entities
        assert self.initial_weight_name is not None

        wprms = [
            "weight_menages",
            "weight_foyers",
            "wprm",
            "wprm_ini",
            "weight_individus",
            "weight_familles",
        ]
        new_variables = [var for var in self.margins_by_variable]
        var_list = self.scenario.used_as_input_variables + new_variables + wprms

        # On calibre sur la base en foyers fiscaux
        base_ind = self.scenario.create_data_frame_by_entity(
            variables=var_list, period=self.period, merge=True
        )
        data = individus_to_entity(
            self.scenario.tax_benefit_system, base_ind, self.entity
        )
        # On ajoute les poids de l'entité voulue
        data[self.initial_weight_name] = self.initial_weight

        for variable in self.margins_by_variable:
            if variable == "total_population":
                continue
            assert variable in self.scenario.tax_benefit_system.variables
            # Pas besoin de calculer les variables mais on verifie qu'elles sont dans notre base
            if variable not in data.keys():
                print(
                    "Attention, il faut calculer et insérer la variable ",
                    variable,
                    " dans la base",
                )
                break
        return data

    # Ok
    def set_calibrated_weights(self):
        """Modify the weights to use the calibrated weights"""
        survey_scenario = self.scenario
        assert survey_scenario.simulation is not None
        for simulation in [
            survey_scenario.simulation,
            survey_scenario.baseline_simulation,
        ]:
            self.propagate_weights(simulation)

    # Ok
    def propagate_weights(self, simulation):
        period = self.period

        # Propagation aux familles et foyers fiscaux
        for wprm in ["weight_foyers", "weight_familles"]:
            simulation.delete_arrays(wprm, period)
            simulation.set_input(wprm, period, self.weight)

        # Propagation aux ménages
        print("Les poids des ménages n'ont plus de sens donc on les supprime")
        wprm_menages = self.scenario.calculate_variable(
            variable="weight_menages", period=period
        ).copy()

        for wprm in ["weight_menages", "wprm"]:
            simulation.delete_arrays(wprm, period)
            simulation.set_input(wprm, period, 0 * wprm_menages)

        # Propagation aux individus
        weight_foyers_en_taille_individu = simulation.individu.foyer_fiscal(
            "weight_foyers", period
        )
        simulation.delete_arrays("weight_foyers", period)
        simulation.set_input(
            "weight_individus", period, weight_foyers_en_taille_individu
        )
