# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ciscoaxl']

package_data = \
{'': ['*'],
 'ciscoaxl': ['schema/10.0/*',
              'schema/10.5/*',
              'schema/11.0/*',
              'schema/11.5/*',
              'schema/12.0/*',
              'schema/12.5/*',
              'schema/8.5/*',
              'schema/9.1/*',
              'schema/current/*']}

install_requires = \
['requests>=2.27.1,<3.0.0', 'zeep>=4.1.0,<5.0.0']

setup_kwargs = {
    'name': 'ciscoaxl',
    'version': '0.2.0',
    'description': 'Cisco CUCM AXL Library. simple to use.',
    'long_description': '# Python SDK for Cisco CUCM AXL API\n[![PyPi Status](https://github.com/PresidioCode/ciscoaxl/actions/workflows/python-publish.yml/badge.svg?event=deployment_status)](https://github.com/PresidioCode/ciscoaxl/actions/workflows/python-publish.yml)\n\n## AXL API Documentation\n\n- https://developer.cisco.com/docs/axl-schema-reference/\n\n## Installation\n\n```bash\npip install ciscoaxl\n```\n\n`testing in a lab is highly recommended. if you don\'t have a lab of your own, you can reserve a DevNet Sandbox free of charge!`\n\n## Reserve a DevNet Sandbox (if required)\n\nThe\tDevNet\tSandbox\tis\taccessible\t through\tCisco\tDevNet\tat\thttp://developer.cisco.com\n\nSelect\tCollaboration\ton\tthe\tright\thand category menu\tand\tthen look\tfor\tthe\t“Collaboration\t12.5”\ttile.\t\nHit\treserve.\n\nTo connect to the lab, you\'ll need to use VPN.\n\nVPN Credentials will be sent to your DevNet registered email account, or you can view the _OUTPUT_ from the topology page. \n\nOnce connected, you can click on the server, in this case CUCM, and select _ATTRIBUTES_ to find username, password, and hostname / ip address.\n\n\n___\n\n\n## Enable AXL SOAP Service on CUCM:\n\nEnable the AXL SOAP interface\n\nBrowse to the CUCM Serviceability page on https://<IP_CUCM>/ccmservice\n\nTools > Service Activation:\n\nEnable the "Cisco AXL Web Service"\n\n![](docs/2020-06-01-11-13-59.png)\n\n---\n\n## Create an AXL Service Account\n\n> Step 1 - Create an AXL User Group\n\nCUCM > User Management > User Group > Add.\n\n> Step 2 - Assign the AXL role to the group\n\nOn the top right drop down list "Related Links". \n\n\nSelect "Assign Role to User Group" and select "Standard AXL API Access"\n\n![](docs/2020-06-01-11-29-06.png)\n\n\n> Step 3 - Create a new Application User\n\nCUCM > User Management > Application User > Add.\n\n![](docs/2020-06-01-11-33-25.png)\n\nAdd the User Group "AXL Group" to this user so that after saving the roles of the new Application User appear as in the following screen:\n\n![](docs/2020-06-01-11-43-34.png)\n\n\n## SDK Usage \n\n```python\nfrom ciscoaxl import axl\n\ncucm = \'10.10.20.1\'\nusername = \'axlaccess\'\npassword = \'axlpassword\'\nversion = \'12.5\'\nucm = axl(username=cucm_username,password=cucm_password,cucm=cucm,cucm_version=version)\n```\n\n> Note: all get methods that return more than 1 item have a tagfilter property that can allow more fields to return. Fields are filtered by default to increase performance, but if you need additional fields returned from the axl call, simply add the tagfilter={} to the request. Example:\n\n```python\nget_phones(tagfilter={ "name": "",\n            "product": "",\n            "description": "",\n            "protocol": "",\n            "locationName": "",\n            "callingSearchSpaceName": "",\n            "devicePoolName": ""\n        })\n```\n\n## Users\n\n#### Get All Users\n\n```python\nfor user in ucm.get_users():\n    print(user.firstName)\n```\n\n#### Get Specific User\n\n```python\nuser = ucm.get_user(user_id=\'mscott\')\nprint(user.email)\n```\n\n#### Add User\n\n```python\nucm.add_user(user_id=\'jlevensailor\', last_name=\'Levensailor\', first_name=\'Jeff\')\n```\n\n#### Delete User\n\n```python\nucm.delete_user(user_id=\'jlevensailor\')\n```\n\n#### Update User\n\n```python\nucm.update_user(user_id=\'jlevensailor\', password=\'Lagavulin16\', pin=\'5432\')\n```\n\n## Phones\n\n#### Get Phones\n\n```python\nfor phone in ucm.get_phones():\n    print(phone.name)\n```\n\n#### Get Specific Phone\n\n```python\nphone = ucm.get_phone(name=\'SEP001122445566\')\nprint(phone.name)\n```\n\n#### Add Phone\n\n```python\nucm.add_phone(\n    name=\'SEP0023AF482340\',\n    description=\'Robert - 1102\',\n    product=\'Cisco 8861\',\n    device_pool=\'RTP_DP\',\n    location=\'RTP_LOC\',\n    phone_template=\'Standard 8861 SIP\',\n    protocol=\'SIP\',\n    css=\'AVST-CSS\',\n    subscribe_css=\'AVST-CSS\',\n    lines=[\n        (\'1102\', \'ABQ_PT\', \'Robert Smith\', \'Robert Smith\', \'Robert Smith - 1102\', \'+1408202XXXX\')\n    ]\n)\n```\n\n#### Delete Phone\n\n```python\nucm.delete_phone(name=\'SEP004433220043\')\n```\n\n## Translations and Transformations\n\n#### Get Translation Patterns\n\n```python\nfor trans in ucm.get_translations():\n    detailed = ucm.get_translation(uuid=trans.uuid)\n    print(detailed.description)\n```\n\n#### Get Specific Translation Pattern\n\n```python\ntrans = ucm.get_translation(pattern=\'2XXX\', routePartitionName=\'xlates-pt\')\nprint(trans.description)\n```\n\n#### Add Translation Pattern\n\n```python\nported = [\'12324625544\', \'12324625545\', \'12324625546\']\n\nfor num in ported:\n    ucm.add_translation(pattern=num, routePartitionName=\'pstn_pt\',calledPartyTransformationMask=\'1102\', callingSearchSpaceName=\'GW_CSS\')\n```\n\n#### Delete Translation Pattern\n\n```python\nucm.delete_translation(pattern=\'34567\', routePartitionName=\'xlates-pt\')\n```\n\n#### Update Translation Pattern\n\n```python\nucm.update_translation(pattern=\'1234\', routePartitionName=\'xlates-pt\', newPattern=\'4567\')\n```\n\n## Device Pools\n\n#### Get Device Pools\n\n```python\nfor dp in ucm.get_device_pools():\n    print(dp.name)\n```\n\n#### Get Specific Device Pool\n\n```python\ndp = ucm.get_device_pool(name=\'RTP_DP\')\nprint(dp.name)\n```\n\n#### Add Device Pool\n\n```python\nucm.add_device_pool(device_pool=\'Hollywood_DP\')\n```\n\n#### Delete Device Pool\n\n```python\nucm.delete_device_pool(device_pool=\'Hollywood_DP\')\n```\n\n#### Update Device Pool\n\n```python\nucm.update_device_pool(name=\'RTP_DP\', regionName=\'G711_RGN\')\n```\n\n## CSS and Partitions\n\n#### Get Calling Search Spaces\n\n```python\nfor css in ucm.get_calling_search_spaces():\n    print(css.name)\n```\n\n#### Get Specific Calling Search Space\n\n```python\ncss = ucm.get_calling_search_space(calling_search_space=\'pstn-css\')\nprint(css.name)\n```\n\n#### Add Calling Search Space\n\n```python\nucm.add_calling_search_space(\n    calling_search_space=\'VIP_CSS\',\n    description=\'Very Important Stuff\'\n    members=[\'losfeliz-pt\',\'silverlake-pt\',\'pstn-pt\']\n    )\n```\n\n#### Delete Calling Search Space\n\n```python\nucm.update_calling_search_space(calling_search_space=\'VIP_CSS\')\n```\n\n#### Delete Calling Search Space\n\n```python\nucm.delete_calling_search_space(calling_search_space=\'VIP_CSS\')\n```\n\n#### Get Partitions\n\n```python\nfor pt in ucm.get_partitions():\n    print(pt.name)\n```\n\n#### Get Specific Partition\n\n```python\npt = ucm.get_partition(routePartitionName=\'pstn-pt\')\nprint(pt.name)\n```\n\n#### Add Partition\n\n```python\nucm.add_partition(routePartitionName=\'VIP_PT\', description=\'Very Important Peep\')\n```\n\n#### Delete Partition\n\n```python\nucm.delete_partition(name=\'VIP_PT\')\n```\n\n## Regions and Locations\n\n#### Get Regions\n\n```python\nfor reg in ucm.get_regions():\n    print(reg.uuid)\n```\n\n#### Get Specific Region\n\n```python\nreg = ucm.get_region(region=\'losfeliz_reg\')\nprint(reg.name)\n```\n\n#### Add Region\n\n```python\nucm.add_region(region=\'Hollywood-REG\')\n```\n\n#### Delete Region\n\n```python\nucm.delete_region(region=\'Hollywood-REG\')\n```\n\n#### Get Locations\n\n```python\nfor loc in ucm.get_locations():\n    print(loc.name)\n```\n\n#### Get Specific Location\n\n```python\nloc = ucm.get_location(name=\'Shadow\')\nprint(loc.name)\n```\n\n#### Add Location\n\n```python\nucm.add_location(location=\'Hollywood-LOC\')\n```\n\n#### Delete Location\n\n```python\nucm.delete_location(location=\'Hollywood-LOC\')\n```\n\n## Directory Numbers\n\n#### Get Directory Numbers\n\n```python\nfor dn in ucm.get_directory_numbers():\n    print(dn.uuid)\n```\n\n#### Get Specific Directory Number\n\n```python\ndn = ucm.get_directory_number(directory_number=\'2888\',routePartitionName=\'losfeliz-pt\')\nprint(dn.uuid)\n```\n\n#### Add Directory Number\n\n```python\nucm.add_directory_number(\n    pattern=\'1102\',\n    routePartitionName=\'ABQ_PT\'\n    )\n```\n\n#### Delete Directory Number\n\n```python\nucm.delete_directory_number(uuid=\'{0B0CDC93-EC9C-7255-1B09-40A3CE727D5A}\')\n```\n\n## Device Profiles\n\n#### Get User Device Profiles\n\n```python\nfor udp in ucm.get_device_profiles():\n    print(udp.name)\n```\n\n#### Get Specific User Device Profile\n\n```python\nudp = ucm.get_device_profile(name=\'udp-bsimpson\')\nprint(udp.name)\n```\n\n#### Add User Device Profile\n\n```python\nucm.add_device_profile(\n    name=\'UDP_MScott\',\n    description=\'Michael Scott - 2901\',\n    product=\'Cisco 8861\',\n    phone_template=\'Standard 8861 SIP\',\n    protocol=\'SIP\',\n    lines=[\n        (\'2901\', \'losfeliz-pt\', \'Michael Scott\', \'Michael Scott\', \'Michael Scott - 2901\', \'+1408202XXXX\'),\n        (\'2902\', \'losfeliz-pt\', \'Pam Beesley\', \'Pam Beesley\', \'Pam Beesley - 2902\', \'+1408202XXXX\')\n    ]\n)\n```\n\n#### Delete User Device Profile\n\n```python\nucm.delete_device_profile(\'UDP_Mscott\')\n```\n\n## CTI Route Points\n\n#### Get CTI Route Points\n\n```python\nfor cti in ucm.get_cti_route_points():\n    print(cti.name)\n```\n\n#### Get Specific CTI Route Point\n\n```python\ncti = ucm.get_cti_route_point(cti_route_point=\'AutoAttendant\')\nprint(cti.name)\n```\n\n#### Add CTI Route Point\n\n```python\nucm.add_cti_route_point(\n    cti_route_point=\'aa-pilot\',\n    description=\'pilot to unity\',\n    device_pool=\'LosFeliz_DP\',\n    css=\'allphone-css\',\n    lines=[\n        (\'2908\', \'losfeliz-pt\'),\n        (\'2909\', \'losfeliz-pt\')\n    ]\n)\n```\n\n#### Delete CTI Route Point\n\n```python\nucm.delete_cti_route_point(name=\'OneArch\')\n```\n\n## Route Groups, Lists, and Patterns\n\n#### List Route Plan\n\n```python\nnums = [\'19197016707\', \'19197016712\', \'19197016713\', \'19197016706\', \'191970167016\']\n\nfor num in nums:\n    for route in ucm.list_route_plan(num):\n        print(route.dnOrPattern)\nfor route in ucm.list_route_plan(\'2901\'):\n    print(route.uuid)\n```\n\n#### Get Route Groups\n\n```python\nfor rg in ucm.get_route_groups():\n    print(rg.name)\n```\n\n#### Get Specific Route Group\n\n```python\nrg = ucm.get_route_group(route_group=\'losfeliz-rg\')\nprint(rg.uuid)\n```\n\n#### Add Route Group\n\n```python\nucm.add_route_group(\n    route_group=\'hollywood-rg\',\n    distribution_algorithm=\'Circular\',\n    members=[(\'america-online-sip\'), (\'h323\')])\n```\n\n#### Delete Route Group\n\n```python\nucm.delete_route_group(route_group=\'hollywood-rg\')\n```\n\n#### Get Route Lists\n\n```python\nfor rl in ucm.get_route_lists():\n    print(rl.name)\n```\n\n#### Get Specific Route List\n\n```python\nrl = ucm.get_route_list(route_list=\'stdloc-rl\')\nprint(rl.description)\n```\n\n#### Add Route List\n\n```python\nucm.add_route_list(\n    route_list=\'hollywood-rl\',\n    description=\'hollywood\',\n    run_on_all_nodes=\'true\',\n    cm_group_name=\'Default\',\n    members=[\n        (\'losfeliz-rg\'),\n        (\'silverlake-rg\')\n    ])\n```\n\n#### Delete Route List\n\n```python\nucm.delete_route_list(route_list=\'hollywood-rl\')\n```\n\n#### Get Route Patterns\n\n```python\nfor rp in ucm.get_route_patterns():\n    print(rp.pattern)\n```\n\n#### Get Specific Route Pattern\n\n```python\nrp = ucm.get_route_pattern(pattern=\'911\')\nprint(rp.description)\n```\n\n#### Add Route Pattern\n\n```python\nucm.add_route_pattern(\n    pattern=\'999\',\n    routePartitionName=\'losfeliz-pt\',\n    description=\'Movie Times\',\n    route_list=\'stdloc-rl\'\n    )\n```\n\n#### Delete Route Pattern\n\n```python\nucm.delete_route_pattern(pattern=\'999\', routePartitionName=\'losfeliz-pt\')\n```\n\n## Runs and Dos\n\n#### Execute SQL Query\n\n```sh\nfor sql in ucm.execute_sql_query(\'select * from device where description like "Bart%"\'):\n    print(sql.name)\n```\n\n#### Do LDAP Sync on all agreements\n\n```sh\nfor ldap in ucm.get_ldap_dir():\n    ucm.do_ldap_sync(uuid=ldap.uuid)\n```\n\n#### Reset Device\n\n```python\nucm.do_device_reset(device=\'SEP001100220033\')\n```\n\n#### Extension Mobility Login\n\n```python\nucm.do_device_login(device=\'SEP001100220033\', userId=\'bsimpson\')\n```\n\n#### Extension Mobility Logout\n\n```python\nucm.do_device_logout(device=\'SEP001100220033\', userId=\'bsimpson\')\n```\n',
    'author': 'Jeff Levensailor',
    'author_email': 'jeff@levensailor.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/levensailor/ciscoaxl',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
