"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobDefinitionImageConfig = void 0;
const ecs = require("aws-cdk-lib/aws-ecs");
const iam = require("aws-cdk-lib/aws-iam");
/**
 * Batch Job Task Definition
 *
 * Defines a Batch Job Task Definition. The properties of this task definition mirrors
 * those of an {@link ecs.ContainerDefinition}. This class is a wrapper on that structure.
 */
class TaskDefinition {
    constructor(props) {
        this.executionRole = props.executionRole;
    }
    /**
     * Internal function to allow the Batch Job task definition
     * to match the CDK requirements of an EC2 task definition.
     *
     * @internal
     */
    _linkContainer() { }
    /**
     * Retrieves the execution role for this task definition
     */
    obtainExecutionRole() {
        return this.executionRole;
    }
}
/**
 * The configuration for creating a batch container image.
 */
class JobDefinitionImageConfig {
    constructor(scope, container) {
        const config = this.bindImageConfig(scope, container);
        this.imageName = config.imageName;
    }
    bindImageConfig(scope, container) {
        return container.image.bind(scope, new ecs.ContainerDefinition(scope, 'Resource-Batch-Job-Container-Definition', {
            command: container.command,
            cpu: container.vcpus,
            image: container.image,
            environment: container.environment,
            linuxParameters: container.linuxParams,
            memoryLimitMiB: container.memoryLimitMiB,
            privileged: container.privileged,
            readonlyRootFilesystem: container.readOnly,
            gpuCount: container.gpuCount,
            user: container.user,
            taskDefinition: new TaskDefinition({
                executionRole: container.jobRole || new iam.LazyRole(scope, 'Resource-Batch-Task-Definition-Role', {
                    assumedBy: new iam.ServicePrincipal('batch.amazonaws.com'),
                }),
            }),
        }));
    }
}
exports.JobDefinitionImageConfig = JobDefinitionImageConfig;
//# sourceMappingURL=data:application/json;base64,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