# coding=utf-8
# *** WARNING: this file was generated by pulumigen. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import errno
from setuptools import setup, find_packages
from setuptools.command.install import install
from subprocess import check_call


VERSION = "0.1.8"
PLUGIN_VERSION = "0.1.8"

class InstallPluginCommand(install):
    def run(self):
        install.run(self)
        try:
            check_call(['pulumi', 'plugin', 'install', 'resource', 'k0s', PLUGIN_VERSION, '--server', 'https://repo.ydkn.io/pulumi-k0s'])
        except OSError as error:
            if error.errno == errno.ENOENT:
                print(f"""
                There was an error installing the k0s resource provider plugin.
                It looks like `pulumi` is not installed on your system.
                Please visit https://pulumi.com/ to install the Pulumi CLI.
                You may try manually installing the plugin by running
                `pulumi plugin install resource k0s {PLUGIN_VERSION}`
                """)
            else:
                raise


def readme():
    try:
        with open('README.md', encoding='utf-8') as f:
            return f.read()
    except FileNotFoundError:
        return "k0s Pulumi Package - Development Version"


setup(name='pulumi_k0s',
      version=VERSION,
      description="A Pulumi package for creating and managing k0s clusters.",
      long_description=readme(),
      long_description_content_type='text/markdown',
      cmdclass={
          'install': InstallPluginCommand,
      },
      keywords='pulumi k0s',
      url='https://github.com/ydkn/pulumi-k0s',
      project_urls={
          'Repository': 'https://github.com/ydkn/pulumi-k0s'
      },
      license='Apache-2.0',
      packages=find_packages(),
      package_data={
          'pulumi_k0s': [
              'py.typed',
              'pulumi-plugin.json',
          ]
      },
      install_requires=[
          'parver>=0.2.1',
          'pulumi>=3.0.0,<4.0.0',
          'semver>=2.8.1'
      ],
      zip_safe=False)
