import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Retrieves or creates projects in any given Atlas organization.
 *
 * @schema CfnProjectProps
 */
export interface CfnProjectProps {
    /**
     * Name of the project to create.
     *
     * @schema CfnProjectProps#Name
     */
    readonly name: string;
    /**
     * Unique identifier of the organization within which to create the project.
     *
     * @schema CfnProjectProps#OrgId
     */
    readonly orgId: string;
    /**
     * @schema CfnProjectProps#ApiKeys
     */
    readonly apiKeys?: ApiKeyDefinition;
}
/**
 * Converts an object of type 'CfnProjectProps' to JSON representation.
 */
export declare function toJson_CfnProjectProps(obj: CfnProjectProps | undefined): Record<string, any> | undefined;
/**
 * @schema apiKeyDefinition
 */
export interface ApiKeyDefinition {
    /**
     * @schema apiKeyDefinition#PublicKey
     */
    readonly publicKey?: string;
    /**
     * @schema apiKeyDefinition#PrivateKey
     */
    readonly privateKey?: string;
}
/**
 * Converts an object of type 'ApiKeyDefinition' to JSON representation.
 */
export declare function toJson_ApiKeyDefinition(obj: ApiKeyDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `MongoDB::Atlas::Project`
 *
 * @cloudformationResource MongoDB::Atlas::Project
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnProject extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "MongoDB::Atlas::Project";
    /**
     * Resource props.
     */
    readonly props: CfnProjectProps;
    /**
     * Attribute `MongoDB::Atlas::Project.Id`
     * @link http://unknown-url
     */
    readonly attrId: string;
    /**
     * Attribute `MongoDB::Atlas::Project.Created`
     * @link http://unknown-url
     */
    readonly attrCreated: string;
    /**
     * Attribute `MongoDB::Atlas::Project.ClusterCount`
     * @link http://unknown-url
     */
    readonly attrClusterCount: number;
    /**
     * Create a new `MongoDB::Atlas::Project`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnProjectProps);
}
