
# from base_logger import logging
# from Config import Config

from bomancli.base_logger import logging
from bomancli.Config import Config

import requests
# import loc_finder as loc
from bomancli import loc_finder as loc
import os 
import subprocess
import json
import xmltodict
 
 
docker = Config.docker_client


##fucntion to check the docker image is already present or not
def checkImageAlreadyExsist(imagename):
    #print(imagename)
    try:
        
        image_list = docker.images.list()
        logging.info('Checking the scanner image (%s) locally',imagename)  
    except Exception as e:
        logging.error('Docker throwing a error , please check the docker installation')
        #print(str(e))
        exit(-1)

    for image in image_list:
       #print(image.tags)
        if imagename in image.tags:
            logging.info('Image is already in the local machine')
            return True
    
    logging.info('Image is not present in the local machine')
    logging.info('Pulling the required image [%s]',imagename)

    try:
        pulled = docker.images.pull(imagename)
        return 1
    except:
        logging.error('Error pulling the image [%s]',imagename)
        exit(-1)

            


### fucntion to check the git is present or not
def isGitDirectory(path):
    try:
        return subprocess.call(['git', '-C', path, 'status'], stderr=subprocess.STDOUT, stdout = open(os.devnull, 'w')) == 0
    except:
        return 0

    




### fucntion to test SaaS server, whether is up or not:
def testServer():
    logging.info('Testing Boman.ai Server')
    url = Config.boman_url+"/api/app/ping"
    try:
        x = requests.get(url)  #var ="renga"
    except requests.ConnectionError as e:
        print(e)
        logging.error("Can't connect to the Server, Please check your Internet connection.")
    else:
        if str(x.content):
            logging.info("Server is reachable ")
            return 1
        else:
            logging.error("Boman.ai Server is not reachable")	
            exit(-1)



### function to check docker is available in the machine or not -- MM
def testDockerAvailable():
    logging.info('Checking for docker in the machine')
    try:
        
        if docker.ping():
           logging.info('Docker is running in the machine. Good to go!')
        else:
            logging.error('Unable to connect to docker, Please install docker in your environment')    
    except Exception as e:
        logging.error('Docker not found in your machine, Please install docker to continue the scanning')
        #print(str(e))
        exit(-1)



### function to test the dast url is accesible or not --- MM


def testDastUrl(url):
    logging.info('Testing %s target', url)
    #url = Config.boman_url+"/api/app/ping"
    #print(url)
    try:
        x = requests.get(url)
    except requests.ConnectionError:
        logging.error("Can't connect to the %s, Please check your Internet connection.", url)
        return 0
    else:
        logging.info("DAST target is reachable")
        return 1
        # if x.status_code == 200:
           
        #     return 1
        # else:
        #     logging.error("Boman.ai Server is not reachable")	
        #     exit(-1)




### fucntion to get the loc in given directory and lang

def getLoc(build_dir,lang):

    lang_extensions = {
        'nodejs':'.js',
        'python':'.py',
        'php':'.php',
        'ruby':'.rb',
        'go':'.go',
        'java':'.java'
    }

    #print(lang_extensions['js'])

    logging.info('Counting the lines of code of the given language. Found: %s',build_dir)
    return loc.countlines(build_dir,extentsion=lang_extensions[lang])


## this function will mask the middle charecters depending on the lenght of given value and return -- used in trufflehog -- MM
def masker(n):
    var1 = str(n)
    str_length = len(n)

    if str_length > 15:
        total_unmask_char_len = 8
        prefix_char_len = 4
        sufix_char_len = 4
    elif str_length < 10:
        total_unmask_char_len = 4
        prefix_char_len = 2
        sufix_char_len = 2
    elif str_length < 5:
        total_unmask_char_len = 2
        prefix_char_len = 1
        sufix_char_len = 1
    elif str_length < 3:
        masked = '#' * str_length
        return masked

    unmasked_len = str_length - total_unmask_char_len
    masked_value = '#' * unmasked_len

    prefix = var1[:prefix_char_len]

    sufix = var1[-sufix_char_len:]

    masked = prefix+masked_value+sufix
    return masked



def convertXmlToJson(file_name,path,output_file):
    
    # open the input xml file and read
    # data in form of python dictionary
    # using xmltodict module
    target = path+file_name
    output_target = path+output_file

    try:
        with open(target) as xml_file:
            
            data_dict = xmltodict.parse(xml_file.read())
            xml_file.close()
            
            # generate the object using json.dumps()
            # corresponding to json data
            
            json_data = json.dumps(data_dict)
            
            # Write the json data to output
            # json file
            with open(output_target, "w") as json_file:
                json_file.write(json_data)
                json_file.close()
            return 1

    except Exception as e:
        return 0

