# Python SDK for Metaloop platform
Metaloop Python SDK is a python library to access [Metaloop](http://data.deepglint.com/)
and manage your datasets.
It provides:

-   A pythonic way to access your Metaloop resources by Metaloop OpenAPI [api](http://data.deepglint.com/api/v1/docs/).


## Installation

```console
pip install metaloop-python-sdk
```

## Documentation

More information can be found on the [examples](https://gitlab.deepglint.com/metaloop/metaloop-python-sdk/-/tree/dev/metaloop/examples)

## Usage
生成API Token
```
  在登录平台后，在浏览器中访问 http://192.168.100.71:30301/api/v1/api_token 即可获取本用户的token
```
操作数据集
```python
import time

from metaloop.client import MDS


if __name__ == '__main__':
    mds_client = MDS("0c02ca70e142b75a75ca4118ce33dbb0", "http://192.168.100.71:30301")

    date_time = time.strftime("%Y%m%d%H%M%S", time.localtime())
    dataset_name = f"test_dataset_{date_time}"

    # create dataset
    dataset = mds_client.create_dataset(
        dataset_name,
        "image",
        ["screw"],
        comment="this is a test dataset for mds"
    )
    dataset.summary()

    # create version
    dataset.create_version(comment="this is a test version for mds")
    dataset.summary()

    # switch version
    dataset.checkout(0)
    dataset.summary()

    # delete version
    dataset.delete_version(0)
    dataset.summary()

    # delete dataset
    mds_client.delete_dataset(dataset_name)
    dataset.summary()

```

## Development
@zizhenyan 获取pypi账号信息