# Generated by Django 3.2.16 on 2022-11-16 10:48

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="OpenidUser",
            fields=[
                (
                    "sub",
                    models.CharField(
                        help_text="subject identifier of this user (userid)",
                        max_length=255,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "_id_token",
                    models.TextField(
                        help_text="json representation of the most current id token"
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="openid",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="OpenidSession",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sid",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        help_text="session id",
                        max_length=256,
                    ),
                ),
                ("scope", models.CharField(max_length=256)),
                ("access_token", models.TextField()),
                ("access_token_expiry", models.DateTimeField(null=True)),
                ("refresh_token", models.TextField(blank=True)),
                ("refresh_token_expiry", models.DateTimeField(null=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sessions",
                        to="simple_openid_connect_django.openiduser",
                    ),
                ),
            ],
        ),
    ]
