import { ReactWidget, UseSignal } from '@jupyterlab/apputils';
import { TextItem } from '@jupyterlab/statusbar';
import * as React from 'react';
const ProjectComponent = (props) => {
    return (React.createElement(UseSignal, { signal: props.manager.projectChanged }, (_, project) => project ? (React.createElement(TextItem, { source: project.name, title: `Active project: ${project.path}` })) : null));
};
export function createProjectStatus(props) {
    return ReactWidget.create(React.createElement(ProjectComponent, Object.assign({}, props)));
}
