/*
 * Copyright (C) 2006-2012 by Benedict Paten (benedictpaten@gmail.com)
 *
 * Released under the MIT license, see LICENSE.txt
 */

#ifndef BIOIOC_H_
#define BIOIOC_H_

#include "commonC.h"

#ifdef __cplusplus
extern "C" {
#endif

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//integer reader / writer
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

void readIntegers(FILE *file, int64_t intNumber, int64_t *iA);

void writeIntegers(FILE *file, int64_t intNumber, int64_t *iA);

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//float reader / writer
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

void readDoubles(const char *string, int64_t intNumber, double *dA);


/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//fasta reader/writer
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

char *fastaNormaliseHeader(const char *fastaHeader);

stList *fastaDecodeHeader(const char *fastaHeader);

char *fastaEncodeHeader(stList *attributes);

void fastaRead(FILE *fastaFile, struct List *seqs, struct List *seqLengths, struct List *fastaNames);

void fastaReadToFunction(FILE *fastaFile, void *destination, void (*addSeq)(void *destination, const char *name, const char *seq, int64_t length));

void fastaRead_readToMapFunction(void *fastaRead_map, const char *fastaHeader, const char *sequence, int64_t length);

stHash *fastaReadToMap(FILE *fastaFile);

void fastaWrite(char *sequence, char *header, FILE *file);

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//read in multi fasta file, and turn into a column alignment
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

struct CharColumnAlignment {
    int64_t columnNo;
    int64_t seqNo;
    char *columnAlignment;
};

char *charColumnAlignment_getColumn(struct CharColumnAlignment *charColumnAlignment, int64_t col);

void destructCharColumnAlignment(struct CharColumnAlignment *charColumnAlignment);

struct CharColumnAlignment *multiFastaRead(char *fastaFile);

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//newick tree parser
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

struct BinaryTree *newickTreeParser(char *newickTreeString, float defaultDistance, int64_t unaryNodes);

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//useful sscanf functions
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

char *eatWhiteSpace(char *string);

int64_t parseInt(char **string, int64_t *j);

int64_t parseFloat(char **string, float *j);

int64_t parseString(char **string, char *cA);

/* 
 * Substitute the string "replacement" for every instance of the character "old" in string "oldString"
 *   Note: Using the variable replacement instead of new to avoid C++ conflicts
 */
char *replaceString(char *oldString, char old, char *replacement, int64_t newLength);

/* 
 * Substitute the string "replacement" for every instance of the character "old" in string "oldString" 
 *   and free oldString.
 *   Note: Using the variable replacement instead of new to avoid C++ conflicts
 */
char *replaceAndFreeString(char *oldString, char old, char *replacement, int64_t newLength);

/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
//Get line function, while getline is not in unix.
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////

int64_t benLine(char **s, int64_t *n, FILE *f);

#ifdef __cplusplus
}
#endif
#endif /*BIOIOC_H_*/
