// Copyright (c) JupyterLite Contributors
// Distributed under the terms of the Modified BSD License.

import {
  JupyterLiteServer,
  JupyterLiteServerPlugin
} from '@jupyterlite/server';

import { IKernel, IKernelSpecs } from '@jupyterlite/kernel';

import { EchoKernel } from './kernel';

/**
 * A plugin to register the echo kernel.
 */
const kernel: JupyterLiteServerPlugin<void> = {
  id: '@jupyterlite/echo-kernel:kernel',
  autoStart: true,
  requires: [IKernelSpecs],
  activate: (app: JupyterLiteServer, kernelspecs: IKernelSpecs) => {
    kernelspecs.register({
      spec: {
        name: 'echo',
        display_name: 'Echo',
        language: 'text',
        argv: [],
        spec: {
          argv: [],
          env: {},
          display_name: 'Echo',
          language: 'text',
          interrupt_mode: 'message',
          metadata: {}
        },
        resources: {
          'logo-32x32': '',
          'logo-64x64': ''
        }
      },
      create: async (options: IKernel.IOptions): Promise<IKernel> => {
        return new EchoKernel(options);
      }
    });
  }
};

const plugins: JupyterLiteServerPlugin<any>[] = [kernel];

export default plugins;
