# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nornir_hier_config',
 'nornir_hier_config.plugins.tasks',
 'nornir_hier_config.utilities']

package_data = \
{'': ['*']}

install_requires = \
['deepdiff>=5.6.0,<6.0.0']

setup_kwargs = {
    'name': 'nornir-hier-config',
    'version': '0.1.0',
    'description': 'Collection of tasks using the hier-config module.',
    'long_description': '# Nornir Hier Config\n\n[![codecov](https://codecov.io/gh/h4ndzdatm0ld/nornir_hier_config/branch/develop/graph/badge.svg?token=C8QDR45SJQ)](https://codecov.io/gh/h4ndzdatm0ld/nornir_hier_config)\n[![Develop](https://github.com/h4ndzdatm0ld/nornir_hier_config/actions/workflows/ci.yml/badge.svg)](https://github.com/h4ndzdatm0ld/nornir_hier_config/actions/workflows/ci.yml/badge.svg)\n\n## Documentation\n\n[Documentation](https://h4ndzdatm0ld.github.io/nornir_hier_config/index.html) is self-generated from `develop` branch and is hosted with Github Pages.\n\n### Hier Config\n\n[Hier Config](https://github.com/netdevops/hier_config) is a python library to build remediation steps in CLI format after evaluating a running configuration to an intended configuration.\n\n[Hier Config Documentation](https://netdevops.io/hier_config/) How to & general information.\n\n## Installation\n\nIn order to use this Nornir Plugin, you will additionally need to install hier-config library from Pypi.\n\n```bash\npip install hier-config\n```\n&\n```bash\npip install nornir_hier_config\n```\n\n### Tasks\n\n- `remediation` - Task available to use with Nornir to generate a remediation config.\n\n## Examples\n\nBelow is an example of using the remediation task. A running_config, generated_config and remediation_config (file path to save remediation) are required args. The options, tags, include & exclude tags are able to be passed in as a path to a YAML file or can be set from Group Vars. Precedence to a YAML file is given if both options are present.\n\nIf you would like to see a few more examples, please head over to the `tests` directory and review the integration tests.\n\nSnippet:\n\n```python\n    nr = nornir.filter(name="PHX-01-69")\n\n    result = nr.run(\n        remediation,\n        running_config="running_config.txt",\n        generated_config="intended_config.txt",\n        remediation_config="remediation_config-no-ntp.txt",\n        options="ios_options.yml",\n        tags="ios_tags.yml",\n        exclude_tags=["ntp"],\n    )\n```\n\n### Group Vars\n\nUnlike the Ansible collection which takes advantage of roles, the Nornir tasks uses Group Vars as the backup choice location if no YAML file is provided for several args. Lets take a look at our directory structure:\n\n```bash\ninventory_data\n├── defaults.yml\n├── groups.yml\n└── hosts.yml\n\n0 directories, 3 files\n```\n\n**Below is an example of two hosts, using two different groups: `iosxr` and `ios`.**\n\nNOTE:\nAny keys to be accessed from group vars must be under the `data` key and should map to the following:\n\n```text\nhier_options [Dict] - Hier Config Options for device platform\n\nhier_tags [Dict] - Hier Config Tags for device platform\n\nhier_include_tags [List] - Hier Config Include Tags for remediation output\n\nhier_exclude_tags [List] - Hier Config Exclude Tags for remediation output\n```\n\n<details>\n  <summary> Click to Expand! </summary>\n\n```yaml\n---\niosxr:\n  username: "netconf"\n  password: "NCadmin123"\n  port: 830\n  platform: "iosxr"\n  data:\n    hier_options:\n      # Indicates the style of the configuration\n      style: "iosxr"\n      ordering:\n        - lineage:\n            - startswith: "no ipv4 access-list"\n          order: 400\n        - lineage:\n            - startswith: "router bgp"\n            - startswith: "no neighbor"\n          order: 600\n        - lineage:\n            - startswith: "router bgp"\n            - startswith: "address-family"\n            - startswith: "no neighbor"\n          order: 600\n\n      # if there is a delta, overwrite these parents instead of one of their children\n      sectional_overwrite: []\n      # - lineage:\n      #  - re_search: ^((ip|ipv4|ipv6) )?access-list\n\n      sectional_overwrite_no_negate:\n        - lineage:\n            - startswith: "as-path-set"\n        - lineage:\n            - startswith: "prefix-set"\n        - lineage:\n            - startswith: "route-policy"\n        - lineage:\n            - startswith: "extcommunity-set"\n        - lineage:\n            - startswith: "community-set"\n\n      parent_allows_duplicate_child: []\n      # - lineage:\n      #  - startswith: route-policy\n\n      sectional_exiting:\n        - lineage:\n            - startswith: "router bgp"\n            - startswith: "address-family"\n          exit_text: "exit-address-family"\n\n      # adds +1 indent to lines following start_expression and removes the +1 indent for lines following end_expression\n      indent_adjust: []\n      # - start_expression: ^\\s*template\n      #   end_expression: ^\\s*end-template\n\n      # substitions against the full multi-line config text\n      full_text_sub: []\n      # - search: \'banner\\s(exec|motd)\\s(\\S)\\n(.*\\n){1,}(\\2)\'\n      #   replace: \'\'\n\n      # substitions against each line of the config text\n      per_line_sub: []\n      # - search: ^Building configuration.*\n      #  replace: \'\'\n\n      idempotent_commands_blacklist: []\n      # - lineage:\n      #  - lineage expression\n\n      # These commands do not require negation, they simply overwrite themselves\n      idempotent_commands:\n        - lineage:\n            - startswith: "router bgp"\n            - endswith: "peer-group"\n            # - lineage:\n            # - startswith: "router bgp"\n            # - re_search: "neighbor (\\d+\\.\\d+\\.\\d+\\.\\d+) peer-group)"\n      # - lineage:\n      #  - startswith: interface\n      #  - startswith: ipv4 address\n\n      # Default when expression: list of lineage expressions\n      negation_default_when: []\n      # - lineage:\n      #  - lineage expression\n\n      # Negate substitutions: lineage expression -> negate with\n      negation_negate_with: []\n      # - lineage:\n      #  - lineage expression\n      #  use: command\n    hier_tags:\n      - lineage:\n          - startswith:\n              - "ipv4 access-list"\n              - "no ipv4 access-list"\n        add_tags: "push"\n      - lineage:\n          - startswith: "router bgp"\n          - startswith: "address-family"\n          - startswith:\n              - "neighbor"\n              - "no neighbor"\n              - "maximum-paths"\n              - "exit-address-family"\n        add_tags: "push"\n      - lineage:\n          - startswith: "router bgp"\n          - startswith:\n              - "neighbor"\n              - "no neighbor"\n        add_tags: "push"\n      - lineage:\n          - startswith: "aaa"\n        add_tags: "ignore"\nios:\n  username: "developer"\n  password: "C1sco12345"\n  platform: "ios"\n```\n\n</details>\n\n### Result Diff\n\nUnlike the Ansible Collection, this Nornir task provides a friendly diff of what the remediation configuration will include. This happens if there is a change detected only. The underlying library providing the diff is [DeepDiff](https://deepdiff.readthedocs.io/en/latest/).\n\n```bash\n*************\n* PHX_LAB_02_XE ** changed : True **********************************************\nvvvv remediation ** changed : True vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv INFO\n{ \'values_changed\': { \'root\': { \'diff\': \'--- \\n\'\n                                        \'+++ \\n\'\n                                        \'@@ -0,0 +1,5 @@\\n\'\n                                        \'+no ntp server 10.20.30.40\\n\'\n                                        \'+no ntp server 10.10.10.1\\n\'\n                                        \'+interface GigabitEthernet3\\n\'\n                                        \'+  ip address 192.168.0.100 \'\n                                        \'255.255.255.0\\n\'\n                                        \'+  no shutdown\',\n                                \'new_value\': \'no ntp server 10.20.30.40\\n\'\n                                             \'no ntp server 10.10.10.1\\n\'\n                                             \'interface GigabitEthernet3\\n\'\n                                             \'  ip address 192.168.0.100 \'\n                                             \'255.255.255.0\\n\'\n                                             \'  no shutdown\',\n                                \'old_value\': \'\'}}}\n^^^^ END remediation ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n```\n\n## Contributions\n\n------------\n\nNo line of code shall go un tested! Any contribution will need to be accounted by the coverage report and satisfy all linting.\n\nLinters:\n\n- Fake8\n- Black\n- Yamllint\n- Pylint\n- Pydocstyle\n- Bandit\n- MyPy\n\n### Testing\n\nTo test within a local docker environment\n\n```bash\ngit clone https://github.com/h4ndzdatm0ld/nornir_hier_config\n```\n\n```bash\ndocker-compose build && docker-compose run test\n```\n\nTo test locally with pytest\n\n```bash\npoetry install && poetry shell\n```\n\n```bash\npytest --cov=nornir_hier_config --color=yes --disable-pytest-warnings -vvv\n```\n',
    'author': 'Hugo Tinoco',
    'author_email': 'hugotinoco@icloud.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/h4ndzdatm0ld/nornir_hier_config',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.10',
}


setup(**setup_kwargs)
