# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AdBreakResponse',
    'Aes128EncryptionResponse',
    'AnimationEndResponse',
    'AnimationFadeResponse',
    'AnimationResponse',
    'AnimationStaticResponse',
    'AudioAtomResponse',
    'AudioChannelInputResponse',
    'AudioChannelResponse',
    'AudioResponse',
    'AudioStreamResponse',
    'ColorResponse',
    'CropResponse',
    'DeblockResponse',
    'DenoiseResponse',
    'EditAtomResponse',
    'ElementaryStreamResponse',
    'EncryptionResponse',
    'FailureDetailResponse',
    'ImageResponse',
    'InputResponse',
    'JobConfigResponse',
    'ManifestResponse',
    'MpegCommonEncryptionResponse',
    'MuxStreamResponse',
    'NormalizedCoordinateResponse',
    'OriginUriResponse',
    'OutputResponse',
    'OverlayResponse',
    'PadResponse',
    'PreprocessingConfigResponse',
    'ProgressResponse',
    'PubsubDestinationResponse',
    'SampleAesEncryptionResponse',
    'SegmentSettingsResponse',
    'SpriteSheetResponse',
    'TextAtomResponse',
    'TextInputResponse',
    'TextStreamResponse',
    'VideoStreamResponse',
]

@pulumi.output_type
class AdBreakResponse(dict):
    """
    Ad break.
    """
    def __init__(__self__, *,
                 start_time_offset: str):
        """
        Ad break.
        :param str start_time_offset: Start time in seconds for the ad break, relative to the output file timeline. The default is `0s`.
        """
        pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> str:
        """
        Start time in seconds for the ad break, relative to the output file timeline. The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class Aes128EncryptionResponse(dict):
    """
    Configuration for AES-128 encryption.
    """
    def __init__(__self__, *,
                 key_uri: str):
        """
        Configuration for AES-128 encryption.
        :param str key_uri: Required. URI of the key delivery service. This URI is inserted into the M3U8 header.
        """
        pulumi.set(__self__, "key_uri", key_uri)

    @property
    @pulumi.getter(name="keyUri")
    def key_uri(self) -> str:
        """
        Required. URI of the key delivery service. This URI is inserted into the M3U8 header.
        """
        return pulumi.get(self, "key_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AnimationEndResponse(dict):
    """
    End previous overlay animation from the video. Without AnimationEnd, the overlay object will keep the state of previous animation until the end of the video.
    """
    def __init__(__self__, *,
                 start_time_offset: str):
        """
        End previous overlay animation from the video. Without AnimationEnd, the overlay object will keep the state of previous animation until the end of the video.
        :param str start_time_offset: The time to end overlay object, in seconds. Default: 0
        """
        pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> str:
        """
        The time to end overlay object, in seconds. Default: 0
        """
        return pulumi.get(self, "start_time_offset")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AnimationFadeResponse(dict):
    """
    Display overlay object with fade animation.
    """
    def __init__(__self__, *,
                 end_time_offset: str,
                 fade_type: str,
                 start_time_offset: str,
                 xy: 'outputs.NormalizedCoordinateResponse'):
        """
        Display overlay object with fade animation.
        :param str end_time_offset: The time to end the fade animation, in seconds. Default: `start_time_offset` + 1s
        :param str fade_type: Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
        :param str start_time_offset: The time to start the fade animation, in seconds. Default: 0
        :param 'NormalizedCoordinateResponseArgs' xy: Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        pulumi.set(__self__, "end_time_offset", end_time_offset)
        pulumi.set(__self__, "fade_type", fade_type)
        pulumi.set(__self__, "start_time_offset", start_time_offset)
        pulumi.set(__self__, "xy", xy)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> str:
        """
        The time to end the fade animation, in seconds. Default: `start_time_offset` + 1s
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="fadeType")
    def fade_type(self) -> str:
        """
        Required. Type of fade animation: `FADE_IN` or `FADE_OUT`.
        """
        return pulumi.get(self, "fade_type")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> str:
        """
        The time to start the fade animation, in seconds. Default: 0
        """
        return pulumi.get(self, "start_time_offset")

    @property
    @pulumi.getter
    def xy(self) -> 'outputs.NormalizedCoordinateResponse':
        """
        Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        return pulumi.get(self, "xy")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AnimationResponse(dict):
    """
    Animation types.
    """
    def __init__(__self__, *,
                 animation_end: 'outputs.AnimationEndResponse',
                 animation_fade: 'outputs.AnimationFadeResponse',
                 animation_static: 'outputs.AnimationStaticResponse'):
        """
        Animation types.
        :param 'AnimationEndResponseArgs' animation_end: End previous animation.
        :param 'AnimationFadeResponseArgs' animation_fade: Display overlay object with fade animation.
        :param 'AnimationStaticResponseArgs' animation_static: Display static overlay object.
        """
        pulumi.set(__self__, "animation_end", animation_end)
        pulumi.set(__self__, "animation_fade", animation_fade)
        pulumi.set(__self__, "animation_static", animation_static)

    @property
    @pulumi.getter(name="animationEnd")
    def animation_end(self) -> 'outputs.AnimationEndResponse':
        """
        End previous animation.
        """
        return pulumi.get(self, "animation_end")

    @property
    @pulumi.getter(name="animationFade")
    def animation_fade(self) -> 'outputs.AnimationFadeResponse':
        """
        Display overlay object with fade animation.
        """
        return pulumi.get(self, "animation_fade")

    @property
    @pulumi.getter(name="animationStatic")
    def animation_static(self) -> 'outputs.AnimationStaticResponse':
        """
        Display static overlay object.
        """
        return pulumi.get(self, "animation_static")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AnimationStaticResponse(dict):
    """
    Display static overlay object.
    """
    def __init__(__self__, *,
                 start_time_offset: str,
                 xy: 'outputs.NormalizedCoordinateResponse'):
        """
        Display static overlay object.
        :param str start_time_offset: The time to start displaying the overlay object, in seconds. Default: 0
        :param 'NormalizedCoordinateResponseArgs' xy: Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        pulumi.set(__self__, "start_time_offset", start_time_offset)
        pulumi.set(__self__, "xy", xy)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> str:
        """
        The time to start displaying the overlay object, in seconds. Default: 0
        """
        return pulumi.get(self, "start_time_offset")

    @property
    @pulumi.getter
    def xy(self) -> 'outputs.NormalizedCoordinateResponse':
        """
        Normalized coordinates based on output video resolution. Valid values: `0.0`–`1.0`. `xy` is the upper-left coordinate of the overlay object. For example, use the x and y coordinates {0,0} to position the top-left corner of the overlay animation in the top-left corner of the output video.
        """
        return pulumi.get(self, "xy")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AudioAtomResponse(dict):
    """
    The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
    """
    def __init__(__self__, *,
                 channels: Sequence['outputs.AudioChannelResponse'],
                 key: str):
        """
        The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
        :param Sequence['AudioChannelResponseArgs'] channels: List of `Channel`s for this audio stream. for in-depth explanation.
        :param str key: Required. The `EditAtom.key` that references the atom with audio inputs in the `Job.edit_list`.
        """
        pulumi.set(__self__, "channels", channels)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.AudioChannelResponse']:
        """
        List of `Channel`s for this audio stream. for in-depth explanation.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Required. The `EditAtom.key` that references the atom with audio inputs in the `Job.edit_list`.
        """
        return pulumi.get(self, "key")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AudioChannelInputResponse(dict):
    """
    Identifies which input file, track, and channel should be used.
    """
    def __init__(__self__, *,
                 channel: int,
                 gain_db: float,
                 key: str,
                 track: int):
        """
        Identifies which input file, track, and channel should be used.
        :param int channel: Required. The zero-based index of the channel in the input file.
        :param float gain_db: Audio volume control in dB. Negative values decrease volume, positive values increase. The default is 0.
        :param str key: Required. The `Input.key` that identifies the input file.
        :param int track: Required. The zero-based index of the track in the input file.
        """
        pulumi.set(__self__, "channel", channel)
        pulumi.set(__self__, "gain_db", gain_db)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "track", track)

    @property
    @pulumi.getter
    def channel(self) -> int:
        """
        Required. The zero-based index of the channel in the input file.
        """
        return pulumi.get(self, "channel")

    @property
    @pulumi.getter(name="gainDb")
    def gain_db(self) -> float:
        """
        Audio volume control in dB. Negative values decrease volume, positive values increase. The default is 0.
        """
        return pulumi.get(self, "gain_db")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Required. The `Input.key` that identifies the input file.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def track(self) -> int:
        """
        Required. The zero-based index of the track in the input file.
        """
        return pulumi.get(self, "track")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AudioChannelResponse(dict):
    """
    The audio channel.
    """
    def __init__(__self__, *,
                 inputs: Sequence['outputs.AudioChannelInputResponse']):
        """
        The audio channel.
        :param Sequence['AudioChannelInputResponseArgs'] inputs: List of `Job.inputs` for this audio channel.
        """
        pulumi.set(__self__, "inputs", inputs)

    @property
    @pulumi.getter
    def inputs(self) -> Sequence['outputs.AudioChannelInputResponse']:
        """
        List of `Job.inputs` for this audio channel.
        """
        return pulumi.get(self, "inputs")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AudioResponse(dict):
    """
    Audio preprocessing configuration.
    """
    def __init__(__self__, *,
                 high_boost: bool,
                 low_boost: bool,
                 lufs: float):
        """
        Audio preprocessing configuration.
        :param bool high_boost: Enable boosting high frequency components. The default is `false`.
        :param bool low_boost: Enable boosting low frequency components. The default is `false`.
        :param float lufs: Specify audio loudness normalization in loudness units relative to full scale (LUFS). Enter a value between -24 and 0 (the default), where: * -24 is the Advanced Television Systems Committee (ATSC A/85) standard * -23 is the EU R128 broadcast standard * -19 is the prior standard for online mono audio * -18 is the ReplayGain standard * -16 is the prior standard for stereo audio * -14 is the new online audio standard recommended by Spotify, as well as Amazon Echo * 0 disables normalization
        """
        pulumi.set(__self__, "high_boost", high_boost)
        pulumi.set(__self__, "low_boost", low_boost)
        pulumi.set(__self__, "lufs", lufs)

    @property
    @pulumi.getter(name="highBoost")
    def high_boost(self) -> bool:
        """
        Enable boosting high frequency components. The default is `false`.
        """
        return pulumi.get(self, "high_boost")

    @property
    @pulumi.getter(name="lowBoost")
    def low_boost(self) -> bool:
        """
        Enable boosting low frequency components. The default is `false`.
        """
        return pulumi.get(self, "low_boost")

    @property
    @pulumi.getter
    def lufs(self) -> float:
        """
        Specify audio loudness normalization in loudness units relative to full scale (LUFS). Enter a value between -24 and 0 (the default), where: * -24 is the Advanced Television Systems Committee (ATSC A/85) standard * -23 is the EU R128 broadcast standard * -19 is the prior standard for online mono audio * -18 is the ReplayGain standard * -16 is the prior standard for stereo audio * -14 is the new online audio standard recommended by Spotify, as well as Amazon Echo * 0 disables normalization
        """
        return pulumi.get(self, "lufs")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AudioStreamResponse(dict):
    """
    Audio stream resource.
    """
    def __init__(__self__, *,
                 bitrate_bps: int,
                 channel_count: int,
                 channel_layout: Sequence[str],
                 codec: str,
                 mapping: Sequence['outputs.AudioAtomResponse'],
                 sample_rate_hertz: int):
        """
        Audio stream resource.
        :param int bitrate_bps: Required. Audio bitrate in bits per second. Must be between 1 and 10,000,000.
        :param int channel_count: Number of audio channels. Must be between 1 and 6. The default is 2.
        :param Sequence[str] channel_layout: A list of channel names specifying layout of the audio channels. This only affects the metadata embedded in the container headers, if supported by the specified format. The default is `["fl", "fr"]`. Supported channel names: - 'fl' - Front left channel - 'fr' - Front right channel - 'sl' - Side left channel - 'sr' - Side right channel - 'fc' - Front center channel - 'lfe' - Low frequency
        :param str codec: The codec for this audio stream. The default is `"aac"`. Supported audio codecs: - 'aac' - 'aac-he' - 'aac-he-v2' - 'mp3' - 'ac3' - 'eac3'
        :param Sequence['AudioAtomResponseArgs'] mapping: The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
        :param int sample_rate_hertz: The audio sample rate in Hertz. The default is 48000 Hertz.
        """
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        pulumi.set(__self__, "channel_count", channel_count)
        pulumi.set(__self__, "channel_layout", channel_layout)
        pulumi.set(__self__, "codec", codec)
        pulumi.set(__self__, "mapping", mapping)
        pulumi.set(__self__, "sample_rate_hertz", sample_rate_hertz)

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> int:
        """
        Required. Audio bitrate in bits per second. Must be between 1 and 10,000,000.
        """
        return pulumi.get(self, "bitrate_bps")

    @property
    @pulumi.getter(name="channelCount")
    def channel_count(self) -> int:
        """
        Number of audio channels. Must be between 1 and 6. The default is 2.
        """
        return pulumi.get(self, "channel_count")

    @property
    @pulumi.getter(name="channelLayout")
    def channel_layout(self) -> Sequence[str]:
        """
        A list of channel names specifying layout of the audio channels. This only affects the metadata embedded in the container headers, if supported by the specified format. The default is `["fl", "fr"]`. Supported channel names: - 'fl' - Front left channel - 'fr' - Front right channel - 'sl' - Side left channel - 'sr' - Side right channel - 'fc' - Front center channel - 'lfe' - Low frequency
        """
        return pulumi.get(self, "channel_layout")

    @property
    @pulumi.getter
    def codec(self) -> str:
        """
        The codec for this audio stream. The default is `"aac"`. Supported audio codecs: - 'aac' - 'aac-he' - 'aac-he-v2' - 'mp3' - 'ac3' - 'eac3'
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter
    def mapping(self) -> Sequence['outputs.AudioAtomResponse']:
        """
        The mapping for the `Job.edit_list` atoms with audio `EditAtom.inputs`.
        """
        return pulumi.get(self, "mapping")

    @property
    @pulumi.getter(name="sampleRateHertz")
    def sample_rate_hertz(self) -> int:
        """
        The audio sample rate in Hertz. The default is 48000 Hertz.
        """
        return pulumi.get(self, "sample_rate_hertz")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ColorResponse(dict):
    """
    Color preprocessing configuration.
    """
    def __init__(__self__, *,
                 brightness: float,
                 contrast: float,
                 saturation: float):
        """
        Color preprocessing configuration.
        :param float brightness: Control brightness of the video. Enter a value between -1 and 1, where -1 is minimum brightness and 1 is maximum brightness. 0 is no change. The default is 0.
        :param float contrast: Control black and white contrast of the video. Enter a value between -1 and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no change. The default is 0.
        :param float saturation: Control color saturation of the video. Enter a value between -1 and 1, where -1 is fully desaturated and 1 is maximum saturation. 0 is no change. The default is 0.
        """
        pulumi.set(__self__, "brightness", brightness)
        pulumi.set(__self__, "contrast", contrast)
        pulumi.set(__self__, "saturation", saturation)

    @property
    @pulumi.getter
    def brightness(self) -> float:
        """
        Control brightness of the video. Enter a value between -1 and 1, where -1 is minimum brightness and 1 is maximum brightness. 0 is no change. The default is 0.
        """
        return pulumi.get(self, "brightness")

    @property
    @pulumi.getter
    def contrast(self) -> float:
        """
        Control black and white contrast of the video. Enter a value between -1 and 1, where -1 is minimum contrast and 1 is maximum contrast. 0 is no change. The default is 0.
        """
        return pulumi.get(self, "contrast")

    @property
    @pulumi.getter
    def saturation(self) -> float:
        """
        Control color saturation of the video. Enter a value between -1 and 1, where -1 is fully desaturated and 1 is maximum saturation. 0 is no change. The default is 0.
        """
        return pulumi.get(self, "saturation")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CropResponse(dict):
    """
    Video cropping configuration for the input video. The cropped input video is scaled to match the output resolution.
    """
    def __init__(__self__, *,
                 bottom_pixels: int,
                 left_pixels: int,
                 right_pixels: int,
                 top_pixels: int):
        """
        Video cropping configuration for the input video. The cropped input video is scaled to match the output resolution.
        :param int bottom_pixels: The number of pixels to crop from the bottom. The default is 0.
        :param int left_pixels: The number of pixels to crop from the left. The default is 0.
        :param int right_pixels: The number of pixels to crop from the right. The default is 0.
        :param int top_pixels: The number of pixels to crop from the top. The default is 0.
        """
        pulumi.set(__self__, "bottom_pixels", bottom_pixels)
        pulumi.set(__self__, "left_pixels", left_pixels)
        pulumi.set(__self__, "right_pixels", right_pixels)
        pulumi.set(__self__, "top_pixels", top_pixels)

    @property
    @pulumi.getter(name="bottomPixels")
    def bottom_pixels(self) -> int:
        """
        The number of pixels to crop from the bottom. The default is 0.
        """
        return pulumi.get(self, "bottom_pixels")

    @property
    @pulumi.getter(name="leftPixels")
    def left_pixels(self) -> int:
        """
        The number of pixels to crop from the left. The default is 0.
        """
        return pulumi.get(self, "left_pixels")

    @property
    @pulumi.getter(name="rightPixels")
    def right_pixels(self) -> int:
        """
        The number of pixels to crop from the right. The default is 0.
        """
        return pulumi.get(self, "right_pixels")

    @property
    @pulumi.getter(name="topPixels")
    def top_pixels(self) -> int:
        """
        The number of pixels to crop from the top. The default is 0.
        """
        return pulumi.get(self, "top_pixels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DeblockResponse(dict):
    """
    Deblock preprocessing configuration.
    """
    def __init__(__self__, *,
                 enabled: bool,
                 strength: float):
        """
        Deblock preprocessing configuration.
        :param bool enabled: Enable deblocker. The default is `false`.
        :param float strength: Set strength of the deblocker. Enter a value between 0 and 1. The higher the value, the stronger the block removal. 0 is no deblocking. The default is 0.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "strength", strength)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Enable deblocker. The default is `false`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def strength(self) -> float:
        """
        Set strength of the deblocker. Enter a value between 0 and 1. The higher the value, the stronger the block removal. 0 is no deblocking. The default is 0.
        """
        return pulumi.get(self, "strength")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DenoiseResponse(dict):
    """
    Denoise preprocessing configuration.
    """
    def __init__(__self__, *,
                 strength: float,
                 tune: str):
        """
        Denoise preprocessing configuration.
        :param float strength: Set strength of the denoise. Enter a value between 0 and 1. The higher the value, the smoother the image. 0 is no denoising. The default is 0.
        :param str tune: Set the denoiser mode. The default is `"standard"`. Supported denoiser modes: - 'standard' - 'grain'
        """
        pulumi.set(__self__, "strength", strength)
        pulumi.set(__self__, "tune", tune)

    @property
    @pulumi.getter
    def strength(self) -> float:
        """
        Set strength of the denoise. Enter a value between 0 and 1. The higher the value, the smoother the image. 0 is no denoising. The default is 0.
        """
        return pulumi.get(self, "strength")

    @property
    @pulumi.getter
    def tune(self) -> str:
        """
        Set the denoiser mode. The default is `"standard"`. Supported denoiser modes: - 'standard' - 'grain'
        """
        return pulumi.get(self, "tune")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EditAtomResponse(dict):
    """
    Edit atom.
    """
    def __init__(__self__, *,
                 end_time_offset: str,
                 inputs: Sequence[str],
                 key: str,
                 start_time_offset: str):
        """
        Edit atom.
        :param str end_time_offset: End time in seconds for the atom, relative to the input file timeline. When `end_time_offset` is not specified, the `inputs` are used until the end of the atom.
        :param Sequence[str] inputs: List of `Input.key`s identifying files that should be used in this atom. The listed `inputs` must have the same timeline.
        :param str key: A unique key for this atom. Must be specified when using advanced mapping.
        :param str start_time_offset: Start time in seconds for the atom, relative to the input file timeline. The default is `0s`.
        """
        pulumi.set(__self__, "end_time_offset", end_time_offset)
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "start_time_offset", start_time_offset)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> str:
        """
        End time in seconds for the atom, relative to the input file timeline. When `end_time_offset` is not specified, the `inputs` are used until the end of the atom.
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter
    def inputs(self) -> Sequence[str]:
        """
        List of `Input.key`s identifying files that should be used in this atom. The listed `inputs` must have the same timeline.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A unique key for this atom. Must be specified when using advanced mapping.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> str:
        """
        Start time in seconds for the atom, relative to the input file timeline. The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ElementaryStreamResponse(dict):
    """
    Encoding of an input file such as an audio, video, or text track. Elementary streams must be packaged before mapping and sharing between different output formats.
    """
    def __init__(__self__, *,
                 audio_stream: 'outputs.AudioStreamResponse',
                 key: str,
                 text_stream: 'outputs.TextStreamResponse',
                 video_stream: 'outputs.VideoStreamResponse'):
        """
        Encoding of an input file such as an audio, video, or text track. Elementary streams must be packaged before mapping and sharing between different output formats.
        :param 'AudioStreamResponseArgs' audio_stream: Encoding of an audio stream.
        :param str key: A unique key for this elementary stream.
        :param 'TextStreamResponseArgs' text_stream: Encoding of a text stream. For example, closed captions or subtitles.
        :param 'VideoStreamResponseArgs' video_stream: Encoding of a video stream.
        """
        pulumi.set(__self__, "audio_stream", audio_stream)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "text_stream", text_stream)
        pulumi.set(__self__, "video_stream", video_stream)

    @property
    @pulumi.getter(name="audioStream")
    def audio_stream(self) -> 'outputs.AudioStreamResponse':
        """
        Encoding of an audio stream.
        """
        return pulumi.get(self, "audio_stream")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A unique key for this elementary stream.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="textStream")
    def text_stream(self) -> 'outputs.TextStreamResponse':
        """
        Encoding of a text stream. For example, closed captions or subtitles.
        """
        return pulumi.get(self, "text_stream")

    @property
    @pulumi.getter(name="videoStream")
    def video_stream(self) -> 'outputs.VideoStreamResponse':
        """
        Encoding of a video stream.
        """
        return pulumi.get(self, "video_stream")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EncryptionResponse(dict):
    """
    Encryption settings.
    """
    def __init__(__self__, *,
                 aes128: 'outputs.Aes128EncryptionResponse',
                 iv: str,
                 key: str,
                 mpeg_cenc: 'outputs.MpegCommonEncryptionResponse',
                 sample_aes: 'outputs.SampleAesEncryptionResponse'):
        """
        Encryption settings.
        :param 'Aes128EncryptionResponseArgs' aes128: Configuration for AES-128 encryption.
        :param str iv: Required. 128 bit Initialization Vector (IV) represented as lowercase hexadecimal digits.
        :param str key: Required. 128 bit encryption key represented as lowercase hexadecimal digits.
        :param 'MpegCommonEncryptionResponseArgs' mpeg_cenc: Configuration for MPEG Common Encryption (MPEG-CENC).
        :param 'SampleAesEncryptionResponseArgs' sample_aes: Configuration for SAMPLE-AES encryption.
        """
        pulumi.set(__self__, "aes128", aes128)
        pulumi.set(__self__, "iv", iv)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "mpeg_cenc", mpeg_cenc)
        pulumi.set(__self__, "sample_aes", sample_aes)

    @property
    @pulumi.getter
    def aes128(self) -> 'outputs.Aes128EncryptionResponse':
        """
        Configuration for AES-128 encryption.
        """
        return pulumi.get(self, "aes128")

    @property
    @pulumi.getter
    def iv(self) -> str:
        """
        Required. 128 bit Initialization Vector (IV) represented as lowercase hexadecimal digits.
        """
        return pulumi.get(self, "iv")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Required. 128 bit encryption key represented as lowercase hexadecimal digits.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="mpegCenc")
    def mpeg_cenc(self) -> 'outputs.MpegCommonEncryptionResponse':
        """
        Configuration for MPEG Common Encryption (MPEG-CENC).
        """
        return pulumi.get(self, "mpeg_cenc")

    @property
    @pulumi.getter(name="sampleAes")
    def sample_aes(self) -> 'outputs.SampleAesEncryptionResponse':
        """
        Configuration for SAMPLE-AES encryption.
        """
        return pulumi.get(self, "sample_aes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class FailureDetailResponse(dict):
    """
    Additional information about the reasons for the failure.
    """
    def __init__(__self__, *,
                 description: str):
        """
        Additional information about the reasons for the failure.
        :param str description: A description of the failure.
        """
        pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the failure.
        """
        return pulumi.get(self, "description")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ImageResponse(dict):
    """
    Overlaid jpeg image.
    """
    def __init__(__self__, *,
                 alpha: float,
                 resolution: 'outputs.NormalizedCoordinateResponse',
                 uri: str):
        """
        Overlaid jpeg image.
        :param float alpha: Target image opacity. Valid values: `1.0` (solid, default) to `0.0` (transparent).
        :param 'NormalizedCoordinateResponseArgs' resolution: Normalized image resolution, based on output video resolution. Valid values: `0.0`–`1.0`. To respect the original image aspect ratio, set either `x` or `y` to `0.0`. To use the original image resolution, set both `x` and `y` to `0.0`.
        :param str uri: Required. URI of the JPEG image in Cloud Storage. For example, `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
        """
        pulumi.set(__self__, "alpha", alpha)
        pulumi.set(__self__, "resolution", resolution)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def alpha(self) -> float:
        """
        Target image opacity. Valid values: `1.0` (solid, default) to `0.0` (transparent).
        """
        return pulumi.get(self, "alpha")

    @property
    @pulumi.getter
    def resolution(self) -> 'outputs.NormalizedCoordinateResponse':
        """
        Normalized image resolution, based on output video resolution. Valid values: `0.0`–`1.0`. To respect the original image aspect ratio, set either `x` or `y` to `0.0`. To use the original image resolution, set both `x` and `y` to `0.0`.
        """
        return pulumi.get(self, "resolution")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Required. URI of the JPEG image in Cloud Storage. For example, `gs://bucket/inputs/image.jpeg`. JPEG is the only supported image type.
        """
        return pulumi.get(self, "uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InputResponse(dict):
    """
    Input asset.
    """
    def __init__(__self__, *,
                 key: str,
                 preprocessing_config: 'outputs.PreprocessingConfigResponse',
                 uri: str):
        """
        Input asset.
        :param str key: A unique key for this input. Must be specified when using advanced mapping and edit lists.
        :param 'PreprocessingConfigResponseArgs' preprocessing_config: Preprocessing configurations.
        :param str uri: URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). If empty, the value will be populated from `Job.input_uri`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "preprocessing_config", preprocessing_config)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A unique key for this input. Must be specified when using advanced mapping and edit lists.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="preprocessingConfig")
    def preprocessing_config(self) -> 'outputs.PreprocessingConfigResponse':
        """
        Preprocessing configurations.
        """
        return pulumi.get(self, "preprocessing_config")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI of the media. Input files must be at least 5 seconds in duration and stored in Cloud Storage (for example, `gs://bucket/inputs/file.mp4`). If empty, the value will be populated from `Job.input_uri`.
        """
        return pulumi.get(self, "uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobConfigResponse(dict):
    """
    Job configuration
    """
    def __init__(__self__, *,
                 ad_breaks: Sequence['outputs.AdBreakResponse'],
                 edit_list: Sequence['outputs.EditAtomResponse'],
                 elementary_streams: Sequence['outputs.ElementaryStreamResponse'],
                 inputs: Sequence['outputs.InputResponse'],
                 manifests: Sequence['outputs.ManifestResponse'],
                 mux_streams: Sequence['outputs.MuxStreamResponse'],
                 output: 'outputs.OutputResponse',
                 overlays: Sequence['outputs.OverlayResponse'],
                 pubsub_destination: 'outputs.PubsubDestinationResponse',
                 sprite_sheets: Sequence['outputs.SpriteSheetResponse']):
        """
        Job configuration
        :param Sequence['AdBreakResponseArgs'] ad_breaks: List of ad breaks. Specifies where to insert ad break tags in the output manifests.
        :param Sequence['EditAtomResponseArgs'] edit_list: List of `Edit atom`s. Defines the ultimate timeline of the resulting file or manifest.
        :param Sequence['ElementaryStreamResponseArgs'] elementary_streams: List of elementary streams.
        :param Sequence['InputResponseArgs'] inputs: List of input assets stored in Cloud Storage.
        :param Sequence['ManifestResponseArgs'] manifests: List of output manifests.
        :param Sequence['MuxStreamResponseArgs'] mux_streams: List of multiplexing settings for output streams.
        :param 'OutputResponseArgs' output: Output configuration.
        :param Sequence['OverlayResponseArgs'] overlays: List of overlays on the output video, in descending Z-order.
        :param 'PubsubDestinationResponseArgs' pubsub_destination: Destination on Pub/Sub.
        :param Sequence['SpriteSheetResponseArgs'] sprite_sheets: List of output sprite sheets.
        """
        pulumi.set(__self__, "ad_breaks", ad_breaks)
        pulumi.set(__self__, "edit_list", edit_list)
        pulumi.set(__self__, "elementary_streams", elementary_streams)
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "manifests", manifests)
        pulumi.set(__self__, "mux_streams", mux_streams)
        pulumi.set(__self__, "output", output)
        pulumi.set(__self__, "overlays", overlays)
        pulumi.set(__self__, "pubsub_destination", pubsub_destination)
        pulumi.set(__self__, "sprite_sheets", sprite_sheets)

    @property
    @pulumi.getter(name="adBreaks")
    def ad_breaks(self) -> Sequence['outputs.AdBreakResponse']:
        """
        List of ad breaks. Specifies where to insert ad break tags in the output manifests.
        """
        return pulumi.get(self, "ad_breaks")

    @property
    @pulumi.getter(name="editList")
    def edit_list(self) -> Sequence['outputs.EditAtomResponse']:
        """
        List of `Edit atom`s. Defines the ultimate timeline of the resulting file or manifest.
        """
        return pulumi.get(self, "edit_list")

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Sequence['outputs.ElementaryStreamResponse']:
        """
        List of elementary streams.
        """
        return pulumi.get(self, "elementary_streams")

    @property
    @pulumi.getter
    def inputs(self) -> Sequence['outputs.InputResponse']:
        """
        List of input assets stored in Cloud Storage.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def manifests(self) -> Sequence['outputs.ManifestResponse']:
        """
        List of output manifests.
        """
        return pulumi.get(self, "manifests")

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> Sequence['outputs.MuxStreamResponse']:
        """
        List of multiplexing settings for output streams.
        """
        return pulumi.get(self, "mux_streams")

    @property
    @pulumi.getter
    def output(self) -> 'outputs.OutputResponse':
        """
        Output configuration.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter
    def overlays(self) -> Sequence['outputs.OverlayResponse']:
        """
        List of overlays on the output video, in descending Z-order.
        """
        return pulumi.get(self, "overlays")

    @property
    @pulumi.getter(name="pubsubDestination")
    def pubsub_destination(self) -> 'outputs.PubsubDestinationResponse':
        """
        Destination on Pub/Sub.
        """
        return pulumi.get(self, "pubsub_destination")

    @property
    @pulumi.getter(name="spriteSheets")
    def sprite_sheets(self) -> Sequence['outputs.SpriteSheetResponse']:
        """
        List of output sprite sheets.
        """
        return pulumi.get(self, "sprite_sheets")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ManifestResponse(dict):
    """
    Manifest configuration.
    """
    def __init__(__self__, *,
                 file_name: str,
                 mux_streams: Sequence[str],
                 type: str):
        """
        Manifest configuration.
        :param str file_name: The name of the generated file. The default is `"manifest"` with the extension suffix corresponding to the `Manifest.type`.
        :param Sequence[str] mux_streams: Required. List of user given `MuxStream.key`s that should appear in this manifest. When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key` and `.m3u8` extension is generated for each element of the `Manifest.mux_streams`.
        :param str type: Required. Type of the manifest, can be "HLS" or "DASH".
        """
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "mux_streams", mux_streams)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        """
        The name of the generated file. The default is `"manifest"` with the extension suffix corresponding to the `Manifest.type`.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter(name="muxStreams")
    def mux_streams(self) -> Sequence[str]:
        """
        Required. List of user given `MuxStream.key`s that should appear in this manifest. When `Manifest.type` is `HLS`, a media manifest with name `MuxStream.key` and `.m3u8` extension is generated for each element of the `Manifest.mux_streams`.
        """
        return pulumi.get(self, "mux_streams")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Required. Type of the manifest, can be "HLS" or "DASH".
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MpegCommonEncryptionResponse(dict):
    """
    Configuration for MPEG Common Encryption (MPEG-CENC).
    """
    def __init__(__self__, *,
                 key_id: str,
                 scheme: str):
        """
        Configuration for MPEG Common Encryption (MPEG-CENC).
        :param str key_id: Required. 128 bit Key ID represented as lowercase hexadecimal digits for use with common encryption.
        :param str scheme: Required. Specify the encryption scheme. Supported encryption schemes: - 'cenc' - 'cbcs'
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        Required. 128 bit Key ID represented as lowercase hexadecimal digits for use with common encryption.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Required. Specify the encryption scheme. Supported encryption schemes: - 'cenc' - 'cbcs'
        """
        return pulumi.get(self, "scheme")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MuxStreamResponse(dict):
    """
    Multiplexing settings for output stream.
    """
    def __init__(__self__, *,
                 container: str,
                 elementary_streams: Sequence[str],
                 encryption: 'outputs.EncryptionResponse',
                 file_name: str,
                 key: str,
                 segment_settings: 'outputs.SegmentSettingsResponse'):
        """
        Multiplexing settings for output stream.
        :param str container: The container format. The default is `"mp4"` Supported container formats: - 'ts' - 'fmp4'- the corresponding file extension is `".m4s"` - 'mp4' - 'vtt'
        :param Sequence[str] elementary_streams: List of `ElementaryStream.key`s multiplexed in this stream.
        :param 'EncryptionResponseArgs' encryption: Encryption settings.
        :param str file_name: The name of the generated file. The default is `MuxStream.key` with the extension suffix corresponding to the `MuxStream.container`. Individual segments also have an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `"mux_stream0000000123.ts"`.
        :param str key: A unique key for this multiplexed stream. HLS media manifests will be named `MuxStream.key` with the `".m3u8"` extension suffix.
        :param 'SegmentSettingsResponseArgs' segment_settings: Segment settings for `"ts"`, `"fmp4"` and `"vtt"`.
        """
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "elementary_streams", elementary_streams)
        pulumi.set(__self__, "encryption", encryption)
        pulumi.set(__self__, "file_name", file_name)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "segment_settings", segment_settings)

    @property
    @pulumi.getter
    def container(self) -> str:
        """
        The container format. The default is `"mp4"` Supported container formats: - 'ts' - 'fmp4'- the corresponding file extension is `".m4s"` - 'mp4' - 'vtt'
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="elementaryStreams")
    def elementary_streams(self) -> Sequence[str]:
        """
        List of `ElementaryStream.key`s multiplexed in this stream.
        """
        return pulumi.get(self, "elementary_streams")

    @property
    @pulumi.getter
    def encryption(self) -> 'outputs.EncryptionResponse':
        """
        Encryption settings.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        """
        The name of the generated file. The default is `MuxStream.key` with the extension suffix corresponding to the `MuxStream.container`. Individual segments also have an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `"mux_stream0000000123.ts"`.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        A unique key for this multiplexed stream. HLS media manifests will be named `MuxStream.key` with the `".m3u8"` extension suffix.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="segmentSettings")
    def segment_settings(self) -> 'outputs.SegmentSettingsResponse':
        """
        Segment settings for `"ts"`, `"fmp4"` and `"vtt"`.
        """
        return pulumi.get(self, "segment_settings")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NormalizedCoordinateResponse(dict):
    """
    2D normalized coordinates. Default: `{0.0, 0.0}`
    """
    def __init__(__self__, *,
                 x: float,
                 y: float):
        """
        2D normalized coordinates. Default: `{0.0, 0.0}`
        :param float x: Normalized x coordinate.
        :param float y: Normalized y coordinate.
        """
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> float:
        """
        Normalized x coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> float:
        """
        Normalized y coordinate.
        """
        return pulumi.get(self, "y")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OriginUriResponse(dict):
    """
    The origin URI.
    """
    def __init__(__self__, *,
                 dash: str,
                 hls: str):
        """
        The origin URI.
        :param str dash: Dash manifest URI. If multiple Dash manifests are created, only the first one is listed.
        :param str hls: HLS manifest URI per https://tools.ietf.org/html/rfc8216#section-4.3.4. If multiple HLS manifests are created, only the first one is listed.
        """
        pulumi.set(__self__, "dash", dash)
        pulumi.set(__self__, "hls", hls)

    @property
    @pulumi.getter
    def dash(self) -> str:
        """
        Dash manifest URI. If multiple Dash manifests are created, only the first one is listed.
        """
        return pulumi.get(self, "dash")

    @property
    @pulumi.getter
    def hls(self) -> str:
        """
        HLS manifest URI per https://tools.ietf.org/html/rfc8216#section-4.3.4. If multiple HLS manifests are created, only the first one is listed.
        """
        return pulumi.get(self, "hls")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OutputResponse(dict):
    """
    Location of output file(s) in a Cloud Storage bucket.
    """
    def __init__(__self__, *,
                 uri: str):
        """
        Location of output file(s) in a Cloud Storage bucket.
        :param str uri: URI for the output file(s). For example, `gs://my-bucket/outputs/`. If empty the value is populated from `Job.output_uri`.
        """
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI for the output file(s). For example, `gs://my-bucket/outputs/`. If empty the value is populated from `Job.output_uri`.
        """
        return pulumi.get(self, "uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OverlayResponse(dict):
    """
    Overlay configuration.
    """
    def __init__(__self__, *,
                 animations: Sequence['outputs.AnimationResponse'],
                 image: 'outputs.ImageResponse'):
        """
        Overlay configuration.
        :param Sequence['AnimationResponseArgs'] animations: List of Animations. The list should be chronological, without any time overlap.
        :param 'ImageResponseArgs' image: Image overlay.
        """
        pulumi.set(__self__, "animations", animations)
        pulumi.set(__self__, "image", image)

    @property
    @pulumi.getter
    def animations(self) -> Sequence['outputs.AnimationResponse']:
        """
        List of Animations. The list should be chronological, without any time overlap.
        """
        return pulumi.get(self, "animations")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.ImageResponse':
        """
        Image overlay.
        """
        return pulumi.get(self, "image")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PadResponse(dict):
    """
    Pad filter configuration for the input video. The padded input video is scaled after padding with black to match the output resolution.
    """
    def __init__(__self__, *,
                 bottom_pixels: int,
                 left_pixels: int,
                 right_pixels: int,
                 top_pixels: int):
        """
        Pad filter configuration for the input video. The padded input video is scaled after padding with black to match the output resolution.
        :param int bottom_pixels: The number of pixels to add to the bottom. The default is 0.
        :param int left_pixels: The number of pixels to add to the left. The default is 0.
        :param int right_pixels: The number of pixels to add to the right. The default is 0.
        :param int top_pixels: The number of pixels to add to the top. The default is 0.
        """
        pulumi.set(__self__, "bottom_pixels", bottom_pixels)
        pulumi.set(__self__, "left_pixels", left_pixels)
        pulumi.set(__self__, "right_pixels", right_pixels)
        pulumi.set(__self__, "top_pixels", top_pixels)

    @property
    @pulumi.getter(name="bottomPixels")
    def bottom_pixels(self) -> int:
        """
        The number of pixels to add to the bottom. The default is 0.
        """
        return pulumi.get(self, "bottom_pixels")

    @property
    @pulumi.getter(name="leftPixels")
    def left_pixels(self) -> int:
        """
        The number of pixels to add to the left. The default is 0.
        """
        return pulumi.get(self, "left_pixels")

    @property
    @pulumi.getter(name="rightPixels")
    def right_pixels(self) -> int:
        """
        The number of pixels to add to the right. The default is 0.
        """
        return pulumi.get(self, "right_pixels")

    @property
    @pulumi.getter(name="topPixels")
    def top_pixels(self) -> int:
        """
        The number of pixels to add to the top. The default is 0.
        """
        return pulumi.get(self, "top_pixels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PreprocessingConfigResponse(dict):
    """
    Preprocessing configurations.
    """
    def __init__(__self__, *,
                 audio: 'outputs.AudioResponse',
                 color: 'outputs.ColorResponse',
                 crop: 'outputs.CropResponse',
                 deblock: 'outputs.DeblockResponse',
                 denoise: 'outputs.DenoiseResponse',
                 pad: 'outputs.PadResponse'):
        """
        Preprocessing configurations.
        :param 'AudioResponseArgs' audio: Audio preprocessing configuration.
        :param 'ColorResponseArgs' color: Color preprocessing configuration.
        :param 'CropResponseArgs' crop: Specify the video cropping configuration.
        :param 'DeblockResponseArgs' deblock: Deblock preprocessing configuration.
        :param 'DenoiseResponseArgs' denoise: Denoise preprocessing configuration.
        :param 'PadResponseArgs' pad: Specify the video pad filter configuration.
        """
        pulumi.set(__self__, "audio", audio)
        pulumi.set(__self__, "color", color)
        pulumi.set(__self__, "crop", crop)
        pulumi.set(__self__, "deblock", deblock)
        pulumi.set(__self__, "denoise", denoise)
        pulumi.set(__self__, "pad", pad)

    @property
    @pulumi.getter
    def audio(self) -> 'outputs.AudioResponse':
        """
        Audio preprocessing configuration.
        """
        return pulumi.get(self, "audio")

    @property
    @pulumi.getter
    def color(self) -> 'outputs.ColorResponse':
        """
        Color preprocessing configuration.
        """
        return pulumi.get(self, "color")

    @property
    @pulumi.getter
    def crop(self) -> 'outputs.CropResponse':
        """
        Specify the video cropping configuration.
        """
        return pulumi.get(self, "crop")

    @property
    @pulumi.getter
    def deblock(self) -> 'outputs.DeblockResponse':
        """
        Deblock preprocessing configuration.
        """
        return pulumi.get(self, "deblock")

    @property
    @pulumi.getter
    def denoise(self) -> 'outputs.DenoiseResponse':
        """
        Denoise preprocessing configuration.
        """
        return pulumi.get(self, "denoise")

    @property
    @pulumi.getter
    def pad(self) -> 'outputs.PadResponse':
        """
        Specify the video pad filter configuration.
        """
        return pulumi.get(self, "pad")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProgressResponse(dict):
    """
    Estimated fractional progress for each step, from `0` to `1`.
    """
    def __init__(__self__, *,
                 analyzed: float,
                 encoded: float,
                 notified: float,
                 uploaded: float):
        """
        Estimated fractional progress for each step, from `0` to `1`.
        :param float analyzed: Estimated fractional progress for `analyzing` step.
        :param float encoded: Estimated fractional progress for `encoding` step.
        :param float notified: Estimated fractional progress for `notifying` step.
        :param float uploaded: Estimated fractional progress for `uploading` step.
        """
        pulumi.set(__self__, "analyzed", analyzed)
        pulumi.set(__self__, "encoded", encoded)
        pulumi.set(__self__, "notified", notified)
        pulumi.set(__self__, "uploaded", uploaded)

    @property
    @pulumi.getter
    def analyzed(self) -> float:
        """
        Estimated fractional progress for `analyzing` step.
        """
        return pulumi.get(self, "analyzed")

    @property
    @pulumi.getter
    def encoded(self) -> float:
        """
        Estimated fractional progress for `encoding` step.
        """
        return pulumi.get(self, "encoded")

    @property
    @pulumi.getter
    def notified(self) -> float:
        """
        Estimated fractional progress for `notifying` step.
        """
        return pulumi.get(self, "notified")

    @property
    @pulumi.getter
    def uploaded(self) -> float:
        """
        Estimated fractional progress for `uploading` step.
        """
        return pulumi.get(self, "uploaded")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PubsubDestinationResponse(dict):
    """
    A Pub/Sub destination.
    """
    def __init__(__self__, *,
                 topic: str):
        """
        A Pub/Sub destination.
        :param str topic: The name of the Pub/Sub topic to publish job completion notification to. For example: `projects/{project}/topics/{topic}`.
        """
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        The name of the Pub/Sub topic to publish job completion notification to. For example: `projects/{project}/topics/{topic}`.
        """
        return pulumi.get(self, "topic")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SampleAesEncryptionResponse(dict):
    """
    Configuration for SAMPLE-AES encryption.
    """
    def __init__(__self__, *,
                 key_uri: str):
        """
        Configuration for SAMPLE-AES encryption.
        :param str key_uri: Required. URI of the key delivery service. This URI is inserted into the M3U8 header.
        """
        pulumi.set(__self__, "key_uri", key_uri)

    @property
    @pulumi.getter(name="keyUri")
    def key_uri(self) -> str:
        """
        Required. URI of the key delivery service. This URI is inserted into the M3U8 header.
        """
        return pulumi.get(self, "key_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SegmentSettingsResponse(dict):
    """
    Segment settings for `"ts"`, `"fmp4"` and `"vtt"`.
    """
    def __init__(__self__, *,
                 individual_segments: bool,
                 segment_duration: str):
        """
        Segment settings for `"ts"`, `"fmp4"` and `"vtt"`.
        :param bool individual_segments: Required. Create an individual segment file. The default is `false`.
        :param str segment_duration: Duration of the segments in seconds. The default is `"6.0s"`. Note that `segmentDuration` must be greater than or equal to [`gopDuration`](#videostream), and `segmentDuration` must be divisible by [`gopDuration`](#videostream).
        """
        pulumi.set(__self__, "individual_segments", individual_segments)
        pulumi.set(__self__, "segment_duration", segment_duration)

    @property
    @pulumi.getter(name="individualSegments")
    def individual_segments(self) -> bool:
        """
        Required. Create an individual segment file. The default is `false`.
        """
        return pulumi.get(self, "individual_segments")

    @property
    @pulumi.getter(name="segmentDuration")
    def segment_duration(self) -> str:
        """
        Duration of the segments in seconds. The default is `"6.0s"`. Note that `segmentDuration` must be greater than or equal to [`gopDuration`](#videostream), and `segmentDuration` must be divisible by [`gopDuration`](#videostream).
        """
        return pulumi.get(self, "segment_duration")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SpriteSheetResponse(dict):
    """
    Sprite sheet configuration.
    """
    def __init__(__self__, *,
                 column_count: int,
                 end_time_offset: str,
                 file_prefix: str,
                 format: str,
                 interval: str,
                 quality: int,
                 row_count: int,
                 sprite_height_pixels: int,
                 sprite_width_pixels: int,
                 start_time_offset: str,
                 total_count: int):
        """
        Sprite sheet configuration.
        :param int column_count: The maximum number of sprites per row in a sprite sheet. The default is 0, which indicates no maximum limit.
        :param str end_time_offset: End time in seconds, relative to the output file timeline. When `end_time_offset` is not specified, the sprites are generated until the end of the output file.
        :param str file_prefix: Required. File name prefix for the generated sprite sheets. Each sprite sheet has an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `"sprite_sheet0000000123.jpeg"`.
        :param str format: Format type. The default is `"jpeg"`. Supported formats: - 'jpeg'
        :param str interval: Starting from `0s`, create sprites at regular intervals. Specify the interval value in seconds.
        :param int quality: The quality of the generated sprite sheet. Enter a value between 1 and 100, where 1 is the lowest quality and 100 is the highest quality. The default is 100. A high quality value corresponds to a low image data compression ratio.
        :param int row_count: The maximum number of rows per sprite sheet. When the sprite sheet is full, a new sprite sheet is created. The default is 0, which indicates no maximum limit.
        :param int sprite_height_pixels: Required. The height of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_height_pixels field or the SpriteSheet.sprite_width_pixels field, but not both (the API will automatically calculate the missing field).
        :param int sprite_width_pixels: Required. The width of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_width_pixels field or the SpriteSheet.sprite_height_pixels field, but not both (the API will automatically calculate the missing field).
        :param str start_time_offset: Start time in seconds, relative to the output file timeline. Determines the first sprite to pick. The default is `0s`.
        :param int total_count: Total number of sprites. Create the specified number of sprites distributed evenly across the timeline of the output media. The default is 100.
        """
        pulumi.set(__self__, "column_count", column_count)
        pulumi.set(__self__, "end_time_offset", end_time_offset)
        pulumi.set(__self__, "file_prefix", file_prefix)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "quality", quality)
        pulumi.set(__self__, "row_count", row_count)
        pulumi.set(__self__, "sprite_height_pixels", sprite_height_pixels)
        pulumi.set(__self__, "sprite_width_pixels", sprite_width_pixels)
        pulumi.set(__self__, "start_time_offset", start_time_offset)
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="columnCount")
    def column_count(self) -> int:
        """
        The maximum number of sprites per row in a sprite sheet. The default is 0, which indicates no maximum limit.
        """
        return pulumi.get(self, "column_count")

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> str:
        """
        End time in seconds, relative to the output file timeline. When `end_time_offset` is not specified, the sprites are generated until the end of the output file.
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter(name="filePrefix")
    def file_prefix(self) -> str:
        """
        Required. File name prefix for the generated sprite sheets. Each sprite sheet has an incremental 10-digit zero-padded suffix starting from 0 before the extension, such as `"sprite_sheet0000000123.jpeg"`.
        """
        return pulumi.get(self, "file_prefix")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Format type. The default is `"jpeg"`. Supported formats: - 'jpeg'
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def interval(self) -> str:
        """
        Starting from `0s`, create sprites at regular intervals. Specify the interval value in seconds.
        """
        return pulumi.get(self, "interval")

    @property
    @pulumi.getter
    def quality(self) -> int:
        """
        The quality of the generated sprite sheet. Enter a value between 1 and 100, where 1 is the lowest quality and 100 is the highest quality. The default is 100. A high quality value corresponds to a low image data compression ratio.
        """
        return pulumi.get(self, "quality")

    @property
    @pulumi.getter(name="rowCount")
    def row_count(self) -> int:
        """
        The maximum number of rows per sprite sheet. When the sprite sheet is full, a new sprite sheet is created. The default is 0, which indicates no maximum limit.
        """
        return pulumi.get(self, "row_count")

    @property
    @pulumi.getter(name="spriteHeightPixels")
    def sprite_height_pixels(self) -> int:
        """
        Required. The height of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_height_pixels field or the SpriteSheet.sprite_width_pixels field, but not both (the API will automatically calculate the missing field).
        """
        return pulumi.get(self, "sprite_height_pixels")

    @property
    @pulumi.getter(name="spriteWidthPixels")
    def sprite_width_pixels(self) -> int:
        """
        Required. The width of sprite in pixels. Must be an even integer. To preserve the source aspect ratio, set the SpriteSheet.sprite_width_pixels field or the SpriteSheet.sprite_height_pixels field, but not both (the API will automatically calculate the missing field).
        """
        return pulumi.get(self, "sprite_width_pixels")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> str:
        """
        Start time in seconds, relative to the output file timeline. Determines the first sprite to pick. The default is `0s`.
        """
        return pulumi.get(self, "start_time_offset")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        Total number of sprites. Create the specified number of sprites distributed evenly across the timeline of the output media. The default is 100.
        """
        return pulumi.get(self, "total_count")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TextAtomResponse(dict):
    """
    The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
    """
    def __init__(__self__, *,
                 inputs: Sequence['outputs.TextInputResponse'],
                 key: str):
        """
        The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
        :param Sequence['TextInputResponseArgs'] inputs: List of `Job.inputs` that should be embedded in this atom. Only one input is supported.
        :param str key: Required. The `EditAtom.key` that references atom with text inputs in the `Job.edit_list`.
        """
        pulumi.set(__self__, "inputs", inputs)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def inputs(self) -> Sequence['outputs.TextInputResponse']:
        """
        List of `Job.inputs` that should be embedded in this atom. Only one input is supported.
        """
        return pulumi.get(self, "inputs")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Required. The `EditAtom.key` that references atom with text inputs in the `Job.edit_list`.
        """
        return pulumi.get(self, "key")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TextInputResponse(dict):
    """
    Identifies which input file and track should be used.
    """
    def __init__(__self__, *,
                 key: str,
                 track: int):
        """
        Identifies which input file and track should be used.
        :param str key: Required. The `Input.key` that identifies the input file.
        :param int track: Required. The zero-based index of the track in the input file.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "track", track)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Required. The `Input.key` that identifies the input file.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def track(self) -> int:
        """
        Required. The zero-based index of the track in the input file.
        """
        return pulumi.get(self, "track")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TextStreamResponse(dict):
    """
    Encoding of a text stream. For example, closed captions or subtitles.
    """
    def __init__(__self__, *,
                 codec: str,
                 language_code: str,
                 mapping: Sequence['outputs.TextAtomResponse']):
        """
        Encoding of a text stream. For example, closed captions or subtitles.
        :param str codec: The codec for this text stream. The default is `"webvtt"`. Supported text codecs: - 'srt' - 'ttml' - 'cea608' - 'cea708' - 'webvtt'
        :param str language_code: Required. The BCP-47 language code, such as `"en-US"` or `"sr-Latn"`. For more information, see https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
        :param Sequence['TextAtomResponseArgs'] mapping: The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
        """
        pulumi.set(__self__, "codec", codec)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "mapping", mapping)

    @property
    @pulumi.getter
    def codec(self) -> str:
        """
        The codec for this text stream. The default is `"webvtt"`. Supported text codecs: - 'srt' - 'ttml' - 'cea608' - 'cea708' - 'webvtt'
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Required. The BCP-47 language code, such as `"en-US"` or `"sr-Latn"`. For more information, see https://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def mapping(self) -> Sequence['outputs.TextAtomResponse']:
        """
        The mapping for the `Job.edit_list` atoms with text `EditAtom.inputs`.
        """
        return pulumi.get(self, "mapping")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VideoStreamResponse(dict):
    """
    Video stream resource.
    """
    def __init__(__self__, *,
                 allow_open_gop: bool,
                 aq_strength: float,
                 b_frame_count: int,
                 b_pyramid: bool,
                 bitrate_bps: int,
                 codec: str,
                 crf_level: int,
                 enable_two_pass: bool,
                 entropy_coder: str,
                 frame_rate: float,
                 gop_duration: str,
                 gop_frame_count: int,
                 height_pixels: int,
                 pixel_format: str,
                 preset: str,
                 profile: str,
                 rate_control_mode: str,
                 tune: str,
                 vbv_fullness_bits: int,
                 vbv_size_bits: int,
                 width_pixels: int):
        """
        Video stream resource.
        :param bool allow_open_gop: Specifies whether an open Group of Pictures (GOP) structure should be allowed or not. The default is `false`.
        :param float aq_strength: Specify the intensity of the adaptive quantizer (AQ). Must be between 0 and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A higher value equals a lower bitrate but smoother image. The default is 0.
        :param int b_frame_count: The number of consecutive B-frames. Must be greater than or equal to zero. Must be less than `VideoStream.gop_frame_count` if set. The default is 0.
        :param bool b_pyramid: Allow B-pyramid for reference frame selection. This may not be supported on all decoders. The default is `false`.
        :param int bitrate_bps: Required. The video bitrate in bits per second. Must be between 1 and 1,000,000,000.
        :param str codec: Codec type. The following codecs are supported: * `h264` (default) * `h265` * `vp9`
        :param int crf_level: Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21.
        :param bool enable_two_pass: Use two-pass encoding strategy to achieve better video quality. `VideoStream.rate_control_mode` must be `"vbr"`. The default is `false`.
        :param str entropy_coder: The entropy coder to use. The default is `"cabac"`. Supported entropy coders: - 'cavlc' - 'cabac'
        :param float frame_rate: Required. The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. The following table shows the computed video FPS given the target FPS (in parenthesis) and input FPS (in the first column): ``` | | (30) | (60) | (25) | (50) | |--------|--------|--------|------|------| | 240 | Fail | Fail | Fail | Fail | | 120 | 30 | 60 | 20 | 30 | | 100 | 25 | 50 | 20 | 30 | | 50 | 25 | 50 | 20 | 30 | | 60 | 30 | 60 | 20 | 30 | | 59.94 | 29.97 | 59.94 | 20 | 30 | | 48 | 24 | 48 | 20 | 30 | | 30 | 30 | 30 | 20 | 30 | | 25 | 25 | 25 | 20 | 30 | | 24 | 24 | 24 | 20 | 30 | | 23.976 | 23.976 | 23.976 | 20 | 30 | | 15 | 15 | 15 | 20 | 30 | | 12 | 12 | 12 | 20 | 30 | | 10 | 10 | 10 | 20 | 30 | ```
        :param str gop_duration: Select the GOP size based on the specified duration. The default is `"3s"`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        :param int gop_frame_count: Select the GOP size based on the specified frame count. Must be greater than zero.
        :param int height_pixels: The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        :param str pixel_format: Pixel format to use. The default is `"yuv420p"`. Supported pixel formats: - 'yuv420p' pixel format. - 'yuv422p' pixel format. - 'yuv444p' pixel format. - 'yuv420p10' 10-bit HDR pixel format. - 'yuv422p10' 10-bit HDR pixel format. - 'yuv444p10' 10-bit HDR pixel format. - 'yuv420p12' 12-bit HDR pixel format. - 'yuv422p12' 12-bit HDR pixel format. - 'yuv444p12' 12-bit HDR pixel format.
        :param str preset: Enforces the specified codec preset. The default is `veryfast`. The available options are FFmpeg-compatible. Note that certain values for this field may cause the transcoder to override other fields you set in the `VideoStream` message.
        :param str profile: Enforces the specified codec profile. The following profiles are supported: * `baseline` * `main` * `high` (default) The available options are FFmpeg-compatible. Note that certain values for this field may cause the transcoder to override other fields you set in the `VideoStream` message.
        :param str rate_control_mode: Specify the `rate_control_mode`. The default is `"vbr"`. Supported rate control modes: - 'vbr' - variable bitrate - 'crf' - constant rate factor
        :param str tune: Enforces the specified codec tune. The available options are FFmpeg-compatible. Note that certain values for this field may cause the transcoder to override other fields you set in the `VideoStream` message.
        :param int vbv_fullness_bits: Initial fullness of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to 90% of `VideoStream.vbv_size_bits`.
        :param int vbv_size_bits: Size of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to `VideoStream.bitrate_bps`.
        :param int width_pixels: The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        pulumi.set(__self__, "allow_open_gop", allow_open_gop)
        pulumi.set(__self__, "aq_strength", aq_strength)
        pulumi.set(__self__, "b_frame_count", b_frame_count)
        pulumi.set(__self__, "b_pyramid", b_pyramid)
        pulumi.set(__self__, "bitrate_bps", bitrate_bps)
        pulumi.set(__self__, "codec", codec)
        pulumi.set(__self__, "crf_level", crf_level)
        pulumi.set(__self__, "enable_two_pass", enable_two_pass)
        pulumi.set(__self__, "entropy_coder", entropy_coder)
        pulumi.set(__self__, "frame_rate", frame_rate)
        pulumi.set(__self__, "gop_duration", gop_duration)
        pulumi.set(__self__, "gop_frame_count", gop_frame_count)
        pulumi.set(__self__, "height_pixels", height_pixels)
        pulumi.set(__self__, "pixel_format", pixel_format)
        pulumi.set(__self__, "preset", preset)
        pulumi.set(__self__, "profile", profile)
        pulumi.set(__self__, "rate_control_mode", rate_control_mode)
        pulumi.set(__self__, "tune", tune)
        pulumi.set(__self__, "vbv_fullness_bits", vbv_fullness_bits)
        pulumi.set(__self__, "vbv_size_bits", vbv_size_bits)
        pulumi.set(__self__, "width_pixels", width_pixels)

    @property
    @pulumi.getter(name="allowOpenGop")
    def allow_open_gop(self) -> bool:
        """
        Specifies whether an open Group of Pictures (GOP) structure should be allowed or not. The default is `false`.
        """
        return pulumi.get(self, "allow_open_gop")

    @property
    @pulumi.getter(name="aqStrength")
    def aq_strength(self) -> float:
        """
        Specify the intensity of the adaptive quantizer (AQ). Must be between 0 and 1, where 0 disables the quantizer and 1 maximizes the quantizer. A higher value equals a lower bitrate but smoother image. The default is 0.
        """
        return pulumi.get(self, "aq_strength")

    @property
    @pulumi.getter(name="bFrameCount")
    def b_frame_count(self) -> int:
        """
        The number of consecutive B-frames. Must be greater than or equal to zero. Must be less than `VideoStream.gop_frame_count` if set. The default is 0.
        """
        return pulumi.get(self, "b_frame_count")

    @property
    @pulumi.getter(name="bPyramid")
    def b_pyramid(self) -> bool:
        """
        Allow B-pyramid for reference frame selection. This may not be supported on all decoders. The default is `false`.
        """
        return pulumi.get(self, "b_pyramid")

    @property
    @pulumi.getter(name="bitrateBps")
    def bitrate_bps(self) -> int:
        """
        Required. The video bitrate in bits per second. Must be between 1 and 1,000,000,000.
        """
        return pulumi.get(self, "bitrate_bps")

    @property
    @pulumi.getter
    def codec(self) -> str:
        """
        Codec type. The following codecs are supported: * `h264` (default) * `h265` * `vp9`
        """
        return pulumi.get(self, "codec")

    @property
    @pulumi.getter(name="crfLevel")
    def crf_level(self) -> int:
        """
        Target CRF level. Must be between 10 and 36, where 10 is the highest quality and 36 is the most efficient compression. The default is 21.
        """
        return pulumi.get(self, "crf_level")

    @property
    @pulumi.getter(name="enableTwoPass")
    def enable_two_pass(self) -> bool:
        """
        Use two-pass encoding strategy to achieve better video quality. `VideoStream.rate_control_mode` must be `"vbr"`. The default is `false`.
        """
        return pulumi.get(self, "enable_two_pass")

    @property
    @pulumi.getter(name="entropyCoder")
    def entropy_coder(self) -> str:
        """
        The entropy coder to use. The default is `"cabac"`. Supported entropy coders: - 'cavlc' - 'cabac'
        """
        return pulumi.get(self, "entropy_coder")

    @property
    @pulumi.getter(name="frameRate")
    def frame_rate(self) -> float:
        """
        Required. The target video frame rate in frames per second (FPS). Must be less than or equal to 120. Will default to the input frame rate if larger than the input frame rate. The API will generate an output FPS that is divisible by the input FPS, and smaller or equal to the target FPS. The following table shows the computed video FPS given the target FPS (in parenthesis) and input FPS (in the first column): ``` | | (30) | (60) | (25) | (50) | |--------|--------|--------|------|------| | 240 | Fail | Fail | Fail | Fail | | 120 | 30 | 60 | 20 | 30 | | 100 | 25 | 50 | 20 | 30 | | 50 | 25 | 50 | 20 | 30 | | 60 | 30 | 60 | 20 | 30 | | 59.94 | 29.97 | 59.94 | 20 | 30 | | 48 | 24 | 48 | 20 | 30 | | 30 | 30 | 30 | 20 | 30 | | 25 | 25 | 25 | 20 | 30 | | 24 | 24 | 24 | 20 | 30 | | 23.976 | 23.976 | 23.976 | 20 | 30 | | 15 | 15 | 15 | 20 | 30 | | 12 | 12 | 12 | 20 | 30 | | 10 | 10 | 10 | 20 | 30 | ```
        """
        return pulumi.get(self, "frame_rate")

    @property
    @pulumi.getter(name="gopDuration")
    def gop_duration(self) -> str:
        """
        Select the GOP size based on the specified duration. The default is `"3s"`. Note that `gopDuration` must be less than or equal to [`segmentDuration`](#SegmentSettings), and [`segmentDuration`](#SegmentSettings) must be divisible by `gopDuration`.
        """
        return pulumi.get(self, "gop_duration")

    @property
    @pulumi.getter(name="gopFrameCount")
    def gop_frame_count(self) -> int:
        """
        Select the GOP size based on the specified frame count. Must be greater than zero.
        """
        return pulumi.get(self, "gop_frame_count")

    @property
    @pulumi.getter(name="heightPixels")
    def height_pixels(self) -> int:
        """
        The height of the video in pixels. Must be an even integer. When not specified, the height is adjusted to match the specified width and input aspect ratio. If both are omitted, the input height is used.
        """
        return pulumi.get(self, "height_pixels")

    @property
    @pulumi.getter(name="pixelFormat")
    def pixel_format(self) -> str:
        """
        Pixel format to use. The default is `"yuv420p"`. Supported pixel formats: - 'yuv420p' pixel format. - 'yuv422p' pixel format. - 'yuv444p' pixel format. - 'yuv420p10' 10-bit HDR pixel format. - 'yuv422p10' 10-bit HDR pixel format. - 'yuv444p10' 10-bit HDR pixel format. - 'yuv420p12' 12-bit HDR pixel format. - 'yuv422p12' 12-bit HDR pixel format. - 'yuv444p12' 12-bit HDR pixel format.
        """
        return pulumi.get(self, "pixel_format")

    @property
    @pulumi.getter
    def preset(self) -> str:
        """
        Enforces the specified codec preset. The default is `veryfast`. The available options are FFmpeg-compatible. Note that certain values for this field may cause the transcoder to override other fields you set in the `VideoStream` message.
        """
        return pulumi.get(self, "preset")

    @property
    @pulumi.getter
    def profile(self) -> str:
        """
        Enforces the specified codec profile. The following profiles are supported: * `baseline` * `main` * `high` (default) The available options are FFmpeg-compatible. Note that certain values for this field may cause the transcoder to override other fields you set in the `VideoStream` message.
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="rateControlMode")
    def rate_control_mode(self) -> str:
        """
        Specify the `rate_control_mode`. The default is `"vbr"`. Supported rate control modes: - 'vbr' - variable bitrate - 'crf' - constant rate factor
        """
        return pulumi.get(self, "rate_control_mode")

    @property
    @pulumi.getter
    def tune(self) -> str:
        """
        Enforces the specified codec tune. The available options are FFmpeg-compatible. Note that certain values for this field may cause the transcoder to override other fields you set in the `VideoStream` message.
        """
        return pulumi.get(self, "tune")

    @property
    @pulumi.getter(name="vbvFullnessBits")
    def vbv_fullness_bits(self) -> int:
        """
        Initial fullness of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to 90% of `VideoStream.vbv_size_bits`.
        """
        return pulumi.get(self, "vbv_fullness_bits")

    @property
    @pulumi.getter(name="vbvSizeBits")
    def vbv_size_bits(self) -> int:
        """
        Size of the Video Buffering Verifier (VBV) buffer in bits. Must be greater than zero. The default is equal to `VideoStream.bitrate_bps`.
        """
        return pulumi.get(self, "vbv_size_bits")

    @property
    @pulumi.getter(name="widthPixels")
    def width_pixels(self) -> int:
        """
        The width of the video in pixels. Must be an even integer. When not specified, the width is adjusted to match the specified height and input aspect ratio. If both are omitted, the input width is used.
        """
        return pulumi.get(self, "width_pixels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


