# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AclEntryArgs',
    'BackupConfigurationArgs',
    'BackupRetentionSettingsArgs',
    'DatabaseFlagsArgs',
    'DenyMaintenancePeriodArgs',
    'DiskEncryptionConfigurationArgs',
    'DiskEncryptionStatusArgs',
    'InsightsConfigArgs',
    'IpConfigurationArgs',
    'IpMappingArgs',
    'LocationPreferenceArgs',
    'MaintenanceWindowArgs',
    'MySqlReplicaConfigurationArgs',
    'OnPremisesConfigurationArgs',
    'OperationErrorArgs',
    'ReplicaConfigurationArgs',
    'SettingsArgs',
    'SqlActiveDirectoryConfigArgs',
    'SqlScheduledMaintenanceArgs',
    'SqlServerDatabaseDetailsArgs',
    'SqlServerUserDetailsArgs',
    'SslCertArgs',
]

@pulumi.input_type
class AclEntryArgs:
    def __init__(__self__, *,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        An entry for an Access Control list.
        :param pulumi.Input[str] expiration_time: The time when this access control entry expires in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        :param pulumi.Input[str] kind: This is always *sql#aclEntry*.
        :param pulumi.Input[str] name: Optional. A label to identify this entry.
        :param pulumi.Input[str] value: The allowlisted value for the access control list.
        """
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when this access control entry expires in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#aclEntry*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A label to identify this entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The allowlisted value for the access control list.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class BackupConfigurationArgs:
    def __init__(__self__, *,
                 backup_retention_settings: Optional[pulumi.Input['BackupRetentionSettingsArgs']] = None,
                 binary_log_enabled: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 point_in_time_recovery_enabled: Optional[pulumi.Input[bool]] = None,
                 replication_log_archiving_enabled: Optional[pulumi.Input[bool]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 transaction_log_retention_days: Optional[pulumi.Input[int]] = None):
        """
        Database instance backup configuration.
        :param pulumi.Input['BackupRetentionSettingsArgs'] backup_retention_settings: Backup retention settings.
        :param pulumi.Input[bool] binary_log_enabled: (MySQL only) Whether binary log is enabled. If backup configuration is disabled, binarylog must be disabled as well.
        :param pulumi.Input[bool] enabled: Whether this configuration is enabled.
        :param pulumi.Input[str] kind: This is always *sql#backupConfiguration*.
        :param pulumi.Input[str] location: Location of the backup
        :param pulumi.Input[bool] point_in_time_recovery_enabled: Reserved for future use.
        :param pulumi.Input[bool] replication_log_archiving_enabled: Reserved for future use.
        :param pulumi.Input[str] start_time: Start time for the daily backup configuration in UTC timezone in the 24 hour format - *HH:MM*.
        :param pulumi.Input[int] transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if replication_log_archiving_enabled is not None:
            pulumi.set(__self__, "replication_log_archiving_enabled", replication_log_archiving_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional[pulumi.Input['BackupRetentionSettingsArgs']]:
        """
        Backup retention settings.
        """
        return pulumi.get(self, "backup_retention_settings")

    @backup_retention_settings.setter
    def backup_retention_settings(self, value: Optional[pulumi.Input['BackupRetentionSettingsArgs']]):
        pulumi.set(self, "backup_retention_settings", value)

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (MySQL only) Whether binary log is enabled. If backup configuration is disabled, binarylog must be disabled as well.
        """
        return pulumi.get(self, "binary_log_enabled")

    @binary_log_enabled.setter
    def binary_log_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "binary_log_enabled", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#backupConfiguration*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Location of the backup
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @point_in_time_recovery_enabled.setter
    def point_in_time_recovery_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "point_in_time_recovery_enabled", value)

    @property
    @pulumi.getter(name="replicationLogArchivingEnabled")
    def replication_log_archiving_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Reserved for future use.
        """
        return pulumi.get(self, "replication_log_archiving_enabled")

    @replication_log_archiving_enabled.setter
    def replication_log_archiving_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "replication_log_archiving_enabled", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time for the daily backup configuration in UTC timezone in the 24 hour format - *HH:MM*.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[pulumi.Input[int]]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        return pulumi.get(self, "transaction_log_retention_days")

    @transaction_log_retention_days.setter
    def transaction_log_retention_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "transaction_log_retention_days", value)


@pulumi.input_type
class BackupRetentionSettingsArgs:
    def __init__(__self__, *,
                 retained_backups: Optional[pulumi.Input[int]] = None,
                 retention_unit: Optional[pulumi.Input[str]] = None):
        """
        We currently only support backup retention by specifying the number of backups we will retain.
        :param pulumi.Input[int] retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit is 'COUNT', we will retain this many backups.
        :param pulumi.Input[str] retention_unit: The unit that 'retained_backups' represents.
        """
        if retained_backups is not None:
            pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> Optional[pulumi.Input[int]]:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @retained_backups.setter
    def retained_backups(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retained_backups", value)

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit that 'retained_backups' represents.
        """
        return pulumi.get(self, "retention_unit")

    @retention_unit.setter
    def retention_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "retention_unit", value)


@pulumi.input_type
class DatabaseFlagsArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Database flags for Cloud SQL instances.
        :param pulumi.Input[str] name: The name of the flag. These flags are passed at instance startup, so include both server options and system variables for MySQL. Flags are specified with underscores, not hyphens. For more information, see Configuring Database Flags in the Cloud SQL documentation.
        :param pulumi.Input[str] value: The value of the flag. Booleans are set to *on* for true and *off* for false. This field must be omitted if the flag doesn't take a value.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the flag. These flags are passed at instance startup, so include both server options and system variables for MySQL. Flags are specified with underscores, not hyphens. For more information, see Configuring Database Flags in the Cloud SQL documentation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The value of the flag. Booleans are set to *on* for true and *off* for false. This field must be omitted if the flag doesn't take a value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DenyMaintenancePeriodArgs:
    def __init__(__self__, *,
                 end_date: Optional[pulumi.Input[str]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 time: Optional[pulumi.Input[str]] = None):
        """
        Deny Maintenance Periods. This specifies a date range during when all CSA rollout will be denied.
        :param pulumi.Input[str] end_date: "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param pulumi.Input[str] start_date: "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        :param pulumi.Input[str] time: Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if time is not None:
            pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input[str]]:
        """
        "deny maintenance period" end date. If the year of the end date is empty, the year of the start date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[str]]:
        """
        "deny maintenance period" start date. If the year of the start date is empty, the year of the end date also must be empty. In this case, it means the deny maintenance period recurs every year. The date is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter
    def time(self) -> Optional[pulumi.Input[str]]:
        """
        Time in UTC when the "deny maintenance period" starts on start_date and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time", value)


@pulumi.input_type
class DiskEncryptionConfigurationArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        Disk encryption configuration for an instance.
        :param pulumi.Input[str] kind: This is always *sql#diskEncryptionConfiguration*.
        :param pulumi.Input[str] kms_key_name: Resource name of KMS key for disk encryption
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#diskEncryptionConfiguration*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Resource name of KMS key for disk encryption
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class DiskEncryptionStatusArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 kms_key_version_name: Optional[pulumi.Input[str]] = None):
        """
        Disk encryption status for an instance.
        :param pulumi.Input[str] kind: This is always *sql#diskEncryptionStatus*.
        :param pulumi.Input[str] kms_key_version_name: KMS key version used to encrypt the Cloud SQL instance resource
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if kms_key_version_name is not None:
            pulumi.set(__self__, "kms_key_version_name", kms_key_version_name)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#diskEncryptionStatus*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="kmsKeyVersionName")
    def kms_key_version_name(self) -> Optional[pulumi.Input[str]]:
        """
        KMS key version used to encrypt the Cloud SQL instance resource
        """
        return pulumi.get(self, "kms_key_version_name")

    @kms_key_version_name.setter
    def kms_key_version_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_version_name", value)


@pulumi.input_type
class InsightsConfigArgs:
    def __init__(__self__, *,
                 query_insights_enabled: Optional[pulumi.Input[bool]] = None,
                 query_string_length: Optional[pulumi.Input[int]] = None,
                 record_application_tags: Optional[pulumi.Input[bool]] = None,
                 record_client_address: Optional[pulumi.Input[bool]] = None):
        """
        Insights configuration. This specifies when Cloud SQL Insights feature is enabled and optional configuration.
        :param pulumi.Input[bool] query_insights_enabled: Whether Query Insights feature is enabled.
        :param pulumi.Input[int] query_string_length: Maximum query length stored in bytes. Default value: 1024 bytes. Range: 256-4500 bytes. Query length more than this field value will be truncated to this value. When unset, query length will be the default value. Changing query length will restart the database.
        :param pulumi.Input[bool] record_application_tags: Whether Query Insights will record application tags from query when enabled.
        :param pulumi.Input[bool] record_client_address: Whether Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @query_insights_enabled.setter
    def query_insights_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "query_insights_enabled", value)

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum query length stored in bytes. Default value: 1024 bytes. Range: 256-4500 bytes. Query length more than this field value will be truncated to this value. When unset, query length will be the default value. Changing query length will restart the database.
        """
        return pulumi.get(self, "query_string_length")

    @query_string_length.setter
    def query_string_length(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "query_string_length", value)

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @record_application_tags.setter
    def record_application_tags(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_application_tags", value)

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")

    @record_client_address.setter
    def record_client_address(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "record_client_address", value)


@pulumi.input_type
class IpConfigurationArgs:
    def __init__(__self__, *,
                 authorized_networks: Optional[pulumi.Input[Sequence[pulumi.Input['AclEntryArgs']]]] = None,
                 ipv4_enabled: Optional[pulumi.Input[bool]] = None,
                 private_network: Optional[pulumi.Input[str]] = None,
                 require_ssl: Optional[pulumi.Input[bool]] = None):
        """
        IP Management configuration.
        :param pulumi.Input[Sequence[pulumi.Input['AclEntryArgs']]] authorized_networks: The list of external networks that are allowed to connect to the instance using the IP. In 'CIDR' notation, also known as 'slash' notation (for example: *192.168.100.0/24*).
        :param pulumi.Input[bool] ipv4_enabled: Whether the instance is assigned a public IP address or not.
        :param pulumi.Input[str] private_network: The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, */projects/myProject/global/networks/default*. This setting can be updated, but it cannot be removed after it is set.
        :param pulumi.Input[bool] require_ssl: Whether SSL connections over IP are enforced or not.
        """
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AclEntryArgs']]]]:
        """
        The list of external networks that are allowed to connect to the instance using the IP. In 'CIDR' notation, also known as 'slash' notation (for example: *192.168.100.0/24*).
        """
        return pulumi.get(self, "authorized_networks")

    @authorized_networks.setter
    def authorized_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AclEntryArgs']]]]):
        pulumi.set(self, "authorized_networks", value)

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the instance is assigned a public IP address or not.
        """
        return pulumi.get(self, "ipv4_enabled")

    @ipv4_enabled.setter
    def ipv4_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv4_enabled", value)

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[pulumi.Input[str]]:
        """
        The resource link for the VPC network from which the Cloud SQL instance is accessible for private IP. For example, */projects/myProject/global/networks/default*. This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @private_network.setter
    def private_network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_network", value)

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether SSL connections over IP are enforced or not.
        """
        return pulumi.get(self, "require_ssl")

    @require_ssl.setter
    def require_ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "require_ssl", value)


@pulumi.input_type
class IpMappingArgs:
    def __init__(__self__, *,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 time_to_retire: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Database instance IP Mapping.
        :param pulumi.Input[str] ip_address: The IP address assigned.
        :param pulumi.Input[str] time_to_retire: The due time for this IP to be retired in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*. This field is only available when the IP is scheduled to be retired.
        :param pulumi.Input[str] type: The type of this IP address. A *PRIMARY* address is a public address that can accept incoming connections. A *PRIVATE* address is a private address that can accept incoming connections. An *OUTGOING* address is the source address of connections originating from the instance, if supported.
        """
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address assigned.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[pulumi.Input[str]]:
        """
        The due time for this IP to be retired in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*. This field is only available when the IP is scheduled to be retired.
        """
        return pulumi.get(self, "time_to_retire")

    @time_to_retire.setter
    def time_to_retire(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_to_retire", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of this IP address. A *PRIMARY* address is a public address that can accept incoming connections. A *PRIVATE* address is a private address that can accept incoming connections. An *OUTGOING* address is the source address of connections originating from the instance, if supported.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class LocationPreferenceArgs:
    def __init__(__self__, *,
                 follow_gae_application: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 secondary_zone: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Preferred location. This specifies where a Cloud SQL instance is located, either in a specific Compute Engine zone, or co-located with an App Engine application. Note that if the preferred location is not available, the instance will be located as close as possible within the region. Only one location may be specified.
        :param pulumi.Input[str] follow_gae_application: The App Engine application to follow, it must be in the same region as the Cloud SQL instance.
        :param pulumi.Input[str] kind: This is always *sql#locationPreference*.
        :param pulumi.Input[str] secondary_zone: The preferred Compute Engine zone for the secondary/failover (for example: us-central1-a, us-central1-b, etc.). Reserved for future use.
        :param pulumi.Input[str] zone: The preferred Compute Engine zone (for example: us-central1-a, us-central1-b, etc.).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[pulumi.Input[str]]:
        """
        The App Engine application to follow, it must be in the same region as the Cloud SQL instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @follow_gae_application.setter
    def follow_gae_application(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "follow_gae_application", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#locationPreference*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred Compute Engine zone for the secondary/failover (for example: us-central1-a, us-central1-b, etc.). Reserved for future use.
        """
        return pulumi.get(self, "secondary_zone")

    @secondary_zone.setter
    def secondary_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_zone", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        The preferred Compute Engine zone (for example: us-central1-a, us-central1-b, etc.).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[int]] = None,
                 hour: Optional[pulumi.Input[int]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 update_track: Optional[pulumi.Input[str]] = None):
        """
        Maintenance window. This specifies when a Cloud SQL instance is restarted for system maintenance purposes.
        :param pulumi.Input[int] day: day of week (1-7), starting on Monday.
        :param pulumi.Input[int] hour: hour of day - 0 to 23.
        :param pulumi.Input[str] kind: This is always *sql#maintenanceWindow*.
        :param pulumi.Input[str] update_track: Maintenance timing setting: *canary* (Earlier) or *stable* (Later). Learn more.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[int]]:
        """
        day of week (1-7), starting on Monday.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "day", value)

    @property
    @pulumi.getter
    def hour(self) -> Optional[pulumi.Input[int]]:
        """
        hour of day - 0 to 23.
        """
        return pulumi.get(self, "hour")

    @hour.setter
    def hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "hour", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#maintenanceWindow*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[pulumi.Input[str]]:
        """
        Maintenance timing setting: *canary* (Earlier) or *stable* (Later). Learn more.
        """
        return pulumi.get(self, "update_track")

    @update_track.setter
    def update_track(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_track", value)


@pulumi.input_type
class MySqlReplicaConfigurationArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 connect_retry_interval: Optional[pulumi.Input[int]] = None,
                 dump_file_path: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 master_heartbeat_period: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 ssl_cipher: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None,
                 verify_server_certificate: Optional[pulumi.Input[bool]] = None):
        """
        Read-replica configuration specific to MySQL databases.
        :param pulumi.Input[str] ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param pulumi.Input[str] client_certificate: PEM representation of the replica's x509 certificate.
        :param pulumi.Input[str] client_key: PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        :param pulumi.Input[int] connect_retry_interval: Seconds to wait between connect retries. MySQL's default is 60 seconds.
        :param pulumi.Input[str] dump_file_path: Path to a SQL dump file in Google Cloud Storage from which the replica instance is to be created. The URI is in the form gs://bucketName/fileName. Compressed gzip files (.gz) are also supported. Dumps have the binlog co-ordinates from which replication begins. This can be accomplished by setting --master-data to 1 when using mysqldump.
        :param pulumi.Input[str] kind: This is always *sql#mysqlReplicaConfiguration*.
        :param pulumi.Input[str] master_heartbeat_period: Interval in milliseconds between replication heartbeats.
        :param pulumi.Input[str] password: The password for the replication connection.
        :param pulumi.Input[str] ssl_cipher: A list of permissible ciphers to use for SSL encryption.
        :param pulumi.Input[str] username: The username for the replication connection.
        :param pulumi.Input[bool] verify_server_certificate: Whether or not to check the primary instance's Common Name value in the certificate that it sends during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[pulumi.Input[int]]:
        """
        Seconds to wait between connect retries. MySQL's default is 60 seconds.
        """
        return pulumi.get(self, "connect_retry_interval")

    @connect_retry_interval.setter
    def connect_retry_interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "connect_retry_interval", value)

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to a SQL dump file in Google Cloud Storage from which the replica instance is to be created. The URI is in the form gs://bucketName/fileName. Compressed gzip files (.gz) are also supported. Dumps have the binlog co-ordinates from which replication begins. This can be accomplished by setting --master-data to 1 when using mysqldump.
        """
        return pulumi.get(self, "dump_file_path")

    @dump_file_path.setter
    def dump_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dump_file_path", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#mysqlReplicaConfiguration*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[pulumi.Input[str]]:
        """
        Interval in milliseconds between replication heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @master_heartbeat_period.setter
    def master_heartbeat_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_heartbeat_period", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for the replication connection.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[pulumi.Input[str]]:
        """
        A list of permissible ciphers to use for SSL encryption.
        """
        return pulumi.get(self, "ssl_cipher")

    @ssl_cipher.setter
    def ssl_cipher(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_cipher", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for the replication connection.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not to check the primary instance's Common Name value in the certificate that it sends during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")

    @verify_server_certificate.setter
    def verify_server_certificate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "verify_server_certificate", value)


@pulumi.input_type
class OnPremisesConfigurationArgs:
    def __init__(__self__, *,
                 ca_certificate: Optional[pulumi.Input[str]] = None,
                 client_certificate: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 dump_file_path: Optional[pulumi.Input[str]] = None,
                 host_port: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        On-premises instance configuration.
        :param pulumi.Input[str] ca_certificate: PEM representation of the trusted CA's x509 certificate.
        :param pulumi.Input[str] client_certificate: PEM representation of the replica's x509 certificate.
        :param pulumi.Input[str] client_key: PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        :param pulumi.Input[str] dump_file_path: The dump file to create the Cloud SQL replica.
        :param pulumi.Input[str] host_port: The host and port of the on-premises instance in host:port format
        :param pulumi.Input[str] kind: This is always *sql#onPremisesConfiguration*.
        :param pulumi.Input[str] password: The password for connecting to on-premises instance.
        :param pulumi.Input[str] username: The username for connecting to on-premises instance.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if host_port is not None:
            pulumi.set(__self__, "host_port", host_port)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the trusted CA's x509 certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @ca_certificate.setter
    def ca_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_certificate", value)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's x509 certificate.
        """
        return pulumi.get(self, "client_certificate")

    @client_certificate.setter
    def client_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_certificate", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation of the replica's private key. The corresponsing public key is encoded in the client's certificate.
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[pulumi.Input[str]]:
        """
        The dump file to create the Cloud SQL replica.
        """
        return pulumi.get(self, "dump_file_path")

    @dump_file_path.setter
    def dump_file_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dump_file_path", value)

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> Optional[pulumi.Input[str]]:
        """
        The host and port of the on-premises instance in host:port format
        """
        return pulumi.get(self, "host_port")

    @host_port.setter
    def host_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_port", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#onPremisesConfiguration*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password for connecting to on-premises instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        The username for connecting to on-premises instance.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class OperationErrorArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        Database instance operation error.
        :param pulumi.Input[str] code: Identifies the specific error that occurred.
        :param pulumi.Input[str] kind: This is always *sql#operationError*.
        :param pulumi.Input[str] message: Additional information about the error encountered.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the specific error that occurred.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#operationError*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the error encountered.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class ReplicaConfigurationArgs:
    def __init__(__self__, *,
                 failover_target: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 mysql_replica_configuration: Optional[pulumi.Input['MySqlReplicaConfigurationArgs']] = None):
        """
        Read-replica configuration for connecting to the primary instance.
        :param pulumi.Input[bool] failover_target: Specifies if the replica is the failover target. If the field is set to *true* the replica will be designated as a failover replica. In case the primary instance fails, the replica instance will be promoted as the new primary instance. Only one replica can be specified as failover target, and the replica has to be in different zone with the primary instance.
        :param pulumi.Input[str] kind: This is always *sql#replicaConfiguration*.
        :param pulumi.Input['MySqlReplicaConfigurationArgs'] mysql_replica_configuration: MySQL specific configuration when replicating from a MySQL on-premises primary instance. Replication configuration information such as the username, password, certificates, and keys are not stored in the instance metadata. The configuration information is used only to set up the replication connection and is stored by MySQL in a file named *master.info* in the data directory.
        """
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if mysql_replica_configuration is not None:
            pulumi.set(__self__, "mysql_replica_configuration", mysql_replica_configuration)

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the replica is the failover target. If the field is set to *true* the replica will be designated as a failover replica. In case the primary instance fails, the replica instance will be promoted as the new primary instance. Only one replica can be specified as failover target, and the replica has to be in different zone with the primary instance.
        """
        return pulumi.get(self, "failover_target")

    @failover_target.setter
    def failover_target(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "failover_target", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#replicaConfiguration*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="mysqlReplicaConfiguration")
    def mysql_replica_configuration(self) -> Optional[pulumi.Input['MySqlReplicaConfigurationArgs']]:
        """
        MySQL specific configuration when replicating from a MySQL on-premises primary instance. Replication configuration information such as the username, password, certificates, and keys are not stored in the instance metadata. The configuration information is used only to set up the replication connection and is stored by MySQL in a file named *master.info* in the data directory.
        """
        return pulumi.get(self, "mysql_replica_configuration")

    @mysql_replica_configuration.setter
    def mysql_replica_configuration(self, value: Optional[pulumi.Input['MySqlReplicaConfigurationArgs']]):
        pulumi.set(self, "mysql_replica_configuration", value)


@pulumi.input_type
class SettingsArgs:
    def __init__(__self__, *,
                 activation_policy: Optional[pulumi.Input[str]] = None,
                 active_directory_config: Optional[pulumi.Input['SqlActiveDirectoryConfigArgs']] = None,
                 authorized_gae_applications: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 availability_type: Optional[pulumi.Input[str]] = None,
                 backup_configuration: Optional[pulumi.Input['BackupConfigurationArgs']] = None,
                 collation: Optional[pulumi.Input[str]] = None,
                 crash_safe_replication_enabled: Optional[pulumi.Input[bool]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[str]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 database_flags: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseFlagsArgs']]]] = None,
                 database_replication_enabled: Optional[pulumi.Input[bool]] = None,
                 deny_maintenance_periods: Optional[pulumi.Input[Sequence[pulumi.Input['DenyMaintenancePeriodArgs']]]] = None,
                 insights_config: Optional[pulumi.Input['InsightsConfigArgs']] = None,
                 ip_configuration: Optional[pulumi.Input['IpConfigurationArgs']] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 location_preference: Optional[pulumi.Input['LocationPreferenceArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['MaintenanceWindowArgs']] = None,
                 pricing_plan: Optional[pulumi.Input[str]] = None,
                 replication_type: Optional[pulumi.Input[str]] = None,
                 settings_version: Optional[pulumi.Input[str]] = None,
                 storage_auto_resize: Optional[pulumi.Input[bool]] = None,
                 storage_auto_resize_limit: Optional[pulumi.Input[str]] = None,
                 tier: Optional[pulumi.Input[str]] = None,
                 user_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Database instance settings.
        :param pulumi.Input[str] activation_policy: The activation policy specifies when the instance is activated; it is applicable only when the instance state is RUNNABLE. Valid values: *ALWAYS*: The instance is on, and remains so even in the absence of connection requests. *NEVER*: The instance is off; it is not activated, even if a connection request arrives.
        :param pulumi.Input['SqlActiveDirectoryConfigArgs'] active_directory_config: Active Directory configuration, relevant only for Cloud SQL for SQL Server.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] authorized_gae_applications: The App Engine app IDs that can access this instance. (Deprecated) Applied to First Generation instances only.
        :param pulumi.Input[str] availability_type: Availability type. Potential values: *ZONAL*: The instance serves data from only one zone. Outages in that zone affect data accessibility. *REGIONAL*: The instance can serve data from more than one zone in a region (it is highly available). For more information, see Overview of the High Availability Configuration.
        :param pulumi.Input['BackupConfigurationArgs'] backup_configuration: The daily backup configuration for the instance.
        :param pulumi.Input[str] collation: The name of server Instance collation.
        :param pulumi.Input[bool] crash_safe_replication_enabled: Configuration specific to read replica instances. Indicates whether database flags for crash-safe replication are enabled. This property was only applicable to First Generation instances.
        :param pulumi.Input[str] data_disk_size_gb: The size of data disk, in GB. The data disk size minimum is 10GB.
        :param pulumi.Input[str] data_disk_type: The type of data disk: PD_SSD (default) or PD_HDD. Not used for First Generation instances.
        :param pulumi.Input[Sequence[pulumi.Input['DatabaseFlagsArgs']]] database_flags: The database flags passed to the instance at startup.
        :param pulumi.Input[bool] database_replication_enabled: Configuration specific to read replica instances. Indicates whether replication is enabled or not.
        :param pulumi.Input[Sequence[pulumi.Input['DenyMaintenancePeriodArgs']]] deny_maintenance_periods: Deny maintenance periods
        :param pulumi.Input['InsightsConfigArgs'] insights_config: Insights configuration, for now relevant only for Postgres.
        :param pulumi.Input['IpConfigurationArgs'] ip_configuration: The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled for Second Generation instances.
        :param pulumi.Input[str] kind: This is always *sql#settings*.
        :param pulumi.Input['LocationPreferenceArgs'] location_preference: The location preference settings. This allows the instance to be located as near as possible to either an App Engine app or Compute Engine zone for better performance. App Engine co-location was only applicable to First Generation instances.
        :param pulumi.Input['MaintenanceWindowArgs'] maintenance_window: The maintenance window for this instance. This specifies when the instance can be restarted for maintenance purposes.
        :param pulumi.Input[str] pricing_plan: The pricing plan for this instance. This can be either *PER_USE* or *PACKAGE*. Only *PER_USE* is supported for Second Generation instances.
        :param pulumi.Input[str] replication_type: The type of replication this instance uses. This can be either *ASYNCHRONOUS* or *SYNCHRONOUS*. (Deprecated_ This property was only applicable to First Generation instances.
        :param pulumi.Input[str] settings_version: The version of instance settings. This is a required field for update method to make sure concurrent updates are handled properly. During update, use the most recent settingsVersion value for this instance and do not try to update this value.
        :param pulumi.Input[bool] storage_auto_resize: Configuration to increase storage size automatically. The default value is true.
        :param pulumi.Input[str] storage_auto_resize_limit: The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        :param pulumi.Input[str] tier: The tier (or machine type) for this instance, for example *db-custom-1-3840* .
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] user_labels: User-provided labels, represented as a dictionary where each label is a single key value pair.
        """
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if authorized_gae_applications is not None:
            pulumi.set(__self__, "authorized_gae_applications", authorized_gae_applications)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if crash_safe_replication_enabled is not None:
            pulumi.set(__self__, "crash_safe_replication_enabled", crash_safe_replication_enabled)
        if data_disk_size_gb is not None:
            pulumi.set(__self__, "data_disk_size_gb", data_disk_size_gb)
        if data_disk_type is not None:
            pulumi.set(__self__, "data_disk_type", data_disk_type)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if database_replication_enabled is not None:
            pulumi.set(__self__, "database_replication_enabled", database_replication_enabled)
        if deny_maintenance_periods is not None:
            pulumi.set(__self__, "deny_maintenance_periods", deny_maintenance_periods)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if replication_type is not None:
            pulumi.set(__self__, "replication_type", replication_type)
        if settings_version is not None:
            pulumi.set(__self__, "settings_version", settings_version)
        if storage_auto_resize is not None:
            pulumi.set(__self__, "storage_auto_resize", storage_auto_resize)
        if storage_auto_resize_limit is not None:
            pulumi.set(__self__, "storage_auto_resize_limit", storage_auto_resize_limit)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The activation policy specifies when the instance is activated; it is applicable only when the instance state is RUNNABLE. Valid values: *ALWAYS*: The instance is on, and remains so even in the absence of connection requests. *NEVER*: The instance is off; it is not activated, even if a connection request arrives.
        """
        return pulumi.get(self, "activation_policy")

    @activation_policy.setter
    def activation_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "activation_policy", value)

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional[pulumi.Input['SqlActiveDirectoryConfigArgs']]:
        """
        Active Directory configuration, relevant only for Cloud SQL for SQL Server.
        """
        return pulumi.get(self, "active_directory_config")

    @active_directory_config.setter
    def active_directory_config(self, value: Optional[pulumi.Input['SqlActiveDirectoryConfigArgs']]):
        pulumi.set(self, "active_directory_config", value)

    @property
    @pulumi.getter(name="authorizedGaeApplications")
    def authorized_gae_applications(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The App Engine app IDs that can access this instance. (Deprecated) Applied to First Generation instances only.
        """
        return pulumi.get(self, "authorized_gae_applications")

    @authorized_gae_applications.setter
    def authorized_gae_applications(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "authorized_gae_applications", value)

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[pulumi.Input[str]]:
        """
        Availability type. Potential values: *ZONAL*: The instance serves data from only one zone. Outages in that zone affect data accessibility. *REGIONAL*: The instance can serve data from more than one zone in a region (it is highly available). For more information, see Overview of the High Availability Configuration.
        """
        return pulumi.get(self, "availability_type")

    @availability_type.setter
    def availability_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_type", value)

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional[pulumi.Input['BackupConfigurationArgs']]:
        """
        The daily backup configuration for the instance.
        """
        return pulumi.get(self, "backup_configuration")

    @backup_configuration.setter
    def backup_configuration(self, value: Optional[pulumi.Input['BackupConfigurationArgs']]):
        pulumi.set(self, "backup_configuration", value)

    @property
    @pulumi.getter
    def collation(self) -> Optional[pulumi.Input[str]]:
        """
        The name of server Instance collation.
        """
        return pulumi.get(self, "collation")

    @collation.setter
    def collation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collation", value)

    @property
    @pulumi.getter(name="crashSafeReplicationEnabled")
    def crash_safe_replication_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Configuration specific to read replica instances. Indicates whether database flags for crash-safe replication are enabled. This property was only applicable to First Generation instances.
        """
        return pulumi.get(self, "crash_safe_replication_enabled")

    @crash_safe_replication_enabled.setter
    def crash_safe_replication_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "crash_safe_replication_enabled", value)

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> Optional[pulumi.Input[str]]:
        """
        The size of data disk, in GB. The data disk size minimum is 10GB.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @data_disk_size_gb.setter
    def data_disk_size_gb(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_size_gb", value)

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of data disk: PD_SSD (default) or PD_HDD. Not used for First Generation instances.
        """
        return pulumi.get(self, "data_disk_type")

    @data_disk_type.setter
    def data_disk_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_disk_type", value)

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseFlagsArgs']]]]:
        """
        The database flags passed to the instance at startup.
        """
        return pulumi.get(self, "database_flags")

    @database_flags.setter
    def database_flags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DatabaseFlagsArgs']]]]):
        pulumi.set(self, "database_flags", value)

    @property
    @pulumi.getter(name="databaseReplicationEnabled")
    def database_replication_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Configuration specific to read replica instances. Indicates whether replication is enabled or not.
        """
        return pulumi.get(self, "database_replication_enabled")

    @database_replication_enabled.setter
    def database_replication_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "database_replication_enabled", value)

    @property
    @pulumi.getter(name="denyMaintenancePeriods")
    def deny_maintenance_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DenyMaintenancePeriodArgs']]]]:
        """
        Deny maintenance periods
        """
        return pulumi.get(self, "deny_maintenance_periods")

    @deny_maintenance_periods.setter
    def deny_maintenance_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DenyMaintenancePeriodArgs']]]]):
        pulumi.set(self, "deny_maintenance_periods", value)

    @property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional[pulumi.Input['InsightsConfigArgs']]:
        """
        Insights configuration, for now relevant only for Postgres.
        """
        return pulumi.get(self, "insights_config")

    @insights_config.setter
    def insights_config(self, value: Optional[pulumi.Input['InsightsConfigArgs']]):
        pulumi.set(self, "insights_config", value)

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional[pulumi.Input['IpConfigurationArgs']]:
        """
        The settings for IP Management. This allows to enable or disable the instance IP and manage which external networks can connect to the instance. The IPv4 address cannot be disabled for Second Generation instances.
        """
        return pulumi.get(self, "ip_configuration")

    @ip_configuration.setter
    def ip_configuration(self, value: Optional[pulumi.Input['IpConfigurationArgs']]):
        pulumi.set(self, "ip_configuration", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#settings*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional[pulumi.Input['LocationPreferenceArgs']]:
        """
        The location preference settings. This allows the instance to be located as near as possible to either an App Engine app or Compute Engine zone for better performance. App Engine co-location was only applicable to First Generation instances.
        """
        return pulumi.get(self, "location_preference")

    @location_preference.setter
    def location_preference(self, value: Optional[pulumi.Input['LocationPreferenceArgs']]):
        pulumi.set(self, "location_preference", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MaintenanceWindowArgs']]:
        """
        The maintenance window for this instance. This specifies when the instance can be restarted for maintenance purposes.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[pulumi.Input[str]]:
        """
        The pricing plan for this instance. This can be either *PER_USE* or *PACKAGE*. Only *PER_USE* is supported for Second Generation instances.
        """
        return pulumi.get(self, "pricing_plan")

    @pricing_plan.setter
    def pricing_plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pricing_plan", value)

    @property
    @pulumi.getter(name="replicationType")
    def replication_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of replication this instance uses. This can be either *ASYNCHRONOUS* or *SYNCHRONOUS*. (Deprecated_ This property was only applicable to First Generation instances.
        """
        return pulumi.get(self, "replication_type")

    @replication_type.setter
    def replication_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "replication_type", value)

    @property
    @pulumi.getter(name="settingsVersion")
    def settings_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of instance settings. This is a required field for update method to make sure concurrent updates are handled properly. During update, use the most recent settingsVersion value for this instance and do not try to update this value.
        """
        return pulumi.get(self, "settings_version")

    @settings_version.setter
    def settings_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "settings_version", value)

    @property
    @pulumi.getter(name="storageAutoResize")
    def storage_auto_resize(self) -> Optional[pulumi.Input[bool]]:
        """
        Configuration to increase storage size automatically. The default value is true.
        """
        return pulumi.get(self, "storage_auto_resize")

    @storage_auto_resize.setter
    def storage_auto_resize(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storage_auto_resize", value)

    @property
    @pulumi.getter(name="storageAutoResizeLimit")
    def storage_auto_resize_limit(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum size to which storage capacity can be automatically increased. The default value is 0, which specifies that there is no limit.
        """
        return pulumi.get(self, "storage_auto_resize_limit")

    @storage_auto_resize_limit.setter
    def storage_auto_resize_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_auto_resize_limit", value)

    @property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[str]]:
        """
        The tier (or machine type) for this instance, for example *db-custom-1-3840* .
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tier", value)

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-provided labels, represented as a dictionary where each label is a single key value pair.
        """
        return pulumi.get(self, "user_labels")

    @user_labels.setter
    def user_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "user_labels", value)


@pulumi.input_type
class SqlActiveDirectoryConfigArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None):
        """
        Active Directory configuration, relevant only for Cloud SQL for SQL Server.
        :param pulumi.Input[str] domain: The name of the domain (e.g., mydomain.com).
        :param pulumi.Input[str] kind: This is always sql#activeDirectoryConfig.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the domain (e.g., mydomain.com).
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always sql#activeDirectoryConfig.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)


@pulumi.input_type
class SqlScheduledMaintenanceArgs:
    def __init__(__self__, *,
                 can_defer: Optional[pulumi.Input[bool]] = None,
                 can_reschedule: Optional[pulumi.Input[bool]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        Any scheduled maintenancce for this instance.
        :param pulumi.Input[bool] can_reschedule: If the scheduled maintenance can be rescheduled.
        :param pulumi.Input[str] start_time: The start time of any upcoming scheduled maintenance for this instance.
        """
        if can_defer is not None:
            pulumi.set(__self__, "can_defer", can_defer)
        if can_reschedule is not None:
            pulumi.set(__self__, "can_reschedule", can_reschedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="canDefer")
    def can_defer(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "can_defer")

    @can_defer.setter
    def can_defer(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_defer", value)

    @property
    @pulumi.getter(name="canReschedule")
    def can_reschedule(self) -> Optional[pulumi.Input[bool]]:
        """
        If the scheduled maintenance can be rescheduled.
        """
        return pulumi.get(self, "can_reschedule")

    @can_reschedule.setter
    def can_reschedule(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "can_reschedule", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of any upcoming scheduled maintenance for this instance.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class SqlServerDatabaseDetailsArgs:
    def __init__(__self__, *,
                 compatibility_level: Optional[pulumi.Input[int]] = None,
                 recovery_model: Optional[pulumi.Input[str]] = None):
        """
        Represents a Sql Server database on the Cloud SQL instance.
        :param pulumi.Input[int] compatibility_level: The version of SQL Server with which the database is to be made compatible
        :param pulumi.Input[str] recovery_model: The recovery model of a SQL Server database
        """
        if compatibility_level is not None:
            pulumi.set(__self__, "compatibility_level", compatibility_level)
        if recovery_model is not None:
            pulumi.set(__self__, "recovery_model", recovery_model)

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> Optional[pulumi.Input[int]]:
        """
        The version of SQL Server with which the database is to be made compatible
        """
        return pulumi.get(self, "compatibility_level")

    @compatibility_level.setter
    def compatibility_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "compatibility_level", value)

    @property
    @pulumi.getter(name="recoveryModel")
    def recovery_model(self) -> Optional[pulumi.Input[str]]:
        """
        The recovery model of a SQL Server database
        """
        return pulumi.get(self, "recovery_model")

    @recovery_model.setter
    def recovery_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recovery_model", value)


@pulumi.input_type
class SqlServerUserDetailsArgs:
    def __init__(__self__, *,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 server_roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents a Sql Server user on the Cloud SQL instance.
        :param pulumi.Input[bool] disabled: If the user has been disabled
        :param pulumi.Input[Sequence[pulumi.Input[str]]] server_roles: The server roles for this user
        """
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[pulumi.Input[bool]]:
        """
        If the user has been disabled
        """
        return pulumi.get(self, "disabled")

    @disabled.setter
    def disabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disabled", value)

    @property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The server roles for this user
        """
        return pulumi.get(self, "server_roles")

    @server_roles.setter
    def server_roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "server_roles", value)


@pulumi.input_type
class SslCertArgs:
    def __init__(__self__, *,
                 cert: Optional[pulumi.Input[str]] = None,
                 cert_serial_number: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 expiration_time: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 sha1_fingerprint: Optional[pulumi.Input[str]] = None):
        """
        SslCerts Resource
        :param pulumi.Input[str] cert: PEM representation.
        :param pulumi.Input[str] cert_serial_number: Serial number, as extracted from the certificate.
        :param pulumi.Input[str] common_name: User supplied name. Constrained to [a-zA-Z.-_ ]+.
        :param pulumi.Input[str] create_time: The time when the certificate was created in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*
        :param pulumi.Input[str] expiration_time: The time when the certificate expires in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        :param pulumi.Input[str] instance: Name of the database instance.
        :param pulumi.Input[str] kind: This is always *sql#sslCert*.
        :param pulumi.Input[str] self_link: The URI of this resource.
        :param pulumi.Input[str] sha1_fingerprint: Sha1 Fingerprint.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if cert_serial_number is not None:
            pulumi.set(__self__, "cert_serial_number", cert_serial_number)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[pulumi.Input[str]]:
        """
        PEM representation.
        """
        return pulumi.get(self, "cert")

    @cert.setter
    def cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert", value)

    @property
    @pulumi.getter(name="certSerialNumber")
    def cert_serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        Serial number, as extracted from the certificate.
        """
        return pulumi.get(self, "cert_serial_number")

    @cert_serial_number.setter
    def cert_serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_serial_number", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        User supplied name. Constrained to [a-zA-Z.-_ ]+.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the certificate was created in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the certificate expires in RFC 3339 format, for example *2012-11-15T16:19:00.094Z*.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expiration_time", value)

    @property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database instance.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        This is always *sql#sslCert*.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of this resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Sha1 Fingerprint.
        """
        return pulumi.get(self, "sha1_fingerprint")

    @sha1_fingerprint.setter
    def sha1_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha1_fingerprint", value)


