# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Runtime']


class Runtime(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_config: Optional[pulumi.Input[pulumi.InputType['RuntimeAccessConfigArgs']]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 runtimes_id: Optional[pulumi.Input[str]] = None,
                 software_config: Optional[pulumi.Input[pulumi.InputType['RuntimeSoftwareConfigArgs']]] = None,
                 virtual_machine: Optional[pulumi.Input[pulumi.InputType['VirtualMachineArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new Runtime in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RuntimeAccessConfigArgs']] access_config: The config settings for accessing runtime.
        :param pulumi.Input[pulumi.InputType['RuntimeSoftwareConfigArgs']] software_config: The config settings for software inside the runtime.
        :param pulumi.Input[pulumi.InputType['VirtualMachineArgs']] virtual_machine: Use a Compute Engine VM image to start the managed notebook instance.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['access_config'] = access_config
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__['locations_id'] = locations_id
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            if runtimes_id is None and not opts.urn:
                raise TypeError("Missing required property 'runtimes_id'")
            __props__['runtimes_id'] = runtimes_id
            __props__['software_config'] = software_config
            __props__['virtual_machine'] = virtual_machine
            __props__['create_time'] = None
            __props__['health_state'] = None
            __props__['metrics'] = None
            __props__['name'] = None
            __props__['state'] = None
            __props__['update_time'] = None
        super(Runtime, __self__).__init__(
            'gcp-native:notebooks/v1:Runtime',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Runtime':
        """
        Get an existing Runtime resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["access_config"] = None
        __props__["create_time"] = None
        __props__["health_state"] = None
        __props__["metrics"] = None
        __props__["name"] = None
        __props__["software_config"] = None
        __props__["state"] = None
        __props__["update_time"] = None
        __props__["virtual_machine"] = None
        return Runtime(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessConfig")
    def access_config(self) -> pulumi.Output['outputs.RuntimeAccessConfigResponse']:
        """
        The config settings for accessing runtime.
        """
        return pulumi.get(self, "access_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Runtime creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="healthState")
    def health_state(self) -> pulumi.Output[str]:
        """
        Runtime health_state.
        """
        return pulumi.get(self, "health_state")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output['outputs.RuntimeMetricsResponse']:
        """
        Contains Runtime daemon metrics such as Service status and JupyterLab stats.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the runtime. Format: `projects/{project}/locations/{location}/runtimes/{runtime}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> pulumi.Output['outputs.RuntimeSoftwareConfigResponse']:
        """
        The config settings for software inside the runtime.
        """
        return pulumi.get(self, "software_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Runtime state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Runtime update time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="virtualMachine")
    def virtual_machine(self) -> pulumi.Output['outputs.VirtualMachineResponse']:
        """
        Use a Compute Engine VM image to start the managed notebook instance.
        """
        return pulumi.get(self, "virtual_machine")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

