# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Instance']


class Instance(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerator_config: Optional[pulumi.Input[pulumi.InputType['AcceleratorConfigArgs']]] = None,
                 boot_disk_size_gb: Optional[pulumi.Input[str]] = None,
                 boot_disk_type: Optional[pulumi.Input[str]] = None,
                 container_image: Optional[pulumi.Input[pulumi.InputType['ContainerImageArgs']]] = None,
                 custom_gpu_driver_path: Optional[pulumi.Input[str]] = None,
                 data_disk_size_gb: Optional[pulumi.Input[str]] = None,
                 data_disk_type: Optional[pulumi.Input[str]] = None,
                 disk_encryption: Optional[pulumi.Input[str]] = None,
                 install_gpu_driver: Optional[pulumi.Input[bool]] = None,
                 instance_owners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 instances_id: Optional[pulumi.Input[str]] = None,
                 kms_key: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 no_proxy_access: Optional[pulumi.Input[bool]] = None,
                 no_public_ip: Optional[pulumi.Input[bool]] = None,
                 no_remove_data_disk: Optional[pulumi.Input[bool]] = None,
                 post_startup_script: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 service_account_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['ShieldedInstanceConfigArgs']]] = None,
                 subnet: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 upgrade_history: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UpgradeHistoryEntryArgs']]]]] = None,
                 vm_image: Optional[pulumi.Input[pulumi.InputType['VmImageArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new Instance in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AcceleratorConfigArgs']] accelerator_config: The hardware accelerator used on this instance. If you use accelerators, make sure that your configuration has [enough vCPUs and memory to support the `machine_type` you have selected](/compute/docs/gpus/#gpus-list).
        :param pulumi.Input[str] boot_disk_size_gb: Input only. The size of the boot disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not specified, this defaults to 100.
        :param pulumi.Input[str] boot_disk_type: Input only. The type of the boot disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        :param pulumi.Input[pulumi.InputType['ContainerImageArgs']] container_image: Use a container image to start the notebook instance.
        :param pulumi.Input[str] custom_gpu_driver_path: Specify a custom Cloud Storage path where the GPU driver is stored. If not specified, we'll automatically choose from official GPU drivers.
        :param pulumi.Input[str] data_disk_size_gb: Input only. The size of the data disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB). You can choose the size of the data disk based on how big your notebooks and data are. If not specified, this defaults to 100.
        :param pulumi.Input[str] data_disk_type: Input only. The type of the data disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        :param pulumi.Input[str] disk_encryption: Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
        :param pulumi.Input[bool] install_gpu_driver: Whether the end user authorizes Google Cloud to install GPU driver on this instance. If this field is empty or set to false, the GPU driver won't be installed. Only applicable to instances with GPUs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] instance_owners: Input only. The owner of this instance after creation. Format: `alias@example.com` Currently supports one owner only. If not specified, all of the service account users of your VM instance's service account can use the instance.
        :param pulumi.Input[str] kms_key: Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}` Learn more about [using your own encryption keys](/kms/docs/quickstart).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
        :param pulumi.Input[str] machine_type: Required. The [Compute Engine machine type](/compute/docs/machine-types) of this instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Custom metadata to apply to this instance.
        :param pulumi.Input[str] network: The name of the VPC that this instance is in. Format: `projects/{project_id}/global/networks/{network_id}`
        :param pulumi.Input[bool] no_proxy_access: If true, the notebook instance will not register with the proxy.
        :param pulumi.Input[bool] no_public_ip: If true, no public IP will be assigned to this instance.
        :param pulumi.Input[bool] no_remove_data_disk: Input only. If true, the data disk will not be auto deleted when deleting the instance.
        :param pulumi.Input[str] post_startup_script: Path to a Bash script that automatically runs after a notebook instance fully boots up. The path must be a URL or Cloud Storage path (gs://path-to-file/file-name).
        :param pulumi.Input[str] service_account: The service account on this instance, giving access to other Google Cloud services. You can use any service account within the same project, but you must have the service account user permission to use the instance. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances. If not specified, the following [scopes](https://cloud.google.com/compute/docs/access/service-accounts#accesscopesiam) are defined: - https://www.googleapis.com/auth/cloud-platform - https://www.googleapis.com/auth/userinfo.email If not using default scopes, you need at least: https://www.googleapis.com/auth/compute
        :param pulumi.Input[pulumi.InputType['ShieldedInstanceConfigArgs']] shielded_instance_config: Optional. Shielded VM configuration. [Images using supported Shielded VM features] (https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
        :param pulumi.Input[str] subnet: The name of the subnet that this instance is in. Format: `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Optional. The Compute Engine tags to add to runtime (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['UpgradeHistoryEntryArgs']]]] upgrade_history: The upgrade history of this instance.
        :param pulumi.Input[pulumi.InputType['VmImageArgs']] vm_image: Use a Compute Engine VM image to start the notebook instance.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['accelerator_config'] = accelerator_config
            __props__['boot_disk_size_gb'] = boot_disk_size_gb
            __props__['boot_disk_type'] = boot_disk_type
            __props__['container_image'] = container_image
            __props__['custom_gpu_driver_path'] = custom_gpu_driver_path
            __props__['data_disk_size_gb'] = data_disk_size_gb
            __props__['data_disk_type'] = data_disk_type
            __props__['disk_encryption'] = disk_encryption
            __props__['install_gpu_driver'] = install_gpu_driver
            __props__['instance_owners'] = instance_owners
            if instances_id is None and not opts.urn:
                raise TypeError("Missing required property 'instances_id'")
            __props__['instances_id'] = instances_id
            __props__['kms_key'] = kms_key
            __props__['labels'] = labels
            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__['locations_id'] = locations_id
            __props__['machine_type'] = machine_type
            __props__['metadata'] = metadata
            __props__['network'] = network
            __props__['no_proxy_access'] = no_proxy_access
            __props__['no_public_ip'] = no_public_ip
            __props__['no_remove_data_disk'] = no_remove_data_disk
            __props__['post_startup_script'] = post_startup_script
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            __props__['service_account'] = service_account
            __props__['service_account_scopes'] = service_account_scopes
            __props__['shielded_instance_config'] = shielded_instance_config
            __props__['subnet'] = subnet
            __props__['tags'] = tags
            __props__['upgrade_history'] = upgrade_history
            __props__['vm_image'] = vm_image
            __props__['create_time'] = None
            __props__['disks'] = None
            __props__['name'] = None
            __props__['proxy_uri'] = None
            __props__['state'] = None
            __props__['update_time'] = None
        super(Instance, __self__).__init__(
            'gcp-native:notebooks/v1:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accelerator_config"] = None
        __props__["boot_disk_size_gb"] = None
        __props__["boot_disk_type"] = None
        __props__["container_image"] = None
        __props__["create_time"] = None
        __props__["custom_gpu_driver_path"] = None
        __props__["data_disk_size_gb"] = None
        __props__["data_disk_type"] = None
        __props__["disk_encryption"] = None
        __props__["disks"] = None
        __props__["install_gpu_driver"] = None
        __props__["instance_owners"] = None
        __props__["kms_key"] = None
        __props__["labels"] = None
        __props__["machine_type"] = None
        __props__["metadata"] = None
        __props__["name"] = None
        __props__["network"] = None
        __props__["no_proxy_access"] = None
        __props__["no_public_ip"] = None
        __props__["no_remove_data_disk"] = None
        __props__["post_startup_script"] = None
        __props__["proxy_uri"] = None
        __props__["service_account"] = None
        __props__["service_account_scopes"] = None
        __props__["shielded_instance_config"] = None
        __props__["state"] = None
        __props__["subnet"] = None
        __props__["tags"] = None
        __props__["update_time"] = None
        __props__["upgrade_history"] = None
        __props__["vm_image"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="acceleratorConfig")
    def accelerator_config(self) -> pulumi.Output['outputs.AcceleratorConfigResponse']:
        """
        The hardware accelerator used on this instance. If you use accelerators, make sure that your configuration has [enough vCPUs and memory to support the `machine_type` you have selected](/compute/docs/gpus/#gpus-list).
        """
        return pulumi.get(self, "accelerator_config")

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> pulumi.Output[str]:
        """
        Input only. The size of the boot disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB). The minimum recommended value is 100 GB. If not specified, this defaults to 100.
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> pulumi.Output[str]:
        """
        Input only. The type of the boot disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> pulumi.Output['outputs.ContainerImageResponse']:
        """
        Use a container image to start the notebook instance.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Instance creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customGpuDriverPath")
    def custom_gpu_driver_path(self) -> pulumi.Output[str]:
        """
        Specify a custom Cloud Storage path where the GPU driver is stored. If not specified, we'll automatically choose from official GPU drivers.
        """
        return pulumi.get(self, "custom_gpu_driver_path")

    @property
    @pulumi.getter(name="dataDiskSizeGb")
    def data_disk_size_gb(self) -> pulumi.Output[str]:
        """
        Input only. The size of the data disk in GB attached to this instance, up to a maximum of 64000 GB (64 TB). You can choose the size of the data disk based on how big your notebooks and data are. If not specified, this defaults to 100.
        """
        return pulumi.get(self, "data_disk_size_gb")

    @property
    @pulumi.getter(name="dataDiskType")
    def data_disk_type(self) -> pulumi.Output[str]:
        """
        Input only. The type of the data disk attached to this instance, defaults to standard persistent disk (`PD_STANDARD`).
        """
        return pulumi.get(self, "data_disk_type")

    @property
    @pulumi.getter(name="diskEncryption")
    def disk_encryption(self) -> pulumi.Output[str]:
        """
        Input only. Disk encryption method used on the boot and data disks, defaults to GMEK.
        """
        return pulumi.get(self, "disk_encryption")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Sequence['outputs.DiskResponse']]:
        """
        Attached disks to notebook instance.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="installGpuDriver")
    def install_gpu_driver(self) -> pulumi.Output[bool]:
        """
        Whether the end user authorizes Google Cloud to install GPU driver on this instance. If this field is empty or set to false, the GPU driver won't be installed. Only applicable to instances with GPUs.
        """
        return pulumi.get(self, "install_gpu_driver")

    @property
    @pulumi.getter(name="instanceOwners")
    def instance_owners(self) -> pulumi.Output[Sequence[str]]:
        """
        Input only. The owner of this instance after creation. Format: `alias@example.com` Currently supports one owner only. If not specified, all of the service account users of your VM instance's service account can use the instance.
        """
        return pulumi.get(self, "instance_owners")

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> pulumi.Output[str]:
        """
        Input only. The KMS key used to encrypt the disks, only applicable if disk_encryption is CMEK. Format: `projects/{project_id}/locations/{location}/keyRings/{key_ring_id}/cryptoKeys/{key_id}` Learn more about [using your own encryption keys](/kms/docs/quickstart).
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels to apply to this instance. These can be later modified by the setLabels method.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        Required. The [Compute Engine machine type](/compute/docs/machine-types) of this instance.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Custom metadata to apply to this instance.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of this notebook instance. Format: `projects/{project_id}/locations/{location}/instances/{instance_id}`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The name of the VPC that this instance is in. Format: `projects/{project_id}/global/networks/{network_id}`
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="noProxyAccess")
    def no_proxy_access(self) -> pulumi.Output[bool]:
        """
        If true, the notebook instance will not register with the proxy.
        """
        return pulumi.get(self, "no_proxy_access")

    @property
    @pulumi.getter(name="noPublicIp")
    def no_public_ip(self) -> pulumi.Output[bool]:
        """
        If true, no public IP will be assigned to this instance.
        """
        return pulumi.get(self, "no_public_ip")

    @property
    @pulumi.getter(name="noRemoveDataDisk")
    def no_remove_data_disk(self) -> pulumi.Output[bool]:
        """
        Input only. If true, the data disk will not be auto deleted when deleting the instance.
        """
        return pulumi.get(self, "no_remove_data_disk")

    @property
    @pulumi.getter(name="postStartupScript")
    def post_startup_script(self) -> pulumi.Output[str]:
        """
        Path to a Bash script that automatically runs after a notebook instance fully boots up. The path must be a URL or Cloud Storage path (gs://path-to-file/file-name).
        """
        return pulumi.get(self, "post_startup_script")

    @property
    @pulumi.getter(name="proxyUri")
    def proxy_uri(self) -> pulumi.Output[str]:
        """
        The proxy endpoint that is used to access the Jupyter notebook.
        """
        return pulumi.get(self, "proxy_uri")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[str]:
        """
        The service account on this instance, giving access to other Google Cloud services. You can use any service account within the same project, but you must have the service account user permission to use the instance. If not specified, the [Compute Engine default service account](https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances. If not specified, the following [scopes](https://cloud.google.com/compute/docs/access/service-accounts#accesscopesiam) are defined: - https://www.googleapis.com/auth/cloud-platform - https://www.googleapis.com/auth/userinfo.email If not using default scopes, you need at least: https://www.googleapis.com/auth/compute
        """
        return pulumi.get(self, "service_account_scopes")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.ShieldedInstanceConfigResponse']:
        """
        Optional. Shielded VM configuration. [Images using supported Shielded VM features] (https://cloud.google.com/compute/docs/instances/modifying-shielded-vm).
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of this instance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[str]:
        """
        The name of the subnet that this instance is in. Format: `projects/{project_id}/regions/{region}/subnetworks/{subnetwork_id}`
        """
        return pulumi.get(self, "subnet")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. The Compute Engine tags to add to runtime (see [Tagging instances](https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Instance update time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="upgradeHistory")
    def upgrade_history(self) -> pulumi.Output[Sequence['outputs.UpgradeHistoryEntryResponse']]:
        """
        The upgrade history of this instance.
        """
        return pulumi.get(self, "upgrade_history")

    @property
    @pulumi.getter(name="vmImage")
    def vm_image(self) -> pulumi.Output['outputs.VmImageResponse']:
        """
        Use a Compute Engine VM image to start the notebook instance.
        """
        return pulumi.get(self, "vm_image")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

