# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['SiteDomain']


class SiteDomain(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 domain_redirect: Optional[pulumi.Input[pulumi.InputType['DomainRedirectArgs']]] = None,
                 domains_id: Optional[pulumi.Input[str]] = None,
                 provisioning: Optional[pulumi.Input[pulumi.InputType['DomainProvisioningArgs']]] = None,
                 site: Optional[pulumi.Input[str]] = None,
                 sites_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a domain mapping on the specified site.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] domain_name: Required. The domain name of the association.
        :param pulumi.Input[pulumi.InputType['DomainRedirectArgs']] domain_redirect: If set, the domain should redirect with the provided parameters.
        :param pulumi.Input[pulumi.InputType['DomainProvisioningArgs']] provisioning: Information about the provisioning of certificates and the health of the DNS resolution for the domain.
        :param pulumi.Input[str] site: Required. The site name of the association.
        :param pulumi.Input[str] status: Additional status of the domain association.
        :param pulumi.Input[str] update_time: The time at which the domain was last updated.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['domain_name'] = domain_name
            __props__['domain_redirect'] = domain_redirect
            if domains_id is None and not opts.urn:
                raise TypeError("Missing required property 'domains_id'")
            __props__['domains_id'] = domains_id
            __props__['provisioning'] = provisioning
            __props__['site'] = site
            if sites_id is None and not opts.urn:
                raise TypeError("Missing required property 'sites_id'")
            __props__['sites_id'] = sites_id
            __props__['status'] = status
            __props__['update_time'] = update_time
        super(SiteDomain, __self__).__init__(
            'gcp-native:firebasehosting/v1beta1:SiteDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SiteDomain':
        """
        Get an existing SiteDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["domain_name"] = None
        __props__["domain_redirect"] = None
        __props__["provisioning"] = None
        __props__["site"] = None
        __props__["status"] = None
        __props__["update_time"] = None
        return SiteDomain(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        Required. The domain name of the association.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="domainRedirect")
    def domain_redirect(self) -> pulumi.Output['outputs.DomainRedirectResponse']:
        """
        If set, the domain should redirect with the provided parameters.
        """
        return pulumi.get(self, "domain_redirect")

    @property
    @pulumi.getter
    def provisioning(self) -> pulumi.Output['outputs.DomainProvisioningResponse']:
        """
        Information about the provisioning of certificates and the health of the DNS resolution for the domain.
        """
        return pulumi.get(self, "provisioning")

    @property
    @pulumi.getter
    def site(self) -> pulumi.Output[str]:
        """
        Required. The site name of the association.
        """
        return pulumi.get(self, "site")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Additional status of the domain association.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time at which the domain was last updated.
        """
        return pulumi.get(self, "update_time")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

