# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from ._inputs import *

__all__ = ['SiteChannelRelease']


class SiteChannelRelease(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 channels_id: Optional[pulumi.Input[str]] = None,
                 message: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 release_time: Optional[pulumi.Input[str]] = None,
                 release_user: Optional[pulumi.Input[pulumi.InputType['ActingUserArgs']]] = None,
                 sites_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[pulumi.InputType['VersionArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new release, which makes the content of the specified version actively display on the appropriate URL(s).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] message: The deploy description when the release was created. The value can be up to 512 characters.
        :param pulumi.Input[str] name: The unique identifier for the release, in either of the following formats: - sites/SITE_ID/releases/RELEASE_ID - sites/SITE_ID/channels/CHANNEL_ID/releases/RELEASE_ID This name is provided in the response body when you call [`releases.create`](sites.releases/create) or [`channels.releases.create`](sites.channels.releases/create).
        :param pulumi.Input[str] release_time: The time at which the version is set to be public.
        :param pulumi.Input[pulumi.InputType['ActingUserArgs']] release_user: Identifies the user who created the release.
        :param pulumi.Input[str] type: Explains the reason for the release. Specify a value for this field only when creating a `SITE_DISABLE` type release.
        :param pulumi.Input[pulumi.InputType['VersionArgs']] version: The configuration and content that was released.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if channels_id is None and not opts.urn:
                raise TypeError("Missing required property 'channels_id'")
            __props__['channels_id'] = channels_id
            __props__['message'] = message
            __props__['name'] = name
            __props__['release_time'] = release_time
            __props__['release_user'] = release_user
            if sites_id is None and not opts.urn:
                raise TypeError("Missing required property 'sites_id'")
            __props__['sites_id'] = sites_id
            __props__['type'] = type
            __props__['version'] = version
        super(SiteChannelRelease, __self__).__init__(
            'gcp-native:firebasehosting/v1beta1:SiteChannelRelease',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SiteChannelRelease':
        """
        Get an existing SiteChannelRelease resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        return SiteChannelRelease(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

