# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'ActingUserArgs',
    'CertDnsChallengeArgs',
    'CertHttpChallengeArgs',
    'CloudRunRewriteArgs',
    'DomainProvisioningArgs',
    'DomainRedirectArgs',
    'HeaderArgs',
    'I18nConfigArgs',
    'PreviewConfigArgs',
    'RedirectArgs',
    'RewriteArgs',
    'ServingConfigArgs',
    'VersionArgs',
]

@pulumi.input_type
class ActingUserArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None,
                 image_url: Optional[pulumi.Input[str]] = None):
        """
        Contains metadata about the user who performed an action, such as creating a release or finalizing a version.
        :param pulumi.Input[str] email: The email address of the user when the user performed the action.
        :param pulumi.Input[str] image_url: A profile image URL for the user. May not be present if the user has changed their email address or deleted their account.
        """
        if email is not None:
            pulumi.set(__self__, "email", email)
        if image_url is not None:
            pulumi.set(__self__, "image_url", image_url)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The email address of the user when the user performed the action.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> Optional[pulumi.Input[str]]:
        """
        A profile image URL for the user. May not be present if the user has changed their email address or deleted their account.
        """
        return pulumi.get(self, "image_url")

    @image_url.setter
    def image_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_url", value)


@pulumi.input_type
class CertDnsChallengeArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Represents a DNS certificate challenge.
        :param pulumi.Input[str] domain_name: The domain name upon which the DNS challenge must be satisfied.
        :param pulumi.Input[str] token: The value that must be present as a TXT record on the domain name to satisfy the challenge.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name upon which the DNS challenge must be satisfied.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The value that must be present as a TXT record on the domain name to satisfy the challenge.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class CertHttpChallengeArgs:
    def __init__(__self__, *,
                 path: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Represents an HTTP certificate challenge.
        :param pulumi.Input[str] path: The URL path on which to serve the specified token to satisfy the certificate challenge.
        :param pulumi.Input[str] token: The token to serve at the specified URL path to satisfy the certificate challenge.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL path on which to serve the specified token to satisfy the certificate challenge.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The token to serve at the specified URL path to satisfy the certificate challenge.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class CloudRunRewriteArgs:
    def __init__(__self__, *,
                 region: Optional[pulumi.Input[str]] = None,
                 service_id: Optional[pulumi.Input[str]] = None):
        """
        A configured rewrite that directs requests to a Cloud Run service. If the Cloud Run service does not exist when setting or updating your Firebase Hosting configuration, then the request fails. Any errors from the Cloud Run service are passed to the end user (for example, if you delete a service, any requests directed to that service receive a `404` error).
        :param pulumi.Input[str] region: Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        :param pulumi.Input[str] service_id: Required. User-defined ID of the Cloud Run service.
        """
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_id is not None:
            pulumi.set(__self__, "service_id", service_id)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User-provided region where the Cloud Run service is hosted. Defaults to `us-central1` if not supplied.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. User-defined ID of the Cloud Run service.
        """
        return pulumi.get(self, "service_id")

    @service_id.setter
    def service_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_id", value)


@pulumi.input_type
class DomainProvisioningArgs:
    def __init__(__self__, *,
                 cert_challenge_discovered_txt: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cert_challenge_dns: Optional[pulumi.Input['CertDnsChallengeArgs']] = None,
                 cert_challenge_http: Optional[pulumi.Input['CertHttpChallengeArgs']] = None,
                 cert_status: Optional[pulumi.Input[str]] = None,
                 discovered_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dns_fetch_time: Optional[pulumi.Input[str]] = None,
                 dns_status: Optional[pulumi.Input[str]] = None,
                 expected_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The current certificate provisioning status information for a domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cert_challenge_discovered_txt: The TXT records (for the certificate challenge) that were found at the last DNS fetch.
        :param pulumi.Input['CertDnsChallengeArgs'] cert_challenge_dns: The DNS challenge for generating a certificate.
        :param pulumi.Input['CertHttpChallengeArgs'] cert_challenge_http: The HTTP challenge for generating a certificate.
        :param pulumi.Input[str] cert_status: The certificate provisioning status; updated when Firebase Hosting provisions an SSL certificate for the domain.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] discovered_ips: The IPs found at the last DNS fetch.
        :param pulumi.Input[str] dns_fetch_time: The time at which the last DNS fetch occurred.
        :param pulumi.Input[str] dns_status: The DNS record match status as of the last DNS fetch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] expected_ips: The list of IPs to which the domain is expected to resolve.
        """
        if cert_challenge_discovered_txt is not None:
            pulumi.set(__self__, "cert_challenge_discovered_txt", cert_challenge_discovered_txt)
        if cert_challenge_dns is not None:
            pulumi.set(__self__, "cert_challenge_dns", cert_challenge_dns)
        if cert_challenge_http is not None:
            pulumi.set(__self__, "cert_challenge_http", cert_challenge_http)
        if cert_status is not None:
            pulumi.set(__self__, "cert_status", cert_status)
        if discovered_ips is not None:
            pulumi.set(__self__, "discovered_ips", discovered_ips)
        if dns_fetch_time is not None:
            pulumi.set(__self__, "dns_fetch_time", dns_fetch_time)
        if dns_status is not None:
            pulumi.set(__self__, "dns_status", dns_status)
        if expected_ips is not None:
            pulumi.set(__self__, "expected_ips", expected_ips)

    @property
    @pulumi.getter(name="certChallengeDiscoveredTxt")
    def cert_challenge_discovered_txt(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The TXT records (for the certificate challenge) that were found at the last DNS fetch.
        """
        return pulumi.get(self, "cert_challenge_discovered_txt")

    @cert_challenge_discovered_txt.setter
    def cert_challenge_discovered_txt(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cert_challenge_discovered_txt", value)

    @property
    @pulumi.getter(name="certChallengeDns")
    def cert_challenge_dns(self) -> Optional[pulumi.Input['CertDnsChallengeArgs']]:
        """
        The DNS challenge for generating a certificate.
        """
        return pulumi.get(self, "cert_challenge_dns")

    @cert_challenge_dns.setter
    def cert_challenge_dns(self, value: Optional[pulumi.Input['CertDnsChallengeArgs']]):
        pulumi.set(self, "cert_challenge_dns", value)

    @property
    @pulumi.getter(name="certChallengeHttp")
    def cert_challenge_http(self) -> Optional[pulumi.Input['CertHttpChallengeArgs']]:
        """
        The HTTP challenge for generating a certificate.
        """
        return pulumi.get(self, "cert_challenge_http")

    @cert_challenge_http.setter
    def cert_challenge_http(self, value: Optional[pulumi.Input['CertHttpChallengeArgs']]):
        pulumi.set(self, "cert_challenge_http", value)

    @property
    @pulumi.getter(name="certStatus")
    def cert_status(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate provisioning status; updated when Firebase Hosting provisions an SSL certificate for the domain.
        """
        return pulumi.get(self, "cert_status")

    @cert_status.setter
    def cert_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_status", value)

    @property
    @pulumi.getter(name="discoveredIps")
    def discovered_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The IPs found at the last DNS fetch.
        """
        return pulumi.get(self, "discovered_ips")

    @discovered_ips.setter
    def discovered_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "discovered_ips", value)

    @property
    @pulumi.getter(name="dnsFetchTime")
    def dns_fetch_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the last DNS fetch occurred.
        """
        return pulumi.get(self, "dns_fetch_time")

    @dns_fetch_time.setter
    def dns_fetch_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_fetch_time", value)

    @property
    @pulumi.getter(name="dnsStatus")
    def dns_status(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS record match status as of the last DNS fetch.
        """
        return pulumi.get(self, "dns_status")

    @dns_status.setter
    def dns_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_status", value)

    @property
    @pulumi.getter(name="expectedIps")
    def expected_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of IPs to which the domain is expected to resolve.
        """
        return pulumi.get(self, "expected_ips")

    @expected_ips.setter
    def expected_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "expected_ips", value)


@pulumi.input_type
class DomainRedirectArgs:
    def __init__(__self__, *,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Defines the behavior of a domain-level redirect. Domain redirects preserve the path of the redirect but replace the requested domain with the one specified in the redirect configuration.
        :param pulumi.Input[str] domain_name: Required. The domain name to redirect to.
        :param pulumi.Input[str] type: Required. The redirect status code.
        """
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The domain name to redirect to.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The redirect status code.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class HeaderArgs:
    def __init__(__self__, *,
                 glob: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 regex: Optional[pulumi.Input[str]] = None):
        """
        A [`Header`](https://firebase.google.com/docs/hosting/full-config#headers) specifies a URL pattern that, if matched to the request URL path, triggers Hosting to apply the specified custom response headers.
        :param pulumi.Input[str] glob: The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] headers: Required. The additional headers to add to the response.
        :param pulumi.Input[str] regex: The user-supplied RE2 regular expression to match against the request URL path.
        """
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def glob(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @glob.setter
    def glob(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glob", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Required. The additional headers to add to the response.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class I18nConfigArgs:
    def __init__(__self__, *,
                 root: Optional[pulumi.Input[str]] = None):
        """
        If provided, i18n rewrites are enabled.
        :param pulumi.Input[str] root: Required. The user-supplied path where country and language specific content will be looked for within the public directory.
        """
        if root is not None:
            pulumi.set(__self__, "root", root)

    @property
    @pulumi.getter
    def root(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The user-supplied path where country and language specific content will be looked for within the public directory.
        """
        return pulumi.get(self, "root")

    @root.setter
    def root(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root", value)


@pulumi.input_type
class PreviewConfigArgs:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 expire_time: Optional[pulumi.Input[str]] = None):
        """
        Deprecated in favor of [site channels](sites.channels).
        :param pulumi.Input[bool] active: If true, preview URLs are enabled for this version.
        :param pulumi.Input[str] expire_time: Indicates the expiration time for previewing this version; preview URL requests received after this time will 404.
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, preview URLs are enabled for this version.
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the expiration time for previewing this version; preview URL requests received after this time will 404.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)


@pulumi.input_type
class RedirectArgs:
    def __init__(__self__, *,
                 glob: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None,
                 status_code: Optional[pulumi.Input[int]] = None):
        """
        A [`Redirect`](https://firebase.google.com/docs/hosting/full-config#redirects) specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond with a redirect to the specified destination path.
        :param pulumi.Input[str] glob: The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        :param pulumi.Input[str] location: Required. The value to put in the HTTP location header of the response. The location can contain capture group values from the pattern using a `:` prefix to identify the segment and an optional `*` to capture the rest of the URL. For example: "glob": "/:capture*", "statusCode": 301, "location": "https://example.com/foo/:capture"
        :param pulumi.Input[str] regex: The user-supplied RE2 regular expression to match against the request URL path.
        :param pulumi.Input[int] status_code: Required. The status HTTP code to return in the response. It must be a valid 3xx status code.
        """
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if status_code is not None:
            pulumi.set(__self__, "status_code", status_code)

    @property
    @pulumi.getter
    def glob(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @glob.setter
    def glob(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glob", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The value to put in the HTTP location header of the response. The location can contain capture group values from the pattern using a `:` prefix to identify the segment and an optional `*` to capture the rest of the URL. For example: "glob": "/:capture*", "statusCode": 301, "location": "https://example.com/foo/:capture"
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter(name="statusCode")
    def status_code(self) -> Optional[pulumi.Input[int]]:
        """
        Required. The status HTTP code to return in the response. It must be a valid 3xx status code.
        """
        return pulumi.get(self, "status_code")

    @status_code.setter
    def status_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "status_code", value)


@pulumi.input_type
class RewriteArgs:
    def __init__(__self__, *,
                 dynamic_links: Optional[pulumi.Input[bool]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 glob: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None,
                 run: Optional[pulumi.Input['CloudRunRewriteArgs']] = None):
        """
        A [`Rewrite`](https://firebase.google.com/docs/hosting/full-config#rewrites) specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        :param pulumi.Input[bool] dynamic_links: The request will be forwarded to Firebase Dynamic Links.
        :param pulumi.Input[str] function: The function to proxy requests to. Must match the exported function name exactly.
        :param pulumi.Input[str] glob: The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        :param pulumi.Input[str] path: The URL path to rewrite the request to.
        :param pulumi.Input[str] regex: The user-supplied RE2 regular expression to match against the request URL path.
        :param pulumi.Input['CloudRunRewriteArgs'] run: The request will be forwarded to Cloud Run.
        """
        if dynamic_links is not None:
            pulumi.set(__self__, "dynamic_links", dynamic_links)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if glob is not None:
            pulumi.set(__self__, "glob", glob)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)
        if run is not None:
            pulumi.set(__self__, "run", run)

    @property
    @pulumi.getter(name="dynamicLinks")
    def dynamic_links(self) -> Optional[pulumi.Input[bool]]:
        """
        The request will be forwarded to Firebase Dynamic Links.
        """
        return pulumi.get(self, "dynamic_links")

    @dynamic_links.setter
    def dynamic_links(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dynamic_links", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        The function to proxy requests to. Must match the exported function name exactly.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def glob(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied [glob](https://firebase.google.com/docs/hosting/full-config#glob_pattern_matching) to match against the request URL path.
        """
        return pulumi.get(self, "glob")

    @glob.setter
    def glob(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "glob", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The URL path to rewrite the request to.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        The user-supplied RE2 regular expression to match against the request URL path.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)

    @property
    @pulumi.getter
    def run(self) -> Optional[pulumi.Input['CloudRunRewriteArgs']]:
        """
        The request will be forwarded to Cloud Run.
        """
        return pulumi.get(self, "run")

    @run.setter
    def run(self, value: Optional[pulumi.Input['CloudRunRewriteArgs']]):
        pulumi.set(self, "run", value)


@pulumi.input_type
class ServingConfigArgs:
    def __init__(__self__, *,
                 app_association: Optional[pulumi.Input[str]] = None,
                 clean_urls: Optional[pulumi.Input[bool]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]]] = None,
                 i18n: Optional[pulumi.Input['I18nConfigArgs']] = None,
                 redirects: Optional[pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]]] = None,
                 rewrites: Optional[pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]]] = None,
                 trailing_slash_behavior: Optional[pulumi.Input[str]] = None):
        """
        The configuration for how incoming requests to a site should be routed and processed before serving content. The URL request paths are matched against the specified URL patterns in the configuration, then Hosting applies the applicable configuration according to a specific [priority order](https://firebase.google.com/docs/hosting/full-config#hosting_priority_order).
        :param pulumi.Input[str] app_association: How to handle well known App Association files.
        :param pulumi.Input[bool] clean_urls: Defines whether to drop the file extension from uploaded files.
        :param pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]] headers: An array of objects, where each object specifies a URL pattern that, if matched to the request URL path, triggers Hosting to apply the specified custom response headers.
        :param pulumi.Input['I18nConfigArgs'] i18n: Optional. Defines i18n rewrite behavior.
        :param pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]] redirects: An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond with a redirect to the specified destination path.
        :param pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]] rewrites: An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        :param pulumi.Input[str] trailing_slash_behavior: Defines how to handle a trailing slash in the URL path.
        """
        if app_association is not None:
            pulumi.set(__self__, "app_association", app_association)
        if clean_urls is not None:
            pulumi.set(__self__, "clean_urls", clean_urls)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if i18n is not None:
            pulumi.set(__self__, "i18n", i18n)
        if redirects is not None:
            pulumi.set(__self__, "redirects", redirects)
        if rewrites is not None:
            pulumi.set(__self__, "rewrites", rewrites)
        if trailing_slash_behavior is not None:
            pulumi.set(__self__, "trailing_slash_behavior", trailing_slash_behavior)

    @property
    @pulumi.getter(name="appAssociation")
    def app_association(self) -> Optional[pulumi.Input[str]]:
        """
        How to handle well known App Association files.
        """
        return pulumi.get(self, "app_association")

    @app_association.setter
    def app_association(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_association", value)

    @property
    @pulumi.getter(name="cleanUrls")
    def clean_urls(self) -> Optional[pulumi.Input[bool]]:
        """
        Defines whether to drop the file extension from uploaded files.
        """
        return pulumi.get(self, "clean_urls")

    @clean_urls.setter
    def clean_urls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "clean_urls", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]]]:
        """
        An array of objects, where each object specifies a URL pattern that, if matched to the request URL path, triggers Hosting to apply the specified custom response headers.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter
    def i18n(self) -> Optional[pulumi.Input['I18nConfigArgs']]:
        """
        Optional. Defines i18n rewrite behavior.
        """
        return pulumi.get(self, "i18n")

    @i18n.setter
    def i18n(self, value: Optional[pulumi.Input['I18nConfigArgs']]):
        pulumi.set(self, "i18n", value)

    @property
    @pulumi.getter
    def redirects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]]]:
        """
        An array of objects (called redirect rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond with a redirect to the specified destination path.
        """
        return pulumi.get(self, "redirects")

    @redirects.setter
    def redirects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedirectArgs']]]]):
        pulumi.set(self, "redirects", value)

    @property
    @pulumi.getter
    def rewrites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]]]:
        """
        An array of objects (called rewrite rules), where each rule specifies a URL pattern that, if matched to the request URL path, triggers Hosting to respond as if the service were given the specified destination URL.
        """
        return pulumi.get(self, "rewrites")

    @rewrites.setter
    def rewrites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RewriteArgs']]]]):
        pulumi.set(self, "rewrites", value)

    @property
    @pulumi.getter(name="trailingSlashBehavior")
    def trailing_slash_behavior(self) -> Optional[pulumi.Input[str]]:
        """
        Defines how to handle a trailing slash in the URL path.
        """
        return pulumi.get(self, "trailing_slash_behavior")

    @trailing_slash_behavior.setter
    def trailing_slash_behavior(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trailing_slash_behavior", value)


@pulumi.input_type
class VersionArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['ServingConfigArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 create_user: Optional[pulumi.Input['ActingUserArgs']] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 delete_user: Optional[pulumi.Input['ActingUserArgs']] = None,
                 file_count: Optional[pulumi.Input[str]] = None,
                 finalize_time: Optional[pulumi.Input[str]] = None,
                 finalize_user: Optional[pulumi.Input['ActingUserArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preview: Optional[pulumi.Input['PreviewConfigArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version_bytes: Optional[pulumi.Input[str]] = None):
        """
        A `Version` is a configuration and a collection of static files which determine how a site is displayed.
        :param pulumi.Input['ServingConfigArgs'] config: The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        :param pulumi.Input[str] create_time: The time at which the version was created.
        :param pulumi.Input['ActingUserArgs'] create_user: Identifies the user who created the version.
        :param pulumi.Input[str] delete_time: The time at which the version was `DELETED`.
        :param pulumi.Input['ActingUserArgs'] delete_user: Identifies the user who `DELETED` the version.
        :param pulumi.Input[str] file_count: The total number of files associated with the version. This value is calculated after a version is `FINALIZED`.
        :param pulumi.Input[str] finalize_time: The time at which the version was `FINALIZED`.
        :param pulumi.Input['ActingUserArgs'] finalize_user: Identifies the user who `FINALIZED` the version.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels used for extra metadata and/or filtering.
        :param pulumi.Input[str] name: The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        :param pulumi.Input['PreviewConfigArgs'] preview: Deprecated in favor of [site channels](sites.channels).
        :param pulumi.Input[str] status: The deploy status of the version. For a successful deploy, call [`CreateVersion`](sites.versions/create) to make a new version (`CREATED` status), [upload all desired files](sites.versions/populateFiles) to the version, then [update](sites.versions/patch) the version to the `FINALIZED` status. Note that if you leave the version in the `CREATED` state for more than 12 hours, the system will automatically mark the version as `ABANDONED`. You can also change the status of a version to `DELETED` by calling [`DeleteVersion`](sites.versions/delete).
        :param pulumi.Input[str] version_bytes: The total stored bytesize of the version. This value is calculated after a version is `FINALIZED`.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if create_user is not None:
            pulumi.set(__self__, "create_user", create_user)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if delete_user is not None:
            pulumi.set(__self__, "delete_user", delete_user)
        if file_count is not None:
            pulumi.set(__self__, "file_count", file_count)
        if finalize_time is not None:
            pulumi.set(__self__, "finalize_time", finalize_time)
        if finalize_user is not None:
            pulumi.set(__self__, "finalize_user", finalize_user)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if preview is not None:
            pulumi.set(__self__, "preview", preview)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version_bytes is not None:
            pulumi.set(__self__, "version_bytes", version_bytes)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ServingConfigArgs']]:
        """
        The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ServingConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the version was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="createUser")
    def create_user(self) -> Optional[pulumi.Input['ActingUserArgs']]:
        """
        Identifies the user who created the version.
        """
        return pulumi.get(self, "create_user")

    @create_user.setter
    def create_user(self, value: Optional[pulumi.Input['ActingUserArgs']]):
        pulumi.set(self, "create_user", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the version was `DELETED`.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter(name="deleteUser")
    def delete_user(self) -> Optional[pulumi.Input['ActingUserArgs']]:
        """
        Identifies the user who `DELETED` the version.
        """
        return pulumi.get(self, "delete_user")

    @delete_user.setter
    def delete_user(self, value: Optional[pulumi.Input['ActingUserArgs']]):
        pulumi.set(self, "delete_user", value)

    @property
    @pulumi.getter(name="fileCount")
    def file_count(self) -> Optional[pulumi.Input[str]]:
        """
        The total number of files associated with the version. This value is calculated after a version is `FINALIZED`.
        """
        return pulumi.get(self, "file_count")

    @file_count.setter
    def file_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_count", value)

    @property
    @pulumi.getter(name="finalizeTime")
    def finalize_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the version was `FINALIZED`.
        """
        return pulumi.get(self, "finalize_time")

    @finalize_time.setter
    def finalize_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "finalize_time", value)

    @property
    @pulumi.getter(name="finalizeUser")
    def finalize_user(self) -> Optional[pulumi.Input['ActingUserArgs']]:
        """
        Identifies the user who `FINALIZED` the version.
        """
        return pulumi.get(self, "finalize_user")

    @finalize_user.setter
    def finalize_user(self, value: Optional[pulumi.Input['ActingUserArgs']]):
        pulumi.set(self, "finalize_user", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The labels used for extra metadata and/or filtering.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def preview(self) -> Optional[pulumi.Input['PreviewConfigArgs']]:
        """
        Deprecated in favor of [site channels](sites.channels).
        """
        return pulumi.get(self, "preview")

    @preview.setter
    def preview(self, value: Optional[pulumi.Input['PreviewConfigArgs']]):
        pulumi.set(self, "preview", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The deploy status of the version. For a successful deploy, call [`CreateVersion`](sites.versions/create) to make a new version (`CREATED` status), [upload all desired files](sites.versions/populateFiles) to the version, then [update](sites.versions/patch) the version to the `FINALIZED` status. Note that if you leave the version in the `CREATED` state for more than 12 hours, the system will automatically mark the version as `ABANDONED`. You can also change the status of a version to `DELETED` by calling [`DeleteVersion`](sites.versions/delete).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="versionBytes")
    def version_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        The total stored bytesize of the version. This value is calculated after a version is `FINALIZED`.
        """
        return pulumi.get(self, "version_bytes")

    @version_bytes.setter
    def version_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version_bytes", value)


