# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ResponsePolicyRule']


class ResponsePolicyRule(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 behavior: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 local_data: Optional[pulumi.Input[pulumi.InputType['ResponsePolicyRuleLocalDataArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 response_policy: Optional[pulumi.Input[str]] = None,
                 response_policy_rule: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new Response Policy Rule.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] behavior: Answer this query with a behavior rather than DNS data.
        :param pulumi.Input[str] dns_name: The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        :param pulumi.Input[pulumi.InputType['ResponsePolicyRuleLocalDataArgs']] local_data: Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name; in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
        :param pulumi.Input[str] rule_name: An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['behavior'] = behavior
            __props__['dns_name'] = dns_name
            __props__['kind'] = kind
            __props__['local_data'] = local_data
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if response_policy is None and not opts.urn:
                raise TypeError("Missing required property 'response_policy'")
            __props__['response_policy'] = response_policy
            if response_policy_rule is None and not opts.urn:
                raise TypeError("Missing required property 'response_policy_rule'")
            __props__['response_policy_rule'] = response_policy_rule
            __props__['rule_name'] = rule_name
        super(ResponsePolicyRule, __self__).__init__(
            'gcp-native:dns/v1beta2:ResponsePolicyRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ResponsePolicyRule':
        """
        Get an existing ResponsePolicyRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["behavior"] = None
        __props__["dns_name"] = None
        __props__["kind"] = None
        __props__["local_data"] = None
        __props__["rule_name"] = None
        return ResponsePolicyRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def behavior(self) -> pulumi.Output[str]:
        """
        Answer this query with a behavior rather than DNS data.
        """
        return pulumi.get(self, "behavior")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name (wildcard or exact) to apply this rule to. Must be unique within the Response Policy Rule.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="localData")
    def local_data(self) -> pulumi.Output['outputs.ResponsePolicyRuleLocalDataResponse']:
        """
        Answer this query directly with DNS data. These ResourceRecordSets override any other DNS behavior for the matched name; in particular they override private zones, the public internet, and GCP internal DNS. No SOA nor NS types are allowed.
        """
        return pulumi.get(self, "local_data")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        """
        An identifier for this rule. Must be unique with the ResponsePolicy.
        """
        return pulumi.get(self, "rule_name")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

