# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'GoogleCloudDialogflowV2AutomatedAgentConfigArgs',
    'GoogleCloudDialogflowV2ContextArgs',
    'GoogleCloudDialogflowV2EntityTypeEntityArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs',
    'GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettingsArgs',
    'GoogleCloudDialogflowV2HumanAgentHandoffConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfigArgs',
    'GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs',
    'GoogleCloudDialogflowV2IntentFollowupIntentInfoArgs',
    'GoogleCloudDialogflowV2IntentMessageArgs',
    'GoogleCloudDialogflowV2IntentMessageBasicCardArgs',
    'GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs',
    'GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriActionArgs',
    'GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardArgs',
    'GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs',
    'GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs',
    'GoogleCloudDialogflowV2IntentMessageCardArgs',
    'GoogleCloudDialogflowV2IntentMessageCardButtonArgs',
    'GoogleCloudDialogflowV2IntentMessageCarouselSelectArgs',
    'GoogleCloudDialogflowV2IntentMessageCarouselSelectItemArgs',
    'GoogleCloudDialogflowV2IntentMessageColumnPropertiesArgs',
    'GoogleCloudDialogflowV2IntentMessageImageArgs',
    'GoogleCloudDialogflowV2IntentMessageLinkOutSuggestionArgs',
    'GoogleCloudDialogflowV2IntentMessageListSelectArgs',
    'GoogleCloudDialogflowV2IntentMessageListSelectItemArgs',
    'GoogleCloudDialogflowV2IntentMessageMediaContentArgs',
    'GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObjectArgs',
    'GoogleCloudDialogflowV2IntentMessageQuickRepliesArgs',
    'GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs',
    'GoogleCloudDialogflowV2IntentMessageSimpleResponseArgs',
    'GoogleCloudDialogflowV2IntentMessageSimpleResponsesArgs',
    'GoogleCloudDialogflowV2IntentMessageSuggestionArgs',
    'GoogleCloudDialogflowV2IntentMessageSuggestionsArgs',
    'GoogleCloudDialogflowV2IntentMessageTableCardArgs',
    'GoogleCloudDialogflowV2IntentMessageTableCardCellArgs',
    'GoogleCloudDialogflowV2IntentMessageTableCardRowArgs',
    'GoogleCloudDialogflowV2IntentMessageTextArgs',
    'GoogleCloudDialogflowV2IntentParameterArgs',
    'GoogleCloudDialogflowV2IntentTrainingPhraseArgs',
    'GoogleCloudDialogflowV2IntentTrainingPhrasePartArgs',
    'GoogleCloudDialogflowV2LoggingConfigArgs',
    'GoogleCloudDialogflowV2NotificationConfigArgs',
    'GoogleCloudDialogflowV2SpeechToTextConfigArgs',
    'GoogleCloudDialogflowV2SuggestionFeatureArgs',
]

@pulumi.input_type
class GoogleCloudDialogflowV2AutomatedAgentConfigArgs:
    def __init__(__self__, *,
                 agent: Optional[pulumi.Input[str]] = None):
        """
        Defines the Automated Agent to connect to a conversation.
        :param pulumi.Input[str] agent: Required. ID of the Dialogflow agent environment to use. This project needs to either be the same project as the conversation or you need to grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API Service Agent` role in this project. Format: `projects//locations//agent/environments/`. If environment is not specified, the default `draft` environment is used. Refer to [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest) for more details.
        """
        if agent is not None:
            pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> Optional[pulumi.Input[str]]:
        """
        Required. ID of the Dialogflow agent environment to use. This project needs to either be the same project as the conversation or you need to grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow API Service Agent` role in this project. Format: `projects//locations//agent/environments/`. If environment is not specified, the default `draft` environment is used. Refer to [DetectIntentRequest](/dialogflow/docs/reference/rpc/google.cloud.dialogflow.v2#google.cloud.dialogflow.v2.DetectIntentRequest) for more details.
        """
        return pulumi.get(self, "agent")

    @agent.setter
    def agent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent", value)


@pulumi.input_type
class GoogleCloudDialogflowV2ContextArgs:
    def __init__(__self__, *,
                 lifespan_count: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Dialogflow contexts are similar to natural language context. If a person says to you "they are orange", you need context in order to understand what "they" is referring to. Similarly, for Dialogflow to handle an end-user expression like that, it needs to be provided with context in order to correctly match an intent. Using contexts, you can control the flow of a conversation. You can configure contexts for an intent by setting input and output contexts, which are identified by string names. When an intent is matched, any configured output contexts for that intent become active. While any contexts are active, Dialogflow is more likely to match intents that are configured with input contexts that correspond to the currently active contexts. For more information about context, see the [Contexts guide](https://cloud.google.com/dialogflow/docs/contexts-overview).
        :param pulumi.Input[int] lifespan_count: Optional. The number of conversational query requests after which the context expires. The default is `0`. If set to `0`, the context expires immediately. Contexts expire automatically after 20 minutes if there are no matching queries.
        :param pulumi.Input[str] name: Required. The unique identifier of the context. Format: `projects//agent/sessions//contexts/`, or `projects//agent/environments//users//sessions//contexts/`. The `Context ID` is always converted to lowercase, may only contain characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If `Environment ID` is not specified, we assume default 'draft' environment. If `User ID` is not specified, we assume default '-' user. The following context names are reserved for internal use by Dialogflow. You should not use these contexts or create contexts with these names: * `__system_counters__` * `*_id_dialog_context` * `*_dialog_params_size`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] parameters: Optional. The collection of parameters associated with this context. Depending on your protocol or client library language, this is a map, associative array, symbol table, dictionary, or JSON object composed of a collection of (MapKey, MapValue) pairs: - MapKey type: string - MapKey value: parameter name - MapValue type: - If parameter's entity type is a composite entity: map - Else: depending on parameter value type, could be one of string, number, boolean, null, list or map - MapValue value: - If parameter's entity type is a composite entity: map from composite entity property names to property values - Else: parameter value
        """
        if lifespan_count is not None:
            pulumi.set(__self__, "lifespan_count", lifespan_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter(name="lifespanCount")
    def lifespan_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The number of conversational query requests after which the context expires. The default is `0`. If set to `0`, the context expires immediately. Contexts expire automatically after 20 minutes if there are no matching queries.
        """
        return pulumi.get(self, "lifespan_count")

    @lifespan_count.setter
    def lifespan_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "lifespan_count", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The unique identifier of the context. Format: `projects//agent/sessions//contexts/`, or `projects//agent/environments//users//sessions//contexts/`. The `Context ID` is always converted to lowercase, may only contain characters in a-zA-Z0-9_-% and may be at most 250 bytes long. If `Environment ID` is not specified, we assume default 'draft' environment. If `User ID` is not specified, we assume default '-' user. The following context names are reserved for internal use by Dialogflow. You should not use these contexts or create contexts with these names: * `__system_counters__` * `*_id_dialog_context` * `*_dialog_params_size`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The collection of parameters associated with this context. Depending on your protocol or client library language, this is a map, associative array, symbol table, dictionary, or JSON object composed of a collection of (MapKey, MapValue) pairs: - MapKey type: string - MapKey value: parameter name - MapValue type: - If parameter's entity type is a composite entity: map - Else: depending on parameter value type, could be one of string, number, boolean, null, list or map - MapValue value: - If parameter's entity type is a composite entity: map from composite entity property names to property values - Else: parameter value
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "parameters", value)


@pulumi.input_type
class GoogleCloudDialogflowV2EntityTypeEntityArgs:
    def __init__(__self__, *,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        An **entity entry** for an associated entity type.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: Required. A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        :param pulumi.Input[str] value: Required. The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A reference value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. A collection of value synonyms. For example, if the entity type is *vegetable*, and `value` is *scallions*, a synonym could be *green onions*. For `KIND_LIST` entity types: * This collection must contain exactly one synonym equal to `value`.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "synonyms", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The primary value associated with this entity entry. For example, if the entity type is *vegetable*, the value could be *scallions*. For `KIND_MAP` entity types: * A reference value to be used in place of synonyms. For `KIND_LIST` entity types: * A string that can contain references to other entity types (with or without aliases).
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigArgs:
    def __init__(__self__, *,
                 end_user_suggestion_config: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs']] = None,
                 human_agent_suggestion_config: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs']] = None,
                 message_analysis_config: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfigArgs']] = None,
                 notification_config: Optional[pulumi.Input['GoogleCloudDialogflowV2NotificationConfigArgs']] = None):
        """
        Defines the Human Agent Assist to connect to a conversation.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs'] end_user_suggestion_config: Configuration for agent assistance of end user participant. Currently, this feature is not general available, please contact Google to get access.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs'] human_agent_suggestion_config: Configuration for agent assistance of human agent participant.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfigArgs'] message_analysis_config: Configuration for message analysis.
        :param pulumi.Input['GoogleCloudDialogflowV2NotificationConfigArgs'] notification_config: Pub/Sub topic on which to publish new agent assistant events.
        """
        if end_user_suggestion_config is not None:
            pulumi.set(__self__, "end_user_suggestion_config", end_user_suggestion_config)
        if human_agent_suggestion_config is not None:
            pulumi.set(__self__, "human_agent_suggestion_config", human_agent_suggestion_config)
        if message_analysis_config is not None:
            pulumi.set(__self__, "message_analysis_config", message_analysis_config)
        if notification_config is not None:
            pulumi.set(__self__, "notification_config", notification_config)

    @property
    @pulumi.getter(name="endUserSuggestionConfig")
    def end_user_suggestion_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs']]:
        """
        Configuration for agent assistance of end user participant. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "end_user_suggestion_config")

    @end_user_suggestion_config.setter
    def end_user_suggestion_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs']]):
        pulumi.set(self, "end_user_suggestion_config", value)

    @property
    @pulumi.getter(name="humanAgentSuggestionConfig")
    def human_agent_suggestion_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs']]:
        """
        Configuration for agent assistance of human agent participant.
        """
        return pulumi.get(self, "human_agent_suggestion_config")

    @human_agent_suggestion_config.setter
    def human_agent_suggestion_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs']]):
        pulumi.set(self, "human_agent_suggestion_config", value)

    @property
    @pulumi.getter(name="messageAnalysisConfig")
    def message_analysis_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfigArgs']]:
        """
        Configuration for message analysis.
        """
        return pulumi.get(self, "message_analysis_config")

    @message_analysis_config.setter
    def message_analysis_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfigArgs']]):
        pulumi.set(self, "message_analysis_config", value)

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2NotificationConfigArgs']]:
        """
        Pub/Sub topic on which to publish new agent assistant events.
        """
        return pulumi.get(self, "notification_config")

    @notification_config.setter
    def notification_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2NotificationConfigArgs']]):
        pulumi.set(self, "notification_config", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfigArgs:
    def __init__(__self__, *,
                 model: Optional[pulumi.Input[str]] = None):
        """
        Custom conversation models used in agent assist feature. Supported feature: ARTICLE_SUGGESTION, SMART_COMPOSE, SMART_REPLY.
        :param pulumi.Input[str] model: Required. Conversation model resource name. Format: `projects//conversationModels/`.
        """
        if model is not None:
            pulumi.set(__self__, "model", model)

    @property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Conversation model resource name. Format: `projects//conversationModels/`.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "model", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigMessageAnalysisConfigArgs:
    def __init__(__self__, *,
                 enable_entity_extraction: Optional[pulumi.Input[bool]] = None,
                 enable_sentiment_analysis: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for analyses to run on each conversation message.
        :param pulumi.Input[bool] enable_entity_extraction: Enable entity extraction in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Currently, this feature is not general available, please contact Google to get access.
        :param pulumi.Input[bool] enable_sentiment_analysis: Enable sentiment analysis in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Sentiment analysis inspects user input and identifies the prevailing subjective opinion, especially to determine a user's attitude as positive, negative, or neutral: https://cloud.google.com/natural-language/docs/basics#sentiment_analysis For Participants.StreamingAnalyzeContent method, result will be in StreamingAnalyzeContentResponse.message.SentimentAnalysisResult. For Participants.AnalyzeContent method, result will be in AnalyzeContentResponse.message.SentimentAnalysisResult For Conversations.ListMessages method, result will be in ListMessagesResponse.messages.SentimentAnalysisResult If Pub/Sub notification is configured, result will be in ConversationEvent.new_message_payload.SentimentAnalysisResult.
        """
        if enable_entity_extraction is not None:
            pulumi.set(__self__, "enable_entity_extraction", enable_entity_extraction)
        if enable_sentiment_analysis is not None:
            pulumi.set(__self__, "enable_sentiment_analysis", enable_sentiment_analysis)

    @property
    @pulumi.getter(name="enableEntityExtraction")
    def enable_entity_extraction(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable entity extraction in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "enable_entity_extraction")

    @enable_entity_extraction.setter
    def enable_entity_extraction(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_entity_extraction", value)

    @property
    @pulumi.getter(name="enableSentimentAnalysis")
    def enable_sentiment_analysis(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable sentiment analysis in conversation messages on [agent assist stage](https://cloud.google.com/dialogflow/priv/docs/contact-center/basics#stages). If unspecified, defaults to false. Sentiment analysis inspects user input and identifies the prevailing subjective opinion, especially to determine a user's attitude as positive, negative, or neutral: https://cloud.google.com/natural-language/docs/basics#sentiment_analysis For Participants.StreamingAnalyzeContent method, result will be in StreamingAnalyzeContentResponse.message.SentimentAnalysisResult. For Participants.AnalyzeContent method, result will be in AnalyzeContentResponse.message.SentimentAnalysisResult For Conversations.ListMessages method, result will be in ListMessagesResponse.messages.SentimentAnalysisResult If Pub/Sub notification is configured, result will be in ConversationEvent.new_message_payload.SentimentAnalysisResult.
        """
        return pulumi.get(self, "enable_sentiment_analysis")

    @enable_sentiment_analysis.setter
    def enable_sentiment_analysis(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_sentiment_analysis", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionConfigArgs:
    def __init__(__self__, *,
                 feature_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]]] = None,
                 group_suggestion_responses: Optional[pulumi.Input[bool]] = None):
        """
        Detail human agent assistant config.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]] feature_configs: Configuration of different suggestion features. One feature can have only one config.
        :param pulumi.Input[bool] group_suggestion_responses: If `group_suggestion_responses` is false, and there are multiple `feature_configs` in `event based suggestion` or StreamingAnalyzeContent, we will try to deliver suggestions to customers as soon as we get new suggestion. Different type of suggestions based on the same context will be in separate Pub/Sub event or `StreamingAnalyzeContentResponse`. If `group_suggestion_responses` set to true. All the suggestions to the same participant based on the same context will be grouped into a single Pub/Sub event or StreamingAnalyzeContentResponse.
        """
        if feature_configs is not None:
            pulumi.set(__self__, "feature_configs", feature_configs)
        if group_suggestion_responses is not None:
            pulumi.set(__self__, "group_suggestion_responses", group_suggestion_responses)

    @property
    @pulumi.getter(name="featureConfigs")
    def feature_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]]]:
        """
        Configuration of different suggestion features. One feature can have only one config.
        """
        return pulumi.get(self, "feature_configs")

    @feature_configs.setter
    def feature_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfigArgs']]]]):
        pulumi.set(self, "feature_configs", value)

    @property
    @pulumi.getter(name="groupSuggestionResponses")
    def group_suggestion_responses(self) -> Optional[pulumi.Input[bool]]:
        """
        If `group_suggestion_responses` is false, and there are multiple `feature_configs` in `event based suggestion` or StreamingAnalyzeContent, we will try to deliver suggestions to customers as soon as we get new suggestion. Different type of suggestions based on the same context will be in separate Pub/Sub event or `StreamingAnalyzeContentResponse`. If `group_suggestion_responses` set to true. All the suggestions to the same participant based on the same context will be grouped into a single Pub/Sub event or StreamingAnalyzeContentResponse.
        """
        return pulumi.get(self, "group_suggestion_responses")

    @group_suggestion_responses.setter
    def group_suggestion_responses(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "group_suggestion_responses", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionFeatureConfigArgs:
    def __init__(__self__, *,
                 conversation_model_config: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfigArgs']] = None,
                 enable_event_based_suggestion: Optional[pulumi.Input[bool]] = None,
                 query_config: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigArgs']] = None,
                 suggestion_feature: Optional[pulumi.Input['GoogleCloudDialogflowV2SuggestionFeatureArgs']] = None,
                 suggestion_trigger_settings: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettingsArgs']] = None):
        """
        Config for suggestion features.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfigArgs'] conversation_model_config: Configs of custom conversation model.
        :param pulumi.Input[bool] enable_event_based_suggestion: Automatically iterates all participants and tries to compile suggestions. Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigArgs'] query_config: Configs of query.
        :param pulumi.Input['GoogleCloudDialogflowV2SuggestionFeatureArgs'] suggestion_feature: The suggestion feature.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettingsArgs'] suggestion_trigger_settings: Settings of suggestion trigger. Currently, only ARTICLE_SUGGESTION and FAQ will use this field.
        """
        if conversation_model_config is not None:
            pulumi.set(__self__, "conversation_model_config", conversation_model_config)
        if enable_event_based_suggestion is not None:
            pulumi.set(__self__, "enable_event_based_suggestion", enable_event_based_suggestion)
        if query_config is not None:
            pulumi.set(__self__, "query_config", query_config)
        if suggestion_feature is not None:
            pulumi.set(__self__, "suggestion_feature", suggestion_feature)
        if suggestion_trigger_settings is not None:
            pulumi.set(__self__, "suggestion_trigger_settings", suggestion_trigger_settings)

    @property
    @pulumi.getter(name="conversationModelConfig")
    def conversation_model_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfigArgs']]:
        """
        Configs of custom conversation model.
        """
        return pulumi.get(self, "conversation_model_config")

    @conversation_model_config.setter
    def conversation_model_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigConversationModelConfigArgs']]):
        pulumi.set(self, "conversation_model_config", value)

    @property
    @pulumi.getter(name="enableEventBasedSuggestion")
    def enable_event_based_suggestion(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically iterates all participants and tries to compile suggestions. Supported features: ARTICLE_SUGGESTION, FAQ, DIALOGFLOW_ASSIST.
        """
        return pulumi.get(self, "enable_event_based_suggestion")

    @enable_event_based_suggestion.setter
    def enable_event_based_suggestion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_event_based_suggestion", value)

    @property
    @pulumi.getter(name="queryConfig")
    def query_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigArgs']]:
        """
        Configs of query.
        """
        return pulumi.get(self, "query_config")

    @query_config.setter
    def query_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigArgs']]):
        pulumi.set(self, "query_config", value)

    @property
    @pulumi.getter(name="suggestionFeature")
    def suggestion_feature(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2SuggestionFeatureArgs']]:
        """
        The suggestion feature.
        """
        return pulumi.get(self, "suggestion_feature")

    @suggestion_feature.setter
    def suggestion_feature(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2SuggestionFeatureArgs']]):
        pulumi.set(self, "suggestion_feature", value)

    @property
    @pulumi.getter(name="suggestionTriggerSettings")
    def suggestion_trigger_settings(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettingsArgs']]:
        """
        Settings of suggestion trigger. Currently, only ARTICLE_SUGGESTION and FAQ will use this field.
        """
        return pulumi.get(self, "suggestion_trigger_settings")

    @suggestion_trigger_settings.setter
    def suggestion_trigger_settings(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettingsArgs']]):
        pulumi.set(self, "suggestion_trigger_settings", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigArgs:
    def __init__(__self__, *,
                 confidence_threshold: Optional[pulumi.Input[float]] = None,
                 context_filter_settings: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs']] = None,
                 dialogflow_query_source: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs']] = None,
                 document_query_source: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs']] = None,
                 knowledge_base_query_source: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs']] = None,
                 max_results: Optional[pulumi.Input[int]] = None):
        """
        Config for suggestion query.
        :param pulumi.Input[float] confidence_threshold: Confidence threshold of query result. Agent Assist gives each suggestion a score in the range [0.0, 1.0], based on the relevance between the suggestion and the current conversation context. A score of 0.0 has no relevance, while a score of 1.0 has high relevance. Only suggestions with a score greater than or equal to the value of this field are included in the results. For a baseline model (the default), the recommended value is in the range [0.05, 0.1]. For a custom model, there is no recommended value. Tune this value by starting from a very low value and slowly increasing until you have desired results. If this field is not set, it defaults to 0.0, which means that all suggestions are returned. Supported features: ARTICLE_SUGGESTION.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs'] context_filter_settings: Determines how recent conversation context is filtered when generating suggestions. If unspecified, no messages will be dropped.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs'] dialogflow_query_source: Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs'] document_query_source: Query from knowledge base document. It is used by: SMART_REPLY, SMART_COMPOSE.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs'] knowledge_base_query_source: Query from knowledgebase. It is used by: ARTICLE_SUGGESTION, FAQ.
        :param pulumi.Input[int] max_results: Maximum number of results to return. Currently, if unset, defaults to 10. And the max number is 20.
        """
        if confidence_threshold is not None:
            pulumi.set(__self__, "confidence_threshold", confidence_threshold)
        if context_filter_settings is not None:
            pulumi.set(__self__, "context_filter_settings", context_filter_settings)
        if dialogflow_query_source is not None:
            pulumi.set(__self__, "dialogflow_query_source", dialogflow_query_source)
        if document_query_source is not None:
            pulumi.set(__self__, "document_query_source", document_query_source)
        if knowledge_base_query_source is not None:
            pulumi.set(__self__, "knowledge_base_query_source", knowledge_base_query_source)
        if max_results is not None:
            pulumi.set(__self__, "max_results", max_results)

    @property
    @pulumi.getter(name="confidenceThreshold")
    def confidence_threshold(self) -> Optional[pulumi.Input[float]]:
        """
        Confidence threshold of query result. Agent Assist gives each suggestion a score in the range [0.0, 1.0], based on the relevance between the suggestion and the current conversation context. A score of 0.0 has no relevance, while a score of 1.0 has high relevance. Only suggestions with a score greater than or equal to the value of this field are included in the results. For a baseline model (the default), the recommended value is in the range [0.05, 0.1]. For a custom model, there is no recommended value. Tune this value by starting from a very low value and slowly increasing until you have desired results. If this field is not set, it defaults to 0.0, which means that all suggestions are returned. Supported features: ARTICLE_SUGGESTION.
        """
        return pulumi.get(self, "confidence_threshold")

    @confidence_threshold.setter
    def confidence_threshold(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "confidence_threshold", value)

    @property
    @pulumi.getter(name="contextFilterSettings")
    def context_filter_settings(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs']]:
        """
        Determines how recent conversation context is filtered when generating suggestions. If unspecified, no messages will be dropped.
        """
        return pulumi.get(self, "context_filter_settings")

    @context_filter_settings.setter
    def context_filter_settings(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs']]):
        pulumi.set(self, "context_filter_settings", value)

    @property
    @pulumi.getter(name="dialogflowQuerySource")
    def dialogflow_query_source(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs']]:
        """
        Query from Dialogflow agent. It is used by DIALOGFLOW_ASSIST.
        """
        return pulumi.get(self, "dialogflow_query_source")

    @dialogflow_query_source.setter
    def dialogflow_query_source(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs']]):
        pulumi.set(self, "dialogflow_query_source", value)

    @property
    @pulumi.getter(name="documentQuerySource")
    def document_query_source(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs']]:
        """
        Query from knowledge base document. It is used by: SMART_REPLY, SMART_COMPOSE.
        """
        return pulumi.get(self, "document_query_source")

    @document_query_source.setter
    def document_query_source(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs']]):
        pulumi.set(self, "document_query_source", value)

    @property
    @pulumi.getter(name="knowledgeBaseQuerySource")
    def knowledge_base_query_source(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs']]:
        """
        Query from knowledgebase. It is used by: ARTICLE_SUGGESTION, FAQ.
        """
        return pulumi.get(self, "knowledge_base_query_source")

    @knowledge_base_query_source.setter
    def knowledge_base_query_source(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs']]):
        pulumi.set(self, "knowledge_base_query_source", value)

    @property
    @pulumi.getter(name="maxResults")
    def max_results(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum number of results to return. Currently, if unset, defaults to 10. And the max number is 20.
        """
        return pulumi.get(self, "max_results")

    @max_results.setter
    def max_results(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_results", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigContextFilterSettingsArgs:
    def __init__(__self__, *,
                 drop_handoff_messages: Optional[pulumi.Input[bool]] = None,
                 drop_ivr_messages: Optional[pulumi.Input[bool]] = None,
                 drop_virtual_agent_messages: Optional[pulumi.Input[bool]] = None):
        """
        Settings that determine how to filter recent conversation context when generating suggestions.
        :param pulumi.Input[bool] drop_handoff_messages: If set to true, the last message from virtual agent (hand off message) and the message before it (trigger message of hand off) are dropped.
        :param pulumi.Input[bool] drop_ivr_messages: If set to true, all messages from ivr stage are dropped.
        :param pulumi.Input[bool] drop_virtual_agent_messages: If set to true, all messages from virtual agent are dropped.
        """
        if drop_handoff_messages is not None:
            pulumi.set(__self__, "drop_handoff_messages", drop_handoff_messages)
        if drop_ivr_messages is not None:
            pulumi.set(__self__, "drop_ivr_messages", drop_ivr_messages)
        if drop_virtual_agent_messages is not None:
            pulumi.set(__self__, "drop_virtual_agent_messages", drop_virtual_agent_messages)

    @property
    @pulumi.getter(name="dropHandoffMessages")
    def drop_handoff_messages(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, the last message from virtual agent (hand off message) and the message before it (trigger message of hand off) are dropped.
        """
        return pulumi.get(self, "drop_handoff_messages")

    @drop_handoff_messages.setter
    def drop_handoff_messages(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_handoff_messages", value)

    @property
    @pulumi.getter(name="dropIvrMessages")
    def drop_ivr_messages(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, all messages from ivr stage are dropped.
        """
        return pulumi.get(self, "drop_ivr_messages")

    @drop_ivr_messages.setter
    def drop_ivr_messages(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_ivr_messages", value)

    @property
    @pulumi.getter(name="dropVirtualAgentMessages")
    def drop_virtual_agent_messages(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to true, all messages from virtual agent are dropped.
        """
        return pulumi.get(self, "drop_virtual_agent_messages")

    @drop_virtual_agent_messages.setter
    def drop_virtual_agent_messages(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "drop_virtual_agent_messages", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDialogflowQuerySourceArgs:
    def __init__(__self__, *,
                 agent: Optional[pulumi.Input[str]] = None):
        """
        Dialogflow source setting. Supported feature: DIALOGFLOW_ASSIST.
        :param pulumi.Input[str] agent: Required. The name of a Dialogflow virtual agent used for end user side intent detection and suggestion. Format: `projects//locations//agent`. When multiple agents are allowed in the same Dialogflow project.
        """
        if agent is not None:
            pulumi.set(__self__, "agent", agent)

    @property
    @pulumi.getter
    def agent(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of a Dialogflow virtual agent used for end user side intent detection and suggestion. Format: `projects//locations//agent`. When multiple agents are allowed in the same Dialogflow project.
        """
        return pulumi.get(self, "agent")

    @agent.setter
    def agent(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "agent", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigDocumentQuerySourceArgs:
    def __init__(__self__, *,
                 documents: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Document source settings. Supported features: SMART_REPLY, SMART_COMPOSE.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] documents: Required. Knowledge documents to query from. Format: `projects//locations//knowledgeBases//documents/`. Currently, at most 5 documents are supported.
        """
        if documents is not None:
            pulumi.set(__self__, "documents", documents)

    @property
    @pulumi.getter
    def documents(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. Knowledge documents to query from. Format: `projects//locations//knowledgeBases//documents/`. Currently, at most 5 documents are supported.
        """
        return pulumi.get(self, "documents")

    @documents.setter
    def documents(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "documents", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionQueryConfigKnowledgeBaseQuerySourceArgs:
    def __init__(__self__, *,
                 knowledge_bases: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Knowledge base source settings. Supported features: ARTICLE_SUGGESTION, FAQ.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] knowledge_bases: Required. Knowledge bases to query. Format: `projects//locations//knowledgeBases/`. Currently, at most 5 knowledge bases are supported.
        """
        if knowledge_bases is not None:
            pulumi.set(__self__, "knowledge_bases", knowledge_bases)

    @property
    @pulumi.getter(name="knowledgeBases")
    def knowledge_bases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Required. Knowledge bases to query. Format: `projects//locations//knowledgeBases/`. Currently, at most 5 knowledge bases are supported.
        """
        return pulumi.get(self, "knowledge_bases")

    @knowledge_bases.setter
    def knowledge_bases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "knowledge_bases", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentAssistantConfigSuggestionTriggerSettingsArgs:
    def __init__(__self__, *,
                 no_smalltalk: Optional[pulumi.Input[bool]] = None,
                 only_end_user: Optional[pulumi.Input[bool]] = None):
        """
        Settings of suggestion trigger.
        :param pulumi.Input[bool] no_smalltalk: Do not trigger if last utterance is small talk.
        :param pulumi.Input[bool] only_end_user: Only trigger suggestion if participant role of last utterance is END_USER.
        """
        if no_smalltalk is not None:
            pulumi.set(__self__, "no_smalltalk", no_smalltalk)
        if only_end_user is not None:
            pulumi.set(__self__, "only_end_user", only_end_user)

    @property
    @pulumi.getter(name="noSmalltalk")
    def no_smalltalk(self) -> Optional[pulumi.Input[bool]]:
        """
        Do not trigger if last utterance is small talk.
        """
        return pulumi.get(self, "no_smalltalk")

    @no_smalltalk.setter
    def no_smalltalk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_smalltalk", value)

    @property
    @pulumi.getter(name="onlyEndUser")
    def only_end_user(self) -> Optional[pulumi.Input[bool]]:
        """
        Only trigger suggestion if participant role of last utterance is END_USER.
        """
        return pulumi.get(self, "only_end_user")

    @only_end_user.setter
    def only_end_user(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "only_end_user", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentHandoffConfigArgs:
    def __init__(__self__, *,
                 live_person_config: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfigArgs']] = None,
                 salesforce_live_agent_config: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs']] = None):
        """
        Defines the hand off to a live agent, typically on which external agent service provider to connect to a conversation. Currently, this feature is not general available, please contact Google to get access.
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfigArgs'] live_person_config: Uses LivePerson (https://www.liveperson.com).
        :param pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs'] salesforce_live_agent_config: Uses Salesforce Live Agent.
        """
        if live_person_config is not None:
            pulumi.set(__self__, "live_person_config", live_person_config)
        if salesforce_live_agent_config is not None:
            pulumi.set(__self__, "salesforce_live_agent_config", salesforce_live_agent_config)

    @property
    @pulumi.getter(name="livePersonConfig")
    def live_person_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfigArgs']]:
        """
        Uses LivePerson (https://www.liveperson.com).
        """
        return pulumi.get(self, "live_person_config")

    @live_person_config.setter
    def live_person_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfigArgs']]):
        pulumi.set(self, "live_person_config", value)

    @property
    @pulumi.getter(name="salesforceLiveAgentConfig")
    def salesforce_live_agent_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs']]:
        """
        Uses Salesforce Live Agent.
        """
        return pulumi.get(self, "salesforce_live_agent_config")

    @salesforce_live_agent_config.setter
    def salesforce_live_agent_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs']]):
        pulumi.set(self, "salesforce_live_agent_config", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentHandoffConfigLivePersonConfigArgs:
    def __init__(__self__, *,
                 account_number: Optional[pulumi.Input[str]] = None):
        """
        Configuration specific to LivePerson (https://www.liveperson.com).
        :param pulumi.Input[str] account_number: Required. Account number of the LivePerson account to connect. This is the account number you input at the login page.
        """
        if account_number is not None:
            pulumi.set(__self__, "account_number", account_number)

    @property
    @pulumi.getter(name="accountNumber")
    def account_number(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Account number of the LivePerson account to connect. This is the account number you input at the login page.
        """
        return pulumi.get(self, "account_number")

    @account_number.setter
    def account_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_number", value)


@pulumi.input_type
class GoogleCloudDialogflowV2HumanAgentHandoffConfigSalesforceLiveAgentConfigArgs:
    def __init__(__self__, *,
                 button_id: Optional[pulumi.Input[str]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 endpoint_domain: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None):
        """
        Configuration specific to Salesforce Live Agent.
        :param pulumi.Input[str] button_id: Required. Live Agent chat button ID.
        :param pulumi.Input[str] deployment_id: Required. Live Agent deployment ID.
        :param pulumi.Input[str] endpoint_domain: Required. Domain of the Live Agent endpoint for this agent. You can find the endpoint URL in the `Live Agent settings` page. For example if URL has the form https://d.la4-c2-phx.salesforceliveagent.com/..., you should fill in d.la4-c2-phx.salesforceliveagent.com.
        :param pulumi.Input[str] organization_id: Required. The organization ID of the Salesforce account.
        """
        if button_id is not None:
            pulumi.set(__self__, "button_id", button_id)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if endpoint_domain is not None:
            pulumi.set(__self__, "endpoint_domain", endpoint_domain)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)

    @property
    @pulumi.getter(name="buttonId")
    def button_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Live Agent chat button ID.
        """
        return pulumi.get(self, "button_id")

    @button_id.setter
    def button_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "button_id", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Live Agent deployment ID.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="endpointDomain")
    def endpoint_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Domain of the Live Agent endpoint for this agent. You can find the endpoint URL in the `Live Agent settings` page. For example if URL has the form https://d.la4-c2-phx.salesforceliveagent.com/..., you should fill in d.la4-c2-phx.salesforceliveagent.com.
        """
        return pulumi.get(self, "endpoint_domain")

    @endpoint_domain.setter
    def endpoint_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_domain", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The organization ID of the Salesforce account.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentFollowupIntentInfoArgs:
    def __init__(__self__, *,
                 followup_intent_name: Optional[pulumi.Input[str]] = None,
                 parent_followup_intent_name: Optional[pulumi.Input[str]] = None):
        """
        Represents a single followup intent in the chain.
        :param pulumi.Input[str] followup_intent_name: The unique identifier of the followup intent. Format: `projects//agent/intents/`.
        :param pulumi.Input[str] parent_followup_intent_name: The unique identifier of the followup intent's parent. Format: `projects//agent/intents/`.
        """
        if followup_intent_name is not None:
            pulumi.set(__self__, "followup_intent_name", followup_intent_name)
        if parent_followup_intent_name is not None:
            pulumi.set(__self__, "parent_followup_intent_name", parent_followup_intent_name)

    @property
    @pulumi.getter(name="followupIntentName")
    def followup_intent_name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the followup intent. Format: `projects//agent/intents/`.
        """
        return pulumi.get(self, "followup_intent_name")

    @followup_intent_name.setter
    def followup_intent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "followup_intent_name", value)

    @property
    @pulumi.getter(name="parentFollowupIntentName")
    def parent_followup_intent_name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the followup intent's parent. Format: `projects//agent/intents/`.
        """
        return pulumi.get(self, "parent_followup_intent_name")

    @parent_followup_intent_name.setter
    def parent_followup_intent_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_followup_intent_name", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageArgs:
    def __init__(__self__, *,
                 basic_card: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardArgs']] = None,
                 browse_carousel_card: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardArgs']] = None,
                 card: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardArgs']] = None,
                 carousel_select: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectArgs']] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 link_out_suggestion: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageLinkOutSuggestionArgs']] = None,
                 list_select: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectArgs']] = None,
                 media_content: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentArgs']] = None,
                 payload: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 platform: Optional[pulumi.Input[str]] = None,
                 quick_replies: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageQuickRepliesArgs']] = None,
                 simple_responses: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponsesArgs']] = None,
                 suggestions: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionsArgs']] = None,
                 table_card: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardArgs']] = None,
                 text: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTextArgs']] = None):
        """
        A rich response message. Corresponds to the intent `Response` field in the Dialogflow console. For more information, see [Rich response messages](https://cloud.google.com/dialogflow/docs/intents-rich-messages).
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardArgs'] basic_card: The basic card response for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardArgs'] browse_carousel_card: Browse carousel card for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardArgs'] card: The card response.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectArgs'] carousel_select: The carousel card response for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] image: The image response.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageLinkOutSuggestionArgs'] link_out_suggestion: The link out suggestion chip for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectArgs'] list_select: The list card response for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentArgs'] media_content: The media content card for Actions on Google.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] payload: A custom platform-specific response.
        :param pulumi.Input[str] platform: Optional. The platform that this message is intended for.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageQuickRepliesArgs'] quick_replies: The quick replies response.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponsesArgs'] simple_responses: The voice and text-only responses for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionsArgs'] suggestions: The suggestion chips for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardArgs'] table_card: Table card for Actions on Google.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageTextArgs'] text: The text response.
        """
        if basic_card is not None:
            pulumi.set(__self__, "basic_card", basic_card)
        if browse_carousel_card is not None:
            pulumi.set(__self__, "browse_carousel_card", browse_carousel_card)
        if card is not None:
            pulumi.set(__self__, "card", card)
        if carousel_select is not None:
            pulumi.set(__self__, "carousel_select", carousel_select)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if link_out_suggestion is not None:
            pulumi.set(__self__, "link_out_suggestion", link_out_suggestion)
        if list_select is not None:
            pulumi.set(__self__, "list_select", list_select)
        if media_content is not None:
            pulumi.set(__self__, "media_content", media_content)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if quick_replies is not None:
            pulumi.set(__self__, "quick_replies", quick_replies)
        if simple_responses is not None:
            pulumi.set(__self__, "simple_responses", simple_responses)
        if suggestions is not None:
            pulumi.set(__self__, "suggestions", suggestions)
        if table_card is not None:
            pulumi.set(__self__, "table_card", table_card)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter(name="basicCard")
    def basic_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardArgs']]:
        """
        The basic card response for Actions on Google.
        """
        return pulumi.get(self, "basic_card")

    @basic_card.setter
    def basic_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardArgs']]):
        pulumi.set(self, "basic_card", value)

    @property
    @pulumi.getter(name="browseCarouselCard")
    def browse_carousel_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardArgs']]:
        """
        Browse carousel card for Actions on Google.
        """
        return pulumi.get(self, "browse_carousel_card")

    @browse_carousel_card.setter
    def browse_carousel_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardArgs']]):
        pulumi.set(self, "browse_carousel_card", value)

    @property
    @pulumi.getter
    def card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardArgs']]:
        """
        The card response.
        """
        return pulumi.get(self, "card")

    @card.setter
    def card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardArgs']]):
        pulumi.set(self, "card", value)

    @property
    @pulumi.getter(name="carouselSelect")
    def carousel_select(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectArgs']]:
        """
        The carousel card response for Actions on Google.
        """
        return pulumi.get(self, "carousel_select")

    @carousel_select.setter
    def carousel_select(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectArgs']]):
        pulumi.set(self, "carousel_select", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        The image response.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="linkOutSuggestion")
    def link_out_suggestion(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageLinkOutSuggestionArgs']]:
        """
        The link out suggestion chip for Actions on Google.
        """
        return pulumi.get(self, "link_out_suggestion")

    @link_out_suggestion.setter
    def link_out_suggestion(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageLinkOutSuggestionArgs']]):
        pulumi.set(self, "link_out_suggestion", value)

    @property
    @pulumi.getter(name="listSelect")
    def list_select(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectArgs']]:
        """
        The list card response for Actions on Google.
        """
        return pulumi.get(self, "list_select")

    @list_select.setter
    def list_select(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectArgs']]):
        pulumi.set(self, "list_select", value)

    @property
    @pulumi.getter(name="mediaContent")
    def media_content(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentArgs']]:
        """
        The media content card for Actions on Google.
        """
        return pulumi.get(self, "media_content")

    @media_content.setter
    def media_content(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentArgs']]):
        pulumi.set(self, "media_content", value)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A custom platform-specific response.
        """
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The platform that this message is intended for.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="quickReplies")
    def quick_replies(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageQuickRepliesArgs']]:
        """
        The quick replies response.
        """
        return pulumi.get(self, "quick_replies")

    @quick_replies.setter
    def quick_replies(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageQuickRepliesArgs']]):
        pulumi.set(self, "quick_replies", value)

    @property
    @pulumi.getter(name="simpleResponses")
    def simple_responses(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponsesArgs']]:
        """
        The voice and text-only responses for Actions on Google.
        """
        return pulumi.get(self, "simple_responses")

    @simple_responses.setter
    def simple_responses(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponsesArgs']]):
        pulumi.set(self, "simple_responses", value)

    @property
    @pulumi.getter
    def suggestions(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionsArgs']]:
        """
        The suggestion chips for Actions on Google.
        """
        return pulumi.get(self, "suggestions")

    @suggestions.setter
    def suggestions(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionsArgs']]):
        pulumi.set(self, "suggestions", value)

    @property
    @pulumi.getter(name="tableCard")
    def table_card(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardArgs']]:
        """
        Table card for Actions on Google.
        """
        return pulumi.get(self, "table_card")

    @table_card.setter
    def table_card(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardArgs']]):
        pulumi.set(self, "table_card", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTextArgs']]:
        """
        The text response.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTextArgs']]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageBasicCardArgs:
    def __init__(__self__, *,
                 buttons: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]]] = None,
                 formatted_text: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 subtitle: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The basic card message. Useful for displaying information.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]] buttons: Optional. The collection of card buttons.
        :param pulumi.Input[str] formatted_text: Required, unless image is present. The body text of the card.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] image: Optional. The image for the card.
        :param pulumi.Input[str] subtitle: Optional. The subtitle of the card.
        :param pulumi.Input[str] title: Optional. The title of the card.
        """
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if formatted_text is not None:
            pulumi.set(__self__, "formatted_text", formatted_text)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]]]:
        """
        Optional. The collection of card buttons.
        """
        return pulumi.get(self, "buttons")

    @buttons.setter
    def buttons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]]]):
        pulumi.set(self, "buttons", value)

    @property
    @pulumi.getter(name="formattedText")
    def formatted_text(self) -> Optional[pulumi.Input[str]]:
        """
        Required, unless image is present. The body text of the card.
        """
        return pulumi.get(self, "formatted_text")

    @formatted_text.setter
    def formatted_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "formatted_text", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        Optional. The image for the card.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The subtitle of the card.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The title of the card.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs:
    def __init__(__self__, *,
                 open_uri_action: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriActionArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The button object that appears at the bottom of a card.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriActionArgs'] open_uri_action: Required. Action to take when a user taps on the button.
        :param pulumi.Input[str] title: Required. The title of the button.
        """
        if open_uri_action is not None:
            pulumi.set(__self__, "open_uri_action", open_uri_action)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="openUriAction")
    def open_uri_action(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriActionArgs']]:
        """
        Required. Action to take when a user taps on the button.
        """
        return pulumi.get(self, "open_uri_action")

    @open_uri_action.setter
    def open_uri_action(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriActionArgs']]):
        pulumi.set(self, "open_uri_action", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The title of the button.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageBasicCardButtonOpenUriActionArgs:
    def __init__(__self__, *,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        Opens the given URI.
        :param pulumi.Input[str] uri: Required. The HTTP or HTTPS scheme URI.
        """
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The HTTP or HTTPS scheme URI.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardArgs:
    def __init__(__self__, *,
                 image_display_options: Optional[pulumi.Input[str]] = None,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]]] = None):
        """
        Browse Carousel Card for Actions on Google. https://developers.google.com/actions/assistant/responses#browsing_carousel
        :param pulumi.Input[str] image_display_options: Optional. Settings for displaying the image. Applies to every image in items.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]] items: Required. List of items in the Browse Carousel Card. Minimum of two items, maximum of ten.
        """
        if image_display_options is not None:
            pulumi.set(__self__, "image_display_options", image_display_options)
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter(name="imageDisplayOptions")
    def image_display_options(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Settings for displaying the image. Applies to every image in items.
        """
        return pulumi.get(self, "image_display_options")

    @image_display_options.setter
    def image_display_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_display_options", value)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]]]:
        """
        Required. List of items in the Browse Carousel Card. Minimum of two items, maximum of ten.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 footer: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 open_uri_action: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Browsing carousel tile
        :param pulumi.Input[str] description: Optional. Description of the carousel item. Maximum of four lines of text.
        :param pulumi.Input[str] footer: Optional. Text that appears at the bottom of the Browse Carousel Card. Maximum of one line of text.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] image: Optional. Hero image for the carousel item.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs'] open_uri_action: Required. Action to present to the user.
        :param pulumi.Input[str] title: Required. Title of the carousel item. Maximum of two lines of text.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if footer is not None:
            pulumi.set(__self__, "footer", footer)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if open_uri_action is not None:
            pulumi.set(__self__, "open_uri_action", open_uri_action)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the carousel item. Maximum of four lines of text.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def footer(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Text that appears at the bottom of the Browse Carousel Card. Maximum of one line of text.
        """
        return pulumi.get(self, "footer")

    @footer.setter
    def footer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "footer", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        Optional. Hero image for the carousel item.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="openUriAction")
    def open_uri_action(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs']]:
        """
        Required. Action to present to the user.
        """
        return pulumi.get(self, "open_uri_action")

    @open_uri_action.setter
    def open_uri_action(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs']]):
        pulumi.set(self, "open_uri_action", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Title of the carousel item. Maximum of two lines of text.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageBrowseCarouselCardBrowseCarouselCardItemOpenUrlActionArgs:
    def __init__(__self__, *,
                 url: Optional[pulumi.Input[str]] = None,
                 url_type_hint: Optional[pulumi.Input[str]] = None):
        """
        Actions on Google action to open a given url.
        :param pulumi.Input[str] url: Required. URL
        :param pulumi.Input[str] url_type_hint: Optional. Specifies the type of viewer that is used when opening the URL. Defaults to opening via web browser.
        """
        if url is not None:
            pulumi.set(__self__, "url", url)
        if url_type_hint is not None:
            pulumi.set(__self__, "url_type_hint", url_type_hint)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Required. URL
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)

    @property
    @pulumi.getter(name="urlTypeHint")
    def url_type_hint(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Specifies the type of viewer that is used when opening the URL. Defaults to opening via web browser.
        """
        return pulumi.get(self, "url_type_hint")

    @url_type_hint.setter
    def url_type_hint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_type_hint", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageCardArgs:
    def __init__(__self__, *,
                 buttons: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardButtonArgs']]]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None,
                 subtitle: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The card response message.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardButtonArgs']]] buttons: Optional. The collection of card buttons.
        :param pulumi.Input[str] image_uri: Optional. The public URI to an image file for the card.
        :param pulumi.Input[str] subtitle: Optional. The subtitle of the card.
        :param pulumi.Input[str] title: Optional. The title of the card.
        """
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardButtonArgs']]]]:
        """
        Optional. The collection of card buttons.
        """
        return pulumi.get(self, "buttons")

    @buttons.setter
    def buttons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCardButtonArgs']]]]):
        pulumi.set(self, "buttons", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The public URI to an image file for the card.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The subtitle of the card.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The title of the card.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageCardButtonArgs:
    def __init__(__self__, *,
                 postback: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Contains information about a button.
        :param pulumi.Input[str] postback: Optional. The text to send back to the Dialogflow API or a URI to open.
        :param pulumi.Input[str] text: Optional. The text to show on the button.
        """
        if postback is not None:
            pulumi.set(__self__, "postback", postback)
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def postback(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The text to send back to the Dialogflow API or a URI to open.
        """
        return pulumi.get(self, "postback")

    @postback.setter
    def postback(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "postback", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The text to show on the button.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageCarouselSelectArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectItemArgs']]]] = None):
        """
        The card for presenting a carousel of options to select from.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectItemArgs']]] items: Required. Carousel items.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectItemArgs']]]]:
        """
        Required. Carousel items.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageCarouselSelectItemArgs']]]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageCarouselSelectItemArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 info: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        An item in the carousel.
        :param pulumi.Input[str] description: Optional. The body text of the card.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] image: Optional. The image to display.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs'] info: Required. Additional info about the option item.
        :param pulumi.Input[str] title: Required. Title of the carousel item.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if info is not None:
            pulumi.set(__self__, "info", info)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The body text of the card.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        Optional. The image to display.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def info(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs']]:
        """
        Required. Additional info about the option item.
        """
        return pulumi.get(self, "info")

    @info.setter
    def info(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs']]):
        pulumi.set(self, "info", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Title of the carousel item.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageColumnPropertiesArgs:
    def __init__(__self__, *,
                 header: Optional[pulumi.Input[str]] = None,
                 horizontal_alignment: Optional[pulumi.Input[str]] = None):
        """
        Column properties for TableCard.
        :param pulumi.Input[str] header: Required. Column heading.
        :param pulumi.Input[str] horizontal_alignment: Optional. Defines text alignment for all cells in this column.
        """
        if header is not None:
            pulumi.set(__self__, "header", header)
        if horizontal_alignment is not None:
            pulumi.set(__self__, "horizontal_alignment", horizontal_alignment)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Column heading.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter(name="horizontalAlignment")
    def horizontal_alignment(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Defines text alignment for all cells in this column.
        """
        return pulumi.get(self, "horizontal_alignment")

    @horizontal_alignment.setter
    def horizontal_alignment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "horizontal_alignment", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageImageArgs:
    def __init__(__self__, *,
                 accessibility_text: Optional[pulumi.Input[str]] = None,
                 image_uri: Optional[pulumi.Input[str]] = None):
        """
        The image response message.
        :param pulumi.Input[str] accessibility_text: Optional. A text description of the image to be used for accessibility, e.g., screen readers.
        :param pulumi.Input[str] image_uri: Optional. The public URI to an image file.
        """
        if accessibility_text is not None:
            pulumi.set(__self__, "accessibility_text", accessibility_text)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)

    @property
    @pulumi.getter(name="accessibilityText")
    def accessibility_text(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A text description of the image to be used for accessibility, e.g., screen readers.
        """
        return pulumi.get(self, "accessibility_text")

    @accessibility_text.setter
    def accessibility_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessibility_text", value)

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The public URI to an image file.
        """
        return pulumi.get(self, "image_uri")

    @image_uri.setter
    def image_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageLinkOutSuggestionArgs:
    def __init__(__self__, *,
                 destination_name: Optional[pulumi.Input[str]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        The suggestion chip message that allows the user to jump out to the app or website associated with this agent.
        :param pulumi.Input[str] destination_name: Required. The name of the app or site this chip is linking to.
        :param pulumi.Input[str] uri: Required. The URI of the app or site to open when the user taps the suggestion chip.
        """
        if destination_name is not None:
            pulumi.set(__self__, "destination_name", destination_name)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="destinationName")
    def destination_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the app or site this chip is linking to.
        """
        return pulumi.get(self, "destination_name")

    @destination_name.setter
    def destination_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_name", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The URI of the app or site to open when the user taps the suggestion chip.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageListSelectArgs:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectItemArgs']]]] = None,
                 subtitle: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The card for presenting a list of options to select from.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectItemArgs']]] items: Required. List items.
        :param pulumi.Input[str] subtitle: Optional. Subtitle of the list.
        :param pulumi.Input[str] title: Optional. The overall title of the list.
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectItemArgs']]]]:
        """
        Required. List items.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageListSelectItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Subtitle of the list.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The overall title of the list.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageListSelectItemArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 info: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs']] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        An item in the list.
        :param pulumi.Input[str] description: Optional. The main text describing the item.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] image: Optional. The image to display.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs'] info: Required. Additional information about this option.
        :param pulumi.Input[str] title: Required. The title of the list item.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if info is not None:
            pulumi.set(__self__, "info", info)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The main text describing the item.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        Optional. The image to display.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def info(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs']]:
        """
        Required. Additional information about this option.
        """
        return pulumi.get(self, "info")

    @info.setter
    def info(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs']]):
        pulumi.set(self, "info", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The title of the list item.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageMediaContentArgs:
    def __init__(__self__, *,
                 media_objects: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObjectArgs']]]] = None,
                 media_type: Optional[pulumi.Input[str]] = None):
        """
        The media content card for Actions on Google.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObjectArgs']]] media_objects: Required. List of media objects.
        :param pulumi.Input[str] media_type: Optional. What type of media is the content (ie "audio").
        """
        if media_objects is not None:
            pulumi.set(__self__, "media_objects", media_objects)
        if media_type is not None:
            pulumi.set(__self__, "media_type", media_type)

    @property
    @pulumi.getter(name="mediaObjects")
    def media_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObjectArgs']]]]:
        """
        Required. List of media objects.
        """
        return pulumi.get(self, "media_objects")

    @media_objects.setter
    def media_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObjectArgs']]]]):
        pulumi.set(self, "media_objects", value)

    @property
    @pulumi.getter(name="mediaType")
    def media_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. What type of media is the content (ie "audio").
        """
        return pulumi.get(self, "media_type")

    @media_type.setter
    def media_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "media_type", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageMediaContentResponseMediaObjectArgs:
    def __init__(__self__, *,
                 content_url: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 icon: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 large_image: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        Response media object for media content card.
        :param pulumi.Input[str] content_url: Required. Url where the media is stored.
        :param pulumi.Input[str] description: Optional. Description of media card.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] icon: Optional. Icon to display above media content.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] large_image: Optional. Image to display above media content.
        :param pulumi.Input[str] name: Required. Name of media card.
        """
        if content_url is not None:
            pulumi.set(__self__, "content_url", content_url)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if icon is not None:
            pulumi.set(__self__, "icon", icon)
        if large_image is not None:
            pulumi.set(__self__, "large_image", large_image)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="contentUrl")
    def content_url(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Url where the media is stored.
        """
        return pulumi.get(self, "content_url")

    @content_url.setter
    def content_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content_url", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of media card.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def icon(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        Optional. Icon to display above media content.
        """
        return pulumi.get(self, "icon")

    @icon.setter
    def icon(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "icon", value)

    @property
    @pulumi.getter(name="largeImage")
    def large_image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        Optional. Image to display above media content.
        """
        return pulumi.get(self, "large_image")

    @large_image.setter
    def large_image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "large_image", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Name of media card.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageQuickRepliesArgs:
    def __init__(__self__, *,
                 quick_replies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The quick replies response message.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] quick_replies: Optional. The collection of quick replies.
        :param pulumi.Input[str] title: Optional. The title of the collection of quick replies.
        """
        if quick_replies is not None:
            pulumi.set(__self__, "quick_replies", quick_replies)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter(name="quickReplies")
    def quick_replies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The collection of quick replies.
        """
        return pulumi.get(self, "quick_replies")

    @quick_replies.setter
    def quick_replies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "quick_replies", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The title of the collection of quick replies.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageSelectItemInfoArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 synonyms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Additional info about the select item for when it is triggered in a dialog.
        :param pulumi.Input[str] key: Required. A unique key that will be sent back to the agent if this response is given.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] synonyms: Optional. A list of synonyms that can also be used to trigger this item in dialog.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if synonyms is not None:
            pulumi.set(__self__, "synonyms", synonyms)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Required. A unique key that will be sent back to the agent if this response is given.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def synonyms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. A list of synonyms that can also be used to trigger this item in dialog.
        """
        return pulumi.get(self, "synonyms")

    @synonyms.setter
    def synonyms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "synonyms", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageSimpleResponseArgs:
    def __init__(__self__, *,
                 display_text: Optional[pulumi.Input[str]] = None,
                 ssml: Optional[pulumi.Input[str]] = None,
                 text_to_speech: Optional[pulumi.Input[str]] = None):
        """
        The simple response message containing speech or text.
        :param pulumi.Input[str] display_text: Optional. The text to display.
        :param pulumi.Input[str] ssml: One of text_to_speech or ssml must be provided. Structured spoken response to the user in the SSML format. Mutually exclusive with text_to_speech.
        :param pulumi.Input[str] text_to_speech: One of text_to_speech or ssml must be provided. The plain text of the speech output. Mutually exclusive with ssml.
        """
        if display_text is not None:
            pulumi.set(__self__, "display_text", display_text)
        if ssml is not None:
            pulumi.set(__self__, "ssml", ssml)
        if text_to_speech is not None:
            pulumi.set(__self__, "text_to_speech", text_to_speech)

    @property
    @pulumi.getter(name="displayText")
    def display_text(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The text to display.
        """
        return pulumi.get(self, "display_text")

    @display_text.setter
    def display_text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_text", value)

    @property
    @pulumi.getter
    def ssml(self) -> Optional[pulumi.Input[str]]:
        """
        One of text_to_speech or ssml must be provided. Structured spoken response to the user in the SSML format. Mutually exclusive with text_to_speech.
        """
        return pulumi.get(self, "ssml")

    @ssml.setter
    def ssml(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssml", value)

    @property
    @pulumi.getter(name="textToSpeech")
    def text_to_speech(self) -> Optional[pulumi.Input[str]]:
        """
        One of text_to_speech or ssml must be provided. The plain text of the speech output. Mutually exclusive with ssml.
        """
        return pulumi.get(self, "text_to_speech")

    @text_to_speech.setter
    def text_to_speech(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text_to_speech", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageSimpleResponsesArgs:
    def __init__(__self__, *,
                 simple_responses: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponseArgs']]]] = None):
        """
        The collection of simple response candidates. This message in `QueryResult.fulfillment_messages` and `WebhookResponse.fulfillment_messages` should contain only one `SimpleResponse`.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponseArgs']]] simple_responses: Required. The list of simple responses.
        """
        if simple_responses is not None:
            pulumi.set(__self__, "simple_responses", simple_responses)

    @property
    @pulumi.getter(name="simpleResponses")
    def simple_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponseArgs']]]]:
        """
        Required. The list of simple responses.
        """
        return pulumi.get(self, "simple_responses")

    @simple_responses.setter
    def simple_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSimpleResponseArgs']]]]):
        pulumi.set(self, "simple_responses", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageSuggestionArgs:
    def __init__(__self__, *,
                 title: Optional[pulumi.Input[str]] = None):
        """
        The suggestion chip message that the user can tap to quickly post a reply to the conversation.
        :param pulumi.Input[str] title: Required. The text shown the in the suggestion chip.
        """
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The text shown the in the suggestion chip.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageSuggestionsArgs:
    def __init__(__self__, *,
                 suggestions: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionArgs']]]] = None):
        """
        The collection of suggestions.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionArgs']]] suggestions: Required. The list of suggested replies.
        """
        if suggestions is not None:
            pulumi.set(__self__, "suggestions", suggestions)

    @property
    @pulumi.getter
    def suggestions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionArgs']]]]:
        """
        Required. The list of suggested replies.
        """
        return pulumi.get(self, "suggestions")

    @suggestions.setter
    def suggestions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageSuggestionArgs']]]]):
        pulumi.set(self, "suggestions", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageTableCardArgs:
    def __init__(__self__, *,
                 buttons: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]]] = None,
                 column_properties: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageColumnPropertiesArgs']]]] = None,
                 image: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']] = None,
                 rows: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardRowArgs']]]] = None,
                 subtitle: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Table card for Actions on Google.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]] buttons: Optional. List of buttons for the card.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageColumnPropertiesArgs']]] column_properties: Optional. Display properties for the columns in this table.
        :param pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs'] image: Optional. Image which should be displayed on the card.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardRowArgs']]] rows: Optional. Rows in this table of data.
        :param pulumi.Input[str] subtitle: Optional. Subtitle to the title.
        :param pulumi.Input[str] title: Required. Title of the card.
        """
        if buttons is not None:
            pulumi.set(__self__, "buttons", buttons)
        if column_properties is not None:
            pulumi.set(__self__, "column_properties", column_properties)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if rows is not None:
            pulumi.set(__self__, "rows", rows)
        if subtitle is not None:
            pulumi.set(__self__, "subtitle", subtitle)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def buttons(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]]]:
        """
        Optional. List of buttons for the card.
        """
        return pulumi.get(self, "buttons")

    @buttons.setter
    def buttons(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageBasicCardButtonArgs']]]]):
        pulumi.set(self, "buttons", value)

    @property
    @pulumi.getter(name="columnProperties")
    def column_properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageColumnPropertiesArgs']]]]:
        """
        Optional. Display properties for the columns in this table.
        """
        return pulumi.get(self, "column_properties")

    @column_properties.setter
    def column_properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageColumnPropertiesArgs']]]]):
        pulumi.set(self, "column_properties", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]:
        """
        Optional. Image which should be displayed on the card.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2IntentMessageImageArgs']]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def rows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardRowArgs']]]]:
        """
        Optional. Rows in this table of data.
        """
        return pulumi.get(self, "rows")

    @rows.setter
    def rows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardRowArgs']]]]):
        pulumi.set(self, "rows", value)

    @property
    @pulumi.getter
    def subtitle(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Subtitle to the title.
        """
        return pulumi.get(self, "subtitle")

    @subtitle.setter
    def subtitle(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subtitle", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Title of the card.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageTableCardCellArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[str]] = None):
        """
        Cell of TableCardRow.
        :param pulumi.Input[str] text: Required. Text in this cell.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Text in this cell.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageTableCardRowArgs:
    def __init__(__self__, *,
                 cells: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardCellArgs']]]] = None,
                 divider_after: Optional[pulumi.Input[bool]] = None):
        """
        Row of TableCard.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardCellArgs']]] cells: Optional. List of cells that make up this row.
        :param pulumi.Input[bool] divider_after: Optional. Whether to add a visual divider after this row.
        """
        if cells is not None:
            pulumi.set(__self__, "cells", cells)
        if divider_after is not None:
            pulumi.set(__self__, "divider_after", divider_after)

    @property
    @pulumi.getter
    def cells(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardCellArgs']]]]:
        """
        Optional. List of cells that make up this row.
        """
        return pulumi.get(self, "cells")

    @cells.setter
    def cells(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentMessageTableCardCellArgs']]]]):
        pulumi.set(self, "cells", value)

    @property
    @pulumi.getter(name="dividerAfter")
    def divider_after(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether to add a visual divider after this row.
        """
        return pulumi.get(self, "divider_after")

    @divider_after.setter
    def divider_after(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "divider_after", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentMessageTextArgs:
    def __init__(__self__, *,
                 text: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The text response message.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] text: Optional. The collection of the agent's responses.
        """
        if text is not None:
            pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The collection of the agent's responses.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "text", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentParameterArgs:
    def __init__(__self__, *,
                 default_value: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 entity_type_display_name: Optional[pulumi.Input[str]] = None,
                 is_list: Optional[pulumi.Input[bool]] = None,
                 mandatory: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 prompts: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Represents intent parameters.
        :param pulumi.Input[str] default_value: Optional. The default value to use when the `value` yields an empty result. Default values can be extracted from contexts by using the following syntax: `#context_name.parameter_name`.
        :param pulumi.Input[str] display_name: Required. The name of the parameter.
        :param pulumi.Input[str] entity_type_display_name: Optional. The name of the entity type, prefixed with `@`, that describes values of the parameter. If the parameter is required, this must be provided.
        :param pulumi.Input[bool] is_list: Optional. Indicates whether the parameter represents a list of values.
        :param pulumi.Input[bool] mandatory: Optional. Indicates whether the parameter is required. That is, whether the intent cannot be completed without collecting the parameter value.
        :param pulumi.Input[str] name: The unique identifier of this parameter.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] prompts: Optional. The collection of prompts that the agent can present to the user in order to collect a value for the parameter.
        :param pulumi.Input[str] value: Optional. The definition of the parameter value. It can be: - a constant string, - a parameter value defined as `$parameter_name`, - an original parameter value defined as `$parameter_name.original`, - a parameter value from some context defined as `#context_name.parameter_name`.
        """
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if entity_type_display_name is not None:
            pulumi.set(__self__, "entity_type_display_name", entity_type_display_name)
        if is_list is not None:
            pulumi.set(__self__, "is_list", is_list)
        if mandatory is not None:
            pulumi.set(__self__, "mandatory", mandatory)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if prompts is not None:
            pulumi.set(__self__, "prompts", prompts)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The default value to use when the `value` yields an empty result. Default values can be extracted from contexts by using the following syntax: `#context_name.parameter_name`.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The name of the parameter.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="entityTypeDisplayName")
    def entity_type_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the entity type, prefixed with `@`, that describes values of the parameter. If the parameter is required, this must be provided.
        """
        return pulumi.get(self, "entity_type_display_name")

    @entity_type_display_name.setter
    def entity_type_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type_display_name", value)

    @property
    @pulumi.getter(name="isList")
    def is_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether the parameter represents a list of values.
        """
        return pulumi.get(self, "is_list")

    @is_list.setter
    def is_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_list", value)

    @property
    @pulumi.getter
    def mandatory(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether the parameter is required. That is, whether the intent cannot be completed without collecting the parameter value.
        """
        return pulumi.get(self, "mandatory")

    @mandatory.setter
    def mandatory(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "mandatory", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of this parameter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def prompts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The collection of prompts that the agent can present to the user in order to collect a value for the parameter.
        """
        return pulumi.get(self, "prompts")

    @prompts.setter
    def prompts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "prompts", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The definition of the parameter value. It can be: - a constant string, - a parameter value defined as `$parameter_name`, - an original parameter value defined as `$parameter_name.original`, - a parameter value from some context defined as `#context_name.parameter_name`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentTrainingPhraseArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 parts: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentTrainingPhrasePartArgs']]]] = None,
                 times_added_count: Optional[pulumi.Input[int]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Represents an example that the agent is trained on.
        :param pulumi.Input[str] name: The unique identifier of this training phrase.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentTrainingPhrasePartArgs']]] parts: Required. The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `entity_type`, `alias`, and `user_defined` fields are all set.
        :param pulumi.Input[int] times_added_count: Optional. Indicates how many times this example was added to the intent. Each time a developer adds an existing sample by editing an intent or training, this counter is increased.
        :param pulumi.Input[str] type: Required. The type of the training phrase.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parts is not None:
            pulumi.set(__self__, "parts", parts)
        if times_added_count is not None:
            pulumi.set(__self__, "times_added_count", times_added_count)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of this training phrase.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def parts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentTrainingPhrasePartArgs']]]]:
        """
        Required. The ordered list of training phrase parts. The parts are concatenated in order to form the training phrase. Note: The API does not automatically annotate training phrases like the Dialogflow Console does. Note: Do not forget to include whitespace at part boundaries, so the training phrase is well formatted when the parts are concatenated. If the training phrase does not need to be annotated with parameters, you just need a single part with only the Part.text field set. If you want to annotate the training phrase, you must create multiple parts, where the fields of each part are populated in one of two ways: - `Part.text` is set to a part of the phrase that has no parameters. - `Part.text` is set to a part of the phrase that you want to annotate, and the `entity_type`, `alias`, and `user_defined` fields are all set.
        """
        return pulumi.get(self, "parts")

    @parts.setter
    def parts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudDialogflowV2IntentTrainingPhrasePartArgs']]]]):
        pulumi.set(self, "parts", value)

    @property
    @pulumi.getter(name="timesAddedCount")
    def times_added_count(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. Indicates how many times this example was added to the intent. Each time a developer adds an existing sample by editing an intent or training, this counter is increased.
        """
        return pulumi.get(self, "times_added_count")

    @times_added_count.setter
    def times_added_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "times_added_count", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The type of the training phrase.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GoogleCloudDialogflowV2IntentTrainingPhrasePartArgs:
    def __init__(__self__, *,
                 alias: Optional[pulumi.Input[str]] = None,
                 entity_type: Optional[pulumi.Input[str]] = None,
                 text: Optional[pulumi.Input[str]] = None,
                 user_defined: Optional[pulumi.Input[bool]] = None):
        """
        Represents a part of a training phrase.
        :param pulumi.Input[str] alias: Optional. The parameter name for the value extracted from the annotated part of the example. This field is required for annotated parts of the training phrase.
        :param pulumi.Input[str] entity_type: Optional. The entity type name prefixed with `@`. This field is required for annotated parts of the training phrase.
        :param pulumi.Input[str] text: Required. The text for this part.
        :param pulumi.Input[bool] user_defined: Optional. Indicates whether the text was manually annotated. This field is set to true when the Dialogflow Console is used to manually annotate the part. When creating an annotated part with the API, you must set this to true.
        """
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if entity_type is not None:
            pulumi.set(__self__, "entity_type", entity_type)
        if text is not None:
            pulumi.set(__self__, "text", text)
        if user_defined is not None:
            pulumi.set(__self__, "user_defined", user_defined)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The parameter name for the value extracted from the annotated part of the example. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The entity type name prefixed with `@`. This field is required for annotated parts of the training phrase.
        """
        return pulumi.get(self, "entity_type")

    @entity_type.setter
    def entity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type", value)

    @property
    @pulumi.getter
    def text(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The text for this part.
        """
        return pulumi.get(self, "text")

    @text.setter
    def text(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "text", value)

    @property
    @pulumi.getter(name="userDefined")
    def user_defined(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Indicates whether the text was manually annotated. This field is set to true when the Dialogflow Console is used to manually annotate the part. When creating an annotated part with the API, you must set this to true.
        """
        return pulumi.get(self, "user_defined")

    @user_defined.setter
    def user_defined(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "user_defined", value)


@pulumi.input_type
class GoogleCloudDialogflowV2LoggingConfigArgs:
    def __init__(__self__, *,
                 enable_stackdriver_logging: Optional[pulumi.Input[bool]] = None):
        """
        Defines logging behavior for conversation lifecycle events.
        :param pulumi.Input[bool] enable_stackdriver_logging: Whether to log conversation events like CONVERSATION_STARTED to Stackdriver in the conversation project as JSON format ConversationEvent protos.
        """
        if enable_stackdriver_logging is not None:
            pulumi.set(__self__, "enable_stackdriver_logging", enable_stackdriver_logging)

    @property
    @pulumi.getter(name="enableStackdriverLogging")
    def enable_stackdriver_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to log conversation events like CONVERSATION_STARTED to Stackdriver in the conversation project as JSON format ConversationEvent protos.
        """
        return pulumi.get(self, "enable_stackdriver_logging")

    @enable_stackdriver_logging.setter
    def enable_stackdriver_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_stackdriver_logging", value)


@pulumi.input_type
class GoogleCloudDialogflowV2NotificationConfigArgs:
    def __init__(__self__, *,
                 message_format: Optional[pulumi.Input[str]] = None,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        Defines notification behavior.
        :param pulumi.Input[str] message_format: Format of message.
        :param pulumi.Input[str] topic: Name of the Pub/Sub topic to publish conversation events like CONVERSATION_STARTED as serialized ConversationEvent protos. Notification works for phone calls, if this topic either is in the same project as the conversation or you grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow Service Agent` role in the topic project. Format: `projects//locations//topics/`.
        """
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[str]]:
        """
        Format of message.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Pub/Sub topic to publish conversation events like CONVERSATION_STARTED as serialized ConversationEvent protos. Notification works for phone calls, if this topic either is in the same project as the conversation or you grant `service-@gcp-sa-dialogflow.iam.gserviceaccount.com` the `Dialogflow Service Agent` role in the topic project. Format: `projects//locations//topics/`.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class GoogleCloudDialogflowV2SpeechToTextConfigArgs:
    def __init__(__self__, *,
                 speech_model_variant: Optional[pulumi.Input[str]] = None):
        """
        Configures speech transcription for ConversationProfile.
        :param pulumi.Input[str] speech_model_variant: Optional. The speech model used in speech to text. `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as `USE_ENHANCED`. It can be overridden in AnalyzeContentRequest and StreamingAnalyzeContentRequest request.
        """
        if speech_model_variant is not None:
            pulumi.set(__self__, "speech_model_variant", speech_model_variant)

    @property
    @pulumi.getter(name="speechModelVariant")
    def speech_model_variant(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The speech model used in speech to text. `SPEECH_MODEL_VARIANT_UNSPECIFIED`, `USE_BEST_AVAILABLE` will be treated as `USE_ENHANCED`. It can be overridden in AnalyzeContentRequest and StreamingAnalyzeContentRequest request.
        """
        return pulumi.get(self, "speech_model_variant")

    @speech_model_variant.setter
    def speech_model_variant(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "speech_model_variant", value)


@pulumi.input_type
class GoogleCloudDialogflowV2SuggestionFeatureArgs:
    def __init__(__self__, *,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The type of Human Agent Assistant API suggestion to perform, and the maximum number of results to return for that type. Multiple `Feature` objects can be specified in the `features` list.
        :param pulumi.Input[str] type: Type of Human Agent Assistant API feature to request.
        """
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of Human Agent Assistant API feature to request.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


