# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Job']


class Job(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_request_id: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 created_from_snapshot_id: Optional[pulumi.Input[str]] = None,
                 current_state: Optional[pulumi.Input[str]] = None,
                 current_state_time: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[pulumi.InputType['EnvironmentArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 job_id: Optional[pulumi.Input[str]] = None,
                 job_metadata: Optional[pulumi.Input[pulumi.InputType['JobMetadataArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pipeline_description: Optional[pulumi.Input[pulumi.InputType['PipelineDescriptionArgs']]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 replace_job_id: Optional[pulumi.Input[str]] = None,
                 replaced_by_job_id: Optional[pulumi.Input[str]] = None,
                 requested_state: Optional[pulumi.Input[str]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 stage_states: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExecutionStageStateArgs']]]]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 steps: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepArgs']]]]] = None,
                 steps_location: Optional[pulumi.Input[str]] = None,
                 temp_files: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 transform_name_mapping: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a Cloud Dataflow job. To create a job, we recommend using `projects.locations.jobs.create` with a [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using `projects.jobs.create` is not recommended, as your job will always start in `us-central1`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_request_id: The client's unique identifier of the job, re-used across retried attempts. If this field is set, the service will ensure its uniqueness. The request to create a job will fail if the service has knowledge of a previously submitted job with the same client's ID and job name. The caller may use this field to ensure idempotence of job creation across retried attempts to create a job. By default, the field is empty and, in that case, the service ignores it.
        :param pulumi.Input[str] create_time: The timestamp when the job was initially created. Immutable and set by the Cloud Dataflow service.
        :param pulumi.Input[str] created_from_snapshot_id: If this is specified, the job's initial state is populated from the given snapshot.
        :param pulumi.Input[str] current_state: The current state of the job. Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise specified. A job in the `JOB_STATE_RUNNING` state may asynchronously enter a terminal state. After a job has reached a terminal state, no further state updates may be made. This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        :param pulumi.Input[str] current_state_time: The timestamp associated with the current state.
        :param pulumi.Input[pulumi.InputType['EnvironmentArgs']] environment: The environment for the job.
        :param pulumi.Input[str] id: The unique ID of this job. This field is set by the Cloud Dataflow service when the Job is created, and is immutable for the life of the job.
        :param pulumi.Input[pulumi.InputType['JobMetadataArgs']] job_metadata: This field is populated by the Dataflow service to support filtering jobs by the metadata values provided here. Populated for ListJobs and all GetJob views SUMMARY and higher.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels for this job. The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: * Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp: [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally constrained to be <= 128 bytes in size.
        :param pulumi.Input[str] location: The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that contains this job.
        :param pulumi.Input[str] name: The user-specified Cloud Dataflow job name. Only one Job with a given name may exist in a project at any given time. If a caller attempts to create a Job with the same name as an already-existing Job, the attempt returns the existing Job. The name must match the regular expression `[a-z]([-a-z0-9]{0,38}[a-z0-9])?`
        :param pulumi.Input[pulumi.InputType['PipelineDescriptionArgs']] pipeline_description: Preliminary field: The format of this data may change at any time. A description of the user pipeline and stages through which it is executed. Created by Cloud Dataflow service. Only retrieved with JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
        :param pulumi.Input[str] project_id: The ID of the Cloud Platform project that the job belongs to.
        :param pulumi.Input[str] replace_job_id: If this job is an update of an existing job, this field is the job ID of the job it replaced. When sending a `CreateJobRequest`, you can update a job by specifying it here. The job named here is stopped, and its intermediate state is transferred to this job.
        :param pulumi.Input[str] replaced_by_job_id: If another job is an update of this job (and thus, this job is in `JOB_STATE_UPDATED`), this field contains the ID of that job.
        :param pulumi.Input[str] requested_state: The job's requested state. `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING` states, by setting requested_state. `UpdateJob` may also be used to directly set a job's requested state to `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the job if it has not already reached a terminal state.
        :param pulumi.Input[bool] satisfies_pzs: Reserved for future use. This field is set only in responses from the server; it is ignored if it is set in any requests.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ExecutionStageStateArgs']]]] stage_states: This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        :param pulumi.Input[str] start_time: The timestamp when the job was started (transitioned to JOB_STATE_PENDING). Flexible resource scheduling jobs are started with some delay after job creation, so start_time is unset before start and is updated when the job is started by the Cloud Dataflow service. For other jobs, start_time always equals to create_time and is immutable and set by the Cloud Dataflow service.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['StepArgs']]]] steps: Exactly one of step or steps_location should be specified. The top-level steps that constitute the entire job. Only retrieved with JOB_VIEW_ALL.
        :param pulumi.Input[str] steps_location: The Cloud Storage location where the steps are stored.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] temp_files: A set of files the system should be aware of that are used for temporary storage. These temporary files will be removed on job completion. No duplicates are allowed. No file patterns are supported. The supported files are: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] transform_name_mapping: The map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job.
        :param pulumi.Input[str] type: The type of Cloud Dataflow job.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['client_request_id'] = client_request_id
            __props__['create_time'] = create_time
            __props__['created_from_snapshot_id'] = created_from_snapshot_id
            __props__['current_state'] = current_state
            __props__['current_state_time'] = current_state_time
            __props__['environment'] = environment
            __props__['id'] = id
            if job_id is None and not opts.urn:
                raise TypeError("Missing required property 'job_id'")
            __props__['job_id'] = job_id
            __props__['job_metadata'] = job_metadata
            __props__['labels'] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__['location'] = location
            __props__['name'] = name
            __props__['pipeline_description'] = pipeline_description
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            __props__['replace_job_id'] = replace_job_id
            __props__['replaced_by_job_id'] = replaced_by_job_id
            __props__['requested_state'] = requested_state
            __props__['satisfies_pzs'] = satisfies_pzs
            __props__['stage_states'] = stage_states
            __props__['start_time'] = start_time
            __props__['steps'] = steps
            __props__['steps_location'] = steps_location
            __props__['temp_files'] = temp_files
            __props__['transform_name_mapping'] = transform_name_mapping
            __props__['type'] = type
        super(Job, __self__).__init__(
            'gcp-native:dataflow/v1b3:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["client_request_id"] = None
        __props__["create_time"] = None
        __props__["created_from_snapshot_id"] = None
        __props__["current_state"] = None
        __props__["current_state_time"] = None
        __props__["environment"] = None
        __props__["job_metadata"] = None
        __props__["labels"] = None
        __props__["location"] = None
        __props__["name"] = None
        __props__["pipeline_description"] = None
        __props__["project_id"] = None
        __props__["replace_job_id"] = None
        __props__["replaced_by_job_id"] = None
        __props__["requested_state"] = None
        __props__["satisfies_pzs"] = None
        __props__["stage_states"] = None
        __props__["start_time"] = None
        __props__["steps"] = None
        __props__["steps_location"] = None
        __props__["temp_files"] = None
        __props__["transform_name_mapping"] = None
        __props__["type"] = None
        return Job(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientRequestId")
    def client_request_id(self) -> pulumi.Output[str]:
        """
        The client's unique identifier of the job, re-used across retried attempts. If this field is set, the service will ensure its uniqueness. The request to create a job will fail if the service has knowledge of a previously submitted job with the same client's ID and job name. The caller may use this field to ensure idempotence of job creation across retried attempts to create a job. By default, the field is empty and, in that case, the service ignores it.
        """
        return pulumi.get(self, "client_request_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the job was initially created. Immutable and set by the Cloud Dataflow service.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="createdFromSnapshotId")
    def created_from_snapshot_id(self) -> pulumi.Output[str]:
        """
        If this is specified, the job's initial state is populated from the given snapshot.
        """
        return pulumi.get(self, "created_from_snapshot_id")

    @property
    @pulumi.getter(name="currentState")
    def current_state(self) -> pulumi.Output[str]:
        """
        The current state of the job. Jobs are created in the `JOB_STATE_STOPPED` state unless otherwise specified. A job in the `JOB_STATE_RUNNING` state may asynchronously enter a terminal state. After a job has reached a terminal state, no further state updates may be made. This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        """
        return pulumi.get(self, "current_state")

    @property
    @pulumi.getter(name="currentStateTime")
    def current_state_time(self) -> pulumi.Output[str]:
        """
        The timestamp associated with the current state.
        """
        return pulumi.get(self, "current_state_time")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output['outputs.EnvironmentResponse']:
        """
        The environment for the job.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="jobMetadata")
    def job_metadata(self) -> pulumi.Output['outputs.JobMetadataResponse']:
        """
        This field is populated by the Dataflow service to support filtering jobs by the metadata values provided here. Populated for ListJobs and all GetJob views SUMMARY and higher.
        """
        return pulumi.get(self, "job_metadata")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User-defined labels for this job. The labels map can contain no more than 64 entries. Entries of the labels map are UTF8 strings that comply with the following restrictions: * Keys must conform to regexp: \p{Ll}\p{Lo}{0,62} * Values must conform to regexp: [\p{Ll}\p{Lo}\p{N}_-]{0,63} * Both keys and values are additionally constrained to be <= 128 bytes in size.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The [regional endpoint] (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints) that contains this job.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The user-specified Cloud Dataflow job name. Only one Job with a given name may exist in a project at any given time. If a caller attempts to create a Job with the same name as an already-existing Job, the attempt returns the existing Job. The name must match the regular expression `[a-z]([-a-z0-9]{0,38}[a-z0-9])?`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pipelineDescription")
    def pipeline_description(self) -> pulumi.Output['outputs.PipelineDescriptionResponse']:
        """
        Preliminary field: The format of this data may change at any time. A description of the user pipeline and stages through which it is executed. Created by Cloud Dataflow service. Only retrieved with JOB_VIEW_DESCRIPTION or JOB_VIEW_ALL.
        """
        return pulumi.get(self, "pipeline_description")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The ID of the Cloud Platform project that the job belongs to.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="replaceJobId")
    def replace_job_id(self) -> pulumi.Output[str]:
        """
        If this job is an update of an existing job, this field is the job ID of the job it replaced. When sending a `CreateJobRequest`, you can update a job by specifying it here. The job named here is stopped, and its intermediate state is transferred to this job.
        """
        return pulumi.get(self, "replace_job_id")

    @property
    @pulumi.getter(name="replacedByJobId")
    def replaced_by_job_id(self) -> pulumi.Output[str]:
        """
        If another job is an update of this job (and thus, this job is in `JOB_STATE_UPDATED`), this field contains the ID of that job.
        """
        return pulumi.get(self, "replaced_by_job_id")

    @property
    @pulumi.getter(name="requestedState")
    def requested_state(self) -> pulumi.Output[str]:
        """
        The job's requested state. `UpdateJob` may be used to switch between the `JOB_STATE_STOPPED` and `JOB_STATE_RUNNING` states, by setting requested_state. `UpdateJob` may also be used to directly set a job's requested state to `JOB_STATE_CANCELLED` or `JOB_STATE_DONE`, irrevocably terminating the job if it has not already reached a terminal state.
        """
        return pulumi.get(self, "requested_state")

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        Reserved for future use. This field is set only in responses from the server; it is ignored if it is set in any requests.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter(name="stageStates")
    def stage_states(self) -> pulumi.Output[Sequence['outputs.ExecutionStageStateResponse']]:
        """
        This field may be mutated by the Cloud Dataflow service; callers cannot mutate it.
        """
        return pulumi.get(self, "stage_states")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        The timestamp when the job was started (transitioned to JOB_STATE_PENDING). Flexible resource scheduling jobs are started with some delay after job creation, so start_time is unset before start and is updated when the job is started by the Cloud Dataflow service. For other jobs, start_time always equals to create_time and is immutable and set by the Cloud Dataflow service.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def steps(self) -> pulumi.Output[Sequence['outputs.StepResponse']]:
        """
        Exactly one of step or steps_location should be specified. The top-level steps that constitute the entire job. Only retrieved with JOB_VIEW_ALL.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter(name="stepsLocation")
    def steps_location(self) -> pulumi.Output[str]:
        """
        The Cloud Storage location where the steps are stored.
        """
        return pulumi.get(self, "steps_location")

    @property
    @pulumi.getter(name="tempFiles")
    def temp_files(self) -> pulumi.Output[Sequence[str]]:
        """
        A set of files the system should be aware of that are used for temporary storage. These temporary files will be removed on job completion. No duplicates are allowed. No file patterns are supported. The supported files are: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_files")

    @property
    @pulumi.getter(name="transformNameMapping")
    def transform_name_mapping(self) -> pulumi.Output[Mapping[str, str]]:
        """
        The map of transform name prefixes of the job to be replaced to the corresponding name prefixes of the new job.
        """
        return pulumi.get(self, "transform_name_mapping")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of Cloud Dataflow job.
        """
        return pulumi.get(self, "type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

