# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['ForwardingRule']


class ForwardingRule(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 ip_protocol: Optional[pulumi.Input[str]] = None,
                 all_ports: Optional[pulumi.Input[bool]] = None,
                 allow_global_access: Optional[pulumi.Input[bool]] = None,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 forwarding_rule: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ip_version: Optional[pulumi.Input[str]] = None,
                 is_mirroring_collector: Optional[pulumi.Input[bool]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 metadata_filters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetadataFilterArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 network_tier: Optional[pulumi.Input[str]] = None,
                 port_range: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 psc_connection_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 service_directory_registrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ForwardingRuleServiceDirectoryRegistrationArgs']]]]] = None,
                 service_label: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a ForwardingRule resource in the specified project and region using the data included in the request.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ip_address: IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.
               
               If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:
               
               * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:  
               - projects/project_id/regions/region/addresses/address-name 
               - regions/region/addresses/address-name 
               - global/addresses/address-name 
               - address-name  
               
               The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
               
               Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.
               
               For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
        :param pulumi.Input[str] ip_protocol: The IP protocol to which this rule applies.
               
               For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
               
               The valid IP protocols are different for different load balancing products:  
               - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid. 
               - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.  
               - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid. 
               - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid. 
               - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
        :param pulumi.Input[bool] all_ports: This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.
               
               When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
        :param pulumi.Input[bool] allow_global_access: This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
        :param pulumi.Input[str] backend_service: Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.
               
               To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] ip_version: The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
        :param pulumi.Input[bool] is_mirroring_collector: Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
        :param pulumi.Input[str] kind: [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
        :param pulumi.Input[str] label_fingerprint: A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
               
               To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        :param pulumi.Input[str] load_balancing_scheme: Specifies the forwarding rule type.
               
                
               - EXTERNAL is used for:  
               - Classic Cloud VPN gateways 
               - Protocol forwarding to VMs from an external IP address 
               - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing    
               - INTERNAL is used for:  
               - Protocol forwarding to VMs from an internal IP address 
               - Internal TCP/UDP Load Balancing   
               - INTERNAL_MANAGED is used for:  
               - Internal HTTP(S) Load Balancing   
               - INTERNAL_SELF_MANAGED is used for:  
               - Traffic Director    
               
               For more information about forwarding rules, refer to Forwarding rule concepts.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MetadataFilterArgs']]]] metadata_filters: Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
               For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
               metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
               metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[str] name: Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] network: This field is not used for external load balancing.
               
               For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
               
               For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
        :param pulumi.Input[str] network_tier: This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
               
               For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
               
               If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
        :param pulumi.Input[str] port_range: This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.
               
               Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
               
               Some types of forwarding target have constraints on the acceptable ports:  
               - TargetHttpProxy: 80, 8080 
               - TargetHttpsProxy: 443 
               - TargetGrpcProxy: no constraints 
               - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222 
               - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222 
               - TargetVpnGateway: 500, 4500
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.
               
               You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.
               
               You can specify a list of up to five ports, which can be non-contiguous.
               
               For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.
               
               For more information, see [Port specifications](/load-balancing/docs/forwarding-rule-concepts#port_specifications).
        :param pulumi.Input[str] psc_connection_id: [Output Only] The PSC connection id of the PSC Forwarding Rule.
        :param pulumi.Input[str] region: [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ForwardingRuleServiceDirectoryRegistrationArgs']]]] service_directory_registrations: Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.
               
               It is only supported for Internal TCP/UDP Load Balancing and Internal HTTP(S) Load Balancing.
        :param pulumi.Input[str] service_label: An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.
               
               The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
               
               This field is only used for internal load balancing.
        :param pulumi.Input[str] service_name: [Output Only] The internal fully qualified service name for this Forwarding Rule.
               
               This field is only used for internal load balancing.
        :param pulumi.Input[str] subnetwork: This field is only used for internal load balancing.
               
               For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.
               
               If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['ip_address'] = ip_address
            __props__['ip_protocol'] = ip_protocol
            __props__['all_ports'] = all_ports
            __props__['allow_global_access'] = allow_global_access
            __props__['backend_service'] = backend_service
            __props__['creation_timestamp'] = creation_timestamp
            __props__['description'] = description
            __props__['fingerprint'] = fingerprint
            if forwarding_rule is None and not opts.urn:
                raise TypeError("Missing required property 'forwarding_rule'")
            __props__['forwarding_rule'] = forwarding_rule
            __props__['id'] = id
            __props__['ip_version'] = ip_version
            __props__['is_mirroring_collector'] = is_mirroring_collector
            __props__['kind'] = kind
            __props__['label_fingerprint'] = label_fingerprint
            __props__['labels'] = labels
            __props__['load_balancing_scheme'] = load_balancing_scheme
            __props__['metadata_filters'] = metadata_filters
            __props__['name'] = name
            __props__['network'] = network
            __props__['network_tier'] = network_tier
            __props__['port_range'] = port_range
            __props__['ports'] = ports
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['psc_connection_id'] = psc_connection_id
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__['region'] = region
            __props__['self_link'] = self_link
            __props__['service_directory_registrations'] = service_directory_registrations
            __props__['service_label'] = service_label
            __props__['service_name'] = service_name
            __props__['subnetwork'] = subnetwork
            __props__['target'] = target
        super(ForwardingRule, __self__).__init__(
            'gcp-native:compute/v1:ForwardingRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ForwardingRule':
        """
        Get an existing ForwardingRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["ip_address"] = None
        __props__["ip_protocol"] = None
        __props__["all_ports"] = None
        __props__["allow_global_access"] = None
        __props__["backend_service"] = None
        __props__["creation_timestamp"] = None
        __props__["description"] = None
        __props__["fingerprint"] = None
        __props__["ip_version"] = None
        __props__["is_mirroring_collector"] = None
        __props__["kind"] = None
        __props__["label_fingerprint"] = None
        __props__["labels"] = None
        __props__["load_balancing_scheme"] = None
        __props__["metadata_filters"] = None
        __props__["name"] = None
        __props__["network"] = None
        __props__["network_tier"] = None
        __props__["port_range"] = None
        __props__["ports"] = None
        __props__["psc_connection_id"] = None
        __props__["region"] = None
        __props__["self_link"] = None
        __props__["service_directory_registrations"] = None
        __props__["service_label"] = None
        __props__["service_name"] = None
        __props__["subnetwork"] = None
        __props__["target"] = None
        return ForwardingRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="IPAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.

        If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:

        * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:  
        - projects/project_id/regions/region/addresses/address-name 
        - regions/region/addresses/address-name 
        - global/addresses/address-name 
        - address-name  

        The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).

        Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.

        For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="IPProtocol")
    def ip_protocol(self) -> pulumi.Output[str]:
        """
        The IP protocol to which this rule applies.

        For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.

        The valid IP protocols are different for different load balancing products:  
        - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid. 
        - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.  
        - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid. 
        - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid. 
        - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
        """
        return pulumi.get(self, "ip_protocol")

    @property
    @pulumi.getter(name="allPorts")
    def all_ports(self) -> pulumi.Output[bool]:
        """
        This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.

        When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
        """
        return pulumi.get(self, "all_ports")

    @property
    @pulumi.getter(name="allowGlobalAccess")
    def allow_global_access(self) -> pulumi.Output[bool]:
        """
        This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
        """
        return pulumi.get(self, "allow_global_access")

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> pulumi.Output[str]:
        """
        Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
        """
        return pulumi.get(self, "backend_service")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.

        To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> pulumi.Output[str]:
        """
        The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="isMirroringCollector")
    def is_mirroring_collector(self) -> pulumi.Output[bool]:
        """
        Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
        """
        return pulumi.get(self, "is_mirroring_collector")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        A fingerprint for the labels being applied to this resource, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.

        To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[str]:
        """
        Specifies the forwarding rule type.

         
        - EXTERNAL is used for:  
        - Classic Cloud VPN gateways 
        - Protocol forwarding to VMs from an external IP address 
        - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing    
        - INTERNAL is used for:  
        - Protocol forwarding to VMs from an internal IP address 
        - Internal TCP/UDP Load Balancing   
        - INTERNAL_MANAGED is used for:  
        - Internal HTTP(S) Load Balancing   
        - INTERNAL_SELF_MANAGED is used for:  
        - Traffic Director    

        For more information about forwarding rules, refer to Forwarding rule concepts.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter(name="metadataFilters")
    def metadata_filters(self) -> pulumi.Output[Sequence['outputs.MetadataFilterResponse']]:
        """
        Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
        For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
        metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
        metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "metadata_filters")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        This field is not used for external load balancing.

        For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.

        For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="networkTier")
    def network_tier(self) -> pulumi.Output[str]:
        """
        This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.

        For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.

        If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
        """
        return pulumi.get(self, "network_tier")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> pulumi.Output[str]:
        """
        This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.

        Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.

        Some types of forwarding target have constraints on the acceptable ports:  
        - TargetHttpProxy: 80, 8080 
        - TargetHttpsProxy: 443 
        - TargetGrpcProxy: no constraints 
        - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222 
        - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222 
        - TargetVpnGateway: 500, 4500
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Sequence[str]]:
        """
        The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.

        You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.

        You can specify a list of up to five ports, which can be non-contiguous.

        For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.

        For more information, see [Port specifications](/load-balancing/docs/forwarding-rule-concepts#port_specifications).
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="pscConnectionId")
    def psc_connection_id(self) -> pulumi.Output[str]:
        """
        [Output Only] The PSC connection id of the PSC Forwarding Rule.
        """
        return pulumi.get(self, "psc_connection_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="serviceDirectoryRegistrations")
    def service_directory_registrations(self) -> pulumi.Output[Sequence['outputs.ForwardingRuleServiceDirectoryRegistrationResponse']]:
        """
        Service Directory resources to register this forwarding rule with. Currently, only supports a single Service Directory resource.

        It is only supported for Internal TCP/UDP Load Balancing and Internal HTTP(S) Load Balancing.
        """
        return pulumi.get(self, "service_directory_registrations")

    @property
    @pulumi.getter(name="serviceLabel")
    def service_label(self) -> pulumi.Output[str]:
        """
        An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.

        The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.

        This field is only used for internal load balancing.
        """
        return pulumi.get(self, "service_label")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        [Output Only] The internal fully qualified service name for this Forwarding Rule.

        This field is only used for internal load balancing.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def subnetwork(self) -> pulumi.Output[str]:
        """
        This field is only used for internal load balancing.

        For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.

        If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[str]:
        return pulumi.get(self, "target")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

