# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Instance']


class Instance(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_machine_features: Optional[pulumi.Input[pulumi.InputType['AdvancedMachineFeaturesArgs']]] = None,
                 can_ip_forward: Optional[pulumi.Input[bool]] = None,
                 confidential_instance_config: Optional[pulumi.Input[pulumi.InputType['ConfidentialInstanceConfigArgs']]] = None,
                 cpu_platform: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AttachedDiskArgs']]]]] = None,
                 display_device: Optional[pulumi.Input[pulumi.InputType['DisplayDeviceArgs']]] = None,
                 erase_windows_vss_signature: Optional[pulumi.Input[bool]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 guest_accelerators: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AcceleratorConfigArgs']]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 instance: Optional[pulumi.Input[str]] = None,
                 instance_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 last_start_timestamp: Optional[pulumi.Input[str]] = None,
                 last_stop_timestamp: Optional[pulumi.Input[str]] = None,
                 last_suspended_timestamp: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[pulumi.InputType['MetadataArgs']]] = None,
                 min_cpu_platform: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_interfaces: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkInterfaceArgs']]]]] = None,
                 network_performance_config: Optional[pulumi.Input[pulumi.InputType['NetworkPerformanceConfigArgs']]] = None,
                 post_key_revocation_action_type: Optional[pulumi.Input[str]] = None,
                 preserved_state_size_gb: Optional[pulumi.Input[str]] = None,
                 private_ipv6_google_access: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 reservation_affinity: Optional[pulumi.Input[pulumi.InputType['ReservationAffinityArgs']]] = None,
                 resource_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 resource_status: Optional[pulumi.Input[pulumi.InputType['ResourceStatusArgs']]] = None,
                 satisfies_pzs: Optional[pulumi.Input[bool]] = None,
                 scheduling: Optional[pulumi.Input[pulumi.InputType['SchedulingArgs']]] = None,
                 secure_labels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 secure_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 self_link_with_id: Optional[pulumi.Input[str]] = None,
                 service_accounts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAccountArgs']]]]] = None,
                 shielded_instance_config: Optional[pulumi.Input[pulumi.InputType['ShieldedInstanceConfigArgs']]] = None,
                 shielded_instance_integrity_policy: Optional[pulumi.Input[pulumi.InputType['ShieldedInstanceIntegrityPolicyArgs']]] = None,
                 shielded_vm_config: Optional[pulumi.Input[pulumi.InputType['ShieldedVmConfigArgs']]] = None,
                 shielded_vm_integrity_policy: Optional[pulumi.Input[pulumi.InputType['ShieldedVmIntegrityPolicyArgs']]] = None,
                 source_machine_image: Optional[pulumi.Input[str]] = None,
                 source_machine_image_encryption_key: Optional[pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']]] = None,
                 start_restricted: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_message: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[pulumi.InputType['TagsArgs']]] = None,
                 upcoming_maintenance: Optional[pulumi.Input[pulumi.InputType['UpcomingMaintenanceArgs']]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an instance resource in the specified project using the data included in the request.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AdvancedMachineFeaturesArgs']] advanced_machine_features: Controls for advanced machine-related behavior features.
        :param pulumi.Input[bool] can_ip_forward: Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
        :param pulumi.Input[str] cpu_platform: [Output Only] The CPU platform used by this instance.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[bool] deletion_protection: Whether the resource should be protected against deletion.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AttachedDiskArgs']]]] disks: Array of disks associated with this instance. Persistent disks must be created before you can assign them.
        :param pulumi.Input[pulumi.InputType['DisplayDeviceArgs']] display_device: Enables display device for the instance.
        :param pulumi.Input[bool] erase_windows_vss_signature: Specifies whether the disks restored from source snapshots or source machine image should erase Windows specific VSS signature.
        :param pulumi.Input[str] fingerprint: Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance.
               
               To see the latest fingerprint, make get() request to the instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AcceleratorConfigArgs']]]] guest_accelerators: A list of the type and count of accelerator cards attached to the instance.
        :param pulumi.Input[str] hostname: Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']] instance_encryption_key: Encrypts or decrypts data for an instance with a customer-supplied encryption key.
               
               If you are creating a new instance, this field encrypts the local SSD and in-memory contents of the instance using a key that you provide.
               
               If you are restarting an instance protected with a customer-supplied encryption key, you must provide the correct key in order to successfully restart the instance.
               
               If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key and you do not need to provide a key to start the instance later.
               
               Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt local SSDs and in-memory content in a managed instance group.
        :param pulumi.Input[str] kind: [Output Only] Type of the resource. Always compute#instance for instances.
        :param pulumi.Input[str] label_fingerprint: A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.
               
               To see the latest fingerprint, make get() request to the instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this instance. These can be later modified by the setLabels method.
        :param pulumi.Input[str] last_start_timestamp: [Output Only] Last start timestamp in RFC3339 text format.
        :param pulumi.Input[str] last_stop_timestamp: [Output Only] Last stop timestamp in RFC3339 text format.
        :param pulumi.Input[str] last_suspended_timestamp: [Output Only] Last suspended timestamp in RFC3339 text format.
        :param pulumi.Input[str] machine_type: Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type:
               zones/us-central1-f/machineTypes/n1-standard-1
               
               
               To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
               zones/zone/machineTypes/custom-CPUS-MEMORY
               
               
               For example: zones/us-central1-f/machineTypes/custom-4-5120 
               
               For a full list of restrictions, read the Specifications for custom machine types.
        :param pulumi.Input[pulumi.InputType['MetadataArgs']] metadata: The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
        :param pulumi.Input[str] min_cpu_platform: Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
        :param pulumi.Input[str] name: The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NetworkInterfaceArgs']]]] network_interfaces: An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
        :param pulumi.Input[str] post_key_revocation_action_type: PostKeyRevocationActionType of the instance.
        :param pulumi.Input[str] preserved_state_size_gb: Total amount of preserved state for SUSPENDED instances. Read-only in the api.
        :param pulumi.Input[str] private_ipv6_google_access: The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
        :param pulumi.Input[pulumi.InputType['ReservationAffinityArgs']] reservation_affinity: Specifies the reservations that this instance can consume from.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_policies: Resource policies applied to this instance.
        :param pulumi.Input[pulumi.InputType['ResourceStatusArgs']] resource_status: [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
        :param pulumi.Input[bool] satisfies_pzs: [Output Only] Reserved for future use.
        :param pulumi.Input[pulumi.InputType['SchedulingArgs']] scheduling: Sets the scheduling options for this instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secure_labels: Secure labels to apply to this instance. These can be later modified by the update method. Maximum number of secure labels allowed is 300.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] secure_tags: Secure tags to apply to this instance. These can be later modified by the update method. Maximum number of secure tags allowed is 300.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for this resource.
        :param pulumi.Input[str] self_link_with_id: [Output Only] Server-defined URL for this resource with the resource id.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceAccountArgs']]]] service_accounts: A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.
               
               Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
        :param pulumi.Input[pulumi.InputType['ShieldedVmConfigArgs']] shielded_vm_config: Deprecating, please use shielded_instance_config.
        :param pulumi.Input[pulumi.InputType['ShieldedVmIntegrityPolicyArgs']] shielded_vm_integrity_policy: Deprecating, please use shielded_instance_integrity_policy.
        :param pulumi.Input[str] source_machine_image: Source machine image
        :param pulumi.Input[pulumi.InputType['CustomerEncryptionKeyArgs']] source_machine_image_encryption_key: Source machine image encryption key when creating an instance from a machine image.
        :param pulumi.Input[bool] start_restricted: [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
        :param pulumi.Input[str] status: [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
        :param pulumi.Input[str] status_message: [Output Only] An optional, human-readable explanation of the status.
        :param pulumi.Input[pulumi.InputType['TagsArgs']] tags: Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
        :param pulumi.Input[pulumi.InputType['UpcomingMaintenanceArgs']] upcoming_maintenance: [Output Only] Specifies upcoming maintenance for the instance.
        :param pulumi.Input[str] zone: [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['advanced_machine_features'] = advanced_machine_features
            __props__['can_ip_forward'] = can_ip_forward
            __props__['confidential_instance_config'] = confidential_instance_config
            __props__['cpu_platform'] = cpu_platform
            __props__['creation_timestamp'] = creation_timestamp
            __props__['deletion_protection'] = deletion_protection
            __props__['description'] = description
            __props__['disks'] = disks
            __props__['display_device'] = display_device
            __props__['erase_windows_vss_signature'] = erase_windows_vss_signature
            __props__['fingerprint'] = fingerprint
            __props__['guest_accelerators'] = guest_accelerators
            __props__['hostname'] = hostname
            __props__['id'] = id
            if instance is None and not opts.urn:
                raise TypeError("Missing required property 'instance'")
            __props__['instance'] = instance
            __props__['instance_encryption_key'] = instance_encryption_key
            __props__['kind'] = kind
            __props__['label_fingerprint'] = label_fingerprint
            __props__['labels'] = labels
            __props__['last_start_timestamp'] = last_start_timestamp
            __props__['last_stop_timestamp'] = last_stop_timestamp
            __props__['last_suspended_timestamp'] = last_suspended_timestamp
            __props__['machine_type'] = machine_type
            __props__['metadata'] = metadata
            __props__['min_cpu_platform'] = min_cpu_platform
            __props__['name'] = name
            __props__['network_interfaces'] = network_interfaces
            __props__['network_performance_config'] = network_performance_config
            __props__['post_key_revocation_action_type'] = post_key_revocation_action_type
            __props__['preserved_state_size_gb'] = preserved_state_size_gb
            __props__['private_ipv6_google_access'] = private_ipv6_google_access
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            __props__['reservation_affinity'] = reservation_affinity
            __props__['resource_policies'] = resource_policies
            __props__['resource_status'] = resource_status
            __props__['satisfies_pzs'] = satisfies_pzs
            __props__['scheduling'] = scheduling
            __props__['secure_labels'] = secure_labels
            __props__['secure_tags'] = secure_tags
            __props__['self_link'] = self_link
            __props__['self_link_with_id'] = self_link_with_id
            __props__['service_accounts'] = service_accounts
            __props__['shielded_instance_config'] = shielded_instance_config
            __props__['shielded_instance_integrity_policy'] = shielded_instance_integrity_policy
            __props__['shielded_vm_config'] = shielded_vm_config
            __props__['shielded_vm_integrity_policy'] = shielded_vm_integrity_policy
            __props__['source_machine_image'] = source_machine_image
            __props__['source_machine_image_encryption_key'] = source_machine_image_encryption_key
            __props__['start_restricted'] = start_restricted
            __props__['status'] = status
            __props__['status_message'] = status_message
            __props__['tags'] = tags
            __props__['upcoming_maintenance'] = upcoming_maintenance
            if zone is None and not opts.urn:
                raise TypeError("Missing required property 'zone'")
            __props__['zone'] = zone
        super(Instance, __self__).__init__(
            'gcp-native:compute/alpha:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["advanced_machine_features"] = None
        __props__["can_ip_forward"] = None
        __props__["confidential_instance_config"] = None
        __props__["cpu_platform"] = None
        __props__["creation_timestamp"] = None
        __props__["deletion_protection"] = None
        __props__["description"] = None
        __props__["disks"] = None
        __props__["display_device"] = None
        __props__["erase_windows_vss_signature"] = None
        __props__["fingerprint"] = None
        __props__["guest_accelerators"] = None
        __props__["hostname"] = None
        __props__["instance_encryption_key"] = None
        __props__["kind"] = None
        __props__["label_fingerprint"] = None
        __props__["labels"] = None
        __props__["last_start_timestamp"] = None
        __props__["last_stop_timestamp"] = None
        __props__["last_suspended_timestamp"] = None
        __props__["machine_type"] = None
        __props__["metadata"] = None
        __props__["min_cpu_platform"] = None
        __props__["name"] = None
        __props__["network_interfaces"] = None
        __props__["network_performance_config"] = None
        __props__["post_key_revocation_action_type"] = None
        __props__["preserved_state_size_gb"] = None
        __props__["private_ipv6_google_access"] = None
        __props__["reservation_affinity"] = None
        __props__["resource_policies"] = None
        __props__["resource_status"] = None
        __props__["satisfies_pzs"] = None
        __props__["scheduling"] = None
        __props__["secure_labels"] = None
        __props__["secure_tags"] = None
        __props__["self_link"] = None
        __props__["self_link_with_id"] = None
        __props__["service_accounts"] = None
        __props__["shielded_instance_config"] = None
        __props__["shielded_instance_integrity_policy"] = None
        __props__["shielded_vm_config"] = None
        __props__["shielded_vm_integrity_policy"] = None
        __props__["source_machine_image"] = None
        __props__["source_machine_image_encryption_key"] = None
        __props__["start_restricted"] = None
        __props__["status"] = None
        __props__["status_message"] = None
        __props__["tags"] = None
        __props__["upcoming_maintenance"] = None
        __props__["zone"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedMachineFeatures")
    def advanced_machine_features(self) -> pulumi.Output['outputs.AdvancedMachineFeaturesResponse']:
        """
        Controls for advanced machine-related behavior features.
        """
        return pulumi.get(self, "advanced_machine_features")

    @property
    @pulumi.getter(name="canIpForward")
    def can_ip_forward(self) -> pulumi.Output[bool]:
        """
        Allows this instance to send and receive packets with non-matching destination or source IPs. This is required if you plan to use this instance to forward routes. For more information, see Enabling IP Forwarding.
        """
        return pulumi.get(self, "can_ip_forward")

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> pulumi.Output['outputs.ConfidentialInstanceConfigResponse']:
        return pulumi.get(self, "confidential_instance_config")

    @property
    @pulumi.getter(name="cpuPlatform")
    def cpu_platform(self) -> pulumi.Output[str]:
        """
        [Output Only] The CPU platform used by this instance.
        """
        return pulumi.get(self, "cpu_platform")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        Whether the resource should be protected against deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def disks(self) -> pulumi.Output[Sequence['outputs.AttachedDiskResponse']]:
        """
        Array of disks associated with this instance. Persistent disks must be created before you can assign them.
        """
        return pulumi.get(self, "disks")

    @property
    @pulumi.getter(name="displayDevice")
    def display_device(self) -> pulumi.Output['outputs.DisplayDeviceResponse']:
        """
        Enables display device for the instance.
        """
        return pulumi.get(self, "display_device")

    @property
    @pulumi.getter(name="eraseWindowsVssSignature")
    def erase_windows_vss_signature(self) -> pulumi.Output[bool]:
        """
        Specifies whether the disks restored from source snapshots or source machine image should erase Windows specific VSS signature.
        """
        return pulumi.get(self, "erase_windows_vss_signature")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Specifies a fingerprint for this resource, which is essentially a hash of the instance's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update the instance. You must always provide an up-to-date fingerprint hash in order to update the instance.

        To see the latest fingerprint, make get() request to the instance.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="guestAccelerators")
    def guest_accelerators(self) -> pulumi.Output[Sequence['outputs.AcceleratorConfigResponse']]:
        """
        A list of the type and count of accelerator cards attached to the instance.
        """
        return pulumi.get(self, "guest_accelerators")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        Specifies the hostname of the instance. The specified hostname must be RFC1035 compliant. If hostname is not specified, the default hostname is [INSTANCE_NAME].c.[PROJECT_ID].internal when using the global DNS, and [INSTANCE_NAME].[ZONE].c.[PROJECT_ID].internal when using zonal DNS.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="instanceEncryptionKey")
    def instance_encryption_key(self) -> pulumi.Output['outputs.CustomerEncryptionKeyResponse']:
        """
        Encrypts or decrypts data for an instance with a customer-supplied encryption key.

        If you are creating a new instance, this field encrypts the local SSD and in-memory contents of the instance using a key that you provide.

        If you are restarting an instance protected with a customer-supplied encryption key, you must provide the correct key in order to successfully restart the instance.

        If you do not provide an encryption key when creating the instance, then the local SSD and in-memory contents will be encrypted using an automatically generated key and you do not need to provide a key to start the instance later.

        Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt local SSDs and in-memory content in a managed instance group.
        """
        return pulumi.get(self, "instance_encryption_key")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        [Output Only] Type of the resource. Always compute#instance for instances.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        A fingerprint for this request, which is essentially a hash of the label's contents and used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels.

        To see the latest fingerprint, make get() request to the instance.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels to apply to this instance. These can be later modified by the setLabels method.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lastStartTimestamp")
    def last_start_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Last start timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_start_timestamp")

    @property
    @pulumi.getter(name="lastStopTimestamp")
    def last_stop_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Last stop timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_stop_timestamp")

    @property
    @pulumi.getter(name="lastSuspendedTimestamp")
    def last_suspended_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Last suspended timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "last_suspended_timestamp")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> pulumi.Output[str]:
        """
        Full or partial URL of the machine type resource to use for this instance, in the format: zones/zone/machineTypes/machine-type. This is provided by the client when the instance is created. For example, the following is a valid partial url to a predefined machine type:
        zones/us-central1-f/machineTypes/n1-standard-1


        To create a custom machine type, provide a URL to a machine type in the following format, where CPUS is 1 or an even number up to 32 (2, 4, 6, ... 24, etc), and MEMORY is the total memory for this instance. Memory must be a multiple of 256 MB and must be supplied in MB (e.g. 5 GB of memory is 5120 MB):
        zones/zone/machineTypes/custom-CPUS-MEMORY


        For example: zones/us-central1-f/machineTypes/custom-4-5120 

        For a full list of restrictions, read the Specifications for custom machine types.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.MetadataResponse']:
        """
        The metadata key/value pairs assigned to this instance. This includes custom metadata and predefined keys.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> pulumi.Output[str]:
        """
        Specifies a minimum CPU platform for the VM instance. Applicable values are the friendly names of CPU platforms, such as minCpuPlatform: "Intel Haswell" or minCpuPlatform: "Intel Sandy Bridge".
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the resource, provided by the client when initially creating the resource. The resource name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkInterfaces")
    def network_interfaces(self) -> pulumi.Output[Sequence['outputs.NetworkInterfaceResponse']]:
        """
        An array of network configurations for this instance. These specify how interfaces are configured to interact with other network services, such as connecting to the internet. Multiple interfaces are supported per instance.
        """
        return pulumi.get(self, "network_interfaces")

    @property
    @pulumi.getter(name="networkPerformanceConfig")
    def network_performance_config(self) -> pulumi.Output['outputs.NetworkPerformanceConfigResponse']:
        return pulumi.get(self, "network_performance_config")

    @property
    @pulumi.getter(name="postKeyRevocationActionType")
    def post_key_revocation_action_type(self) -> pulumi.Output[str]:
        """
        PostKeyRevocationActionType of the instance.
        """
        return pulumi.get(self, "post_key_revocation_action_type")

    @property
    @pulumi.getter(name="preservedStateSizeGb")
    def preserved_state_size_gb(self) -> pulumi.Output[str]:
        """
        Total amount of preserved state for SUSPENDED instances. Read-only in the api.
        """
        return pulumi.get(self, "preserved_state_size_gb")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> pulumi.Output[str]:
        """
        The private IPv6 google access type for the VM. If not specified, use  INHERIT_FROM_SUBNETWORK as default.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> pulumi.Output['outputs.ReservationAffinityResponse']:
        """
        Specifies the reservations that this instance can consume from.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="resourcePolicies")
    def resource_policies(self) -> pulumi.Output[Sequence[str]]:
        """
        Resource policies applied to this instance.
        """
        return pulumi.get(self, "resource_policies")

    @property
    @pulumi.getter(name="resourceStatus")
    def resource_status(self) -> pulumi.Output['outputs.ResourceStatusResponse']:
        """
        [Output Only] Specifies values set for instance attributes as compared to the values requested by user in the corresponding input only field.
        """
        return pulumi.get(self, "resource_status")

    @property
    @pulumi.getter(name="satisfiesPzs")
    def satisfies_pzs(self) -> pulumi.Output[bool]:
        """
        [Output Only] Reserved for future use.
        """
        return pulumi.get(self, "satisfies_pzs")

    @property
    @pulumi.getter
    def scheduling(self) -> pulumi.Output['outputs.SchedulingResponse']:
        """
        Sets the scheduling options for this instance.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="secureLabels")
    def secure_labels(self) -> pulumi.Output[Sequence[str]]:
        """
        Secure labels to apply to this instance. These can be later modified by the update method. Maximum number of secure labels allowed is 300.
        """
        return pulumi.get(self, "secure_labels")

    @property
    @pulumi.getter(name="secureTags")
    def secure_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Secure tags to apply to this instance. These can be later modified by the update method. Maximum number of secure tags allowed is 300.
        """
        return pulumi.get(self, "secure_tags")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for this resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @property
    @pulumi.getter(name="serviceAccounts")
    def service_accounts(self) -> pulumi.Output[Sequence['outputs.ServiceAccountResponse']]:
        """
        A list of service accounts, with their specified scopes, authorized for this instance. Only one service account per VM instance is supported.

        Service accounts generate access tokens that can be accessed through the metadata server and used to authenticate applications on the instance. See Service Accounts for more information.
        """
        return pulumi.get(self, "service_accounts")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> pulumi.Output['outputs.ShieldedInstanceConfigResponse']:
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="shieldedInstanceIntegrityPolicy")
    def shielded_instance_integrity_policy(self) -> pulumi.Output['outputs.ShieldedInstanceIntegrityPolicyResponse']:
        return pulumi.get(self, "shielded_instance_integrity_policy")

    @property
    @pulumi.getter(name="shieldedVmConfig")
    def shielded_vm_config(self) -> pulumi.Output['outputs.ShieldedVmConfigResponse']:
        """
        Deprecating, please use shielded_instance_config.
        """
        return pulumi.get(self, "shielded_vm_config")

    @property
    @pulumi.getter(name="shieldedVmIntegrityPolicy")
    def shielded_vm_integrity_policy(self) -> pulumi.Output['outputs.ShieldedVmIntegrityPolicyResponse']:
        """
        Deprecating, please use shielded_instance_integrity_policy.
        """
        return pulumi.get(self, "shielded_vm_integrity_policy")

    @property
    @pulumi.getter(name="sourceMachineImage")
    def source_machine_image(self) -> pulumi.Output[str]:
        """
        Source machine image
        """
        return pulumi.get(self, "source_machine_image")

    @property
    @pulumi.getter(name="sourceMachineImageEncryptionKey")
    def source_machine_image_encryption_key(self) -> pulumi.Output['outputs.CustomerEncryptionKeyResponse']:
        """
        Source machine image encryption key when creating an instance from a machine image.
        """
        return pulumi.get(self, "source_machine_image_encryption_key")

    @property
    @pulumi.getter(name="startRestricted")
    def start_restricted(self) -> pulumi.Output[bool]:
        """
        [Output Only] Whether a VM has been restricted for start because Compute Engine has detected suspicious activity.
        """
        return pulumi.get(self, "start_restricted")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        [Output Only] The status of the instance. One of the following values: PROVISIONING, STAGING, RUNNING, STOPPING, SUSPENDING, SUSPENDED, REPAIRING, and TERMINATED. For more information about the status of the instance, see  Instance life cycle.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        [Output Only] An optional, human-readable explanation of the status.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output['outputs.TagsResponse']:
        """
        Tags to apply to this instance. Tags are used to identify valid sources or targets for network firewalls and are specified by the client during instance creation. The tags can be later modified by the setTags method. Each tag within the list must comply with RFC1035. Multiple tags can be specified via the 'tags.items' field.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="upcomingMaintenance")
    def upcoming_maintenance(self) -> pulumi.Output['outputs.UpcomingMaintenanceResponse']:
        """
        [Output Only] Specifies upcoming maintenance for the instance.
        """
        return pulumi.get(self, "upcoming_maintenance")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        [Output Only] URL of the zone where the instance resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "zone")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

