# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'DynamicGroupMetadataArgs',
    'DynamicGroupQueryArgs',
    'EntityKeyArgs',
    'ExpiryDetailArgs',
    'MembershipRoleArgs',
]

@pulumi.input_type
class DynamicGroupMetadataArgs:
    def __init__(__self__, *,
                 queries: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]]] = None):
        """
        Dynamic group metadata like queries and status.
        :param pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]] queries: Memberships will be the union of all queries. Only one entry with USER resource is currently supported. Customers can create up to 100 dynamic groups.
        """
        if queries is not None:
            pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]]]:
        """
        Memberships will be the union of all queries. Only one entry with USER resource is currently supported. Customers can create up to 100 dynamic groups.
        """
        return pulumi.get(self, "queries")

    @queries.setter
    def queries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DynamicGroupQueryArgs']]]]):
        pulumi.set(self, "queries", value)


@pulumi.input_type
class DynamicGroupQueryArgs:
    def __init__(__self__, *,
                 query: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None):
        """
        Defines a query on a resource.
        :param pulumi.Input[str] query: Query that determines the memberships of the dynamic group. Examples: All users with at least one `organizations.department` of engineering. `user.organizations.exists(org, org.department=='engineering')` All users with at least one location that has `area` of `foo` and `building_id` of `bar`. `user.locations.exists(loc, loc.area=='foo' && loc.building_id=='bar')`
        """
        if query is not None:
            pulumi.set(__self__, "query", query)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Query that determines the memberships of the dynamic group. Examples: All users with at least one `organizations.department` of engineering. `user.organizations.exists(org, org.department=='engineering')` All users with at least one location that has `area` of `foo` and `building_id` of `bar`. `user.locations.exists(loc, loc.area=='foo' && loc.building_id=='bar')`
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)


@pulumi.input_type
class EntityKeyArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        A unique identifier for an entity in the Cloud Identity Groups API. An entity can represent either a group with an optional `namespace` or a user without a `namespace`. The combination of `id` and `namespace` must be unique; however, the same `id` can be used with different `namespace`s.
        :param pulumi.Input[str] id: The ID of the entity. For Google-managed entities, the `id` must be the email address of an existing group or user. For external-identity-mapped entities, the `id` must be a string conforming to the Identity Source's requirements. Must be unique within a `namespace`.
        :param pulumi.Input[str] namespace: The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source_id}.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the entity. For Google-managed entities, the `id` must be the email address of an existing group or user. For external-identity-mapped entities, the `id` must be a string conforming to the Identity Source's requirements. Must be unique within a `namespace`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source_id}.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class ExpiryDetailArgs:
    def __init__(__self__, *,
                 expire_time: Optional[pulumi.Input[str]] = None):
        """
        The `MembershipRole` expiry details.
        :param pulumi.Input[str] expire_time: The time at which the `MembershipRole` will expire.
        """
        if expire_time is not None:
            pulumi.set(__self__, "expire_time", expire_time)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time at which the `MembershipRole` will expire.
        """
        return pulumi.get(self, "expire_time")

    @expire_time.setter
    def expire_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expire_time", value)


@pulumi.input_type
class MembershipRoleArgs:
    def __init__(__self__, *,
                 expiry_detail: Optional[pulumi.Input['ExpiryDetailArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        A membership role within the Cloud Identity Groups API. A `MembershipRole` defines the privileges granted to a `Membership`.
        :param pulumi.Input['ExpiryDetailArgs'] expiry_detail: The expiry details of the `MembershipRole`. Expiry details are only supported for `MEMBER` `MembershipRoles`. May be set if `name` is `MEMBER`. Must not be set if `name` is any other value.
        :param pulumi.Input[str] name: The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`, `MEMBER`.
        """
        if expiry_detail is not None:
            pulumi.set(__self__, "expiry_detail", expiry_detail)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="expiryDetail")
    def expiry_detail(self) -> Optional[pulumi.Input['ExpiryDetailArgs']]:
        """
        The expiry details of the `MembershipRole`. Expiry details are only supported for `MEMBER` `MembershipRoles`. May be set if `name` is `MEMBER`. Must not be set if `name` is any other value.
        """
        return pulumi.get(self, "expiry_detail")

    @expiry_detail.setter
    def expiry_detail(self, value: Optional[pulumi.Input['ExpiryDetailArgs']]):
        pulumi.set(self, "expiry_detail", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`, `MEMBER`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


