# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['OrganizationReport']


class OrganizationReport(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 chart_type: Optional[pulumi.Input[str]] = None,
                 comments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 filter: Optional[pulumi.Input[str]] = None,
                 from_time: Optional[pulumi.Input[str]] = None,
                 limit: Optional[pulumi.Input[str]] = None,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1CustomReportMetricArgs']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 offset: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1ReportPropertyArgs']]]]] = None,
                 reports_id: Optional[pulumi.Input[str]] = None,
                 sort_by_cols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 sort_order: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 time_unit: Optional[pulumi.Input[str]] = None,
                 to_time: Optional[pulumi.Input[str]] = None,
                 topk: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a Custom Report for an Organization. A Custom Report provides Apigee Customers to create custom dashboards in addition to the standard dashboards which are provided. The Custom Report in its simplest form contains specifications about metrics, dimensions and filters. It is important to note that the custom report by itself does not provide an executable entity. The Edge UI converts the custom report definition into an analytics query and displays the result in a chart.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] chart_type: This field contains the chart type for the report
        :param pulumi.Input[Sequence[pulumi.Input[str]]] comments: Legacy field: not used. This field contains a list of comments associated with custom report
        :param pulumi.Input[Sequence[pulumi.Input[str]]] dimensions: This contains the list of dimensions for the report
        :param pulumi.Input[str] display_name: This is the display name for the report
        :param pulumi.Input[str] filter: This field contains the filter expression
        :param pulumi.Input[str] from_time: Legacy field: not used. Contains the from time for the report
        :param pulumi.Input[str] limit: Legacy field: not used This field contains the limit for the result retrieved
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1CustomReportMetricArgs']]]] metrics: Required. This contains the list of metrics
        :param pulumi.Input[str] name: Required. Unique identifier for the report T his is a legacy field used to encode custom report unique id
        :param pulumi.Input[str] offset: Legacy field: not used. This field contains the offset for the data
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1ReportPropertyArgs']]]] properties: This field contains report properties such as ui metadata etc.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sort_by_cols: Legacy field: not used much. Contains the list of sort by columns
        :param pulumi.Input[str] sort_order: Legacy field: not used much. Contains the sort order for the sort columns
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Legacy field: not used. This field contains a list of tags associated with custom report
        :param pulumi.Input[str] time_unit: This field contains the time unit of aggregation for the report
        :param pulumi.Input[str] to_time: Legacy field: not used. Contains the end time for the report
        :param pulumi.Input[str] topk: Legacy field: not used. This field contains the top k parameter value for restricting the result
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['chart_type'] = chart_type
            __props__['comments'] = comments
            __props__['dimensions'] = dimensions
            __props__['display_name'] = display_name
            __props__['filter'] = filter
            __props__['from_time'] = from_time
            __props__['limit'] = limit
            __props__['metrics'] = metrics
            __props__['name'] = name
            __props__['offset'] = offset
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            __props__['properties'] = properties
            if reports_id is None and not opts.urn:
                raise TypeError("Missing required property 'reports_id'")
            __props__['reports_id'] = reports_id
            __props__['sort_by_cols'] = sort_by_cols
            __props__['sort_order'] = sort_order
            __props__['tags'] = tags
            __props__['time_unit'] = time_unit
            __props__['to_time'] = to_time
            __props__['topk'] = topk
            __props__['created_at'] = None
            __props__['environment'] = None
            __props__['last_modified_at'] = None
            __props__['last_viewed_at'] = None
            __props__['organization'] = None
        super(OrganizationReport, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationReport',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationReport':
        """
        Get an existing OrganizationReport resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["chart_type"] = None
        __props__["comments"] = None
        __props__["created_at"] = None
        __props__["dimensions"] = None
        __props__["display_name"] = None
        __props__["environment"] = None
        __props__["filter"] = None
        __props__["from_time"] = None
        __props__["last_modified_at"] = None
        __props__["last_viewed_at"] = None
        __props__["limit"] = None
        __props__["metrics"] = None
        __props__["name"] = None
        __props__["offset"] = None
        __props__["organization"] = None
        __props__["properties"] = None
        __props__["sort_by_cols"] = None
        __props__["sort_order"] = None
        __props__["tags"] = None
        __props__["time_unit"] = None
        __props__["to_time"] = None
        __props__["topk"] = None
        return OrganizationReport(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="chartType")
    def chart_type(self) -> pulumi.Output[str]:
        """
        This field contains the chart type for the report
        """
        return pulumi.get(self, "chart_type")

    @property
    @pulumi.getter
    def comments(self) -> pulumi.Output[Sequence[str]]:
        """
        Legacy field: not used. This field contains a list of comments associated with custom report
        """
        return pulumi.get(self, "comments")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Unix time when the app was created json key: createdAt
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Sequence[str]]:
        """
        This contains the list of dimensions for the report
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        This is the display name for the report
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        Environment name
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def filter(self) -> pulumi.Output[str]:
        """
        This field contains the filter expression
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="fromTime")
    def from_time(self) -> pulumi.Output[str]:
        """
        Legacy field: not used. Contains the from time for the report
        """
        return pulumi.get(self, "from_time")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[str]:
        """
        Modified time of this entity as milliseconds since epoch. json key: lastModifiedAt
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter(name="lastViewedAt")
    def last_viewed_at(self) -> pulumi.Output[str]:
        """
        Last viewed time of this entity as milliseconds since epoch
        """
        return pulumi.get(self, "last_viewed_at")

    @property
    @pulumi.getter
    def limit(self) -> pulumi.Output[str]:
        """
        Legacy field: not used This field contains the limit for the result retrieved
        """
        return pulumi.get(self, "limit")

    @property
    @pulumi.getter
    def metrics(self) -> pulumi.Output[Sequence['outputs.GoogleCloudApigeeV1CustomReportMetricResponse']]:
        """
        Required. This contains the list of metrics
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Required. Unique identifier for the report T his is a legacy field used to encode custom report unique id
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def offset(self) -> pulumi.Output[str]:
        """
        Legacy field: not used. This field contains the offset for the data
        """
        return pulumi.get(self, "offset")

    @property
    @pulumi.getter
    def organization(self) -> pulumi.Output[str]:
        """
        Organization name
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Sequence['outputs.GoogleCloudApigeeV1ReportPropertyResponse']]:
        """
        This field contains report properties such as ui metadata etc.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="sortByCols")
    def sort_by_cols(self) -> pulumi.Output[Sequence[str]]:
        """
        Legacy field: not used much. Contains the list of sort by columns
        """
        return pulumi.get(self, "sort_by_cols")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> pulumi.Output[str]:
        """
        Legacy field: not used much. Contains the sort order for the sort columns
        """
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Legacy field: not used. This field contains a list of tags associated with custom report
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> pulumi.Output[str]:
        """
        This field contains the time unit of aggregation for the report
        """
        return pulumi.get(self, "time_unit")

    @property
    @pulumi.getter(name="toTime")
    def to_time(self) -> pulumi.Output[str]:
        """
        Legacy field: not used. Contains the end time for the report
        """
        return pulumi.get(self, "to_time")

    @property
    @pulumi.getter
    def topk(self) -> pulumi.Output[str]:
        """
        Legacy field: not used. This field contains the top k parameter value for restricting the result
        """
        return pulumi.get(self, "topk")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

