# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from ._inputs import *

__all__ = ['OrganizationDeveloperAppKeyCreate']


class OrganizationDeveloperAppKeyCreate(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_products: Optional[pulumi.Input[Sequence[Any]]] = None,
                 apps_id: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]]] = None,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 consumer_secret: Optional[pulumi.Input[str]] = None,
                 developers_id: Optional[pulumi.Input[str]] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 expires_in_seconds: Optional[pulumi.Input[str]] = None,
                 issued_at: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a custom consumer key and secret for a developer app. This is particularly useful if you want to migrate existing consumer keys and secrets to Apigee hybrid from another system. Consumer keys and secrets can contain letters, numbers, underscores, and hyphens. No other special characters are allowed. To avoid service disruptions, a consumer key and secret should not exceed 2 KBs each. **Note**: When creating the consumer key and secret, an association to API products will not be made. Therefore, you should not specify the associated API products in your request. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created. If a consumer key and secret already exist, you can keep them or delete them using the DeleteDeveloperAppKey API.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[Any]] api_products: List of API products for which the credential can be used. **Note**: Do not specify the list of API products when creating a consumer key and secret for a developer app. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]] attributes: List of attributes associated with the credential.
        :param pulumi.Input[str] consumer_key: Consumer key.
        :param pulumi.Input[str] consumer_secret: Secret key.
        :param pulumi.Input[str] expires_at: Time the developer app expires in milliseconds since epoch.
        :param pulumi.Input[str] expires_in_seconds: Input only. Expiration time, in seconds, for the consumer key. If not set or left to the default value of `-1`, the API key never expires. The expiration time can't be updated after it is set.
        :param pulumi.Input[str] issued_at: Time the developer app was created in milliseconds since epoch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Scopes to apply to the app. The specified scope names must already be defined for the API product that you associate with the app.
        :param pulumi.Input[str] status: Status of the credential. Valid values include `approved` or `revoked`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['api_products'] = api_products
            if apps_id is None and not opts.urn:
                raise TypeError("Missing required property 'apps_id'")
            __props__['apps_id'] = apps_id
            __props__['attributes'] = attributes
            __props__['consumer_key'] = consumer_key
            __props__['consumer_secret'] = consumer_secret
            if developers_id is None and not opts.urn:
                raise TypeError("Missing required property 'developers_id'")
            __props__['developers_id'] = developers_id
            __props__['expires_at'] = expires_at
            __props__['expires_in_seconds'] = expires_in_seconds
            __props__['issued_at'] = issued_at
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            __props__['scopes'] = scopes
            __props__['status'] = status
        super(OrganizationDeveloperAppKeyCreate, __self__).__init__(
            'gcp-native:apigee/v1:OrganizationDeveloperAppKeyCreate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationDeveloperAppKeyCreate':
        """
        Get an existing OrganizationDeveloperAppKeyCreate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        return OrganizationDeveloperAppKeyCreate(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

