# type: ignore
"""content

Revision ID: a918b6b05d2f
Revises: 6b1b10eb67de
Create Date: 2021-05-31 02:56:28.192070

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "a918b6b05d2f"
down_revision = "6b1b10eb67de"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("medias", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.DATETIME(),
            type_=sa.TIMESTAMP(),
            existing_nullable=True,
        )

    with op.batch_alter_table("posts", schema=None) as batch_op:
        batch_op.add_column(sa.Column("archived", sa.Boolean(), nullable=True))
        batch_op.alter_column(
            "created_at",
            existing_type=sa.DATETIME(),
            type_=sa.TIMESTAMP(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("posts", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.TIMESTAMP(),
            type_=sa.DATETIME(),
            existing_nullable=True,
        )
        batch_op.drop_column("archived")

    with op.batch_alter_table("medias", schema=None) as batch_op:
        batch_op.alter_column(
            "created_at",
            existing_type=sa.TIMESTAMP(),
            type_=sa.DATETIME(),
            existing_nullable=True,
        )

    # ### end Alembic commands ###
