"""
Because FSSpec is inconsistent in name mapping, we gotta do this.
"""

_ASYNC_METHODS = [
    "async_call",
    "async_cat",
    "async_cat_file",
    "async_cat_ranges",
    "async_copy",
    "async_cp_file",
    "async_du",
    "async_exists",
    "async_expand_path",
    "async_find",
    "async_get",
    "async_get_file",
    "async_getxattr",
    "async_glob",
    "async_info",
    "async_isdir",
    "async_isfile",
    "async_list_buckets",
    "async_list_objects",
    "async_ls",
    "async_makedirs",
    "async_merge",
    "async_mkdir",
    "async_pipe",
    "async_pipe_file",
    "async_process_limits",
    "async_put",
    "async_put_file",
    "async_rm",
    "async_rm_file",
    "async_rmdir",
    "async_rm_files",
    "async_setxattrs",
    "async_size",
    "async_sizes",
]

_ASYNC_MAPPING_GS = {
    "_call": "async_call",
    "_cat": "async_cat",
    "_cat_file": "async_cat_file",
    "_cat_ranges": "async_cat_ranges",
    "_copy": "async_copy",
    "_cp_file": "async_cp_file",
    "_du": "async_du",
    "_exists": "async_exists",
    "_expand_path": "async_expand_path",
    "_find": "async_find",
    "_get": "async_get",
    "_get_file": "async_get_file",
    "_getxattr": "async_getxattr",
    "_glob": "async_glob",
    "_info": "async_info",
    "_isdir": "async_isdir",
    "_isfile": "async_isfile",
    "_list_buckets": "async_list_buckets",
    "_list_objects": "async_list_objects",
    "_ls": "async_ls",
    #"_makedir": "async_makedir",
    "_makedirs": "async_makedirs",
    "_merge": "async_merge",
    "_mkdir": "async_mkdir",
    "_pipe": "async_pipe",
    "_pipe_file": "async_pipe_file",
    "_process_limits": "async_process_limits",
    "_put": "async_put",
    "_put_file": "async_put_file",
    "_rm": "async_rm",
    "_rm_file": "async_rm_file",
    "_rmdir": "async_rmdir",
    "_rm_files": "async_rm_files",
    "_setxattrs": "async_setxattrs",
    "_size": "async_size",
    "_sizes": "async_sizes",
}


_ASYNC_MAPPING_S3 = {
    "_call_s3": "async_call",
    "_cat": "async_cat",
    "_cat_file": "async_cat_file",
    "_cat_ranges": "async_cat_ranges",
    "_copy": "async_copy",
    "_cp_file": "async_cp_file",
    "_du": "async_du",
    "_exists": "async_exists",
    "_expand_path": "async_expand_path",
    "_find": "async_find",
    "_get": "async_get",
    "_get_file": "async_get_file",
    "_getxattr": "async_getxattr",
    "_glob": "async_glob",
    "_info": "async_info",
    "_isdir": "async_isdir",
    "_isfile": "async_isfile",
    "_lsbuckets": "async_list_buckets",
    "_lsdir": "async_list_objects",
    "_ls": "async_ls",
    "_makedirs": "async_makedirs",
    "_merge": "async_merge",
    "_mkdir": "async_mkdir",
    "_pipe": "async_pipe",
    "_pipe_file": "async_pipe_file",
    "_process_limits": "async_process_limits",
    "_put": "async_put",
    "_put_file": "async_put_file",
    "_rm": "async_rm",
    "_rm_file": "async_rm_file",
    "_rmdir": "async_rmdir",
    "_bulk_delete": "async_rm_files",
    "_setxattr": "async_setxattrs",
    "_size": "async_size",
    "_sizes": "async_sizes",
}

_ASYNC_SYNTAX_MAPPING = {
    'gs': _ASYNC_MAPPING_GS,
    's3': _ASYNC_MAPPING_S3,
    'minio': _ASYNC_MAPPING_S3,
}